/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ListenableFuture;
import io.druid.java.util.common.guava.Sequence;
import io.druid.java.util.common.guava.Sequences;
import io.druid.query.AsyncQueryRunner;
import io.druid.query.Druids;
import io.druid.query.Query;
import io.druid.query.QueryPlus;
import io.druid.query.QueryRunner;
import io.druid.query.QueryRunnerTestHelper;
import io.druid.query.QueryWatcher;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.CountAggregatorFactory;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeoutException;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class AsyncQueryRunnerTest {
    private static final long TEST_TIMEOUT = 60000L;
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private final Query query = Druids.newTimeseriesQueryBuilder().dataSource("test").intervals("2014/2015").aggregators((List)Lists.newArrayList((Object[])new AggregatorFactory[]{new CountAggregatorFactory("count")})).build();

    @Test(timeout=60000L)
    public void testAsyncNature() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        QueryRunner baseRunner = new QueryRunner(){

            public Sequence run(QueryPlus queryPlus, Map responseContext) {
                try {
                    latch.await();
                    return Sequences.simple((Iterable)Lists.newArrayList((Object[])new Integer[]{1}));
                }
                catch (InterruptedException ex) {
                    throw new RuntimeException(ex);
                }
            }
        };
        AsyncQueryRunner asyncRunner = new AsyncQueryRunner(baseRunner, this.executor, QueryRunnerTestHelper.NOOP_QUERYWATCHER);
        Sequence lazy = asyncRunner.run(QueryPlus.wrap((Query)this.query), Collections.EMPTY_MAP);
        latch.countDown();
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new Integer[]{1}), (Object)Sequences.toList((Sequence)lazy, (List)Lists.newArrayList()));
    }

    @Test(timeout=60000L)
    public void testQueryTimeoutHonored() {
        QueryRunner baseRunner = new QueryRunner(){

            public Sequence run(QueryPlus queryPlus, Map responseContext) {
                try {
                    Thread.sleep(Long.MAX_VALUE);
                    throw new RuntimeException("query should not have completed");
                }
                catch (InterruptedException ex) {
                    throw new RuntimeException(ex);
                }
            }
        };
        AsyncQueryRunner asyncRunner = new AsyncQueryRunner(baseRunner, this.executor, QueryRunnerTestHelper.NOOP_QUERYWATCHER);
        Sequence lazy = asyncRunner.run(QueryPlus.wrap((Query)this.query.withOverriddenContext((Map)ImmutableMap.of((Object)"timeout", (Object)1))), Collections.EMPTY_MAP);
        try {
            Sequences.toList((Sequence)lazy, (List)Lists.newArrayList());
        }
        catch (RuntimeException ex) {
            Assert.assertTrue((boolean)(ex.getCause() instanceof TimeoutException));
            return;
        }
        Assert.fail();
    }

    @Test
    public void testQueryRegistration() {
        QueryRunner baseRunner = (queryPlus, responseContext) -> null;
        QueryWatcher mock = (QueryWatcher)EasyMock.createMock(QueryWatcher.class);
        mock.registerQuery((Query)EasyMock.eq((Object)this.query), (ListenableFuture)EasyMock.anyObject(ListenableFuture.class));
        EasyMock.replay((Object[])new Object[]{mock});
        AsyncQueryRunner asyncRunner = new AsyncQueryRunner(baseRunner, this.executor, mock);
        asyncRunner.run(QueryPlus.wrap((Query)this.query), Collections.EMPTY_MAP);
        EasyMock.verify((Object[])new Object[]{mock});
    }
}

