/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.druid.data.input.InputRow;
import io.druid.data.input.impl.DimensionsSpec;
import io.druid.data.input.impl.InputRowParser;
import io.druid.data.input.impl.JSONParseSpec;
import io.druid.data.input.impl.MapInputRowParser;
import io.druid.data.input.impl.ParseSpec;
import io.druid.data.input.impl.TimestampSpec;
import io.druid.java.util.common.DateTimes;
import io.druid.java.util.common.Intervals;
import io.druid.java.util.common.guava.Sequence;
import io.druid.java.util.common.guava.Sequences;
import io.druid.query.DataSource;
import io.druid.query.DefaultGenericQueryMetricsFactory;
import io.druid.query.Druids;
import io.druid.query.Query;
import io.druid.query.QueryPlus;
import io.druid.query.QueryRunner;
import io.druid.query.QueryRunnerTestHelper;
import io.druid.query.TableDataSource;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.DoubleSumAggregatorFactory;
import io.druid.query.metadata.SegmentMetadataQueryConfig;
import io.druid.query.metadata.SegmentMetadataQueryQueryToolChest;
import io.druid.query.metadata.SegmentMetadataQueryRunnerFactory;
import io.druid.query.metadata.metadata.ColumnAnalysis;
import io.druid.query.metadata.metadata.ColumnIncluderator;
import io.druid.query.metadata.metadata.ListColumnIncluderator;
import io.druid.query.metadata.metadata.SegmentAnalysis;
import io.druid.query.metadata.metadata.SegmentMetadataQuery;
import io.druid.query.scan.ScanQuery;
import io.druid.query.scan.ScanQueryConfig;
import io.druid.query.scan.ScanQueryEngine;
import io.druid.query.scan.ScanQueryQueryToolChest;
import io.druid.query.scan.ScanQueryRunnerFactory;
import io.druid.query.scan.ScanQueryRunnerTest;
import io.druid.query.scan.ScanResultValue;
import io.druid.query.spec.LegacySegmentSpec;
import io.druid.query.spec.QuerySegmentSpec;
import io.druid.segment.IndexIO;
import io.druid.segment.IndexMergerV9;
import io.druid.segment.IndexSpec;
import io.druid.segment.QueryableIndex;
import io.druid.segment.QueryableIndexSegment;
import io.druid.segment.Segment;
import io.druid.segment.TestHelper;
import io.druid.segment.VirtualColumn;
import io.druid.segment.column.ValueType;
import io.druid.segment.incremental.IncrementalIndex;
import io.druid.segment.incremental.IncrementalIndexSchema;
import io.druid.segment.incremental.IndexSizeExceededException;
import io.druid.segment.writeout.OffHeapMemorySegmentWriteOutMediumFactory;
import io.druid.segment.writeout.SegmentWriteOutMediumFactory;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.joda.time.Interval;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class DoubleStorageTest {
    private static final SegmentMetadataQueryRunnerFactory METADATA_QR_FACTORY = new SegmentMetadataQueryRunnerFactory(new SegmentMetadataQueryQueryToolChest(new SegmentMetadataQueryConfig()), QueryRunnerTestHelper.NOOP_QUERYWATCHER);
    private static final ScanQueryQueryToolChest scanQueryQueryToolChest = new ScanQueryQueryToolChest(new ScanQueryConfig(), DefaultGenericQueryMetricsFactory.instance());
    private static final ScanQueryRunnerFactory SCAN_QUERY_RUNNER_FACTORY = new ScanQueryRunnerFactory(scanQueryQueryToolChest, new ScanQueryEngine());
    private static final IndexMergerV9 INDEX_MERGER_V9 = TestHelper.getTestIndexMergerV9((SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance());
    private static final IndexIO INDEX_IO = TestHelper.getTestIndexIO((SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance());
    private static final Integer MAX_ROWS = 10;
    private static final String TIME_COLUMN = "__time";
    private static final String DIM_NAME = "testDimName";
    private static final String DIM_VALUE = "testDimValue";
    private static final String DIM_FLOAT_NAME = "testDimFloatName";
    private static final String SEGMENT_ID = "segmentId";
    private static final Interval INTERVAL = Intervals.of((String)"2011-01-13T00:00:00.000Z/2011-01-22T00:00:00.001Z");
    private static final InputRowParser<Map<String, Object>> ROW_PARSER = new MapInputRowParser((ParseSpec)new JSONParseSpec(new TimestampSpec("__time", "auto", null), new DimensionsSpec(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"testDimName")), (List)ImmutableList.of((Object)"testDimFloatName"), (List)ImmutableList.of()), null, null));
    private QueryableIndex index;
    private final SegmentAnalysis expectedSegmentAnalysis;
    private final String storeDoubleAs;

    private ScanQuery.ScanQueryBuilder newTestQuery() {
        return ScanQuery.newScanQueryBuilder().dataSource((DataSource)new TableDataSource("testing")).columns(Arrays.asList(new String[0])).intervals(QueryRunnerTestHelper.fullOnInterval).limit(Integer.MAX_VALUE).legacy(Boolean.valueOf(false));
    }

    public DoubleStorageTest(String storeDoubleAs, SegmentAnalysis expectedSegmentAnalysis) throws IOException {
        this.storeDoubleAs = storeDoubleAs;
        this.expectedSegmentAnalysis = expectedSegmentAnalysis;
    }

    @Parameterized.Parameters
    public static Collection<?> dataFeeder() throws IOException {
        SegmentAnalysis expectedSegmentAnalysisDouble = new SegmentAnalysis(SEGMENT_ID, (List)ImmutableList.of((Object)INTERVAL), (Map)ImmutableMap.of((Object)TIME_COLUMN, (Object)new ColumnAnalysis(ValueType.LONG.toString(), false, 100L, null, null, null, null), (Object)DIM_NAME, (Object)new ColumnAnalysis(ValueType.STRING.toString(), false, 120L, Integer.valueOf(1), (Comparable)((Object)DIM_VALUE), (Comparable)((Object)DIM_VALUE), null), (Object)DIM_FLOAT_NAME, (Object)new ColumnAnalysis(ValueType.DOUBLE.toString(), false, 80L, null, null, null, null)), 330L, (long)MAX_ROWS.intValue(), null, null, null, null);
        SegmentAnalysis expectedSegmentAnalysisFloat = new SegmentAnalysis(SEGMENT_ID, (List)ImmutableList.of((Object)INTERVAL), (Map)ImmutableMap.of((Object)TIME_COLUMN, (Object)new ColumnAnalysis(ValueType.LONG.toString(), false, 100L, null, null, null, null), (Object)DIM_NAME, (Object)new ColumnAnalysis(ValueType.STRING.toString(), false, 120L, Integer.valueOf(1), (Comparable)((Object)DIM_VALUE), (Comparable)((Object)DIM_VALUE), null), (Object)DIM_FLOAT_NAME, (Object)new ColumnAnalysis(ValueType.FLOAT.toString(), false, 80L, null, null, null, null)), 330L, (long)MAX_ROWS.intValue(), null, null, null, null);
        return ImmutableList.of((Object)new Object[]{"double", expectedSegmentAnalysisDouble}, (Object)new Object[]{"float", expectedSegmentAnalysisFloat});
    }

    @Before
    public void setup() throws IOException {
        this.index = DoubleStorageTest.buildIndex(this.storeDoubleAs);
    }

    @Test
    public void testMetaDataAnalysis() throws IndexSizeExceededException {
        QueryRunner runner = QueryRunnerTestHelper.makeQueryRunner(METADATA_QR_FACTORY, SEGMENT_ID, (Segment)new QueryableIndexSegment(SEGMENT_ID, this.index), null);
        SegmentMetadataQuery segmentMetadataQuery = Druids.newSegmentMetadataQueryBuilder().dataSource("testing").intervals((List)ImmutableList.of((Object)INTERVAL)).toInclude((ColumnIncluderator)new ListColumnIncluderator(Arrays.asList(TIME_COLUMN, DIM_NAME, DIM_FLOAT_NAME))).analysisTypes(new SegmentMetadataQuery.AnalysisType[]{SegmentMetadataQuery.AnalysisType.CARDINALITY, SegmentMetadataQuery.AnalysisType.SIZE, SegmentMetadataQuery.AnalysisType.INTERVAL, SegmentMetadataQuery.AnalysisType.MINMAX}).merge(true).build();
        List results = Sequences.toList((Sequence)runner.run(QueryPlus.wrap((Query)segmentMetadataQuery), (Map)Maps.newHashMap()), (List)Lists.newArrayList());
        Assert.assertEquals(Arrays.asList(this.expectedSegmentAnalysis), (Object)results);
    }

    @Test
    public void testSelectValues() {
        QueryRunner runner = QueryRunnerTestHelper.makeQueryRunner(SCAN_QUERY_RUNNER_FACTORY, SEGMENT_ID, (Segment)new QueryableIndexSegment(SEGMENT_ID, this.index), null);
        ScanQuery query = this.newTestQuery().intervals((QuerySegmentSpec)new LegacySegmentSpec((Object)INTERVAL)).virtualColumns(new VirtualColumn[0]).build();
        HashMap context = new HashMap();
        List results = Sequences.toList((Sequence)runner.run(QueryPlus.wrap((Query)query), context), (List)Lists.newArrayList());
        ScanResultValue expectedScanResult = new ScanResultValue(SEGMENT_ID, (List)ImmutableList.of((Object)TIME_COLUMN, (Object)DIM_NAME, (Object)DIM_FLOAT_NAME), DoubleStorageTest.getStreamOfEvents().collect(Collectors.toList()));
        ArrayList expectedResults = Lists.newArrayList((Object[])new ScanResultValue[]{expectedScanResult});
        ScanQueryRunnerTest.verify(expectedResults, results);
    }

    private static QueryableIndex buildIndex(String storeDoubleAsFloat) throws IOException {
        String oldValue = System.getProperty("druid.indexing.doubleStorage");
        System.setProperty("druid.indexing.doubleStorage", storeDoubleAsFloat);
        IncrementalIndexSchema schema = new IncrementalIndexSchema.Builder().withMinTimestamp(DateTimes.of((String)"2011-01-13T00:00:00.000Z").getMillis()).withDimensionsSpec(ROW_PARSER).withMetrics(new AggregatorFactory[]{new DoubleSumAggregatorFactory(DIM_FLOAT_NAME, DIM_FLOAT_NAME)}).build();
        IncrementalIndex index = new IncrementalIndex.Builder().setIndexSchema(schema).setMaxRowCount(MAX_ROWS.intValue()).buildOnheap();
        DoubleStorageTest.getStreamOfEvents().forEach(o -> {
            try {
                index.add((InputRow)ROW_PARSER.parseBatch((Object)((Map)o)).get(0));
            }
            catch (IndexSizeExceededException e) {
                Throwables.propagate((Throwable)e);
            }
        });
        if (oldValue == null) {
            System.clearProperty("druid.indexing.doubleStorage");
        } else {
            System.setProperty("druid.indexing.doubleStorage", oldValue);
        }
        File someTmpFile = File.createTempFile("billy", "yay");
        someTmpFile.delete();
        someTmpFile.mkdirs();
        INDEX_MERGER_V9.persist(index, someTmpFile, new IndexSpec(), null);
        someTmpFile.delete();
        return INDEX_IO.loadIndex(someTmpFile);
    }

    @After
    public void cleanUp() throws IOException {
        this.index.close();
    }

    private static Stream getStreamOfEvents() {
        return IntStream.range(0, MAX_ROWS).mapToObj(i -> ImmutableMap.of((Object)TIME_COLUMN, (Object)DateTimes.of((String)"2011-01-13T00:00:00.000Z").plusDays(i).getMillis(), (Object)DIM_NAME, (Object)DIM_VALUE, (Object)DIM_FLOAT_NAME, (Object)((double)i / 1.6179775280898876)));
    }
}

