/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import io.druid.collections.NonBlockingPool;
import io.druid.collections.StupidPool;
import io.druid.query.FinalizeResultsQueryRunner;
import io.druid.query.QueryRunner;
import io.druid.query.QueryRunnerTestHelper;
import io.druid.query.search.SearchQueryConfig;
import io.druid.query.search.SearchQueryQueryToolChest;
import io.druid.query.search.SearchQueryRunnerFactory;
import io.druid.query.search.SearchStrategySelector;
import io.druid.query.timeboundary.TimeBoundaryQueryRunnerFactory;
import io.druid.query.timeseries.TimeseriesQueryEngine;
import io.druid.query.timeseries.TimeseriesQueryQueryToolChest;
import io.druid.query.timeseries.TimeseriesQueryRunnerFactory;
import io.druid.query.topn.TopNQueryConfig;
import io.druid.query.topn.TopNQueryQueryToolChest;
import io.druid.query.topn.TopNQueryRunnerFactory;
import io.druid.segment.Segment;
import java.nio.ByteBuffer;

public class TestQueryRunners {
    public static final NonBlockingPool<ByteBuffer> pool = new StupidPool("TestQueryRunners-bufferPool", (Supplier)new Supplier<ByteBuffer>(){

        public ByteBuffer get() {
            return ByteBuffer.allocate(0xA00000);
        }
    });
    public static final TopNQueryConfig topNConfig = new TopNQueryConfig();

    public static NonBlockingPool<ByteBuffer> getPool() {
        return pool;
    }

    public static <T> QueryRunner<T> makeTopNQueryRunner(Segment adapter) {
        TopNQueryRunnerFactory factory = new TopNQueryRunnerFactory(pool, new TopNQueryQueryToolChest(topNConfig, QueryRunnerTestHelper.NoopIntervalChunkingQueryRunnerDecorator()), QueryRunnerTestHelper.NOOP_QUERYWATCHER);
        return new FinalizeResultsQueryRunner(factory.createRunner(adapter), factory.getToolchest());
    }

    public static <T> QueryRunner<T> makeTimeSeriesQueryRunner(Segment adapter) {
        TimeseriesQueryRunnerFactory factory = new TimeseriesQueryRunnerFactory(new TimeseriesQueryQueryToolChest(QueryRunnerTestHelper.NoopIntervalChunkingQueryRunnerDecorator()), new TimeseriesQueryEngine(), QueryRunnerTestHelper.NOOP_QUERYWATCHER);
        return new FinalizeResultsQueryRunner(factory.createRunner(adapter), factory.getToolchest());
    }

    public static <T> QueryRunner<T> makeSearchQueryRunner(Segment adapter) {
        SearchQueryConfig config = new SearchQueryConfig();
        SearchQueryRunnerFactory factory = new SearchQueryRunnerFactory(new SearchStrategySelector(Suppliers.ofInstance((Object)config)), new SearchQueryQueryToolChest(config, QueryRunnerTestHelper.NoopIntervalChunkingQueryRunnerDecorator()), QueryRunnerTestHelper.NOOP_QUERYWATCHER);
        return new FinalizeResultsQueryRunner(factory.createRunner(adapter), factory.getToolchest());
    }

    public static <T> QueryRunner<T> makeTimeBoundaryQueryRunner(Segment adapter) {
        TimeBoundaryQueryRunnerFactory factory = new TimeBoundaryQueryRunnerFactory(QueryRunnerTestHelper.NOOP_QUERYWATCHER);
        return new FinalizeResultsQueryRunner(factory.createRunner(adapter), factory.getToolchest());
    }
}

