/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import io.druid.js.JavaScriptConfig;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.DoubleSumAggregatorFactory;
import io.druid.query.aggregation.FilteredAggregator;
import io.druid.query.aggregation.FilteredAggregatorFactory;
import io.druid.query.aggregation.TestFloatColumnSelector;
import io.druid.query.dimension.DimensionSpec;
import io.druid.query.extraction.ExtractionFn;
import io.druid.query.extraction.JavaScriptExtractionFn;
import io.druid.query.filter.AndDimFilter;
import io.druid.query.filter.BoundDimFilter;
import io.druid.query.filter.DimFilter;
import io.druid.query.filter.InDimFilter;
import io.druid.query.filter.JavaScriptDimFilter;
import io.druid.query.filter.NotDimFilter;
import io.druid.query.filter.OrDimFilter;
import io.druid.query.filter.RegexDimFilter;
import io.druid.query.filter.SearchQueryDimFilter;
import io.druid.query.filter.SelectorDimFilter;
import io.druid.query.filter.ValueMatcher;
import io.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import io.druid.query.ordering.StringComparators;
import io.druid.query.search.ContainsSearchQuerySpec;
import io.druid.query.search.SearchQuerySpec;
import io.druid.segment.ColumnSelectorFactory;
import io.druid.segment.ColumnValueSelector;
import io.druid.segment.DimensionSelector;
import io.druid.segment.DimensionSelectorUtils;
import io.druid.segment.IdLookup;
import io.druid.segment.column.ColumnCapabilities;
import io.druid.segment.column.ColumnCapabilitiesImpl;
import io.druid.segment.column.ValueType;
import io.druid.segment.data.IndexedInts;
import io.druid.segment.data.SingleIndexedInt;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.junit.Assert;
import org.junit.Test;

public class FilteredAggregatorTest {
    private void aggregate(TestFloatColumnSelector selector, FilteredAggregator agg) {
        agg.aggregate();
        selector.increment();
    }

    @Test
    public void testAggregate() {
        double expectedSecond;
        float[] values = new float[]{0.15f, 0.27f};
        TestFloatColumnSelector selector = new TestFloatColumnSelector(values);
        FilteredAggregatorFactory factory = new FilteredAggregatorFactory((AggregatorFactory)new DoubleSumAggregatorFactory("billy", "value"), (DimFilter)new SelectorDimFilter("dim", "a", null));
        FilteredAggregator agg = (FilteredAggregator)factory.factorize(this.makeColumnSelector(selector));
        double expectedFirst = new Float(values[0]).doubleValue();
        double expectedThird = expectedSecond = new Float(values[1]).doubleValue() + expectedFirst;
        this.assertValues(agg, selector, expectedFirst, expectedSecond, expectedThird);
    }

    private ColumnSelectorFactory makeColumnSelector(final TestFloatColumnSelector selector) {
        return new ColumnSelectorFactory(){

            public DimensionSelector makeDimensionSelector(DimensionSpec dimensionSpec) {
                String dimensionName = dimensionSpec.getDimension();
                if (dimensionName.equals("dim")) {
                    return dimensionSpec.decorate(new DimensionSelector(){

                        public IndexedInts getRow() {
                            if (selector.getIndex() % 3 == 2) {
                                return SingleIndexedInt.of((int)1);
                            }
                            return SingleIndexedInt.of((int)0);
                        }

                        public ValueMatcher makeValueMatcher(String value) {
                            return DimensionSelectorUtils.makeValueMatcherGeneric((DimensionSelector)this, (String)value);
                        }

                        public ValueMatcher makeValueMatcher(Predicate<String> predicate) {
                            return DimensionSelectorUtils.makeValueMatcherGeneric((DimensionSelector)this, predicate);
                        }

                        public int getValueCardinality() {
                            return 2;
                        }

                        public String lookupName(int id) {
                            switch (id) {
                                case 0: {
                                    return "a";
                                }
                                case 1: {
                                    return "b";
                                }
                            }
                            throw new IllegalArgumentException();
                        }

                        public boolean nameLookupPossibleInAdvance() {
                            return true;
                        }

                        @Nullable
                        public IdLookup idLookup() {
                            return new IdLookup(){

                                public int lookupId(String name) {
                                    switch (name) {
                                        case "a": {
                                            return 0;
                                        }
                                        case "b": {
                                            return 1;
                                        }
                                    }
                                    throw new IllegalArgumentException();
                                }
                            };
                        }

                        @Nullable
                        public Object getObject() {
                            return this.defaultGetObject();
                        }

                        public Class classOfObject() {
                            return Object.class;
                        }

                        public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                        }
                    });
                }
                throw new UnsupportedOperationException();
            }

            public ColumnValueSelector<?> makeColumnValueSelector(String columnName) {
                if (columnName.equals("value")) {
                    return selector;
                }
                throw new UnsupportedOperationException();
            }

            public ColumnCapabilities getColumnCapabilities(String columnName) {
                ColumnCapabilitiesImpl caps;
                if (columnName.equals("value")) {
                    caps = new ColumnCapabilitiesImpl();
                    caps.setType(ValueType.FLOAT);
                    caps.setDictionaryEncoded(false);
                    caps.setHasBitmapIndexes(false);
                } else {
                    caps = new ColumnCapabilitiesImpl();
                    caps.setType(ValueType.STRING);
                    caps.setDictionaryEncoded(true);
                    caps.setHasBitmapIndexes(true);
                }
                return caps;
            }
        };
    }

    private void assertValues(FilteredAggregator agg, TestFloatColumnSelector selector, double ... expectedVals) {
        Assert.assertEquals((Object)0.0, (Object)agg.get());
        Assert.assertEquals((Object)0.0, (Object)agg.get());
        Assert.assertEquals((Object)0.0, (Object)agg.get());
        for (double expectedVal : expectedVals) {
            this.aggregate(selector, agg);
            Assert.assertEquals((Object)expectedVal, (Object)agg.get());
            Assert.assertEquals((Object)expectedVal, (Object)agg.get());
            Assert.assertEquals((Object)expectedVal, (Object)agg.get());
        }
    }

    @Test
    public void testAggregateWithNotFilter() {
        float[] values = new float[]{0.15f, 0.27f};
        TestFloatColumnSelector selector = new TestFloatColumnSelector(values);
        FilteredAggregatorFactory factory = new FilteredAggregatorFactory((AggregatorFactory)new DoubleSumAggregatorFactory("billy", "value"), (DimFilter)new NotDimFilter((DimFilter)new SelectorDimFilter("dim", "b", null)));
        this.validateFilteredAggs(factory, values, selector);
    }

    @Test
    public void testAggregateWithOrFilter() {
        float[] values = new float[]{0.15f, 0.27f, 0.14f};
        TestFloatColumnSelector selector = new TestFloatColumnSelector(values);
        FilteredAggregatorFactory factory = new FilteredAggregatorFactory((AggregatorFactory)new DoubleSumAggregatorFactory("billy", "value"), (DimFilter)new OrDimFilter((List)Lists.newArrayList((Object[])new DimFilter[]{new SelectorDimFilter("dim", "a", null), new SelectorDimFilter("dim", "b", null)})));
        FilteredAggregator agg = (FilteredAggregator)factory.factorize(this.makeColumnSelector(selector));
        double expectedFirst = new Float(values[0]).doubleValue();
        double expectedSecond = new Float(values[1]).doubleValue() + expectedFirst;
        double expectedThird = expectedSecond + new Float(values[2]).doubleValue();
        this.assertValues(agg, selector, expectedFirst, expectedSecond, expectedThird);
    }

    @Test
    public void testAggregateWithAndFilter() {
        float[] values = new float[]{0.15f, 0.27f};
        TestFloatColumnSelector selector = new TestFloatColumnSelector(values);
        FilteredAggregatorFactory factory = new FilteredAggregatorFactory((AggregatorFactory)new DoubleSumAggregatorFactory("billy", "value"), (DimFilter)new AndDimFilter((List)Lists.newArrayList((Object[])new DimFilter[]{new NotDimFilter((DimFilter)new SelectorDimFilter("dim", "b", null)), new SelectorDimFilter("dim", "a", null)})));
        this.validateFilteredAggs(factory, values, selector);
    }

    @Test
    public void testAggregateWithPredicateFilters() {
        float[] values = new float[]{0.15f, 0.27f};
        FilteredAggregatorFactory factory = new FilteredAggregatorFactory((AggregatorFactory)new DoubleSumAggregatorFactory("billy", "value"), (DimFilter)new BoundDimFilter("dim", "a", "a", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true), null, StringComparators.ALPHANUMERIC));
        TestFloatColumnSelector selector = new TestFloatColumnSelector(values);
        this.validateFilteredAggs(factory, values, selector);
        factory = new FilteredAggregatorFactory((AggregatorFactory)new DoubleSumAggregatorFactory("billy", "value"), (DimFilter)new RegexDimFilter("dim", "a", null));
        selector = new TestFloatColumnSelector(values);
        this.validateFilteredAggs(factory, values, selector);
        factory = new FilteredAggregatorFactory((AggregatorFactory)new DoubleSumAggregatorFactory("billy", "value"), (DimFilter)new SearchQueryDimFilter("dim", (SearchQuerySpec)new ContainsSearchQuerySpec("a", true), null));
        selector = new TestFloatColumnSelector(values);
        this.validateFilteredAggs(factory, values, selector);
        String jsFn = "function(x) { return(x === 'a') }";
        factory = new FilteredAggregatorFactory((AggregatorFactory)new DoubleSumAggregatorFactory("billy", "value"), (DimFilter)new JavaScriptDimFilter("dim", jsFn, null, JavaScriptConfig.getEnabledInstance()));
        selector = new TestFloatColumnSelector(values);
        this.validateFilteredAggs(factory, values, selector);
    }

    @Test
    public void testAggregateWithExtractionFns() {
        float[] values = new float[]{0.15f, 0.27f};
        String extractionJsFn = "function(str) { return str + 'AARDVARK'; }";
        JavaScriptExtractionFn extractionFn = new JavaScriptExtractionFn(extractionJsFn, false, JavaScriptConfig.getEnabledInstance());
        FilteredAggregatorFactory factory = new FilteredAggregatorFactory((AggregatorFactory)new DoubleSumAggregatorFactory("billy", "value"), (DimFilter)new SelectorDimFilter("dim", "aAARDVARK", (ExtractionFn)extractionFn));
        TestFloatColumnSelector selector = new TestFloatColumnSelector(values);
        this.validateFilteredAggs(factory, values, selector);
        factory = new FilteredAggregatorFactory((AggregatorFactory)new DoubleSumAggregatorFactory("billy", "value"), (DimFilter)new InDimFilter("dim", Arrays.asList("NOT-aAARDVARK", "FOOBAR", "aAARDVARK"), (ExtractionFn)extractionFn));
        selector = new TestFloatColumnSelector(values);
        this.validateFilteredAggs(factory, values, selector);
        factory = new FilteredAggregatorFactory((AggregatorFactory)new DoubleSumAggregatorFactory("billy", "value"), (DimFilter)new BoundDimFilter("dim", "aAARDVARK", "aAARDVARK", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true), (ExtractionFn)extractionFn, StringComparators.ALPHANUMERIC));
        selector = new TestFloatColumnSelector(values);
        this.validateFilteredAggs(factory, values, selector);
        factory = new FilteredAggregatorFactory((AggregatorFactory)new DoubleSumAggregatorFactory("billy", "value"), (DimFilter)new RegexDimFilter("dim", "aAARDVARK", (ExtractionFn)extractionFn));
        selector = new TestFloatColumnSelector(values);
        this.validateFilteredAggs(factory, values, selector);
        factory = new FilteredAggregatorFactory((AggregatorFactory)new DoubleSumAggregatorFactory("billy", "value"), (DimFilter)new SearchQueryDimFilter("dim", (SearchQuerySpec)new ContainsSearchQuerySpec("aAARDVARK", true), (ExtractionFn)extractionFn));
        selector = new TestFloatColumnSelector(values);
        this.validateFilteredAggs(factory, values, selector);
        String jsFn = "function(x) { return(x === 'aAARDVARK') }";
        factory = new FilteredAggregatorFactory((AggregatorFactory)new DoubleSumAggregatorFactory("billy", "value"), (DimFilter)new JavaScriptDimFilter("dim", jsFn, (ExtractionFn)extractionFn, JavaScriptConfig.getEnabledInstance()));
        selector = new TestFloatColumnSelector(values);
        this.validateFilteredAggs(factory, values, selector);
    }

    private void validateFilteredAggs(FilteredAggregatorFactory factory, float[] values, TestFloatColumnSelector selector) {
        double expectedSecond;
        FilteredAggregator agg = (FilteredAggregator)factory.factorize(this.makeColumnSelector(selector));
        double expectedFirst = new Float(values[0]).doubleValue();
        double expectedThird = expectedSecond = new Float(values[1]).doubleValue() + expectedFirst;
        this.assertValues(agg, selector, expectedFirst, expectedSecond, expectedThird);
    }
}

