/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation.last;

import io.druid.collections.SerializablePair;
import io.druid.jackson.DefaultObjectMapper;
import io.druid.java.util.common.Pair;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.TestFloatColumnSelector;
import io.druid.query.aggregation.TestLongColumnSelector;
import io.druid.query.aggregation.TestObjectColumnSelector;
import io.druid.query.aggregation.last.FloatLastAggregator;
import io.druid.query.aggregation.last.FloatLastAggregatorFactory;
import io.druid.query.aggregation.last.FloatLastBufferAggregator;
import io.druid.segment.ColumnSelectorFactory;
import java.nio.ByteBuffer;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FloatLastAggregationTest {
    private FloatLastAggregatorFactory floatLastAggregatorFactory;
    private FloatLastAggregatorFactory combiningAggFactory;
    private ColumnSelectorFactory colSelectorFactory;
    private TestLongColumnSelector timeSelector;
    private TestFloatColumnSelector valueSelector;
    private TestObjectColumnSelector objectSelector;
    private float[] floats = new float[]{1.1897f, 0.001f, 86.23f, 166.228f};
    private long[] times = new long[]{8224L, 6879L, 2436L, 7888L};
    private SerializablePair[] pairs = new SerializablePair[]{new SerializablePair((Object)52782L, (Object)Float.valueOf(134.3f)), new SerializablePair((Object)65492L, (Object)Float.valueOf(1232.212f)), new SerializablePair((Object)69134L, (Object)Float.valueOf(18.1233f)), new SerializablePair((Object)11111L, (Object)Float.valueOf(233.5232f))};

    @Before
    public void setup() {
        this.floatLastAggregatorFactory = new FloatLastAggregatorFactory("billy", "nilly");
        this.combiningAggFactory = (FloatLastAggregatorFactory)this.floatLastAggregatorFactory.getCombiningFactory();
        this.timeSelector = new TestLongColumnSelector(this.times);
        this.valueSelector = new TestFloatColumnSelector(this.floats);
        this.objectSelector = new TestObjectColumnSelector<SerializablePair>(this.pairs);
        this.colSelectorFactory = (ColumnSelectorFactory)EasyMock.createMock(ColumnSelectorFactory.class);
        EasyMock.expect((Object)this.colSelectorFactory.makeColumnValueSelector("__time")).andReturn((Object)this.timeSelector);
        EasyMock.expect((Object)this.colSelectorFactory.makeColumnValueSelector("nilly")).andReturn((Object)this.valueSelector);
        EasyMock.expect((Object)this.colSelectorFactory.makeColumnValueSelector("billy")).andReturn((Object)this.objectSelector);
        EasyMock.replay((Object[])new Object[]{this.colSelectorFactory});
    }

    @Test
    public void testDoubleLastAggregator() {
        FloatLastAggregator agg = (FloatLastAggregator)this.floatLastAggregatorFactory.factorize(this.colSelectorFactory);
        this.aggregate(agg);
        this.aggregate(agg);
        this.aggregate(agg);
        this.aggregate(agg);
        Pair result = (Pair)agg.get();
        Assert.assertEquals((long)this.times[0], (long)((Long)result.lhs));
        Assert.assertEquals((double)this.floats[0], (double)((Float)result.rhs).floatValue(), (double)1.0E-4);
        Assert.assertEquals((long)((long)this.floats[0]), (long)agg.getLong());
        Assert.assertEquals((double)this.floats[0], (double)agg.getFloat(), (double)1.0E-4);
    }

    @Test
    public void testDoubleLastBufferAggregator() {
        FloatLastBufferAggregator agg = (FloatLastBufferAggregator)this.floatLastAggregatorFactory.factorizeBuffered(this.colSelectorFactory);
        ByteBuffer buffer = ByteBuffer.wrap(new byte[this.floatLastAggregatorFactory.getMaxIntermediateSize()]);
        agg.init(buffer, 0);
        this.aggregate(agg, buffer, 0);
        this.aggregate(agg, buffer, 0);
        this.aggregate(agg, buffer, 0);
        this.aggregate(agg, buffer, 0);
        Pair result = (Pair)agg.get(buffer, 0);
        Assert.assertEquals((long)this.times[0], (long)((Long)result.lhs));
        Assert.assertEquals((double)this.floats[0], (double)((Float)result.rhs).floatValue(), (double)1.0E-4);
        Assert.assertEquals((long)((long)this.floats[0]), (long)agg.getLong(buffer, 0));
        Assert.assertEquals((double)this.floats[0], (double)agg.getFloat(buffer, 0), (double)1.0E-4);
    }

    @Test
    public void testCombine() {
        SerializablePair pair1 = new SerializablePair((Object)1467225000L, (Object)3.621);
        SerializablePair pair2 = new SerializablePair((Object)1467240000L, (Object)785.4);
        Assert.assertEquals((Object)pair2, (Object)this.floatLastAggregatorFactory.combine((Object)pair1, (Object)pair2));
    }

    @Test
    public void testDoubleLastCombiningAggregator() {
        FloatLastAggregator agg = (FloatLastAggregator)this.combiningAggFactory.factorize(this.colSelectorFactory);
        this.aggregate(agg);
        this.aggregate(agg);
        this.aggregate(agg);
        this.aggregate(agg);
        Pair result = (Pair)agg.get();
        SerializablePair expected = this.pairs[2];
        Assert.assertEquals((Object)expected.lhs, (Object)result.lhs);
        Assert.assertEquals((double)((Float)expected.rhs).floatValue(), (double)((Float)result.rhs).floatValue(), (double)1.0E-4);
        Assert.assertEquals((long)((Float)expected.rhs).longValue(), (long)agg.getLong());
        Assert.assertEquals((double)((Float)expected.rhs).floatValue(), (double)agg.getFloat(), (double)1.0E-4);
    }

    @Test
    public void testDoubleLastCombiningBufferAggregator() {
        FloatLastBufferAggregator agg = (FloatLastBufferAggregator)this.combiningAggFactory.factorizeBuffered(this.colSelectorFactory);
        ByteBuffer buffer = ByteBuffer.wrap(new byte[this.floatLastAggregatorFactory.getMaxIntermediateSize()]);
        agg.init(buffer, 0);
        this.aggregate(agg, buffer, 0);
        this.aggregate(agg, buffer, 0);
        this.aggregate(agg, buffer, 0);
        this.aggregate(agg, buffer, 0);
        Pair result = (Pair)agg.get(buffer, 0);
        SerializablePair expected = this.pairs[2];
        Assert.assertEquals((Object)expected.lhs, (Object)result.lhs);
        Assert.assertEquals((double)((Float)expected.rhs).floatValue(), (double)((Float)result.rhs).floatValue(), (double)1.0E-4);
        Assert.assertEquals((long)((Float)expected.rhs).longValue(), (long)agg.getLong(buffer, 0));
        Assert.assertEquals((double)((Float)expected.rhs).floatValue(), (double)agg.getFloat(buffer, 0), (double)1.0E-4);
    }

    @Test
    public void testSerde() throws Exception {
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        String doubleSpecJson = "{\"type\":\"floatLast\",\"name\":\"billy\",\"fieldName\":\"nilly\"}";
        Assert.assertEquals((Object)this.floatLastAggregatorFactory, (Object)mapper.readValue(doubleSpecJson, AggregatorFactory.class));
    }

    private void aggregate(FloatLastAggregator agg) {
        agg.aggregate();
        this.timeSelector.increment();
        this.valueSelector.increment();
        this.objectSelector.increment();
    }

    private void aggregate(FloatLastBufferAggregator agg, ByteBuffer buff, int position) {
        agg.aggregate(buff, position);
        this.timeSelector.increment();
        this.valueSelector.increment();
        this.objectSelector.increment();
    }
}

