/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation.last;

import io.druid.collections.SerializablePair;
import io.druid.jackson.DefaultObjectMapper;
import io.druid.java.util.common.Pair;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.TestLongColumnSelector;
import io.druid.query.aggregation.TestObjectColumnSelector;
import io.druid.query.aggregation.last.LongLastAggregator;
import io.druid.query.aggregation.last.LongLastAggregatorFactory;
import io.druid.query.aggregation.last.LongLastBufferAggregator;
import io.druid.segment.ColumnSelectorFactory;
import java.nio.ByteBuffer;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LongLastAggregationTest {
    private LongLastAggregatorFactory longLastAggFactory;
    private LongLastAggregatorFactory combiningAggFactory;
    private ColumnSelectorFactory colSelectorFactory;
    private TestLongColumnSelector timeSelector;
    private TestLongColumnSelector valueSelector;
    private TestObjectColumnSelector objectSelector;
    private long[] longValues = new long[]{23216L, 8635L, 1547123L, Long.MAX_VALUE};
    private long[] times = new long[]{1467935723L, 1467225653L, 1601848932L, 72515L};
    private SerializablePair[] pairs = new SerializablePair[]{new SerializablePair((Object)12531L, (Object)113267L), new SerializablePair((Object)123L, (Object)5437384L), new SerializablePair((Object)125755L, (Object)34583458L), new SerializablePair((Object)124L, (Object)34283452L)};

    @Before
    public void setup() {
        this.longLastAggFactory = new LongLastAggregatorFactory("billy", "nilly");
        this.combiningAggFactory = (LongLastAggregatorFactory)this.longLastAggFactory.getCombiningFactory();
        this.timeSelector = new TestLongColumnSelector(this.times);
        this.valueSelector = new TestLongColumnSelector(this.longValues);
        this.objectSelector = new TestObjectColumnSelector<SerializablePair>(this.pairs);
        this.colSelectorFactory = (ColumnSelectorFactory)EasyMock.createMock(ColumnSelectorFactory.class);
        EasyMock.expect((Object)this.colSelectorFactory.makeColumnValueSelector("__time")).andReturn((Object)this.timeSelector);
        EasyMock.expect((Object)this.colSelectorFactory.makeColumnValueSelector("nilly")).andReturn((Object)this.valueSelector);
        EasyMock.expect((Object)this.colSelectorFactory.makeColumnValueSelector("billy")).andReturn((Object)this.objectSelector);
        EasyMock.replay((Object[])new Object[]{this.colSelectorFactory});
    }

    @Test
    public void testLongLastAggregator() {
        LongLastAggregator agg = (LongLastAggregator)this.longLastAggFactory.factorize(this.colSelectorFactory);
        this.aggregate(agg);
        this.aggregate(agg);
        this.aggregate(agg);
        this.aggregate(agg);
        Pair result = (Pair)agg.get();
        Assert.assertEquals((long)this.times[2], (long)((Long)result.lhs));
        Assert.assertEquals((long)this.longValues[2], (long)((Long)result.rhs));
        Assert.assertEquals((long)this.longValues[2], (long)agg.getLong());
        Assert.assertEquals((float)this.longValues[2], (float)agg.getFloat(), (float)1.0f);
    }

    @Test
    public void testLongLastBufferAggregator() {
        LongLastBufferAggregator agg = (LongLastBufferAggregator)this.longLastAggFactory.factorizeBuffered(this.colSelectorFactory);
        ByteBuffer buffer = ByteBuffer.wrap(new byte[this.longLastAggFactory.getMaxIntermediateSize()]);
        agg.init(buffer, 0);
        this.aggregate(agg, buffer, 0);
        this.aggregate(agg, buffer, 0);
        this.aggregate(agg, buffer, 0);
        this.aggregate(agg, buffer, 0);
        Pair result = (Pair)agg.get(buffer, 0);
        Assert.assertEquals((long)this.times[2], (long)((Long)result.lhs));
        Assert.assertEquals((long)this.longValues[2], (long)((Long)result.rhs));
        Assert.assertEquals((long)this.longValues[2], (long)agg.getLong(buffer, 0));
        Assert.assertEquals((float)this.longValues[2], (float)agg.getFloat(buffer, 0), (float)1.0f);
    }

    @Test
    public void testCombine() {
        SerializablePair pair1 = new SerializablePair((Object)1467225000L, (Object)64432L);
        SerializablePair pair2 = new SerializablePair((Object)1467240000L, (Object)99999L);
        Assert.assertEquals((Object)pair2, (Object)this.longLastAggFactory.combine((Object)pair1, (Object)pair2));
    }

    @Test
    public void testLongLastCombiningAggregator() {
        LongLastAggregator agg = (LongLastAggregator)this.combiningAggFactory.factorize(this.colSelectorFactory);
        this.aggregate(agg);
        this.aggregate(agg);
        this.aggregate(agg);
        this.aggregate(agg);
        Pair result = (Pair)agg.get();
        SerializablePair expected = this.pairs[2];
        Assert.assertEquals((Object)expected.lhs, (Object)result.lhs);
        Assert.assertEquals((Object)expected.rhs, (Object)result.rhs);
        Assert.assertEquals((long)((Long)expected.rhs), (long)agg.getLong());
        Assert.assertEquals((float)((Long)expected.rhs).longValue(), (float)agg.getFloat(), (float)1.0f);
    }

    @Test
    public void testLongLastCombiningBufferAggregator() {
        LongLastBufferAggregator agg = (LongLastBufferAggregator)this.combiningAggFactory.factorizeBuffered(this.colSelectorFactory);
        ByteBuffer buffer = ByteBuffer.wrap(new byte[this.longLastAggFactory.getMaxIntermediateSize()]);
        agg.init(buffer, 0);
        this.aggregate(agg, buffer, 0);
        this.aggregate(agg, buffer, 0);
        this.aggregate(agg, buffer, 0);
        this.aggregate(agg, buffer, 0);
        Pair result = (Pair)agg.get(buffer, 0);
        SerializablePair expected = this.pairs[2];
        Assert.assertEquals((Object)expected.lhs, (Object)result.lhs);
        Assert.assertEquals((Object)expected.rhs, (Object)result.rhs);
        Assert.assertEquals((long)((Long)expected.rhs), (long)agg.getLong(buffer, 0));
        Assert.assertEquals((float)((Long)expected.rhs).longValue(), (float)agg.getFloat(buffer, 0), (float)1.0f);
    }

    @Test
    public void testSerde() throws Exception {
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        String longSpecJson = "{\"type\":\"longLast\",\"name\":\"billy\",\"fieldName\":\"nilly\"}";
        Assert.assertEquals((Object)this.longLastAggFactory, (Object)mapper.readValue(longSpecJson, AggregatorFactory.class));
    }

    private void aggregate(LongLastAggregator agg) {
        agg.aggregate();
        this.timeSelector.increment();
        this.valueSelector.increment();
        this.objectSelector.increment();
    }

    private void aggregate(LongLastBufferAggregator agg, ByteBuffer buff, int position) {
        agg.aggregate(buff, position);
        this.timeSelector.increment();
        this.valueSelector.increment();
        this.objectSelector.increment();
    }
}

