/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation.post;

import com.google.common.collect.Lists;
import io.druid.query.aggregation.CountAggregator;
import io.druid.query.aggregation.PostAggregator;
import io.druid.query.aggregation.post.ConstantPostAggregator;
import io.druid.query.aggregation.post.FieldAccessPostAggregator;
import io.druid.query.aggregation.post.LongLeastPostAggregator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class LongLeastPostAggregatorTest {
    @Test
    public void testCompute() {
        String aggName = "rows";
        CountAggregator agg = new CountAggregator();
        agg.aggregate();
        agg.aggregate();
        agg.aggregate();
        HashMap<String, Object> metricValues = new HashMap<String, Object>();
        metricValues.put("rows", agg.get());
        ArrayList postAggregatorList = Lists.newArrayList((Object[])new PostAggregator[]{new ConstantPostAggregator("roku", (Number)6.0), new FieldAccessPostAggregator("rows", "rows")});
        LongLeastPostAggregator leastPostAggregator = new LongLeastPostAggregator("leastPostAggregator", (List)postAggregatorList);
        Assert.assertEquals((Object)3L, (Object)leastPostAggregator.compute(metricValues));
    }

    @Test
    public void testComparator() {
        String aggName = "rows";
        CountAggregator agg = new CountAggregator();
        HashMap<String, Object> metricValues = new HashMap<String, Object>();
        metricValues.put("rows", agg.get());
        ArrayList postAggregatorList = Lists.newArrayList((Object[])new PostAggregator[]{new ConstantPostAggregator("roku", (Number)2.0), new FieldAccessPostAggregator("rows", "rows")});
        LongLeastPostAggregator leastPostAggregator = new LongLeastPostAggregator("leastPostAggregator", (List)postAggregatorList);
        Comparator comp = leastPostAggregator.getComparator();
        Object before = leastPostAggregator.compute(metricValues);
        agg.aggregate();
        agg.aggregate();
        agg.aggregate();
        metricValues.put("rows", agg.get());
        Object after = leastPostAggregator.compute(metricValues);
        Assert.assertEquals((long)-1L, (long)comp.compare(before, after));
        Assert.assertEquals((long)0L, (long)comp.compare(before, before));
        Assert.assertEquals((long)0L, (long)comp.compare(after, after));
        Assert.assertEquals((long)1L, (long)comp.compare(after, before));
    }
}

