/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.extraction;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.druid.jackson.DefaultObjectMapper;
import io.druid.query.extraction.ExtractionFn;
import io.druid.query.extraction.SearchQuerySpecDimExtractionFn;
import io.druid.query.search.FragmentSearchQuerySpec;
import io.druid.query.search.SearchQuerySpec;
import java.util.ArrayList;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;

public class SearchQuerySpecDimExtractionFnTest {
    private static final String[] testStrings = new String[]{"Kyoto", "Calgary", "Tokyo", "Stockholm", "Toyokawa", "Pretoria", "Yorktown", "Ontario"};

    @Test
    public void testExtraction() {
        FragmentSearchQuerySpec spec = new FragmentSearchQuerySpec(Arrays.asList("tO", "yO"));
        SearchQuerySpecDimExtractionFn extractionFn = new SearchQuerySpecDimExtractionFn((SearchQuerySpec)spec);
        ImmutableList expected = ImmutableList.of((Object)"Kyoto", (Object)"Tokyo", (Object)"Toyokawa", (Object)"Yorktown");
        ArrayList extracted = Lists.newArrayList();
        for (String str : testStrings) {
            String res = extractionFn.apply(str);
            if (res == null) continue;
            extracted.add(res);
        }
        Assert.assertEquals((Object)expected, (Object)extracted);
    }

    @Test
    public void testCaseSensitiveExtraction() {
        FragmentSearchQuerySpec spec = new FragmentSearchQuerySpec(Arrays.asList("to", "yo"), true);
        SearchQuerySpecDimExtractionFn extractionFn = new SearchQuerySpecDimExtractionFn((SearchQuerySpec)spec);
        ImmutableList expected = ImmutableList.of((Object)"Kyoto");
        ArrayList extracted = Lists.newArrayList();
        for (String str : testStrings) {
            String res = extractionFn.apply(str);
            if (res == null) continue;
            extracted.add(res);
        }
        Assert.assertEquals((Object)expected, (Object)extracted);
    }

    @Test
    public void testCaseSensitiveExtraction2() {
        FragmentSearchQuerySpec spec = new FragmentSearchQuerySpec(Arrays.asList("To", "yo"), true);
        SearchQuerySpecDimExtractionFn extractionFn = new SearchQuerySpecDimExtractionFn((SearchQuerySpec)spec);
        ImmutableList expected = ImmutableList.of((Object)"Tokyo", (Object)"Toyokawa");
        ArrayList extracted = Lists.newArrayList();
        for (String str : testStrings) {
            String res = extractionFn.apply(str);
            if (res == null) continue;
            extracted.add(res);
        }
        Assert.assertEquals((Object)expected, (Object)extracted);
    }

    @Test
    public void testSerde() throws Exception {
        DefaultObjectMapper objectMapper = new DefaultObjectMapper();
        FragmentSearchQuerySpec spec = new FragmentSearchQuerySpec(Arrays.asList("to", "yo"), true);
        SearchQuerySpecDimExtractionFn extractionFn = new SearchQuerySpecDimExtractionFn((SearchQuerySpec)spec);
        ExtractionFn extractionFn2 = (ExtractionFn)objectMapper.readValue(objectMapper.writeValueAsBytes((Object)extractionFn), ExtractionFn.class);
        FragmentSearchQuerySpec spec2 = (FragmentSearchQuerySpec)((SearchQuerySpecDimExtractionFn)extractionFn2).getSearchQuerySpec();
        Assert.assertEquals((Object)extractionFn, (Object)extractionFn2);
        Assert.assertEquals((Object)true, (Object)spec2.isCaseSensitive());
        Assert.assertEquals((Object)ImmutableList.of((Object)"to", (Object)"yo"), (Object)spec2.getValues());
    }
}

