/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.extraction;

import io.druid.jackson.DefaultObjectMapper;
import io.druid.query.extraction.ExtractionFn;
import io.druid.query.extraction.SubstringDimExtractionFn;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;

public class SubstringDimExtractionFnTest {
    @Test
    public void testSubstrings() {
        SubstringDimExtractionFn extractionFn = new SubstringDimExtractionFn(1, Integer.valueOf(3));
        Assert.assertEquals((Object)"ppl", (Object)extractionFn.apply("apple"));
        Assert.assertEquals((Object)"e", (Object)extractionFn.apply("be"));
        Assert.assertEquals((Object)"ool", (Object)extractionFn.apply("cool"));
        Assert.assertEquals(null, (Object)extractionFn.apply("a"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testZeroLength() {
        SubstringDimExtractionFn extractionFnNoLength = new SubstringDimExtractionFn(1, Integer.valueOf(0));
    }

    @Test
    public void testNoLength() {
        SubstringDimExtractionFn extractionFnNoLength = new SubstringDimExtractionFn(1, null);
        Assert.assertEquals((Object)"abcdef", (Object)extractionFnNoLength.apply("/abcdef"));
        Assert.assertEquals(null, (Object)extractionFnNoLength.apply("/"));
    }

    @Test
    public void testGetCacheKey() {
        SubstringDimExtractionFn extractionFn1 = new SubstringDimExtractionFn(2, Integer.valueOf(4));
        SubstringDimExtractionFn extractionFn2 = new SubstringDimExtractionFn(2, Integer.valueOf(4));
        SubstringDimExtractionFn extractionFn3 = new SubstringDimExtractionFn(1, Integer.valueOf(4));
        Assert.assertArrayEquals((byte[])extractionFn1.getCacheKey(), (byte[])extractionFn2.getCacheKey());
        Assert.assertFalse((boolean)Arrays.equals(extractionFn1.getCacheKey(), extractionFn3.getCacheKey()));
    }

    @Test
    public void testHashCode() {
        SubstringDimExtractionFn extractionFn1 = new SubstringDimExtractionFn(2, Integer.valueOf(4));
        SubstringDimExtractionFn extractionFn2 = new SubstringDimExtractionFn(2, Integer.valueOf(4));
        SubstringDimExtractionFn extractionFn3 = new SubstringDimExtractionFn(1, Integer.valueOf(4));
        Assert.assertEquals((long)extractionFn1.hashCode(), (long)extractionFn2.hashCode());
        Assert.assertNotEquals((long)extractionFn1.hashCode(), (long)extractionFn3.hashCode());
    }

    @Test
    public void testNullAndEmpty() {
        SubstringDimExtractionFn extractionFn = new SubstringDimExtractionFn(2, Integer.valueOf(4));
        Assert.assertEquals(null, (Object)extractionFn.apply(""));
        Assert.assertEquals(null, (Object)extractionFn.apply(null));
        Assert.assertEquals(null, (Object)extractionFn.apply("/a"));
    }

    @Test
    public void testSerde() throws Exception {
        DefaultObjectMapper objectMapper = new DefaultObjectMapper();
        String json = "{ \"type\" : \"substring\", \"index\" : 1, \"length\" : 3 }";
        String jsonNoLength = "{ \"type\" : \"substring\", \"index\" : 1 }";
        SubstringDimExtractionFn extractionFn = (SubstringDimExtractionFn)objectMapper.readValue("{ \"type\" : \"substring\", \"index\" : 1, \"length\" : 3 }", ExtractionFn.class);
        SubstringDimExtractionFn extractionFnNoLength = (SubstringDimExtractionFn)objectMapper.readValue("{ \"type\" : \"substring\", \"index\" : 1 }", ExtractionFn.class);
        Assert.assertEquals((long)1L, (long)extractionFn.getIndex());
        Assert.assertEquals((Object)new Integer(3), (Object)extractionFn.getLength());
        Assert.assertEquals((long)1L, (long)extractionFnNoLength.getIndex());
        Assert.assertEquals(null, (Object)extractionFnNoLength.getLength());
        Assert.assertEquals((Object)extractionFn, (Object)objectMapper.readValue(objectMapper.writeValueAsBytes((Object)extractionFn), ExtractionFn.class));
        Assert.assertEquals((Object)extractionFnNoLength, (Object)objectMapper.readValue(objectMapper.writeValueAsBytes((Object)extractionFnNoLength), ExtractionFn.class));
    }
}

