/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.groupby;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.druid.data.input.Row;
import io.druid.data.input.impl.CSVParseSpec;
import io.druid.data.input.impl.DimensionsSpec;
import io.druid.data.input.impl.ParseSpec;
import io.druid.data.input.impl.StringInputRowParser;
import io.druid.data.input.impl.TimestampSpec;
import io.druid.java.util.common.granularity.Granularities;
import io.druid.java.util.common.guava.MergeSequence;
import io.druid.java.util.common.guava.Sequence;
import io.druid.java.util.common.guava.Sequences;
import io.druid.query.Query;
import io.druid.query.QueryPlus;
import io.druid.query.QueryRunner;
import io.druid.query.QueryRunnerFactory;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.CountAggregatorFactory;
import io.druid.query.dimension.DefaultDimensionSpec;
import io.druid.query.dimension.DimensionSpec;
import io.druid.query.groupby.GroupByQuery;
import io.druid.query.groupby.GroupByQueryConfig;
import io.druid.query.groupby.GroupByQueryRunnerFactory;
import io.druid.query.groupby.GroupByQueryRunnerTest;
import io.druid.query.groupby.GroupByQueryRunnerTestHelper;
import io.druid.query.spec.LegacySegmentSpec;
import io.druid.query.spec.QuerySegmentSpec;
import io.druid.segment.CloserRule;
import io.druid.segment.IncrementalIndexSegment;
import io.druid.segment.Segment;
import io.druid.segment.TestHelper;
import io.druid.segment.incremental.IncrementalIndex;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.junit.Rule;
import org.junit.Test;

public class GroupByQueryRunnerFactoryTest {
    @Rule
    public CloserRule closerRule = new CloserRule(true);

    @Test
    public void testMergeRunnersEnsureGroupMerging() throws Exception {
        GroupByQuery query = GroupByQuery.builder().setDataSource("xx").setQuerySegmentSpec((QuerySegmentSpec)new LegacySegmentSpec((Object)"1970/3000")).setGranularity(Granularities.ALL).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("tags", "tags")})).setAggregatorSpecs(Collections.singletonList(new CountAggregatorFactory("count"))).build();
        GroupByQueryRunnerFactory factory = GroupByQueryRunnerTest.makeQueryRunnerFactory(new GroupByQueryConfig());
        QueryRunner mergedRunner = factory.getToolchest().mergeResults(new QueryRunner((QueryRunnerFactory)factory){
            final /* synthetic */ QueryRunnerFactory val$factory;
            {
                this.val$factory = queryRunnerFactory;
            }

            public Sequence run(QueryPlus queryPlus, Map responseContext) {
                return this.val$factory.getToolchest().mergeResults(new QueryRunner(){

                    public Sequence run(QueryPlus queryPlus, Map responseContext) {
                        Query query = queryPlus.getQuery();
                        try {
                            return new MergeSequence(query.getResultOrdering(), Sequences.simple(Arrays.asList(val$factory.createRunner(GroupByQueryRunnerFactoryTest.this.createSegment()).run(queryPlus, responseContext), val$factory.createRunner(GroupByQueryRunnerFactoryTest.this.createSegment()).run(queryPlus, responseContext))));
                        }
                        catch (Exception e) {
                            Throwables.propagate((Throwable)e);
                            return null;
                        }
                    }
                }).run(queryPlus, responseContext);
            }
        });
        Sequence result = mergedRunner.run(QueryPlus.wrap((Query)query), (Map)Maps.newHashMap());
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("1970-01-01T00:00:00.000Z", "tags", "t1", "count", 2L), GroupByQueryRunnerTestHelper.createExpectedRow("1970-01-01T00:00:00.000Z", "tags", "t2", "count", 4L));
        TestHelper.assertExpectedObjects(expectedResults, Sequences.toList((Sequence)result, new ArrayList()), "");
    }

    private Segment createSegment() throws Exception {
        String[] rows;
        IncrementalIndex incrementalIndex = new IncrementalIndex.Builder().setSimpleTestingIndexSchema(new AggregatorFactory[]{new CountAggregatorFactory("count")}).setConcurrentEventAdd(true).setMaxRowCount(5000).buildOnheap();
        StringInputRowParser parser = new StringInputRowParser((ParseSpec)new CSVParseSpec(new TimestampSpec("timestamp", "iso", null), new DimensionsSpec(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"product", (Object)"tags")), null, null), "\t", (List)ImmutableList.of((Object)"timestamp", (Object)"product", (Object)"tags"), false, 0), "UTF-8");
        for (String row : rows = new String[]{"2011-01-12T00:00:00.000Z,product_1,t1", "2011-01-13T00:00:00.000Z,product_2,t2", "2011-01-14T00:00:00.000Z,product_3,t2"}) {
            incrementalIndex.add(parser.parse(row));
        }
        this.closerRule.closeLater(incrementalIndex);
        return new IncrementalIndexSegment(incrementalIndex, "test");
    }
}

