/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.groupby;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Functions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.MoreExecutors;
import io.druid.collections.BlockingPool;
import io.druid.collections.DefaultBlockingPool;
import io.druid.collections.NonBlockingPool;
import io.druid.collections.StupidPool;
import io.druid.data.input.Row;
import io.druid.java.util.common.DateTimes;
import io.druid.java.util.common.IAE;
import io.druid.java.util.common.ISE;
import io.druid.java.util.common.Intervals;
import io.druid.java.util.common.StringUtils;
import io.druid.java.util.common.granularity.DurationGranularity;
import io.druid.java.util.common.granularity.Granularities;
import io.druid.java.util.common.granularity.Granularity;
import io.druid.java.util.common.granularity.PeriodGranularity;
import io.druid.java.util.common.guava.MergeSequence;
import io.druid.java.util.common.guava.Sequence;
import io.druid.java.util.common.guava.Sequences;
import io.druid.js.JavaScriptConfig;
import io.druid.query.BySegmentResultValueClass;
import io.druid.query.ChainedExecutionQueryRunner;
import io.druid.query.DataSource;
import io.druid.query.DruidProcessingConfig;
import io.druid.query.FinalizeResultsQueryRunner;
import io.druid.query.Query;
import io.druid.query.QueryDataSource;
import io.druid.query.QueryPlus;
import io.druid.query.QueryRunner;
import io.druid.query.QueryRunnerFactory;
import io.druid.query.QueryRunnerTestHelper;
import io.druid.query.QueryToolChest;
import io.druid.query.ResourceLimitExceededException;
import io.druid.query.Result;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.CountAggregatorFactory;
import io.druid.query.aggregation.DoubleMaxAggregatorFactory;
import io.druid.query.aggregation.DoubleSumAggregatorFactory;
import io.druid.query.aggregation.FilteredAggregatorFactory;
import io.druid.query.aggregation.FloatSumAggregatorFactory;
import io.druid.query.aggregation.JavaScriptAggregatorFactory;
import io.druid.query.aggregation.LongMaxAggregatorFactory;
import io.druid.query.aggregation.LongSumAggregatorFactory;
import io.druid.query.aggregation.PostAggregator;
import io.druid.query.aggregation.cardinality.CardinalityAggregatorFactory;
import io.druid.query.aggregation.first.LongFirstAggregatorFactory;
import io.druid.query.aggregation.hyperloglog.HyperUniqueFinalizingPostAggregator;
import io.druid.query.aggregation.hyperloglog.HyperUniquesAggregatorFactory;
import io.druid.query.aggregation.last.LongLastAggregatorFactory;
import io.druid.query.aggregation.post.ArithmeticPostAggregator;
import io.druid.query.aggregation.post.ConstantPostAggregator;
import io.druid.query.aggregation.post.ExpressionPostAggregator;
import io.druid.query.aggregation.post.FieldAccessPostAggregator;
import io.druid.query.dimension.DefaultDimensionSpec;
import io.druid.query.dimension.DimensionSpec;
import io.druid.query.dimension.ExtractionDimensionSpec;
import io.druid.query.dimension.ListFilteredDimensionSpec;
import io.druid.query.dimension.RegexFilteredDimensionSpec;
import io.druid.query.expression.TestExprMacroTable;
import io.druid.query.extraction.CascadeExtractionFn;
import io.druid.query.extraction.DimExtractionFn;
import io.druid.query.extraction.ExtractionFn;
import io.druid.query.extraction.JavaScriptExtractionFn;
import io.druid.query.extraction.MapLookupExtractor;
import io.druid.query.extraction.RegexDimExtractionFn;
import io.druid.query.extraction.StringFormatExtractionFn;
import io.druid.query.extraction.StrlenExtractionFn;
import io.druid.query.extraction.TimeFormatExtractionFn;
import io.druid.query.filter.AndDimFilter;
import io.druid.query.filter.BoundDimFilter;
import io.druid.query.filter.DimFilter;
import io.druid.query.filter.ExtractionDimFilter;
import io.druid.query.filter.InDimFilter;
import io.druid.query.filter.JavaScriptDimFilter;
import io.druid.query.filter.OrDimFilter;
import io.druid.query.filter.RegexDimFilter;
import io.druid.query.filter.SearchQueryDimFilter;
import io.druid.query.filter.SelectorDimFilter;
import io.druid.query.groupby.GroupByQuery;
import io.druid.query.groupby.GroupByQueryConfig;
import io.druid.query.groupby.GroupByQueryEngine;
import io.druid.query.groupby.GroupByQueryQueryToolChest;
import io.druid.query.groupby.GroupByQueryRunnerFactory;
import io.druid.query.groupby.GroupByQueryRunnerTestHelper;
import io.druid.query.groupby.having.BaseHavingSpec;
import io.druid.query.groupby.having.DimFilterHavingSpec;
import io.druid.query.groupby.having.DimensionSelectorHavingSpec;
import io.druid.query.groupby.having.EqualToHavingSpec;
import io.druid.query.groupby.having.GreaterThanHavingSpec;
import io.druid.query.groupby.having.HavingSpec;
import io.druid.query.groupby.having.OrHavingSpec;
import io.druid.query.groupby.orderby.DefaultLimitSpec;
import io.druid.query.groupby.orderby.LimitSpec;
import io.druid.query.groupby.orderby.OrderByColumnSpec;
import io.druid.query.groupby.strategy.GroupByStrategySelector;
import io.druid.query.groupby.strategy.GroupByStrategyV1;
import io.druid.query.groupby.strategy.GroupByStrategyV2;
import io.druid.query.lookup.LookupExtractionFn;
import io.druid.query.lookup.LookupExtractor;
import io.druid.query.ordering.StringComparators;
import io.druid.query.search.ContainsSearchQuerySpec;
import io.druid.query.search.SearchQuerySpec;
import io.druid.query.spec.MultipleIntervalSegmentSpec;
import io.druid.query.spec.QuerySegmentSpec;
import io.druid.segment.TestHelper;
import io.druid.segment.VirtualColumn;
import io.druid.segment.column.ValueType;
import io.druid.segment.virtual.ExpressionVirtualColumn;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class GroupByQueryRunnerTest {
    public static final ObjectMapper DEFAULT_MAPPER = TestHelper.makeSmileMapper();
    public static final DruidProcessingConfig DEFAULT_PROCESSING_CONFIG = new DruidProcessingConfig(){

        public String getFormatString() {
            return null;
        }

        public int intermediateComputeSizeBytes() {
            return 0xA00000;
        }

        public int getNumMergeBuffers() {
            return 2;
        }

        public int getNumThreads() {
            return 2;
        }
    };
    private final QueryRunner<Row> runner;
    private GroupByQueryRunnerFactory factory;
    private GroupByQueryConfig config;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    public static List<GroupByQueryConfig> testConfigs() {
        GroupByQueryConfig v1Config = new GroupByQueryConfig(){

            public String toString() {
                return "v1";
            }

            public String getDefaultStrategy() {
                return "v1";
            }
        };
        GroupByQueryConfig v1SingleThreadedConfig = new GroupByQueryConfig(){

            public boolean isSingleThreaded() {
                return true;
            }

            public String getDefaultStrategy() {
                return "v1";
            }

            public String toString() {
                return "v1SingleThreaded";
            }
        };
        GroupByQueryConfig v2Config = new GroupByQueryConfig(){

            public String getDefaultStrategy() {
                return "v2";
            }

            public String toString() {
                return "v2";
            }
        };
        GroupByQueryConfig v2SmallBufferConfig = new GroupByQueryConfig(){

            public String getDefaultStrategy() {
                return "v2";
            }

            public int getBufferGrouperMaxSize() {
                return 2;
            }

            public long getMaxOnDiskStorage() {
                return 0xA00000L;
            }

            public String toString() {
                return "v2SmallBuffer";
            }
        };
        GroupByQueryConfig v2SmallDictionaryConfig = new GroupByQueryConfig(){

            public String getDefaultStrategy() {
                return "v2";
            }

            public long getMaxMergingDictionarySize() {
                return 400L;
            }

            public long getMaxOnDiskStorage() {
                return 0xA00000L;
            }

            public String toString() {
                return "v2SmallDictionary";
            }
        };
        GroupByQueryConfig v2ParallelCombineConfig = new GroupByQueryConfig(){

            public String getDefaultStrategy() {
                return "v2";
            }

            public int getNumParallelCombineThreads() {
                return DEFAULT_PROCESSING_CONFIG.getNumThreads();
            }

            public String toString() {
                return "v2ParallelCombine";
            }
        };
        v1Config.setMaxIntermediateRows(10000);
        v1SingleThreadedConfig.setMaxIntermediateRows(10000);
        return ImmutableList.of((Object)v1Config, (Object)v1SingleThreadedConfig, (Object)v2Config, (Object)v2SmallBufferConfig, (Object)v2SmallDictionaryConfig, (Object)v2ParallelCombineConfig);
    }

    public static GroupByQueryRunnerFactory makeQueryRunnerFactory(GroupByQueryConfig config) {
        return GroupByQueryRunnerTest.makeQueryRunnerFactory(DEFAULT_MAPPER, config, DEFAULT_PROCESSING_CONFIG);
    }

    public static GroupByQueryRunnerFactory makeQueryRunnerFactory(ObjectMapper mapper, GroupByQueryConfig config) {
        return GroupByQueryRunnerTest.makeQueryRunnerFactory(mapper, config, DEFAULT_PROCESSING_CONFIG);
    }

    public static GroupByQueryRunnerFactory makeQueryRunnerFactory(ObjectMapper mapper, GroupByQueryConfig config, final DruidProcessingConfig processingConfig) {
        Supplier configSupplier = Suppliers.ofInstance((Object)config);
        StupidPool bufferPool = new StupidPool("GroupByQueryEngine-bufferPool", (Supplier)new Supplier<ByteBuffer>(){

            public ByteBuffer get() {
                return ByteBuffer.allocateDirect(processingConfig.intermediateComputeSizeBytes());
            }
        });
        DefaultBlockingPool mergeBufferPool = new DefaultBlockingPool((Supplier)new Supplier<ByteBuffer>(){

            public ByteBuffer get() {
                return ByteBuffer.allocateDirect(processingConfig.intermediateComputeSizeBytes());
            }
        }, processingConfig.getNumMergeBuffers());
        GroupByStrategySelector strategySelector = new GroupByStrategySelector(configSupplier, new GroupByStrategyV1(configSupplier, new GroupByQueryEngine(configSupplier, (NonBlockingPool)bufferPool), QueryRunnerTestHelper.NOOP_QUERYWATCHER, (NonBlockingPool)bufferPool), new GroupByStrategyV2(processingConfig, configSupplier, (NonBlockingPool)bufferPool, (BlockingPool)mergeBufferPool, mapper, QueryRunnerTestHelper.NOOP_QUERYWATCHER));
        GroupByQueryQueryToolChest toolChest = new GroupByQueryQueryToolChest(strategySelector, QueryRunnerTestHelper.sameThreadIntervalChunkingQueryRunnerDecorator());
        return new GroupByQueryRunnerFactory(strategySelector, toolChest);
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection<?> constructorFeeder() throws IOException {
        ArrayList constructors = Lists.newArrayList();
        for (GroupByQueryConfig config : GroupByQueryRunnerTest.testConfigs()) {
            GroupByQueryRunnerFactory factory = GroupByQueryRunnerTest.makeQueryRunnerFactory(config);
            for (QueryRunner runner : QueryRunnerTestHelper.makeQueryRunners(factory)) {
                String testName = StringUtils.format((String)"config=%s, runner=%s", (Object[])new Object[]{config.toString(), runner.toString()});
                constructors.add(new Object[]{testName, config, factory, runner});
            }
        }
        return constructors;
    }

    public GroupByQueryRunnerTest(String testName, GroupByQueryConfig config, GroupByQueryRunnerFactory factory, QueryRunner runner) {
        this.config = config;
        this.factory = factory;
        this.runner = factory.mergeRunners((ExecutorService)MoreExecutors.sameThreadExecutor(), (Iterable)ImmutableList.of((Object)runner));
    }

    @Test
    public void testGroupBy() {
        GroupByQuery query = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"), new FloatSumAggregatorFactory("idxFloat", "indexFloat"), new DoubleSumAggregatorFactory("idxDouble", "index"))).setGranularity(QueryRunnerTestHelper.dayGran).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "automotive", "rows", 1L, "idx", 135L, "idxFloat", Float.valueOf(135.8851f), "idxDouble", (double)135.8851f), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "business", "rows", 1L, "idx", 118L, "idxFloat", 118.57034, "idxDouble", 118.57034), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "entertainment", "rows", 1L, "idx", 158L, "idxFloat", 158.747224, "idxDouble", 158.747224), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "health", "rows", 1L, "idx", 120L, "idxFloat", 120.134704, "idxDouble", 120.134704), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "mezzanine", "rows", 3L, "idx", 2870L, "idxFloat", Float.valueOf(2871.8867f), "idxDouble", 2871.8866900000003), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "news", "rows", 1L, "idx", 121L, "idxFloat", Float.valueOf(121.58358f), "idxDouble", 121.58358), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "premium", "rows", 3L, "idx", 2900L, "idxFloat", Float.valueOf(2900.7986f), "idxDouble", 2900.798647), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "technology", "rows", 1L, "idx", 78L, "idxFloat", Float.valueOf(78.62254f), "idxDouble", 78.622547), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "travel", "rows", 1L, "idx", 119L, "idxFloat", Float.valueOf(119.922745f), "idxDouble", 119.922742), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "automotive", "rows", 1L, "idx", 147L, "idxFloat", Float.valueOf(147.42593f), "idxDouble", 147.42593), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "business", "rows", 1L, "idx", 112L, "idxFloat", Float.valueOf(112.98703f), "idxDouble", 112.987027), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "entertainment", "rows", 1L, "idx", 166L, "idxFloat", Float.valueOf(166.01605f), "idxDouble", 166.016049), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "health", "rows", 1L, "idx", 113L, "idxFloat", Float.valueOf(113.44601f), "idxDouble", 113.446008), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "mezzanine", "rows", 3L, "idx", 2447L, "idxFloat", Float.valueOf(2448.8306f), "idxDouble", 2448.830613), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "news", "rows", 1L, "idx", 114L, "idxFloat", Float.valueOf(114.29014f), "idxDouble", 114.290141), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "premium", "rows", 3L, "idx", 2505L, "idxFloat", Float.valueOf(2506.415f), "idxDouble", 2506.415148), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "technology", "rows", 1L, "idx", 97L, "idxFloat", Float.valueOf(97.387436f), "idxDouble", 97.387433), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "travel", "rows", 1L, "idx", 126L, "idxFloat", Float.valueOf(126.41136f), "idxDouble", 126.411364));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Test
    public void testGroupByOnMissingColumn() {
        GroupByQuery query = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("nonexistent0", "alias0"), new ExtractionDimensionSpec("nonexistent1", "alias1", (ExtractionFn)new StringFormatExtractionFn("foo"))})).setAggregatorSpecs(Collections.singletonList(QueryRunnerTestHelper.rowsCount)).setGranularity(QueryRunnerTestHelper.allGran).build();
        List<Row> expectedResults = Collections.singletonList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias0", null, "alias1", "foo", "rows", 26L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Test
    public void testGroupByWithStringPostAggregator() {
        GroupByQuery query = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).setPostAggregatorSpecs((List)ImmutableList.of((Object)new ExpressionPostAggregator("post", "alias + 'x'", null, TestExprMacroTable.INSTANCE))).setGranularity(QueryRunnerTestHelper.dayGran).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("post", OrderByColumnSpec.Direction.DESCENDING)), Integer.valueOf(Integer.MAX_VALUE))).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "travel", "post", "travelx", "rows", 1L, "idx", 119L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "technology", "post", "technologyx", "rows", 1L, "idx", 78L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "premium", "post", "premiumx", "rows", 3L, "idx", 2900L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "news", "post", "newsx", "rows", 1L, "idx", 121L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "mezzanine", "post", "mezzaninex", "rows", 3L, "idx", 2870L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "health", "post", "healthx", "rows", 1L, "idx", 120L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "entertainment", "post", "entertainmentx", "rows", 1L, "idx", 158L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "business", "post", "businessx", "rows", 1L, "idx", 118L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "automotive", "post", "automotivex", "rows", 1L, "idx", 135L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "travel", "post", "travelx", "rows", 1L, "idx", 126L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "technology", "post", "technologyx", "rows", 1L, "idx", 97L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "premium", "post", "premiumx", "rows", 3L, "idx", 2505L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "news", "post", "newsx", "rows", 1L, "idx", 114L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "mezzanine", "post", "mezzaninex", "rows", 3L, "idx", 2447L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "health", "post", "healthx", "rows", 1L, "idx", 113L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "entertainment", "post", "entertainmentx", "rows", 1L, "idx", 166L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "business", "post", "businessx", "rows", 1L, "idx", 112L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "automotive", "post", "automotivex", "rows", 1L, "idx", 147L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Test
    public void testGroupByWithStringVirtualColumn() {
        GroupByQuery query = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setVirtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("vc", "quality + 'x'", ValueType.STRING, TestExprMacroTable.INSTANCE)}).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("vc", "alias")})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).setGranularity(QueryRunnerTestHelper.dayGran).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "automotivex", "rows", 1L, "idx", 135L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "businessx", "rows", 1L, "idx", 118L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "entertainmentx", "rows", 1L, "idx", 158L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "healthx", "rows", 1L, "idx", 120L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "mezzaninex", "rows", 3L, "idx", 2870L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "newsx", "rows", 1L, "idx", 121L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "premiumx", "rows", 3L, "idx", 2900L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "technologyx", "rows", 1L, "idx", 78L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "travelx", "rows", 1L, "idx", 119L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "automotivex", "rows", 1L, "idx", 147L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "businessx", "rows", 1L, "idx", 112L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "entertainmentx", "rows", 1L, "idx", 166L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "healthx", "rows", 1L, "idx", 113L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "mezzaninex", "rows", 3L, "idx", 2447L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "newsx", "rows", 1L, "idx", 114L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "premiumx", "rows", 3L, "idx", 2505L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "technologyx", "rows", 1L, "idx", 97L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "travelx", "rows", 1L, "idx", 126L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Test
    public void testGroupByWithDurationGranularity() {
        GroupByQuery query = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).setGranularity((Granularity)new DurationGranularity(86400L, 0L)).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "automotive", "rows", 1L, "idx", 135L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "business", "rows", 1L, "idx", 118L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "entertainment", "rows", 1L, "idx", 158L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "health", "rows", 1L, "idx", 120L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "mezzanine", "rows", 3L, "idx", 2870L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "news", "rows", 1L, "idx", 121L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "premium", "rows", 3L, "idx", 2900L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "technology", "rows", 1L, "idx", 78L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "travel", "rows", 1L, "idx", 119L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "automotive", "rows", 1L, "idx", 147L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "business", "rows", 1L, "idx", 112L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "entertainment", "rows", 1L, "idx", 166L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "health", "rows", 1L, "idx", 113L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "mezzanine", "rows", 3L, "idx", 2447L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "news", "rows", 1L, "idx", 114L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "premium", "rows", 3L, "idx", 2505L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "technology", "rows", 1L, "idx", 97L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "travel", "rows", 1L, "idx", 126L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Test
    public void testGroupByWithOutputNameCollisions() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("[alias] already defined");
        GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("alias", "index"))).setGranularity(QueryRunnerTestHelper.dayGran).build();
    }

    @Test
    public void testGroupByWithSortDimsFirst() {
        GroupByQuery query = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).setGranularity(QueryRunnerTestHelper.dayGran).setContext((Map)ImmutableMap.of((Object)"sortByDimsFirst", (Object)true, (Object)"groupByStrategy", (Object)"v2")).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "automotive", "rows", 1L, "idx", 135L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "automotive", "rows", 1L, "idx", 147L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "business", "rows", 1L, "idx", 118L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "business", "rows", 1L, "idx", 112L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "entertainment", "rows", 1L, "idx", 158L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "entertainment", "rows", 1L, "idx", 166L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "health", "rows", 1L, "idx", 120L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "health", "rows", 1L, "idx", 113L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "mezzanine", "rows", 3L, "idx", 2870L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "mezzanine", "rows", 3L, "idx", 2447L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "news", "rows", 1L, "idx", 121L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "news", "rows", 1L, "idx", 114L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "premium", "rows", 3L, "idx", 2900L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "premium", "rows", 3L, "idx", 2505L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "technology", "rows", 1L, "idx", 78L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "technology", "rows", 1L, "idx", 97L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "travel", "rows", 1L, "idx", 119L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "travel", "rows", 1L, "idx", 126L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Test
    public void testGroupByWithChunkPeriod() {
        GroupByQuery query = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).setGranularity(QueryRunnerTestHelper.allGran).setContext((Map)ImmutableMap.of((Object)"chunkPeriod", (Object)"P1D")).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "automotive", "rows", 2L, "idx", 282L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "business", "rows", 2L, "idx", 230L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "entertainment", "rows", 2L, "idx", 324L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "health", "rows", 2L, "idx", 233L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "mezzanine", "rows", 6L, "idx", 5317L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "news", "rows", 2L, "idx", 235L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "premium", "rows", 6L, "idx", 5405L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "technology", "rows", 2L, "idx", 175L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "travel", "rows", 2L, "idx", 245L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Test
    public void testGroupByNoAggregators() {
        GroupByQuery query = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")})).setGranularity(QueryRunnerTestHelper.dayGran).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "automotive"), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "business"), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "entertainment"), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "health"), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "mezzanine"), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "news"), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "premium"), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "technology"), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "travel"), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "automotive"), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "business"), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "entertainment"), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "health"), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "mezzanine"), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "news"), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "premium"), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "technology"), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "travel"));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Test
    public void testMultiValueDimension() {
        GroupByQuery query = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("placementish", "alias")})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).setGranularity(QueryRunnerTestHelper.allGran).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "a", "rows", 2L, "idx", 282L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "b", "rows", 2L, "idx", 230L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "e", "rows", 2L, "idx", 324L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "h", "rows", 2L, "idx", 233L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "m", "rows", 6L, "idx", 5317L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "n", "rows", 2L, "idx", 235L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "p", "rows", 6L, "idx", 5405L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "preferred", "rows", 26L, "idx", 12446L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "t", "rows", 4L, "idx", 420L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Test
    public void testTwoMultiValueDimensions() {
        GroupByQuery query = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimFilter((DimFilter)new SelectorDimFilter("placementish", "a", null)).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("placementish", "alias"), new DefaultDimensionSpec("placementish", "alias2")})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).setGranularity(QueryRunnerTestHelper.allGran).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "a", "alias2", "a", "rows", 2L, "idx", 282L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "a", "alias2", "preferred", "rows", 2L, "idx", 282L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "preferred", "alias2", "a", "rows", 2L, "idx", 282L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "preferred", "alias2", "preferred", "rows", 2L, "idx", 282L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Test
    public void testMultipleDimensionsOneOfWhichIsMultiValue1() {
        GroupByQuery query = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("placementish", "alias"), new DefaultDimensionSpec("quality", "quality")})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).setGranularity(QueryRunnerTestHelper.allGran).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "quality", "automotive", "alias", "a", "rows", 2L, "idx", 282L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "quality", "business", "alias", "b", "rows", 2L, "idx", 230L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "quality", "entertainment", "alias", "e", "rows", 2L, "idx", 324L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "quality", "health", "alias", "h", "rows", 2L, "idx", 233L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "quality", "mezzanine", "alias", "m", "rows", 6L, "idx", 5317L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "quality", "news", "alias", "n", "rows", 2L, "idx", 235L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "quality", "premium", "alias", "p", "rows", 6L, "idx", 5405L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "quality", "automotive", "alias", "preferred", "rows", 2L, "idx", 282L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "quality", "business", "alias", "preferred", "rows", 2L, "idx", 230L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "quality", "entertainment", "alias", "preferred", "rows", 2L, "idx", 324L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "quality", "health", "alias", "preferred", "rows", 2L, "idx", 233L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "quality", "mezzanine", "alias", "preferred", "rows", 6L, "idx", 5317L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "quality", "news", "alias", "preferred", "rows", 2L, "idx", 235L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "quality", "premium", "alias", "preferred", "rows", 6L, "idx", 5405L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "quality", "technology", "alias", "preferred", "rows", 2L, "idx", 175L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "quality", "travel", "alias", "preferred", "rows", 2L, "idx", 245L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "quality", "technology", "alias", "t", "rows", 2L, "idx", 175L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "quality", "travel", "alias", "t", "rows", 2L, "idx", 245L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Test
    public void testMultipleDimensionsOneOfWhichIsMultiValueDifferentOrder() {
        GroupByQuery query = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "quality"), new DefaultDimensionSpec("placementish", "alias")})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).setGranularity(QueryRunnerTestHelper.allGran).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "quality", "automotive", "alias", "a", "rows", 2L, "idx", 282L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "quality", "automotive", "alias", "preferred", "rows", 2L, "idx", 282L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "quality", "business", "alias", "b", "rows", 2L, "idx", 230L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "quality", "business", "alias", "preferred", "rows", 2L, "idx", 230L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "quality", "entertainment", "alias", "e", "rows", 2L, "idx", 324L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "quality", "entertainment", "alias", "preferred", "rows", 2L, "idx", 324L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "quality", "health", "alias", "h", "rows", 2L, "idx", 233L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "quality", "health", "alias", "preferred", "rows", 2L, "idx", 233L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "quality", "mezzanine", "alias", "m", "rows", 6L, "idx", 5317L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "quality", "mezzanine", "alias", "preferred", "rows", 6L, "idx", 5317L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "quality", "news", "alias", "n", "rows", 2L, "idx", 235L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "quality", "news", "alias", "preferred", "rows", 2L, "idx", 235L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "quality", "premium", "alias", "p", "rows", 6L, "idx", 5405L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "quality", "premium", "alias", "preferred", "rows", 6L, "idx", 5405L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "quality", "technology", "alias", "preferred", "rows", 2L, "idx", 175L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "quality", "technology", "alias", "t", "rows", 2L, "idx", 175L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "quality", "travel", "alias", "preferred", "rows", 2L, "idx", 245L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "quality", "travel", "alias", "t", "rows", 2L, "idx", 245L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Test
    public void testGroupByMaxRowsLimitContextOverride() {
        GroupByQuery query = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).setGranularity(QueryRunnerTestHelper.dayGran).setContext((Map)ImmutableMap.of((Object)"maxResults", (Object)1)).build();
        List<Row> expectedResults = null;
        if (this.config.getDefaultStrategy().equals("v1")) {
            this.expectedException.expect(ResourceLimitExceededException.class);
        } else {
            expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "automotive", "rows", 1L, "idx", 135L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "business", "rows", 1L, "idx", 118L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "entertainment", "rows", 1L, "idx", 158L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "health", "rows", 1L, "idx", 120L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "mezzanine", "rows", 3L, "idx", 2870L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "news", "rows", 1L, "idx", 121L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "premium", "rows", 3L, "idx", 2900L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "technology", "rows", 1L, "idx", 78L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "travel", "rows", 1L, "idx", 119L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "automotive", "rows", 1L, "idx", 147L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "business", "rows", 1L, "idx", 112L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "entertainment", "rows", 1L, "idx", 166L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "health", "rows", 1L, "idx", 113L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "mezzanine", "rows", 3L, "idx", 2447L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "news", "rows", 1L, "idx", 114L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "premium", "rows", 3L, "idx", 2505L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "technology", "rows", 1L, "idx", 97L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "travel", "rows", 1L, "idx", 126L));
        }
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Test
    public void testGroupByTimeoutContextOverride() {
        GroupByQuery query = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).setGranularity(QueryRunnerTestHelper.dayGran).setContext((Map)ImmutableMap.of((Object)"timeout", (Object)60000)).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "automotive", "rows", 1L, "idx", 135L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "business", "rows", 1L, "idx", 118L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "entertainment", "rows", 1L, "idx", 158L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "health", "rows", 1L, "idx", 120L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "mezzanine", "rows", 3L, "idx", 2870L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "news", "rows", 1L, "idx", 121L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "premium", "rows", 3L, "idx", 2900L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "technology", "rows", 1L, "idx", 78L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "travel", "rows", 1L, "idx", 119L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "automotive", "rows", 1L, "idx", 147L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "business", "rows", 1L, "idx", 112L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "entertainment", "rows", 1L, "idx", 166L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "health", "rows", 1L, "idx", 113L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "mezzanine", "rows", 3L, "idx", 2447L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "news", "rows", 1L, "idx", 114L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "premium", "rows", 3L, "idx", 2505L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "technology", "rows", 1L, "idx", 97L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "travel", "rows", 1L, "idx", 126L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Test
    public void testGroupByMaxOnDiskStorageContextOverride() {
        GroupByQuery query = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).setGranularity(QueryRunnerTestHelper.dayGran).setContext((Map)ImmutableMap.of((Object)"maxOnDiskStorage", (Object)0, (Object)"bufferGrouperMaxSize", (Object)1)).build();
        List<Row> expectedResults = null;
        if (this.config.getDefaultStrategy().equals("v2")) {
            this.expectedException.expect(ResourceLimitExceededException.class);
            this.expectedException.expectMessage("Not enough aggregation buffer space to execute this query");
        } else {
            expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "automotive", "rows", 1L, "idx", 135L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "business", "rows", 1L, "idx", 118L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "entertainment", "rows", 1L, "idx", 158L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "health", "rows", 1L, "idx", 120L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "mezzanine", "rows", 3L, "idx", 2870L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "news", "rows", 1L, "idx", 121L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "premium", "rows", 3L, "idx", 2900L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "technology", "rows", 1L, "idx", 78L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "travel", "rows", 1L, "idx", 119L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "automotive", "rows", 1L, "idx", 147L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "business", "rows", 1L, "idx", 112L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "entertainment", "rows", 1L, "idx", 166L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "health", "rows", 1L, "idx", 113L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "mezzanine", "rows", 3L, "idx", 2447L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "news", "rows", 1L, "idx", 114L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "premium", "rows", 3L, "idx", 2505L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "technology", "rows", 1L, "idx", 97L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "travel", "rows", 1L, "idx", 126L));
        }
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Test
    public void testNotEnoughDictionarySpaceThroughContextOverride() {
        GroupByQuery query = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).setGranularity(QueryRunnerTestHelper.dayGran).setContext((Map)ImmutableMap.of((Object)"maxOnDiskStorage", (Object)0, (Object)"maxMergingDictionarySize", (Object)1)).build();
        List<Row> expectedResults = null;
        if (this.config.getDefaultStrategy().equals("v2")) {
            this.expectedException.expect(ResourceLimitExceededException.class);
            this.expectedException.expectMessage("Not enough dictionary space to execute this query");
        } else {
            expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "automotive", "rows", 1L, "idx", 135L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "business", "rows", 1L, "idx", 118L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "entertainment", "rows", 1L, "idx", 158L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "health", "rows", 1L, "idx", 120L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "mezzanine", "rows", 3L, "idx", 2870L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "news", "rows", 1L, "idx", 121L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "premium", "rows", 3L, "idx", 2900L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "technology", "rows", 1L, "idx", 78L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "travel", "rows", 1L, "idx", 119L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "automotive", "rows", 1L, "idx", 147L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "business", "rows", 1L, "idx", 112L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "entertainment", "rows", 1L, "idx", 166L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "health", "rows", 1L, "idx", 113L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "mezzanine", "rows", 3L, "idx", 2447L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "news", "rows", 1L, "idx", 114L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "premium", "rows", 3L, "idx", 2505L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "technology", "rows", 1L, "idx", 97L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "travel", "rows", 1L, "idx", 126L));
        }
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Test
    public void testNotEnoughDiskSpaceThroughContextOverride() {
        GroupByQuery query = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).setGranularity(QueryRunnerTestHelper.dayGran).setContext((Map)ImmutableMap.of((Object)"maxOnDiskStorage", (Object)1, (Object)"maxMergingDictionarySize", (Object)1)).build();
        List<Row> expectedResults = null;
        if (this.config.getDefaultStrategy().equals("v2")) {
            this.expectedException.expect(ResourceLimitExceededException.class);
            if (this.config.getMaxOnDiskStorage() > 0L) {
                this.expectedException.expectMessage("Not enough disk space to execute this query");
            } else {
                this.expectedException.expectMessage("Not enough dictionary space to execute this query");
            }
        } else {
            expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "automotive", "rows", 1L, "idx", 135L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "business", "rows", 1L, "idx", 118L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "entertainment", "rows", 1L, "idx", 158L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "health", "rows", 1L, "idx", 120L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "mezzanine", "rows", 3L, "idx", 2870L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "news", "rows", 1L, "idx", 121L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "premium", "rows", 3L, "idx", 2900L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "technology", "rows", 1L, "idx", 78L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "travel", "rows", 1L, "idx", 119L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "automotive", "rows", 1L, "idx", 147L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "business", "rows", 1L, "idx", 112L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "entertainment", "rows", 1L, "idx", 166L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "health", "rows", 1L, "idx", 113L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "mezzanine", "rows", 3L, "idx", 2447L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "news", "rows", 1L, "idx", 114L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "premium", "rows", 3L, "idx", 2505L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "technology", "rows", 1L, "idx", 97L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "travel", "rows", 1L, "idx", 126L));
        }
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Test
    public void testSubqueryWithOuterMaxOnDiskStorageContextOverride() {
        GroupByQuery subquery = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.fullOnInterval).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")})).setGranularity(QueryRunnerTestHelper.dayGran).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("alias", OrderByColumnSpec.Direction.ASCENDING)), null)).setContext((Map)ImmutableMap.of((Object)"maxOnDiskStorage", (Object)Integer.MAX_VALUE, (Object)"bufferGrouperMaxSize", (Object)Integer.MAX_VALUE)).build();
        GroupByQuery query = GroupByQuery.builder().setDataSource((Query)subquery).setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList()).setAggregatorSpecs((List)ImmutableList.of((Object)new CountAggregatorFactory("count"))).setGranularity(QueryRunnerTestHelper.allGran).setContext((Map)ImmutableMap.of((Object)"maxOnDiskStorage", (Object)0, (Object)"bufferGrouperMaxSize", (Object)0)).build();
        if (this.config.getDefaultStrategy().equals("v1")) {
            this.expectedException.expect(ISE.class);
            this.expectedException.expectMessage("Unknown column in order clause");
            GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        } else {
            this.expectedException.expect(ResourceLimitExceededException.class);
            this.expectedException.expectMessage("Not enough aggregation buffer space to execute this query");
            GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        }
    }

    @Test
    public void testGroupByWithRebucketRename() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("automotive", "automotive0");
        map.put("business", "business0");
        map.put("entertainment", "entertainment0");
        map.put("health", "health0");
        map.put("mezzanine", "mezzanine0");
        map.put("news", "news0");
        map.put("premium", "premium0");
        map.put("technology", "technology0");
        map.put("travel", "travel0");
        GroupByQuery query = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new ExtractionDimensionSpec("quality", "alias", (ExtractionFn)new LookupExtractionFn((LookupExtractor)new MapLookupExtractor(map, false), false, null, Boolean.valueOf(false), Boolean.valueOf(false)))})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).setGranularity(QueryRunnerTestHelper.dayGran).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "automotive0", "rows", 1L, "idx", 135L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "business0", "rows", 1L, "idx", 118L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "entertainment0", "rows", 1L, "idx", 158L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "health0", "rows", 1L, "idx", 120L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "mezzanine0", "rows", 3L, "idx", 2870L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "news0", "rows", 1L, "idx", 121L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "premium0", "rows", 3L, "idx", 2900L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "technology0", "rows", 1L, "idx", 78L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "travel0", "rows", 1L, "idx", 119L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "automotive0", "rows", 1L, "idx", 147L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "business0", "rows", 1L, "idx", 112L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "entertainment0", "rows", 1L, "idx", 166L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "health0", "rows", 1L, "idx", 113L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "mezzanine0", "rows", 3L, "idx", 2447L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "news0", "rows", 1L, "idx", 114L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "premium0", "rows", 3L, "idx", 2505L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "technology0", "rows", 1L, "idx", 97L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "travel0", "rows", 1L, "idx", 126L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Test
    public void testGroupByWithSimpleRenameRetainMissingNonInjective() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("automotive", "automotive0");
        map.put("business", "business0");
        map.put("entertainment", "entertainment0");
        map.put("health", "health0");
        map.put("mezzanine", "mezzanine0");
        map.put("news", "news0");
        map.put("premium", "premium0");
        map.put("technology", "technology0");
        map.put("travel", "travel0");
        GroupByQuery query = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new ExtractionDimensionSpec("quality", "alias", (ExtractionFn)new LookupExtractionFn((LookupExtractor)new MapLookupExtractor(map, false), true, null, Boolean.valueOf(false), Boolean.valueOf(false)))})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).setGranularity(QueryRunnerTestHelper.dayGran).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "automotive0", "rows", 1L, "idx", 135L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "business0", "rows", 1L, "idx", 118L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "entertainment0", "rows", 1L, "idx", 158L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "health0", "rows", 1L, "idx", 120L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "mezzanine0", "rows", 3L, "idx", 2870L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "news0", "rows", 1L, "idx", 121L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "premium0", "rows", 3L, "idx", 2900L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "technology0", "rows", 1L, "idx", 78L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "travel0", "rows", 1L, "idx", 119L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "automotive0", "rows", 1L, "idx", 147L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "business0", "rows", 1L, "idx", 112L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "entertainment0", "rows", 1L, "idx", 166L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "health0", "rows", 1L, "idx", 113L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "mezzanine0", "rows", 3L, "idx", 2447L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "news0", "rows", 1L, "idx", 114L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "premium0", "rows", 3L, "idx", 2505L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "technology0", "rows", 1L, "idx", 97L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "travel0", "rows", 1L, "idx", 126L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Test
    public void testGroupByWithSimpleRenameRetainMissing() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("automotive", "automotive0");
        map.put("business", "business0");
        map.put("entertainment", "entertainment0");
        map.put("health", "health0");
        map.put("mezzanine", "mezzanine0");
        map.put("news", "news0");
        map.put("premium", "premium0");
        map.put("technology", "technology0");
        map.put("travel", "travel0");
        GroupByQuery query = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new ExtractionDimensionSpec("quality", "alias", (ExtractionFn)new LookupExtractionFn((LookupExtractor)new MapLookupExtractor(map, false), true, null, Boolean.valueOf(true), Boolean.valueOf(false)))})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).setGranularity(QueryRunnerTestHelper.dayGran).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "automotive0", "rows", 1L, "idx", 135L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "business0", "rows", 1L, "idx", 118L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "entertainment0", "rows", 1L, "idx", 158L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "health0", "rows", 1L, "idx", 120L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "mezzanine0", "rows", 3L, "idx", 2870L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "news0", "rows", 1L, "idx", 121L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "premium0", "rows", 3L, "idx", 2900L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "technology0", "rows", 1L, "idx", 78L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "travel0", "rows", 1L, "idx", 119L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "automotive0", "rows", 1L, "idx", 147L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "business0", "rows", 1L, "idx", 112L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "entertainment0", "rows", 1L, "idx", 166L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "health0", "rows", 1L, "idx", 113L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "mezzanine0", "rows", 3L, "idx", 2447L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "news0", "rows", 1L, "idx", 114L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "premium0", "rows", 3L, "idx", 2505L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "technology0", "rows", 1L, "idx", 97L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "travel0", "rows", 1L, "idx", 126L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Test
    public void testGroupByWithSimpleRenameAndMissingString() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("automotive", "automotive0");
        map.put("business", "business0");
        map.put("entertainment", "entertainment0");
        map.put("health", "health0");
        map.put("mezzanine", "mezzanine0");
        map.put("news", "news0");
        map.put("premium", "premium0");
        map.put("technology", "technology0");
        map.put("travel", "travel0");
        GroupByQuery query = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new ExtractionDimensionSpec("quality", "alias", (ExtractionFn)new LookupExtractionFn((LookupExtractor)new MapLookupExtractor(map, false), false, "MISSING", Boolean.valueOf(true), Boolean.valueOf(false)))})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).setGranularity(QueryRunnerTestHelper.dayGran).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "automotive0", "rows", 1L, "idx", 135L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "business0", "rows", 1L, "idx", 118L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "entertainment0", "rows", 1L, "idx", 158L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "health0", "rows", 1L, "idx", 120L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "mezzanine0", "rows", 3L, "idx", 2870L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "news0", "rows", 1L, "idx", 121L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "premium0", "rows", 3L, "idx", 2900L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "technology0", "rows", 1L, "idx", 78L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "travel0", "rows", 1L, "idx", 119L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "automotive0", "rows", 1L, "idx", 147L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "business0", "rows", 1L, "idx", 112L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "entertainment0", "rows", 1L, "idx", 166L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "health0", "rows", 1L, "idx", 113L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "mezzanine0", "rows", 3L, "idx", 2447L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "news0", "rows", 1L, "idx", 114L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "premium0", "rows", 3L, "idx", 2505L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "technology0", "rows", 1L, "idx", 97L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "travel0", "rows", 1L, "idx", 126L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Test
    public void testGroupByWithSimpleRename() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("automotive", "automotive0");
        map.put("business", "business0");
        map.put("entertainment", "entertainment0");
        map.put("health", "health0");
        map.put("mezzanine", "mezzanine0");
        map.put("news", "news0");
        map.put("premium", "premium0");
        map.put("technology", "technology0");
        map.put("travel", "travel0");
        GroupByQuery query = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new ExtractionDimensionSpec("quality", "alias", (ExtractionFn)new LookupExtractionFn((LookupExtractor)new MapLookupExtractor(map, false), false, null, Boolean.valueOf(true), Boolean.valueOf(false)))})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).setGranularity(QueryRunnerTestHelper.dayGran).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "automotive0", "rows", 1L, "idx", 135L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "business0", "rows", 1L, "idx", 118L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "entertainment0", "rows", 1L, "idx", 158L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "health0", "rows", 1L, "idx", 120L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "mezzanine0", "rows", 3L, "idx", 2870L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "news0", "rows", 1L, "idx", 121L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "premium0", "rows", 3L, "idx", 2900L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "technology0", "rows", 1L, "idx", 78L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "travel0", "rows", 1L, "idx", 119L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "automotive0", "rows", 1L, "idx", 147L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "business0", "rows", 1L, "idx", 112L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "entertainment0", "rows", 1L, "idx", 166L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "health0", "rows", 1L, "idx", 113L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "mezzanine0", "rows", 3L, "idx", 2447L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "news0", "rows", 1L, "idx", 114L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "premium0", "rows", 3L, "idx", 2505L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "technology0", "rows", 1L, "idx", 97L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "travel0", "rows", 1L, "idx", 126L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Test
    public void testGroupByWithUniques() {
        GroupByQuery query = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, QueryRunnerTestHelper.qualityUniques)).setGranularity(QueryRunnerTestHelper.allGran).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "rows", 26L, "uniques", 9.019833517963864));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGroupByWithUniquesAndPostAggWithSameName() {
        GroupByQuery query = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new HyperUniquesAggregatorFactory("quality_uniques", "quality_uniques"))).setPostAggregatorSpecs(Arrays.asList(new HyperUniqueFinalizingPostAggregator("quality_uniques", "quality_uniques"))).setGranularity(QueryRunnerTestHelper.allGran).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "rows", 26L, "quality_uniques", 9.019833517963864));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Test
    public void testGroupByWithCardinality() {
        GroupByQuery query = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, QueryRunnerTestHelper.qualityCardinality)).setGranularity(QueryRunnerTestHelper.allGran).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "rows", 26L, "cardinality", 9.019833517963864));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Test
    public void testGroupByWithFirstLast() {
        GroupByQuery query = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.fullOnInterval).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("market", "market")})).setAggregatorSpecs(Arrays.asList(new LongFirstAggregatorFactory("first", "index"), new LongLastAggregatorFactory("last", "index"))).setGranularity(QueryRunnerTestHelper.monthGran).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-01-01", "market", "spot", "first", 100L, "last", 155L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-01-01", "market", "total_market", "first", 1000L, "last", 1127L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-01-01", "market", "upfront", "first", 800L, "last", 943L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-02-01", "market", "spot", "first", 132L, "last", 114L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-02-01", "market", "total_market", "first", 1203L, "last", 1292L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-02-01", "market", "upfront", "first", 1667L, "last", 1101L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-03-01", "market", "spot", "first", 153L, "last", 125L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-03-01", "market", "total_market", "first", 1124L, "last", 1366L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-03-01", "market", "upfront", "first", 1166L, "last", 1063L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "market", "spot", "first", 135L, "last", 120L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "market", "total_market", "first", 1314L, "last", 1029L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "market", "upfront", "first", 1447L, "last", 780L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Test
    public void testGroupByWithNoResult() {
        GroupByQuery query = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.emptyInterval).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("market", "market")})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, QueryRunnerTestHelper.indexLongSum, QueryRunnerTestHelper.qualityCardinality, new LongFirstAggregatorFactory("first", "index"), new LongLastAggregatorFactory("last", "index"))).setGranularity(QueryRunnerTestHelper.dayGran).build();
        ImmutableList expectedResults = ImmutableList.of();
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        Assert.assertEquals((Object)expectedResults, results);
    }

    @Test
    public void testGroupByWithNullProducingDimExtractionFn() {
        RegexDimExtractionFn nullExtractionFn = new RegexDimExtractionFn("(\\w{1})", false, null){

            public byte[] getCacheKey() {
                return new byte[]{-1};
            }

            public String apply(String dimValue) {
                return dimValue.equals("mezzanine") ? null : super.apply(dimValue);
            }
        };
        GroupByQuery query = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).setGranularity(QueryRunnerTestHelper.dayGran).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new ExtractionDimensionSpec("quality", "alias", (ExtractionFn)nullExtractionFn)})).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", null, "rows", 3L, "idx", 2870L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "a", "rows", 1L, "idx", 135L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "b", "rows", 1L, "idx", 118L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "e", "rows", 1L, "idx", 158L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "h", "rows", 1L, "idx", 120L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "n", "rows", 1L, "idx", 121L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "p", "rows", 3L, "idx", 2900L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "t", "rows", 2L, "idx", 197L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", null, "rows", 3L, "idx", 2447L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "a", "rows", 1L, "idx", 147L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "b", "rows", 1L, "idx", 112L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "e", "rows", 1L, "idx", 166L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "h", "rows", 1L, "idx", 113L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "n", "rows", 1L, "idx", 114L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "p", "rows", 3L, "idx", 2505L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "t", "rows", 2L, "idx", 223L));
        TestHelper.assertExpectedObjects(expectedResults, GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query), "");
    }

    @Test
    @Ignore
    public void testGroupByWithEmptyStringProducingDimExtractionFn() {
        RegexDimExtractionFn emptyStringExtractionFn = new RegexDimExtractionFn("(\\w{1})", false, null){

            public byte[] getCacheKey() {
                return new byte[]{-1};
            }

            public String apply(String dimValue) {
                return dimValue.equals("mezzanine") ? "" : super.apply(dimValue);
            }
        };
        GroupByQuery query = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).setGranularity(QueryRunnerTestHelper.dayGran).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new ExtractionDimensionSpec("quality", "alias", (ExtractionFn)emptyStringExtractionFn)})).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "", "rows", 3L, "idx", 2870L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "a", "rows", 1L, "idx", 135L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "b", "rows", 1L, "idx", 118L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "e", "rows", 1L, "idx", 158L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "h", "rows", 1L, "idx", 120L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "n", "rows", 1L, "idx", 121L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "p", "rows", 3L, "idx", 2900L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "t", "rows", 2L, "idx", 197L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "", "rows", 3L, "idx", 2447L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "a", "rows", 1L, "idx", 147L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "b", "rows", 1L, "idx", 112L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "e", "rows", 1L, "idx", 166L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "h", "rows", 1L, "idx", 113L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "n", "rows", 1L, "idx", 114L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "p", "rows", 3L, "idx", 2505L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "t", "rows", 2L, "idx", 223L));
        TestHelper.assertExpectedObjects(expectedResults, GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query), "");
    }

    @Test
    public void testGroupByWithTimeZone() {
        DateTimeZone tz = DateTimeZone.forID((String)"America/Los_Angeles");
        GroupByQuery query = GroupByQuery.builder().setDataSource("testing").setInterval("2011-03-31T00:00:00-07:00/2011-04-02T00:00:00-07:00").setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).setGranularity((Granularity)new PeriodGranularity(new Period((Object)"P1D"), null, tz)).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow(new DateTime((Object)"2011-03-31", tz), "alias", "automotive", "rows", 1L, "idx", 135L), GroupByQueryRunnerTestHelper.createExpectedRow(new DateTime((Object)"2011-03-31", tz), "alias", "business", "rows", 1L, "idx", 118L), GroupByQueryRunnerTestHelper.createExpectedRow(new DateTime((Object)"2011-03-31", tz), "alias", "entertainment", "rows", 1L, "idx", 158L), GroupByQueryRunnerTestHelper.createExpectedRow(new DateTime((Object)"2011-03-31", tz), "alias", "health", "rows", 1L, "idx", 120L), GroupByQueryRunnerTestHelper.createExpectedRow(new DateTime((Object)"2011-03-31", tz), "alias", "mezzanine", "rows", 3L, "idx", 2870L), GroupByQueryRunnerTestHelper.createExpectedRow(new DateTime((Object)"2011-03-31", tz), "alias", "news", "rows", 1L, "idx", 121L), GroupByQueryRunnerTestHelper.createExpectedRow(new DateTime((Object)"2011-03-31", tz), "alias", "premium", "rows", 3L, "idx", 2900L), GroupByQueryRunnerTestHelper.createExpectedRow(new DateTime((Object)"2011-03-31", tz), "alias", "technology", "rows", 1L, "idx", 78L), GroupByQueryRunnerTestHelper.createExpectedRow(new DateTime((Object)"2011-03-31", tz), "alias", "travel", "rows", 1L, "idx", 119L), GroupByQueryRunnerTestHelper.createExpectedRow(new DateTime((Object)"2011-04-01", tz), "alias", "automotive", "rows", 1L, "idx", 147L), GroupByQueryRunnerTestHelper.createExpectedRow(new DateTime((Object)"2011-04-01", tz), "alias", "business", "rows", 1L, "idx", 112L), GroupByQueryRunnerTestHelper.createExpectedRow(new DateTime((Object)"2011-04-01", tz), "alias", "entertainment", "rows", 1L, "idx", 166L), GroupByQueryRunnerTestHelper.createExpectedRow(new DateTime((Object)"2011-04-01", tz), "alias", "health", "rows", 1L, "idx", 113L), GroupByQueryRunnerTestHelper.createExpectedRow(new DateTime((Object)"2011-04-01", tz), "alias", "mezzanine", "rows", 3L, "idx", 2447L), GroupByQueryRunnerTestHelper.createExpectedRow(new DateTime((Object)"2011-04-01", tz), "alias", "news", "rows", 1L, "idx", 114L), GroupByQueryRunnerTestHelper.createExpectedRow(new DateTime((Object)"2011-04-01", tz), "alias", "premium", "rows", 3L, "idx", 2505L), GroupByQueryRunnerTestHelper.createExpectedRow(new DateTime((Object)"2011-04-01", tz), "alias", "technology", "rows", 1L, "idx", 97L), GroupByQueryRunnerTestHelper.createExpectedRow(new DateTime((Object)"2011-04-01", tz), "alias", "travel", "rows", 1L, "idx", 126L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Test
    public void testMergeResults() {
        GroupByQuery.Builder builder = GroupByQuery.builder().setDataSource("testing").setInterval("2011-04-02/2011-04-04").setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).setGranularity((Granularity)new PeriodGranularity(new Period((Object)"P1M"), null, null));
        GroupByQuery fullQuery = builder.build();
        GroupByQuery allGranQuery = builder.copy().setGranularity(Granularities.ALL).build();
        QueryRunner mergedRunner = this.factory.getToolchest().mergeResults((QueryRunner)new QueryRunner<Row>(){

            public Sequence<Row> run(QueryPlus<Row> queryPlus, Map<String, Object> responseContext) {
                QueryPlus queryPlus1 = queryPlus.withQuerySegmentSpec((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)Lists.newArrayList((Object[])new Interval[]{Intervals.of((String)"2011-04-02/2011-04-03")})));
                QueryPlus queryPlus2 = queryPlus.withQuerySegmentSpec((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)Lists.newArrayList((Object[])new Interval[]{Intervals.of((String)"2011-04-03/2011-04-04")})));
                return new MergeSequence(queryPlus.getQuery().getResultOrdering(), Sequences.simple(Arrays.asList(GroupByQueryRunnerTest.this.runner.run(queryPlus1, responseContext), GroupByQueryRunnerTest.this.runner.run(queryPlus2, responseContext))));
            }
        });
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "automotive", "rows", 2L, "idx", 269L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "business", "rows", 2L, "idx", 217L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "entertainment", "rows", 2L, "idx", 319L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "health", "rows", 2L, "idx", 216L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "mezzanine", "rows", 6L, "idx", 4420L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "news", "rows", 2L, "idx", 221L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "premium", "rows", 6L, "idx", 4416L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "technology", "rows", 2L, "idx", 177L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "travel", "rows", 2L, "idx", 243L));
        HashMap context = Maps.newHashMap();
        TestHelper.assertExpectedObjects(expectedResults, mergedRunner.run(QueryPlus.wrap((Query)fullQuery), (Map)context), "merged");
        List<Row> allGranExpectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "automotive", "rows", 2L, "idx", 269L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "business", "rows", 2L, "idx", 217L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "entertainment", "rows", 2L, "idx", 319L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "health", "rows", 2L, "idx", 216L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "mezzanine", "rows", 6L, "idx", 4420L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "news", "rows", 2L, "idx", 221L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "premium", "rows", 6L, "idx", 4416L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "technology", "rows", 2L, "idx", 177L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "travel", "rows", 2L, "idx", 243L));
        TestHelper.assertExpectedObjects(allGranExpectedResults, mergedRunner.run(QueryPlus.wrap((Query)allGranQuery), (Map)context), "merged");
    }

    @Test
    public void testMergeResultsWithLimit() {
        for (int limit = 1; limit < 20; ++limit) {
            this.doTestMergeResultsWithValidLimit(limit);
        }
    }

    private void doTestMergeResultsWithValidLimit(int limit) {
        GroupByQuery.Builder builder = GroupByQuery.builder().setDataSource("testing").setInterval("2011-04-02/2011-04-04").setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).setGranularity((Granularity)new PeriodGranularity(new Period((Object)"P1M"), null, null)).setLimit(limit);
        GroupByQuery fullQuery = builder.build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "automotive", "rows", 2L, "idx", 269L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "business", "rows", 2L, "idx", 217L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "entertainment", "rows", 2L, "idx", 319L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "health", "rows", 2L, "idx", 216L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "mezzanine", "rows", 6L, "idx", 4420L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "news", "rows", 2L, "idx", 221L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "premium", "rows", 6L, "idx", 4416L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "technology", "rows", 2L, "idx", 177L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "travel", "rows", 2L, "idx", 243L));
        QueryRunner mergeRunner = this.factory.getToolchest().mergeResults(this.runner);
        HashMap context = Maps.newHashMap();
        TestHelper.assertExpectedObjects(Iterables.limit(expectedResults, (int)limit), mergeRunner.run(QueryPlus.wrap((Query)fullQuery), (Map)context), StringUtils.format((String)"limit: %d", (Object[])new Object[]{limit}));
    }

    @Test
    public void testMergeResultsAcrossMultipleDaysWithLimitAndOrderBy() {
        int limit = 14;
        GroupByQuery.Builder builder = GroupByQuery.builder().setDataSource("testing").setInterval(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).setGranularity(Granularities.DAY).setLimit(14).addOrderByColumn("idx", OrderByColumnSpec.Direction.DESCENDING);
        GroupByQuery fullQuery = builder.build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "premium", "rows", 3L, "idx", 2900L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "mezzanine", "rows", 3L, "idx", 2870L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "entertainment", "rows", 1L, "idx", 158L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "automotive", "rows", 1L, "idx", 135L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "news", "rows", 1L, "idx", 121L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "health", "rows", 1L, "idx", 120L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "travel", "rows", 1L, "idx", 119L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "business", "rows", 1L, "idx", 118L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "technology", "rows", 1L, "idx", 78L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "premium", "rows", 3L, "idx", 2505L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "mezzanine", "rows", 3L, "idx", 2447L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "entertainment", "rows", 1L, "idx", 166L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "automotive", "rows", 1L, "idx", 147L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "travel", "rows", 1L, "idx", 126L));
        QueryRunner mergeRunner = this.factory.getToolchest().mergeResults(this.runner);
        HashMap context = Maps.newHashMap();
        TestHelper.assertExpectedObjects(Iterables.limit(expectedResults, (int)14), mergeRunner.run(QueryPlus.wrap((Query)fullQuery), (Map)context), StringUtils.format((String)"limit: %d", (Object[])new Object[]{14}));
    }

    @Test
    public void testMergeResultsAcrossMultipleDaysWithLimitAndOrderByUsingMathExpressions() {
        int limit = 14;
        GroupByQuery.Builder builder = GroupByQuery.builder().setDataSource("testing").setInterval(QueryRunnerTestHelper.firstToThird).setVirtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("expr", "index * 2 + indexMin / 10", ValueType.FLOAT, TestExprMacroTable.INSTANCE)}).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "expr"))).setGranularity(Granularities.DAY).setLimit(14).addOrderByColumn("idx", OrderByColumnSpec.Direction.DESCENDING);
        GroupByQuery fullQuery = builder.build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "premium", "rows", 3L, "idx", 6090L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "mezzanine", "rows", 3L, "idx", 6030L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "entertainment", "rows", 1L, "idx", 333L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "automotive", "rows", 1L, "idx", 285L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "news", "rows", 1L, "idx", 255L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "health", "rows", 1L, "idx", 252L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "travel", "rows", 1L, "idx", 251L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "business", "rows", 1L, "idx", 248L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "technology", "rows", 1L, "idx", 165L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "premium", "rows", 3L, "idx", 5262L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "mezzanine", "rows", 3L, "idx", 5141L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "entertainment", "rows", 1L, "idx", 348L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "automotive", "rows", 1L, "idx", 309L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "travel", "rows", 1L, "idx", 265L));
        QueryRunner mergeRunner = this.factory.getToolchest().mergeResults(this.runner);
        HashMap context = Maps.newHashMap();
        TestHelper.assertExpectedObjects(Iterables.limit(expectedResults, (int)14), mergeRunner.run(QueryPlus.wrap((Query)fullQuery), (Map)context), StringUtils.format((String)"limit: %d", (Object[])new Object[]{14}));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMergeResultsWithNegativeLimit() {
        GroupByQuery.Builder builder = GroupByQuery.builder().setDataSource("testing").setInterval("2011-04-02/2011-04-04").setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).setGranularity((Granularity)new PeriodGranularity(new Period((Object)"P1M"), null, null)).setLimit(-1);
        builder.build();
    }

    @Test
    public void testMergeResultsWithOrderBy() {
        LimitSpec[] orderBySpecs = new LimitSpec[]{new DefaultLimitSpec(OrderByColumnSpec.ascending((String[])new String[]{"idx"}), null), new DefaultLimitSpec(OrderByColumnSpec.ascending((String[])new String[]{"rows", "idx"}), null), new DefaultLimitSpec(OrderByColumnSpec.descending((String[])new String[]{"idx"}), null), new DefaultLimitSpec(OrderByColumnSpec.descending((String[])new String[]{"rows", "idx"}), null)};
        final Comparator<Row> idxComparator = new Comparator<Row>(){

            @Override
            public int compare(Row o1, Row o2) {
                return Float.compare(o1.getMetric("idx").floatValue(), o2.getMetric("idx").floatValue());
            }
        };
        Comparator<Row> rowsIdxComparator = new Comparator<Row>(){

            @Override
            public int compare(Row o1, Row o2) {
                int value = Float.compare(o1.getMetric("rows").floatValue(), o2.getMetric("rows").floatValue());
                if (value != 0) {
                    return value;
                }
                return idxComparator.compare(o1, o2);
            }
        };
        List<Row> allResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "automotive", "rows", 2L, "idx", 269L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "business", "rows", 2L, "idx", 217L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "entertainment", "rows", 2L, "idx", 319L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "health", "rows", 2L, "idx", 216L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "mezzanine", "rows", 6L, "idx", 4420L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "news", "rows", 2L, "idx", 221L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "premium", "rows", 6L, "idx", 4416L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "technology", "rows", 2L, "idx", 177L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "travel", "rows", 2L, "idx", 243L));
        ArrayList expectedResults = Lists.newArrayList((Object[])new List[]{Ordering.from((Comparator)idxComparator).sortedCopy(allResults), Ordering.from((Comparator)rowsIdxComparator).sortedCopy(allResults), Ordering.from((Comparator)idxComparator).reverse().sortedCopy(allResults), Ordering.from((Comparator)rowsIdxComparator).reverse().sortedCopy(allResults)});
        for (int i = 0; i < orderBySpecs.length; ++i) {
            this.doTestMergeResultsWithOrderBy(orderBySpecs[i], (List)expectedResults.get(i));
        }
    }

    private void doTestMergeResultsWithOrderBy(LimitSpec orderBySpec, List<Row> expectedResults) {
        GroupByQuery.Builder builder = GroupByQuery.builder().setDataSource("testing").setInterval("2011-04-02/2011-04-04").setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).setGranularity((Granularity)new PeriodGranularity(new Period((Object)"P1M"), null, null)).setLimitSpec(orderBySpec);
        GroupByQuery fullQuery = builder.build();
        QueryRunner mergedRunner = this.factory.getToolchest().mergeResults((QueryRunner)new QueryRunner<Row>(){

            public Sequence<Row> run(QueryPlus<Row> queryPlus, Map<String, Object> responseContext) {
                QueryPlus queryPlus1 = queryPlus.withQuerySegmentSpec((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)Lists.newArrayList((Object[])new Interval[]{Intervals.of((String)"2011-04-02/2011-04-03")})));
                QueryPlus queryPlus2 = queryPlus.withQuerySegmentSpec((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)Lists.newArrayList((Object[])new Interval[]{Intervals.of((String)"2011-04-03/2011-04-04")})));
                return new MergeSequence(queryPlus.getQuery().getResultOrdering(), Sequences.simple(Arrays.asList(GroupByQueryRunnerTest.this.runner.run(queryPlus1, responseContext), GroupByQueryRunnerTest.this.runner.run(queryPlus2, responseContext))));
            }
        });
        HashMap context = Maps.newHashMap();
        TestHelper.assertExpectedObjects(expectedResults, mergedRunner.run(QueryPlus.wrap((Query)fullQuery), (Map)context), "merged");
    }

    @Test
    public void testGroupByOrderLimit() throws Exception {
        GroupByQuery.Builder builder = GroupByQuery.builder().setDataSource("testing").setInterval("2011-04-02/2011-04-04").setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).addOrderByColumn("rows").addOrderByColumn("alias", OrderByColumnSpec.Direction.DESCENDING).setGranularity((Granularity)new PeriodGranularity(new Period((Object)"P1M"), null, null));
        GroupByQuery query = builder.build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "travel", "rows", 2L, "idx", 243L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "technology", "rows", 2L, "idx", 177L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "news", "rows", 2L, "idx", 221L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "health", "rows", 2L, "idx", 216L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "entertainment", "rows", 2L, "idx", 319L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "business", "rows", 2L, "idx", 217L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "automotive", "rows", 2L, "idx", 269L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "premium", "rows", 6L, "idx", 4416L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "mezzanine", "rows", 6L, "idx", 4420L));
        HashMap context = Maps.newHashMap();
        QueryRunner mergeRunner = this.factory.getToolchest().mergeResults(this.runner);
        TestHelper.assertExpectedObjects(expectedResults, mergeRunner.run(QueryPlus.wrap((Query)query), (Map)context), "no-limit");
        TestHelper.assertExpectedObjects(Iterables.limit(expectedResults, (int)5), mergeRunner.run(QueryPlus.wrap((Query)builder.setLimit(5).build()), (Map)context), "limited");
        List<AggregatorFactory> aggregatorSpecs = Arrays.asList(QueryRunnerTestHelper.rowsCount, new DoubleSumAggregatorFactory("idx", null, "index / 2 + indexMin", TestExprMacroTable.INSTANCE));
        builder.setLimit(Integer.MAX_VALUE).setAggregatorSpecs(aggregatorSpecs);
        expectedResults = GroupByQueryRunnerTestHelper.createExpectedRows(new String[]{"__time", "alias", "rows", "idx"}, {"2011-04-01", "travel", 2L, 365.4876403808594}, {"2011-04-01", "technology", 2L, 267.3737487792969}, {"2011-04-01", "news", 2L, 333.3147277832031}, {"2011-04-01", "health", 2L, 325.467529296875}, {"2011-04-01", "entertainment", 2L, 479.916015625}, {"2011-04-01", "business", 2L, 328.083740234375}, {"2011-04-01", "automotive", 2L, 405.5966796875}, {"2011-04-01", "premium", 6L, 6627.927734375}, {"2011-04-01", "mezzanine", 6L, 6635.47998046875});
        TestHelper.assertExpectedObjects(expectedResults, mergeRunner.run(QueryPlus.wrap((Query)builder.build()), (Map)context), "no-limit");
        TestHelper.assertExpectedObjects(Iterables.limit(expectedResults, (int)5), mergeRunner.run(QueryPlus.wrap((Query)builder.setLimit(5).build()), (Map)context), "limited");
        ExpressionVirtualColumn expressionVirtualColumn = new ExpressionVirtualColumn("expr", "index / 2 + indexMin", ValueType.FLOAT, TestExprMacroTable.INSTANCE);
        List<AggregatorFactory> aggregatorSpecs2 = Arrays.asList(QueryRunnerTestHelper.rowsCount, new DoubleSumAggregatorFactory("idx", "expr"));
        builder.setLimit(Integer.MAX_VALUE).setVirtualColumns(new VirtualColumn[]{expressionVirtualColumn}).setAggregatorSpecs(aggregatorSpecs2);
        TestHelper.assertExpectedObjects(expectedResults, mergeRunner.run(QueryPlus.wrap((Query)builder.build()), (Map)context), "no-limit");
        TestHelper.assertExpectedObjects(Iterables.limit(expectedResults, (int)5), mergeRunner.run(QueryPlus.wrap((Query)builder.setLimit(5).build()), (Map)context), "limited");
    }

    @Test
    public void testGroupByWithOrderLimit2() throws Exception {
        GroupByQuery.Builder builder = GroupByQuery.builder().setDataSource("testing").setInterval("2011-04-02/2011-04-04").setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).addOrderByColumn("rows", OrderByColumnSpec.Direction.DESCENDING).addOrderByColumn("alias", OrderByColumnSpec.Direction.DESCENDING).setGranularity((Granularity)new PeriodGranularity(new Period((Object)"P1M"), null, null));
        GroupByQuery query = builder.build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "premium", "rows", 6L, "idx", 4416L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "mezzanine", "rows", 6L, "idx", 4420L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "travel", "rows", 2L, "idx", 243L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "technology", "rows", 2L, "idx", 177L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "news", "rows", 2L, "idx", 221L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "health", "rows", 2L, "idx", 216L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "entertainment", "rows", 2L, "idx", 319L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "business", "rows", 2L, "idx", 217L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "automotive", "rows", 2L, "idx", 269L));
        HashMap context = Maps.newHashMap();
        QueryRunner mergeRunner = this.factory.getToolchest().mergeResults(this.runner);
        TestHelper.assertExpectedObjects(expectedResults, mergeRunner.run(QueryPlus.wrap((Query)query), (Map)context), "no-limit");
        TestHelper.assertExpectedObjects(Iterables.limit(expectedResults, (int)5), mergeRunner.run(QueryPlus.wrap((Query)builder.setLimit(5).build()), (Map)context), "limited");
    }

    @Test
    public void testGroupByWithOrderLimit3() throws Exception {
        GroupByQuery.Builder builder = GroupByQuery.builder().setDataSource("testing").setInterval("2011-04-02/2011-04-04").setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new DoubleSumAggregatorFactory("idx", "index"))).addOrderByColumn("idx", OrderByColumnSpec.Direction.DESCENDING).addOrderByColumn("alias", OrderByColumnSpec.Direction.DESCENDING).setGranularity((Granularity)new PeriodGranularity(new Period((Object)"P1M"), null, null));
        GroupByQuery query = builder.build();
        List<Row> expectedResults = GroupByQueryRunnerTestHelper.createExpectedRows(new String[]{"__time", "alias", "rows", "idx"}, {"2011-04-01", "mezzanine", 6L, 4423.6533203125}, {"2011-04-01", "premium", 6L, 4418.61865234375}, {"2011-04-01", "entertainment", 2L, 319.94403076171875}, {"2011-04-01", "automotive", 2L, 270.3977966308594}, {"2011-04-01", "travel", 2L, 243.65843200683594}, {"2011-04-01", "news", 2L, 222.20980834960938}, {"2011-04-01", "business", 2L, 218.7224884033203}, {"2011-04-01", "health", 2L, 216.97836303710938}, {"2011-04-01", "technology", 2L, 178.24917602539062});
        HashMap context = Maps.newHashMap();
        QueryRunner mergeRunner = this.factory.getToolchest().mergeResults(this.runner);
        TestHelper.assertExpectedObjects(expectedResults, mergeRunner.run(QueryPlus.wrap((Query)query), (Map)context), "no-limit");
        TestHelper.assertExpectedObjects(Iterables.limit(expectedResults, (int)5), mergeRunner.run(QueryPlus.wrap((Query)builder.setLimit(5).build()), (Map)context), "limited");
    }

    @Test
    public void testGroupByOrderLimitNumeric() throws Exception {
        GroupByQuery.Builder builder = GroupByQuery.builder().setDataSource("testing").setInterval("2011-04-02/2011-04-04").setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).addOrderByColumn(new OrderByColumnSpec("rows", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)).addOrderByColumn(new OrderByColumnSpec("alias", OrderByColumnSpec.Direction.ASCENDING, StringComparators.NUMERIC)).setGranularity((Granularity)new PeriodGranularity(new Period((Object)"P1M"), null, null));
        GroupByQuery query = builder.build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "mezzanine", "rows", 6L, "idx", 4420L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "premium", "rows", 6L, "idx", 4416L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "automotive", "rows", 2L, "idx", 269L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "business", "rows", 2L, "idx", 217L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "entertainment", "rows", 2L, "idx", 319L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "health", "rows", 2L, "idx", 216L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "news", "rows", 2L, "idx", 221L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "technology", "rows", 2L, "idx", 177L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "travel", "rows", 2L, "idx", 243L));
        HashMap context = Maps.newHashMap();
        QueryRunner mergeRunner = this.factory.getToolchest().mergeResults(this.runner);
        TestHelper.assertExpectedObjects(expectedResults, mergeRunner.run(QueryPlus.wrap((Query)query), (Map)context), "no-limit");
        TestHelper.assertExpectedObjects(Iterables.limit(expectedResults, (int)5), mergeRunner.run(QueryPlus.wrap((Query)builder.setLimit(5).build()), (Map)context), "limited");
    }

    @Test
    public void testGroupByWithSameCaseOrdering() {
        GroupByQuery query = new GroupByQuery.Builder().setDataSource("testing").setGranularity(QueryRunnerTestHelper.allGran).setDimensions(Arrays.asList(new DefaultDimensionSpec("market", "marketalias"))).setInterval(QueryRunnerTestHelper.fullOnInterval).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)Lists.newArrayList((Object[])new OrderByColumnSpec[]{new OrderByColumnSpec("marketalias", OrderByColumnSpec.Direction.DESCENDING)}), Integer.valueOf(3))).setAggregatorSpecs((List)Lists.newArrayList((Object[])new AggregatorFactory[]{QueryRunnerTestHelper.rowsCount})).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("1970-01-01T00:00:00.000Z", "marketalias", "upfront", "rows", 186L), GroupByQueryRunnerTestHelper.createExpectedRow("1970-01-01T00:00:00.000Z", "marketalias", "total_market", "rows", 186L), GroupByQueryRunnerTestHelper.createExpectedRow("1970-01-01T00:00:00.000Z", "marketalias", "spot", "rows", 837L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "order-limit");
    }

    @Test
    public void testGroupByWithOrderLimit4() {
        GroupByQuery query = new GroupByQuery.Builder().setDataSource("testing").setGranularity(QueryRunnerTestHelper.allGran).setDimensions(Arrays.asList(new DefaultDimensionSpec("market", "market"))).setInterval(QueryRunnerTestHelper.fullOnInterval).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)Lists.newArrayList((Object[])new OrderByColumnSpec[]{new OrderByColumnSpec("market", OrderByColumnSpec.Direction.DESCENDING)}), Integer.valueOf(3))).setAggregatorSpecs((List)Lists.newArrayList((Object[])new AggregatorFactory[]{QueryRunnerTestHelper.rowsCount})).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("1970-01-01T00:00:00.000Z", "market", "upfront", "rows", 186L), GroupByQueryRunnerTestHelper.createExpectedRow("1970-01-01T00:00:00.000Z", "market", "total_market", "rows", 186L), GroupByQueryRunnerTestHelper.createExpectedRow("1970-01-01T00:00:00.000Z", "market", "spot", "rows", 837L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "order-limit");
    }

    @Test
    public void testGroupByWithOrderOnHyperUnique() {
        GroupByQuery query = new GroupByQuery.Builder().setDataSource("testing").setGranularity(QueryRunnerTestHelper.allGran).setDimensions(Arrays.asList(new DefaultDimensionSpec("market", "market"))).setInterval(QueryRunnerTestHelper.fullOnInterval).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)Lists.newArrayList((Object[])new OrderByColumnSpec[]{new OrderByColumnSpec("uniques", OrderByColumnSpec.Direction.DESCENDING)}), Integer.valueOf(3))).setAggregatorSpecs((List)Lists.newArrayList((Object[])new AggregatorFactory[]{QueryRunnerTestHelper.qualityUniques})).setPostAggregatorSpecs((List)Lists.newArrayList((Object[])new PostAggregator[]{new HyperUniqueFinalizingPostAggregator("hyperUniqueFinalizingPostAggMetric", "uniques")})).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("1970-01-01T00:00:00.000Z", "market", "spot", "uniques", 9.019833517963864, "hyperUniqueFinalizingPostAggMetric", 9.019833517963864), GroupByQueryRunnerTestHelper.createExpectedRow("1970-01-01T00:00:00.000Z", "market", "upfront", "uniques", 2.000977198748901, "hyperUniqueFinalizingPostAggMetric", 2.000977198748901), GroupByQueryRunnerTestHelper.createExpectedRow("1970-01-01T00:00:00.000Z", "market", "total_market", "uniques", 2.000977198748901, "hyperUniqueFinalizingPostAggMetric", 2.000977198748901));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "order-limit");
    }

    @Test
    public void testGroupByWithHavingOnHyperUnique() {
        GroupByQuery query = new GroupByQuery.Builder().setDataSource("testing").setGranularity(QueryRunnerTestHelper.allGran).setDimensions(Arrays.asList(new DefaultDimensionSpec("market", "market"))).setInterval(QueryRunnerTestHelper.fullOnInterval).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)Lists.newArrayList((Object[])new OrderByColumnSpec[]{new OrderByColumnSpec("uniques", OrderByColumnSpec.Direction.DESCENDING)}), Integer.valueOf(3))).setHavingSpec((HavingSpec)new GreaterThanHavingSpec("uniques", (Number)8)).setAggregatorSpecs((List)Lists.newArrayList((Object[])new AggregatorFactory[]{QueryRunnerTestHelper.qualityUniques})).setPostAggregatorSpecs((List)Lists.newArrayList((Object[])new PostAggregator[]{new HyperUniqueFinalizingPostAggregator("hyperUniqueFinalizingPostAggMetric", "uniques")})).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("1970-01-01T00:00:00.000Z", "market", "spot", "uniques", 9.019833517963864, "hyperUniqueFinalizingPostAggMetric", 9.019833517963864));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "order-limit");
    }

    @Test
    public void testGroupByWithHavingOnFinalizedHyperUnique() {
        GroupByQuery query = new GroupByQuery.Builder().setDataSource("testing").setGranularity(QueryRunnerTestHelper.allGran).setDimensions(Arrays.asList(new DefaultDimensionSpec("market", "market"))).setInterval(QueryRunnerTestHelper.fullOnInterval).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)Lists.newArrayList((Object[])new OrderByColumnSpec[]{new OrderByColumnSpec("hyperUniqueFinalizingPostAggMetric", OrderByColumnSpec.Direction.DESCENDING)}), Integer.valueOf(3))).setHavingSpec((HavingSpec)new GreaterThanHavingSpec("hyperUniqueFinalizingPostAggMetric", (Number)8)).setAggregatorSpecs((List)Lists.newArrayList((Object[])new AggregatorFactory[]{QueryRunnerTestHelper.qualityUniques})).setPostAggregatorSpecs((List)Lists.newArrayList((Object[])new PostAggregator[]{new HyperUniqueFinalizingPostAggregator("hyperUniqueFinalizingPostAggMetric", "uniques")})).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("1970-01-01T00:00:00.000Z", "market", "spot", "uniques", 9.019833517963864, "hyperUniqueFinalizingPostAggMetric", 9.019833517963864));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "order-limit");
    }

    @Test
    public void testGroupByWithLimitOnFinalizedHyperUnique() {
        GroupByQuery query = new GroupByQuery.Builder().setDataSource("testing").setGranularity(QueryRunnerTestHelper.allGran).setDimensions(Arrays.asList(new DefaultDimensionSpec("market", "market"))).setInterval(QueryRunnerTestHelper.fullOnInterval).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)Lists.newArrayList((Object[])new OrderByColumnSpec[]{new OrderByColumnSpec("hyperUniqueFinalizingPostAggMetric", OrderByColumnSpec.Direction.DESCENDING)}), Integer.valueOf(3))).setAggregatorSpecs((List)Lists.newArrayList((Object[])new AggregatorFactory[]{QueryRunnerTestHelper.qualityUniques})).setPostAggregatorSpecs((List)Lists.newArrayList((Object[])new PostAggregator[]{new HyperUniqueFinalizingPostAggregator("hyperUniqueFinalizingPostAggMetric", "uniques")})).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("1970-01-01T00:00:00.000Z", "market", "spot", "uniques", 9.019833517963864, "hyperUniqueFinalizingPostAggMetric", 9.019833517963864), GroupByQueryRunnerTestHelper.createExpectedRow("1970-01-01T00:00:00.000Z", "market", "upfront", "uniques", 2.000977198748901, "hyperUniqueFinalizingPostAggMetric", 2.000977198748901), GroupByQueryRunnerTestHelper.createExpectedRow("1970-01-01T00:00:00.000Z", "market", "total_market", "uniques", 2.000977198748901, "hyperUniqueFinalizingPostAggMetric", 2.000977198748901));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "order-limit");
    }

    @Test
    public void testGroupByWithAlphaNumericDimensionOrder() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("automotive", "health105");
        map.put("business", "health20");
        map.put("entertainment", "travel47");
        map.put("health", "health55");
        map.put("mezzanine", "health09");
        map.put("news", "health0000");
        map.put("premium", "health999");
        map.put("technology", "travel123");
        map.put("travel", "travel555");
        GroupByQuery query = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new ExtractionDimensionSpec("quality", "alias", (ExtractionFn)new LookupExtractionFn((LookupExtractor)new MapLookupExtractor(map, false), false, null, Boolean.valueOf(false), Boolean.valueOf(false)))})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)Lists.newArrayList((Object[])new OrderByColumnSpec[]{new OrderByColumnSpec("alias", null, StringComparators.ALPHANUMERIC)}), null)).setGranularity(QueryRunnerTestHelper.dayGran).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "health0000", "rows", 1L, "idx", 121L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "health09", "rows", 3L, "idx", 2870L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "health20", "rows", 1L, "idx", 118L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "health55", "rows", 1L, "idx", 120L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "health105", "rows", 1L, "idx", 135L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "health999", "rows", 3L, "idx", 2900L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "travel47", "rows", 1L, "idx", 158L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "travel123", "rows", 1L, "idx", 78L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "travel555", "rows", 1L, "idx", 119L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "health0000", "rows", 1L, "idx", 114L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "health09", "rows", 3L, "idx", 2447L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "health20", "rows", 1L, "idx", 112L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "health55", "rows", 1L, "idx", 113L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "health105", "rows", 1L, "idx", 147L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "health999", "rows", 3L, "idx", 2505L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "travel47", "rows", 1L, "idx", 166L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "travel123", "rows", 1L, "idx", 97L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "travel555", "rows", 1L, "idx", 126L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Test
    public void testGroupByWithLookupAndLimitAndSortByDimsFirst() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("automotive", "9");
        map.put("business", "8");
        map.put("entertainment", "7");
        map.put("health", "6");
        map.put("mezzanine", "5");
        map.put("news", "4");
        map.put("premium", "3");
        map.put("technology", "2");
        map.put("travel", "1");
        GroupByQuery query = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new ExtractionDimensionSpec("quality", "alias", (ExtractionFn)new LookupExtractionFn((LookupExtractor)new MapLookupExtractor(map, false), false, null, Boolean.valueOf(false), Boolean.valueOf(false)))})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)Lists.newArrayList((Object[])new OrderByColumnSpec[]{new OrderByColumnSpec("alias", null, StringComparators.ALPHANUMERIC)}), Integer.valueOf(11))).setGranularity(QueryRunnerTestHelper.dayGran).setContext((Map)ImmutableMap.of((Object)"sortByDimsFirst", (Object)true)).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "1", "rows", 1L, "idx", 119L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "1", "rows", 1L, "idx", 126L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "2", "rows", 1L, "idx", 78L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "2", "rows", 1L, "idx", 97L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "3", "rows", 3L, "idx", 2900L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "3", "rows", 3L, "idx", 2505L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "4", "rows", 1L, "idx", 121L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "4", "rows", 1L, "idx", 114L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "5", "rows", 3L, "idx", 2870L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "5", "rows", 3L, "idx", 2447L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "6", "rows", 1L, "idx", 120L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Ignore
    @Test
    public void testLimitPerGrouping() {
        GroupByQuery query = new GroupByQuery.Builder().setDataSource("testing").setGranularity(QueryRunnerTestHelper.dayGran).setDimensions(Arrays.asList(new DefaultDimensionSpec("market", "market"))).setInterval(QueryRunnerTestHelper.firstToThird).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)Lists.newArrayList((Object[])new OrderByColumnSpec[]{new OrderByColumnSpec("rows", OrderByColumnSpec.Direction.DESCENDING)}), Integer.valueOf(2))).setAggregatorSpecs((List)Lists.newArrayList((Object[])new AggregatorFactory[]{QueryRunnerTestHelper.rowsCount})).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01T00:00:00.000Z", "market", "spot", "rows", 9L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02T00:00:00.000Z", "market", "spot", "rows", 9L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        Iterator resultsIter = results.iterator();
        Iterator<Row> expectedResultsIter = expectedResults.iterator();
        Object next1 = resultsIter.next();
        Row expectedNext1 = expectedResultsIter.next();
        Assert.assertEquals((String)"order-limit", (Object)expectedNext1, next1);
        Object next2 = resultsIter.next();
        Row expectedNext2 = expectedResultsIter.next();
        Assert.assertNotEquals((String)"order-limit", (Object)expectedNext2, next2);
    }

    @Test
    public void testPostAggMergedHavingSpec() {
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "mezzanine", "rows", 6L, "index", 4420L, "addRowsIndexConstant", 4427.0), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "premium", "rows", 6L, "index", 4416L, "addRowsIndexConstant", 4423.0));
        GroupByQuery.Builder builder = GroupByQuery.builder().setDataSource("testing").setInterval("2011-04-02/2011-04-04").setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("index", "index"))).setPostAggregatorSpecs((List)ImmutableList.of((Object)QueryRunnerTestHelper.addRowsIndexConstant)).setGranularity((Granularity)new PeriodGranularity(new Period((Object)"P1M"), null, null)).setHavingSpec((HavingSpec)new OrHavingSpec((List)ImmutableList.of((Object)new GreaterThanHavingSpec("addRowsIndexConstant", (Number)1000L))));
        GroupByQuery fullQuery = builder.build();
        QueryRunner mergedRunner = this.factory.getToolchest().mergeResults((QueryRunner)new QueryRunner<Row>(){

            public Sequence<Row> run(QueryPlus<Row> queryPlus, Map<String, Object> responseContext) {
                QueryPlus queryPlus1 = queryPlus.withQuerySegmentSpec((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)Lists.newArrayList((Object[])new Interval[]{Intervals.of((String)"2011-04-02/2011-04-03")})));
                QueryPlus queryPlus2 = queryPlus.withQuerySegmentSpec((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)Lists.newArrayList((Object[])new Interval[]{Intervals.of((String)"2011-04-03/2011-04-04")})));
                return new MergeSequence(queryPlus.getQuery().getResultOrdering(), Sequences.simple(Arrays.asList(GroupByQueryRunnerTest.this.runner.run(queryPlus1, responseContext), GroupByQueryRunnerTest.this.runner.run(queryPlus2, responseContext))));
            }
        });
        HashMap context = Maps.newHashMap();
        TestHelper.assertExpectedObjects(expectedResults, mergedRunner.run(QueryPlus.wrap((Query)fullQuery), (Map)context), "merged");
    }

    @Test
    public void testGroupByWithOrderLimitHavingSpec() {
        GroupByQuery.Builder builder = GroupByQuery.builder().setDataSource("testing").setInterval("2011-01-25/2011-01-28").setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new DoubleSumAggregatorFactory("index", "index"))).setGranularity(Granularities.ALL).setHavingSpec((HavingSpec)new GreaterThanHavingSpec("index", (Number)310L)).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)Lists.newArrayList((Object[])new OrderByColumnSpec[]{new OrderByColumnSpec("index", OrderByColumnSpec.Direction.ASCENDING)}), Integer.valueOf(5)));
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-01-25", "alias", "business", "rows", 3L, "index", 312.38165283203125), GroupByQueryRunnerTestHelper.createExpectedRow("2011-01-25", "alias", "news", "rows", 3L, "index", 312.7834167480469), GroupByQueryRunnerTestHelper.createExpectedRow("2011-01-25", "alias", "technology", "rows", 3L, "index", 324.6412353515625), GroupByQueryRunnerTestHelper.createExpectedRow("2011-01-25", "alias", "travel", "rows", 3L, "index", 393.36322021484375), GroupByQueryRunnerTestHelper.createExpectedRow("2011-01-25", "alias", "health", "rows", 3L, "index", 511.2996826171875));
        GroupByQuery fullQuery = builder.build();
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, fullQuery);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Test
    public void testPostAggHavingSpec() {
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "mezzanine", "rows", 6L, "index", 4420L, "addRowsIndexConstant", 4427.0), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "premium", "rows", 6L, "index", 4416L, "addRowsIndexConstant", 4423.0));
        GroupByQuery.Builder builder = GroupByQuery.builder().setDataSource("testing").setInterval("2011-04-02/2011-04-04").setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("index", "index"))).setPostAggregatorSpecs((List)ImmutableList.of((Object)QueryRunnerTestHelper.addRowsIndexConstant)).setGranularity((Granularity)new PeriodGranularity(new Period((Object)"P1M"), null, null)).setHavingSpec((HavingSpec)new OrHavingSpec((List)ImmutableList.of((Object)new GreaterThanHavingSpec("addRowsIndexConstant", (Number)1000L))));
        GroupByQuery fullQuery = builder.build();
        TestHelper.assertExpectedObjects(expectedResults, GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, fullQuery), "");
    }

    @Test
    public void testHavingSpec() {
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "business", "rows", 2L, "idx", 217L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "mezzanine", "rows", 6L, "idx", 4420L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "premium", "rows", 6L, "idx", 4416L));
        GroupByQuery.Builder builder = GroupByQuery.builder().setDataSource("testing").setInterval("2011-04-02/2011-04-04").setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).setGranularity((Granularity)new PeriodGranularity(new Period((Object)"P1M"), null, null)).setHavingSpec((HavingSpec)new OrHavingSpec((List)ImmutableList.of((Object)new GreaterThanHavingSpec("rows", (Number)2L), (Object)new EqualToHavingSpec("idx", (Number)217L))));
        GroupByQuery fullQuery = builder.build();
        TestHelper.assertExpectedObjects(expectedResults, GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, fullQuery), "");
    }

    @Test
    public void testDimFilterHavingSpec() {
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "business", "rows", 2L, "idx", 217L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "mezzanine", "rows", 6L, "idx", 4420L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "premium", "rows", 6L, "idx", 4416L));
        DimFilterHavingSpec havingSpec = new DimFilterHavingSpec((DimFilter)new AndDimFilter((List)ImmutableList.of((Object)new OrDimFilter((List)ImmutableList.of((Object)new BoundDimFilter("rows", "2", null, Boolean.valueOf(true), Boolean.valueOf(false), null, null, StringComparators.NUMERIC), (Object)new SelectorDimFilter("idx", "217", null))), (Object)new SelectorDimFilter("__time", String.valueOf(DateTimes.of((String)"2011-04-01").getMillis()), null))), null);
        GroupByQuery.Builder builder = GroupByQuery.builder().setDataSource("testing").setInterval("2011-04-02/2011-04-04").setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).setGranularity((Granularity)new PeriodGranularity(new Period((Object)"P1M"), null, null)).setHavingSpec((HavingSpec)havingSpec);
        GroupByQuery fullQuery = builder.build();
        TestHelper.assertExpectedObjects(expectedResults, GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, fullQuery), "");
    }

    @Test
    public void testDimFilterHavingSpecWithExtractionFns() {
        String extractionJsFn = "function(str) { return 'super-' + str; }";
        JavaScriptExtractionFn extractionFn = new JavaScriptExtractionFn(extractionJsFn, false, JavaScriptConfig.getEnabledInstance());
        String extractionJsFn2 = "function(num) { return num + 10; }";
        JavaScriptExtractionFn extractionFn2 = new JavaScriptExtractionFn(extractionJsFn2, false, JavaScriptConfig.getEnabledInstance());
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "business", "rows", 2L, "idx", 217L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "mezzanine", "rows", 6L, "idx", 4420L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "premium", "rows", 6L, "idx", 4416L));
        DimFilterHavingSpec havingSpec = new DimFilterHavingSpec((DimFilter)new OrDimFilter((List)ImmutableList.of((Object)new BoundDimFilter("rows", "12", null, Boolean.valueOf(true), Boolean.valueOf(false), null, (ExtractionFn)extractionFn2, StringComparators.NUMERIC), (Object)new SelectorDimFilter("idx", "super-217", (ExtractionFn)extractionFn))), null);
        GroupByQuery.Builder builder = GroupByQuery.builder().setDataSource("testing").setInterval("2011-04-02/2011-04-04").setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).setGranularity((Granularity)new PeriodGranularity(new Period((Object)"P1M"), null, null)).setHavingSpec((HavingSpec)havingSpec);
        GroupByQuery fullQuery = builder.build();
        TestHelper.assertExpectedObjects(expectedResults, GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, fullQuery), "");
    }

    @Test
    public void testMergedHavingSpec() {
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "business", "rows", 2L, "idx", 217L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "mezzanine", "rows", 6L, "idx", 4420L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "premium", "rows", 6L, "idx", 4416L));
        GroupByQuery.Builder builder = GroupByQuery.builder().setDataSource("testing").setInterval("2011-04-02/2011-04-04").setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).setGranularity((Granularity)new PeriodGranularity(new Period((Object)"P1M"), null, null)).setHavingSpec((HavingSpec)new OrHavingSpec((List)ImmutableList.of((Object)new GreaterThanHavingSpec("rows", (Number)2L), (Object)new EqualToHavingSpec("idx", (Number)217L))));
        GroupByQuery fullQuery = builder.build();
        QueryRunner mergedRunner = this.factory.getToolchest().mergeResults((QueryRunner)new QueryRunner<Row>(){

            public Sequence<Row> run(QueryPlus<Row> queryPlus, Map<String, Object> responseContext) {
                QueryPlus queryPlus1 = queryPlus.withQuerySegmentSpec((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)Lists.newArrayList((Object[])new Interval[]{Intervals.of((String)"2011-04-02/2011-04-03")})));
                QueryPlus queryPlus2 = queryPlus.withQuerySegmentSpec((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)Lists.newArrayList((Object[])new Interval[]{Intervals.of((String)"2011-04-03/2011-04-04")})));
                return new MergeSequence(queryPlus.getQuery().getResultOrdering(), Sequences.simple(Arrays.asList(GroupByQueryRunnerTest.this.runner.run(queryPlus1, responseContext), GroupByQueryRunnerTest.this.runner.run(queryPlus2, responseContext))));
            }
        });
        HashMap context = Maps.newHashMap();
        TestHelper.assertExpectedObjects(expectedResults, mergedRunner.run(QueryPlus.wrap((Query)fullQuery), (Map)context), "merged");
    }

    @Test
    public void testMergedPostAggHavingSpec() {
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "business", "rows", 2L, "idx", 217L, "rows_times_10", 20.0), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "mezzanine", "rows", 6L, "idx", 4420L, "rows_times_10", 60.0), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "premium", "rows", 6L, "idx", 4416L, "rows_times_10", 60.0));
        GroupByQuery.Builder builder = GroupByQuery.builder().setDataSource("testing").setInterval("2011-04-02/2011-04-04").setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).setPostAggregatorSpecs(Arrays.asList(new ArithmeticPostAggregator("rows_times_10", "*", Arrays.asList(new FieldAccessPostAggregator("rows", "rows"), new ConstantPostAggregator("const", (Number)10L))))).setGranularity((Granularity)new PeriodGranularity(new Period((Object)"P1M"), null, null)).setHavingSpec((HavingSpec)new OrHavingSpec((List)ImmutableList.of((Object)new GreaterThanHavingSpec("rows_times_10", (Number)20L), (Object)new EqualToHavingSpec("idx", (Number)217L))));
        GroupByQuery fullQuery = builder.build();
        QueryRunner mergedRunner = this.factory.getToolchest().mergeResults((QueryRunner)new QueryRunner<Row>(){

            public Sequence<Row> run(QueryPlus<Row> queryPlus, Map<String, Object> responseContext) {
                QueryPlus queryPlus1 = queryPlus.withQuerySegmentSpec((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)Lists.newArrayList((Object[])new Interval[]{Intervals.of((String)"2011-04-02/2011-04-03")})));
                QueryPlus queryPlus2 = queryPlus.withQuerySegmentSpec((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)Lists.newArrayList((Object[])new Interval[]{Intervals.of((String)"2011-04-03/2011-04-04")})));
                return new MergeSequence(queryPlus.getQuery().getResultOrdering(), Sequences.simple(Arrays.asList(GroupByQueryRunnerTest.this.runner.run(queryPlus1, responseContext), GroupByQueryRunnerTest.this.runner.run(queryPlus2, responseContext))));
            }
        });
        HashMap context = Maps.newHashMap();
        TestHelper.assertExpectedObjects(expectedResults, this.factory.getToolchest().postMergeQueryDecoration(this.factory.getToolchest().mergeResults(this.factory.getToolchest().preMergeQueryDecoration(mergedRunner))).run(QueryPlus.wrap((Query)fullQuery), (Map)context), "merged");
        fullQuery = fullQuery.withPostAggregatorSpecs(Arrays.asList(new ExpressionPostAggregator("rows_times_10", "rows * 10.0", null, TestExprMacroTable.INSTANCE)));
        TestHelper.assertExpectedObjects(expectedResults, this.factory.getToolchest().postMergeQueryDecoration(this.factory.getToolchest().mergeResults(this.factory.getToolchest().preMergeQueryDecoration(mergedRunner))).run(QueryPlus.wrap((Query)fullQuery), (Map)context), "merged");
    }

    @Test
    public void testGroupByWithRegEx() throws Exception {
        GroupByQuery.Builder builder = GroupByQuery.builder().setDataSource("testing").setInterval("2011-04-02/2011-04-04").setDimFilter((DimFilter)new RegexDimFilter("quality", "auto.*", null)).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "quality")})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount)).setGranularity((Granularity)new PeriodGranularity(new Period((Object)"P1M"), null, null));
        GroupByQuery query = builder.build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "quality", "automotive", "rows", 2L));
        QueryRunner mergeRunner = this.factory.getToolchest().mergeResults(this.runner);
        HashMap context = Maps.newHashMap();
        TestHelper.assertExpectedObjects(expectedResults, mergeRunner.run(QueryPlus.wrap((Query)query), (Map)context), "no-limit");
    }

    @Test
    public void testGroupByWithNonexistentDimension() throws Exception {
        GroupByQuery.Builder builder = GroupByQuery.builder().setDataSource("testing").setInterval("2011-04-02/2011-04-04").addDimension("billy").addDimension("quality").setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount)).setGranularity((Granularity)new PeriodGranularity(new Period((Object)"P1M"), null, null));
        GroupByQuery query = builder.build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "billy", null, "quality", "automotive", "rows", 2L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "billy", null, "quality", "business", "rows", 2L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "billy", null, "quality", "entertainment", "rows", 2L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "billy", null, "quality", "health", "rows", 2L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "billy", null, "quality", "mezzanine", "rows", 6L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "billy", null, "quality", "news", "rows", 2L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "billy", null, "quality", "premium", "rows", 6L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "billy", null, "quality", "technology", "rows", 2L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "billy", null, "quality", "travel", "rows", 2L));
        HashMap context = Maps.newHashMap();
        QueryRunner mergeRunner = this.factory.getToolchest().mergeResults(this.runner);
        TestHelper.assertExpectedObjects(expectedResults, mergeRunner.run(QueryPlus.wrap((Query)query), (Map)context), "no-limit");
    }

    @Test
    public void testIdenticalSubquery() {
        GroupByQuery subquery = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")})).setDimFilter((DimFilter)new JavaScriptDimFilter("quality", "function(dim){ return true; }", null, JavaScriptConfig.getEnabledInstance())).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"), new LongSumAggregatorFactory("indexMaxPlusTen", "indexMaxPlusTen"))).setGranularity(QueryRunnerTestHelper.dayGran).build();
        GroupByQuery query = GroupByQuery.builder().setDataSource((Query)subquery).setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("alias", "alias")})).setAggregatorSpecs(Arrays.asList(new LongSumAggregatorFactory("rows", "rows"), new LongSumAggregatorFactory("idx", "idx"))).setGranularity(QueryRunnerTestHelper.dayGran).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "automotive", "rows", 1L, "idx", 135L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "business", "rows", 1L, "idx", 118L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "entertainment", "rows", 1L, "idx", 158L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "health", "rows", 1L, "idx", 120L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "mezzanine", "rows", 3L, "idx", 2870L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "news", "rows", 1L, "idx", 121L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "premium", "rows", 3L, "idx", 2900L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "technology", "rows", 1L, "idx", 78L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "travel", "rows", 1L, "idx", 119L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "automotive", "rows", 1L, "idx", 147L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "business", "rows", 1L, "idx", 112L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "entertainment", "rows", 1L, "idx", 166L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "health", "rows", 1L, "idx", 113L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "mezzanine", "rows", 3L, "idx", 2447L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "news", "rows", 1L, "idx", 114L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "premium", "rows", 3L, "idx", 2505L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "technology", "rows", 1L, "idx", 97L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "travel", "rows", 1L, "idx", 126L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Test
    public void testSubqueryWithMultipleIntervalsInOuterQuery() {
        GroupByQuery subquery = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")})).setDimFilter((DimFilter)new JavaScriptDimFilter("quality", "function(dim){ return true; }", null, JavaScriptConfig.getEnabledInstance())).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"), new LongSumAggregatorFactory("indexMaxPlusTen", "indexMaxPlusTen"))).setGranularity(QueryRunnerTestHelper.dayGran).build();
        GroupByQuery query = GroupByQuery.builder().setDataSource((Query)subquery).setQuerySegmentSpec((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.of((String)"2011-04-01T00:00:00.000Z/2011-04-01T23:58:00.000Z"), (Object)Intervals.of((String)"2011-04-02T00:00:00.000Z/2011-04-03T00:00:00.000Z")))).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("alias", "alias")})).setAggregatorSpecs(Arrays.asList(new LongSumAggregatorFactory("rows", "rows"), new LongSumAggregatorFactory("idx", "idx"))).setGranularity(QueryRunnerTestHelper.dayGran).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "automotive", "rows", 1L, "idx", 135L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "business", "rows", 1L, "idx", 118L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "entertainment", "rows", 1L, "idx", 158L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "health", "rows", 1L, "idx", 120L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "mezzanine", "rows", 3L, "idx", 2870L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "news", "rows", 1L, "idx", 121L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "premium", "rows", 3L, "idx", 2900L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "technology", "rows", 1L, "idx", 78L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "travel", "rows", 1L, "idx", 119L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "automotive", "rows", 1L, "idx", 147L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "business", "rows", 1L, "idx", 112L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "entertainment", "rows", 1L, "idx", 166L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "health", "rows", 1L, "idx", 113L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "mezzanine", "rows", 3L, "idx", 2447L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "news", "rows", 1L, "idx", 114L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "premium", "rows", 3L, "idx", 2505L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "technology", "rows", 1L, "idx", 97L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "travel", "rows", 1L, "idx", 126L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Test
    public void testSubqueryWithMultipleIntervalsInOuterQueryAndChunkPeriod() {
        GroupByQuery subquery = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")})).setDimFilter((DimFilter)new JavaScriptDimFilter("quality", "function(dim){ return true; }", null, JavaScriptConfig.getEnabledInstance())).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"), new LongSumAggregatorFactory("indexMaxPlusTen", "indexMaxPlusTen"))).setGranularity(QueryRunnerTestHelper.dayGran).setContext((Map)ImmutableMap.of((Object)"chunkPeriod", (Object)"P1D")).build();
        GroupByQuery query = GroupByQuery.builder().setDataSource((Query)subquery).setQuerySegmentSpec((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.of((String)"2011-04-01T00:00:00.000Z/2011-04-01T23:58:00.000Z"), (Object)Intervals.of((String)"2011-04-02T00:00:00.000Z/2011-04-03T00:00:00.000Z")))).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("alias", "alias")})).setAggregatorSpecs(Arrays.asList(new LongSumAggregatorFactory("rows", "rows"), new LongSumAggregatorFactory("idx", "idx"))).setGranularity(QueryRunnerTestHelper.dayGran).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "automotive", "rows", 1L, "idx", 135L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "business", "rows", 1L, "idx", 118L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "entertainment", "rows", 1L, "idx", 158L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "health", "rows", 1L, "idx", 120L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "mezzanine", "rows", 3L, "idx", 2870L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "news", "rows", 1L, "idx", 121L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "premium", "rows", 3L, "idx", 2900L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "technology", "rows", 1L, "idx", 78L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "travel", "rows", 1L, "idx", 119L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "automotive", "rows", 1L, "idx", 147L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "business", "rows", 1L, "idx", 112L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "entertainment", "rows", 1L, "idx", 166L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "health", "rows", 1L, "idx", 113L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "mezzanine", "rows", 3L, "idx", 2447L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "news", "rows", 1L, "idx", 114L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "premium", "rows", 3L, "idx", 2505L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "technology", "rows", 1L, "idx", 97L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "travel", "rows", 1L, "idx", 126L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Test
    public void testSubqueryWithExtractionFnInOuterQuery() {
        GroupByQuery subquery = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")})).setDimFilter((DimFilter)new JavaScriptDimFilter("quality", "function(dim){ return true; }", null, JavaScriptConfig.getEnabledInstance())).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"), new LongSumAggregatorFactory("indexMaxPlusTen", "indexMaxPlusTen"))).setGranularity(QueryRunnerTestHelper.dayGran).build();
        GroupByQuery query = GroupByQuery.builder().setDataSource((Query)subquery).setQuerySegmentSpec((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.of((String)"2011-04-01T00:00:00.000Z/2011-04-03T00:00:00.000Z")))).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new ExtractionDimensionSpec("alias", "alias", (ExtractionFn)new RegexDimExtractionFn("(a).*", Boolean.valueOf(true), "a"))})).setAggregatorSpecs(Arrays.asList(new LongSumAggregatorFactory("rows", "rows"), new LongSumAggregatorFactory("idx", "idx"))).setGranularity(QueryRunnerTestHelper.dayGran).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "a", "rows", 13L, "idx", 6619L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "a", "rows", 13L, "idx", 5827L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Test
    public void testDifferentGroupingSubquery() {
        GroupByQuery subquery = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"), new LongSumAggregatorFactory("indexMaxPlusTen", "indexMaxPlusTen"))).setGranularity(QueryRunnerTestHelper.dayGran).build();
        GroupByQuery query = GroupByQuery.builder().setDataSource((Query)subquery).setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new DoubleMaxAggregatorFactory("idx", "idx"), new DoubleMaxAggregatorFactory("indexMaxPlusTen", "indexMaxPlusTen"))).setGranularity(QueryRunnerTestHelper.dayGran).build();
        List<Row> expectedResults = GroupByQueryRunnerTestHelper.createExpectedRows(new String[]{"__time", "rows", "idx", "indexMaxPlusTen"}, {"2011-04-01", 9L, 2900.0, 2930.0}, {"2011-04-02", 9L, 2505.0, 2535.0});
        TestHelper.assertExpectedObjects(expectedResults, GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query), "");
        subquery = new GroupByQuery.Builder(subquery).setVirtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("expr", "-index + 100", ValueType.FLOAT, TestExprMacroTable.INSTANCE)}).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "expr"), new LongSumAggregatorFactory("indexMaxPlusTen", "indexMaxPlusTen"))).build();
        query = (GroupByQuery)query.withDataSource((DataSource)new QueryDataSource((Query)subquery));
        expectedResults = GroupByQueryRunnerTestHelper.createExpectedRows(new String[]{"__time", "rows", "idx", "indexMaxPlusTen"}, {"2011-04-01", 9L, 21.0, 2930.0}, {"2011-04-02", 9L, 2.0, 2535.0});
        TestHelper.assertExpectedObjects(expectedResults, GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query), "");
    }

    @Test
    public void testDifferentGroupingSubqueryMultipleAggregatorsOnSameField() {
        GroupByQuery subquery = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).setPostAggregatorSpecs((List)Lists.newArrayList((Object[])new PostAggregator[]{new ArithmeticPostAggregator("post_agg", "+", (List)Lists.newArrayList((Object[])new PostAggregator[]{new FieldAccessPostAggregator("idx", "idx"), new FieldAccessPostAggregator("idx", "idx")}))})).setGranularity(QueryRunnerTestHelper.dayGran).build();
        GroupByQuery query = GroupByQuery.builder().setDataSource((Query)subquery).setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setAggregatorSpecs(Arrays.asList(new DoubleMaxAggregatorFactory("idx1", "idx"), new DoubleMaxAggregatorFactory("idx2", "idx"), new DoubleMaxAggregatorFactory("idx3", "post_agg"), new DoubleMaxAggregatorFactory("idx4", "post_agg"))).setGranularity(QueryRunnerTestHelper.dayGran).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "idx1", 2900.0, "idx2", 2900.0, "idx3", 5800.0, "idx4", 5800.0), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "idx1", 2505.0, "idx2", 2505.0, "idx3", 5010.0, "idx4", 5010.0));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Test
    public void testDifferentGroupingSubqueryWithFilter() {
        GroupByQuery subquery = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "quality")})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).setGranularity(QueryRunnerTestHelper.dayGran).build();
        GroupByQuery query = GroupByQuery.builder().setDataSource((Query)subquery).setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setAggregatorSpecs(Arrays.asList(new DoubleMaxAggregatorFactory("idx", "idx"))).setDimFilter((DimFilter)new OrDimFilter((List)Lists.newArrayList((Object[])new DimFilter[]{new SelectorDimFilter("quality", "automotive", null), new SelectorDimFilter("quality", "premium", null), new SelectorDimFilter("quality", "mezzanine", null), new SelectorDimFilter("quality", "business", null), new SelectorDimFilter("quality", "entertainment", null), new SelectorDimFilter("quality", "health", null), new SelectorDimFilter("quality", "news", null), new SelectorDimFilter("quality", "technology", null), new SelectorDimFilter("quality", "travel", null)}))).setGranularity(QueryRunnerTestHelper.dayGran).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "idx", 2900.0), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "idx", 2505.0));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Test
    public void testDifferentIntervalSubquery() {
        GroupByQuery subquery = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).setGranularity(QueryRunnerTestHelper.dayGran).build();
        GroupByQuery query = GroupByQuery.builder().setDataSource((Query)subquery).setQuerySegmentSpec(QueryRunnerTestHelper.secondOnly).setAggregatorSpecs(Arrays.asList(new DoubleMaxAggregatorFactory("idx", "idx"))).setGranularity(QueryRunnerTestHelper.dayGran).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "idx", 2505.0));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Test
    public void testGroupByTimeExtractionNamedUnderUnderTime() {
        this.expectedException.expect(IAE.class);
        this.expectedException.expectMessage("'__time' cannot be used as an output name for dimensions, aggregators, or post-aggregators.");
        GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.fullOnInterval).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("market", "market"), new ExtractionDimensionSpec("__time", "__time", (ExtractionFn)new TimeFormatExtractionFn("EEEE", null, null, null, false))})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, QueryRunnerTestHelper.indexDoubleSum)).setPostAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).setGranularity(QueryRunnerTestHelper.allGran).setDimFilter((DimFilter)new OrDimFilter(Arrays.asList(new SelectorDimFilter("market", "spot", null), new SelectorDimFilter("market", "upfront", null)))).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of(), Integer.valueOf(1))).build();
    }

    @Test
    public void testGroupByWithUnderUnderTimeAsDimensionNameWithHavingAndLimit() {
        this.expectedException.expect(IAE.class);
        this.expectedException.expectMessage("'__time' cannot be used as an output name for dimensions, aggregators, or post-aggregators.");
        GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "__time")})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).setGranularity(QueryRunnerTestHelper.dayGran).setHavingSpec((HavingSpec)new OrHavingSpec((List)ImmutableList.of((Object)new DimensionSelectorHavingSpec("__time", "automotive", null), (Object)new DimensionSelectorHavingSpec("__time", "business", null)))).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("__time", OrderByColumnSpec.Direction.DESCENDING)), null)).build();
    }

    @Test
    public void testEmptySubquery() {
        GroupByQuery subquery = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.emptyInterval).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).setGranularity(QueryRunnerTestHelper.dayGran).build();
        GroupByQuery query = GroupByQuery.builder().setDataSource((Query)subquery).setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setAggregatorSpecs(Arrays.asList(new DoubleMaxAggregatorFactory("idx", "idx"))).setGranularity(QueryRunnerTestHelper.dayGran).build();
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        Assert.assertFalse((boolean)results.iterator().hasNext());
    }

    @Test
    public void testSubqueryWithPostAggregators() {
        GroupByQuery subquery = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")})).setDimFilter((DimFilter)new JavaScriptDimFilter("quality", "function(dim){ return true; }", null, JavaScriptConfig.getEnabledInstance())).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx_subagg", "index"))).setPostAggregatorSpecs(Arrays.asList(new ArithmeticPostAggregator("idx_subpostagg", "+", Arrays.asList(new FieldAccessPostAggregator("the_idx_subagg", "idx_subagg"), new ConstantPostAggregator("thousand", (Number)1000))))).setGranularity(QueryRunnerTestHelper.dayGran).build();
        GroupByQuery query = GroupByQuery.builder().setDataSource((Query)subquery).setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("alias", "alias")})).setAggregatorSpecs(Arrays.asList(new LongSumAggregatorFactory("rows", "rows"), new LongSumAggregatorFactory("idx", "idx_subpostagg"))).setPostAggregatorSpecs(Arrays.asList(new ArithmeticPostAggregator("idx_post", "+", Arrays.asList(new FieldAccessPostAggregator("the_idx_agg", "idx"), new ConstantPostAggregator("ten_thousand", (Number)10000))))).setGranularity(QueryRunnerTestHelper.dayGran).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "automotive", "rows", 1L, "idx_post", 11135.0, "idx", 1135L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "business", "rows", 1L, "idx_post", 11118.0, "idx", 1118L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "entertainment", "rows", 1L, "idx_post", 11158.0, "idx", 1158L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "health", "rows", 1L, "idx_post", 11120.0, "idx", 1120L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "mezzanine", "rows", 3L, "idx_post", 13870.0, "idx", 3870L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "news", "rows", 1L, "idx_post", 11121.0, "idx", 1121L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "premium", "rows", 3L, "idx_post", 13900.0, "idx", 3900L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "technology", "rows", 1L, "idx_post", 11078.0, "idx", 1078L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "travel", "rows", 1L, "idx_post", 11119.0, "idx", 1119L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "automotive", "rows", 1L, "idx_post", 11147.0, "idx", 1147L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "business", "rows", 1L, "idx_post", 11112.0, "idx", 1112L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "entertainment", "rows", 1L, "idx_post", 11166.0, "idx", 1166L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "health", "rows", 1L, "idx_post", 11113.0, "idx", 1113L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "mezzanine", "rows", 3L, "idx_post", 13447.0, "idx", 3447L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "news", "rows", 1L, "idx_post", 11114.0, "idx", 1114L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "premium", "rows", 3L, "idx_post", 13505.0, "idx", 3505L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "technology", "rows", 1L, "idx_post", 11097.0, "idx", 1097L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "travel", "rows", 1L, "idx_post", 11126.0, "idx", 1126L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Test
    public void testSubqueryWithPostAggregatorsAndHaving() {
        GroupByQuery subquery = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")})).setDimFilter((DimFilter)new JavaScriptDimFilter("quality", "function(dim){ return true; }", null, JavaScriptConfig.getEnabledInstance())).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx_subagg", "index"))).setPostAggregatorSpecs(Arrays.asList(new ArithmeticPostAggregator("idx_subpostagg", "+", Arrays.asList(new FieldAccessPostAggregator("the_idx_subagg", "idx_subagg"), new ConstantPostAggregator("thousand", (Number)1000))))).setHavingSpec((HavingSpec)new BaseHavingSpec(){

            public boolean eval(Row row) {
                return row.getMetric("idx_subpostagg").floatValue() < 3800.0f;
            }
        }).addOrderByColumn("alias").setGranularity(QueryRunnerTestHelper.dayGran).build();
        GroupByQuery query = GroupByQuery.builder().setDataSource((Query)subquery).setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("alias", "alias")})).setAggregatorSpecs(Arrays.asList(new LongSumAggregatorFactory("rows", "rows"), new LongSumAggregatorFactory("idx", "idx_subpostagg"))).setPostAggregatorSpecs(Arrays.asList(new ArithmeticPostAggregator("idx_post", "+", Arrays.asList(new FieldAccessPostAggregator("the_idx_agg", "idx"), new ConstantPostAggregator("ten_thousand", (Number)10000))))).setGranularity(QueryRunnerTestHelper.dayGran).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "automotive", "rows", 1L, "idx_post", 11135.0, "idx", 1135L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "business", "rows", 1L, "idx_post", 11118.0, "idx", 1118L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "entertainment", "rows", 1L, "idx_post", 11158.0, "idx", 1158L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "health", "rows", 1L, "idx_post", 11120.0, "idx", 1120L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "news", "rows", 1L, "idx_post", 11121.0, "idx", 1121L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "technology", "rows", 1L, "idx_post", 11078.0, "idx", 1078L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "travel", "rows", 1L, "idx_post", 11119.0, "idx", 1119L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "automotive", "rows", 1L, "idx_post", 11147.0, "idx", 1147L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "business", "rows", 1L, "idx_post", 11112.0, "idx", 1112L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "entertainment", "rows", 1L, "idx_post", 11166.0, "idx", 1166L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "health", "rows", 1L, "idx_post", 11113.0, "idx", 1113L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "mezzanine", "rows", 3L, "idx_post", 13447.0, "idx", 3447L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "news", "rows", 1L, "idx_post", 11114.0, "idx", 1114L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "premium", "rows", 3L, "idx_post", 13505.0, "idx", 3505L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "technology", "rows", 1L, "idx_post", 11097.0, "idx", 1097L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "travel", "rows", 1L, "idx_post", 11126.0, "idx", 1126L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Test
    public void testSubqueryWithMultiColumnAggregators() {
        GroupByQuery subquery = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")})).setDimFilter((DimFilter)new JavaScriptDimFilter("market", "function(dim){ return true; }", null, JavaScriptConfig.getEnabledInstance())).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new DoubleSumAggregatorFactory("idx_subagg", "index"), new JavaScriptAggregatorFactory("js_agg", Arrays.asList("index", "market"), "function(current, index, dim){return current + index + dim.length;}", "function(){return 0;}", "function(a,b){return a + b;}", JavaScriptConfig.getEnabledInstance()))).setPostAggregatorSpecs(Arrays.asList(new ArithmeticPostAggregator("idx_subpostagg", "+", Arrays.asList(new FieldAccessPostAggregator("the_idx_subagg", "idx_subagg"), new ConstantPostAggregator("thousand", (Number)1000))))).setHavingSpec((HavingSpec)new BaseHavingSpec(){

            public boolean eval(Row row) {
                return row.getMetric("idx_subpostagg").floatValue() < 3800.0f;
            }
        }).addOrderByColumn("alias").setGranularity(QueryRunnerTestHelper.dayGran).build();
        GroupByQuery query = GroupByQuery.builder().setDataSource((Query)subquery).setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("alias", "alias")})).setAggregatorSpecs(Arrays.asList(new LongSumAggregatorFactory("rows", "rows"), new LongSumAggregatorFactory("idx", "idx_subpostagg"), new DoubleSumAggregatorFactory("js_outer_agg", "js_agg"))).setPostAggregatorSpecs(Arrays.asList(new ArithmeticPostAggregator("idx_post", "+", Arrays.asList(new FieldAccessPostAggregator("the_idx_agg", "idx"), new ConstantPostAggregator("ten_thousand", (Number)10000))))).setLimitSpec((LimitSpec)new DefaultLimitSpec(Arrays.asList(new OrderByColumnSpec("alias", OrderByColumnSpec.Direction.DESCENDING)), Integer.valueOf(5))).setGranularity(QueryRunnerTestHelper.dayGran).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "travel", "rows", 1L, "idx_post", 11119.0, "idx", 1119L, "js_outer_agg", 123.92274475097656), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "technology", "rows", 1L, "idx_post", 11078.0, "idx", 1078L, "js_outer_agg", 82.62254333496094), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "news", "rows", 1L, "idx_post", 11121.0, "idx", 1121L, "js_outer_agg", 125.58358001708984), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "health", "rows", 1L, "idx_post", 11120.0, "idx", 1120L, "js_outer_agg", 124.13470458984375), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "entertainment", "rows", 1L, "idx_post", 11158.0, "idx", 1158L, "js_outer_agg", 162.74722290039062));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Test
    public void testSubqueryWithOuterFilterAggregator() {
        GroupByQuery subquery = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.fullOnInterval).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("market", "market"), new DefaultDimensionSpec("quality", "quality")})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("index", "index"))).setGranularity(QueryRunnerTestHelper.dayGran).build();
        SelectorDimFilter filter = new SelectorDimFilter("market", "spot", null);
        GroupByQuery query = GroupByQuery.builder().setDataSource((Query)subquery).setQuerySegmentSpec(QueryRunnerTestHelper.fullOnInterval).setDimensions((List)Lists.newArrayList()).setAggregatorSpecs((List)ImmutableList.of((Object)new FilteredAggregatorFactory((AggregatorFactory)QueryRunnerTestHelper.rowsCount, (DimFilter)filter))).setGranularity(QueryRunnerTestHelper.allGran).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("1970-01-01", "rows", 837L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Test
    public void testSubqueryWithOuterTimeFilter() {
        GroupByQuery subquery = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.fullOnInterval).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("market", "market"), new DefaultDimensionSpec("quality", "quality")})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("index", "index"))).setGranularity(QueryRunnerTestHelper.dayGran).build();
        SelectorDimFilter fridayFilter = new SelectorDimFilter("__time", "Friday", (ExtractionFn)new TimeFormatExtractionFn("EEEE", null, null, null, false));
        InDimFilter firstDaysFilter = new InDimFilter("__time", (Collection)ImmutableList.of((Object)"1", (Object)"2", (Object)"3"), (ExtractionFn)new TimeFormatExtractionFn("d", null, null, null, false));
        GroupByQuery query = GroupByQuery.builder().setDataSource((Query)subquery).setQuerySegmentSpec(QueryRunnerTestHelper.fullOnInterval).setDimensions((List)Lists.newArrayList()).setDimFilter((DimFilter)firstDaysFilter).setAggregatorSpecs((List)ImmutableList.of((Object)new FilteredAggregatorFactory((AggregatorFactory)QueryRunnerTestHelper.rowsCount, (DimFilter)fridayFilter))).setGranularity(QueryRunnerTestHelper.dayGran).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-02-01", "rows", 0L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-02-02", "rows", 0L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-02-03", "rows", 0L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-03-01", "rows", 0L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-03-02", "rows", 0L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-03-03", "rows", 0L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "rows", 13L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "rows", 0L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-03", "rows", 0L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Test
    public void testSubqueryWithContextTimeout() {
        GroupByQuery subquery = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.fullOnInterval).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")})).setGranularity(QueryRunnerTestHelper.dayGran).build();
        GroupByQuery query = GroupByQuery.builder().setDataSource((Query)subquery).setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList()).setAggregatorSpecs((List)ImmutableList.of((Object)new CountAggregatorFactory("count"))).setGranularity(QueryRunnerTestHelper.allGran).setContext((Map)ImmutableMap.of((Object)"timeout", (Object)10000)).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "count", 18L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Test
    public void testSubqueryWithOuterVirtualColumns() {
        GroupByQuery subquery = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.fullOnInterval).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")})).setGranularity(QueryRunnerTestHelper.dayGran).build();
        GroupByQuery query = GroupByQuery.builder().setDataSource((Query)subquery).setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setVirtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("expr", "1", ValueType.FLOAT, TestExprMacroTable.INSTANCE)}).setDimensions((List)Lists.newArrayList()).setAggregatorSpecs((List)ImmutableList.of((Object)new LongSumAggregatorFactory("count", "expr"))).setGranularity(QueryRunnerTestHelper.allGran).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "count", 18L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Test
    public void testSubqueryWithOuterCardinalityAggregator() {
        GroupByQuery subquery = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.fullOnInterval).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("market", "market"), new DefaultDimensionSpec("quality", "quality")})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("index", "index"))).setGranularity(QueryRunnerTestHelper.dayGran).build();
        GroupByQuery query = GroupByQuery.builder().setDataSource((Query)subquery).setQuerySegmentSpec(QueryRunnerTestHelper.fullOnInterval).setDimensions((List)Lists.newArrayList()).setAggregatorSpecs((List)ImmutableList.of((Object)new CardinalityAggregatorFactory("car", (List)ImmutableList.of((Object)new DefaultDimensionSpec("quality", "quality")), false))).setGranularity(QueryRunnerTestHelper.allGran).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("1970-01-01", "car", 9.019833517963864));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Test
    public void testSubqueryWithOuterCountAggregator() {
        GroupByQuery subquery = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.fullOnInterval).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")})).setGranularity(QueryRunnerTestHelper.dayGran).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("alias", OrderByColumnSpec.Direction.ASCENDING)), null)).build();
        GroupByQuery query = GroupByQuery.builder().setDataSource((Query)subquery).setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList()).setAggregatorSpecs((List)ImmutableList.of((Object)new CountAggregatorFactory("count"))).setGranularity(QueryRunnerTestHelper.allGran).build();
        if (this.config.getDefaultStrategy().equals("v1")) {
            this.expectedException.expect(ISE.class);
            this.expectedException.expectMessage("Unknown column in order clause");
            GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        } else {
            List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "count", 18L));
            Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
            TestHelper.assertExpectedObjects(expectedResults, results, "");
        }
    }

    @Test
    public void testSubqueryWithOuterDimJavascriptAggregators() {
        GroupByQuery subquery = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("market", "market"), new DefaultDimensionSpec("quality", "quality")})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("index", "index"))).setGranularity(QueryRunnerTestHelper.dayGran).build();
        GroupByQuery query = GroupByQuery.builder().setDataSource((Query)subquery).setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "quality")})).setAggregatorSpecs(Arrays.asList(new JavaScriptAggregatorFactory("js_agg", Arrays.asList("index", "market"), "function(current, index, dim){return current + index + dim.length;}", "function(){return 0;}", "function(a,b){return a + b;}", JavaScriptConfig.getEnabledInstance()))).setGranularity(QueryRunnerTestHelper.dayGran).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "quality", "automotive", "js_agg", 139.0), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "quality", "business", "js_agg", 122.0), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "quality", "entertainment", "js_agg", 162.0), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "quality", "health", "js_agg", 124.0), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "quality", "mezzanine", "js_agg", 2893.0), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "quality", "news", "js_agg", 125.0), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "quality", "premium", "js_agg", 2923.0), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "quality", "technology", "js_agg", 82.0), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "quality", "travel", "js_agg", 123.0), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "quality", "automotive", "js_agg", 151.0), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "quality", "business", "js_agg", 116.0), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "quality", "entertainment", "js_agg", 170.0), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "quality", "health", "js_agg", 117.0), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "quality", "mezzanine", "js_agg", 2470.0), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "quality", "news", "js_agg", 118.0), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "quality", "premium", "js_agg", 2528.0), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "quality", "technology", "js_agg", 101.0), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "quality", "travel", "js_agg", 130.0));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Test
    public void testSubqueryWithOuterJavascriptAggregators() {
        GroupByQuery subquery = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("market", "market"), new DefaultDimensionSpec("quality", "quality")})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("index", "index"))).setGranularity(QueryRunnerTestHelper.dayGran).build();
        GroupByQuery query = GroupByQuery.builder().setDataSource((Query)subquery).setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "quality")})).setAggregatorSpecs(Arrays.asList(new JavaScriptAggregatorFactory("js_agg", Arrays.asList("index", "rows"), "function(current, index, rows){return current + index + rows;}", "function(){return 0;}", "function(a,b){return a + b;}", JavaScriptConfig.getEnabledInstance()))).setGranularity(QueryRunnerTestHelper.dayGran).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "quality", "automotive", "js_agg", 136.0), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "quality", "business", "js_agg", 119.0), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "quality", "entertainment", "js_agg", 159.0), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "quality", "health", "js_agg", 121.0), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "quality", "mezzanine", "js_agg", 2873.0), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "quality", "news", "js_agg", 122.0), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "quality", "premium", "js_agg", 2903.0), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "quality", "technology", "js_agg", 79.0), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "quality", "travel", "js_agg", 120.0), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "quality", "automotive", "js_agg", 148.0), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "quality", "business", "js_agg", 113.0), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "quality", "entertainment", "js_agg", 167.0), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "quality", "health", "js_agg", 114.0), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "quality", "mezzanine", "js_agg", 2450.0), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "quality", "news", "js_agg", 115.0), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "quality", "premium", "js_agg", 2508.0), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "quality", "technology", "js_agg", 98.0), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "quality", "travel", "js_agg", 127.0));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Test
    public void testSubqueryWithHyperUniques() {
        GroupByQuery subquery = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"), new HyperUniquesAggregatorFactory("quality_uniques", "quality_uniques"))).setGranularity(QueryRunnerTestHelper.dayGran).build();
        GroupByQuery query = GroupByQuery.builder().setDataSource((Query)subquery).setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("alias", "alias")})).setAggregatorSpecs(Arrays.asList(new LongSumAggregatorFactory("rows", "rows"), new LongSumAggregatorFactory("idx", "idx"), new HyperUniquesAggregatorFactory("uniq", "quality_uniques"))).setGranularity(QueryRunnerTestHelper.allGran).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "automotive", "rows", 2L, "idx", 282L, "uniq", 1.0002442201269182), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "business", "rows", 2L, "idx", 230L, "uniq", 1.0002442201269182), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "entertainment", "rows", 2L, "idx", 324L, "uniq", 1.0002442201269182), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "health", "rows", 2L, "idx", 233L, "uniq", 1.0002442201269182), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "mezzanine", "rows", 6L, "idx", 5317L, "uniq", 1.0002442201269182), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "news", "rows", 2L, "idx", 235L, "uniq", 1.0002442201269182), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "premium", "rows", 6L, "idx", 5405L, "uniq", 1.0002442201269182), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "technology", "rows", 2L, "idx", 175L, "uniq", 1.0002442201269182), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "travel", "rows", 2L, "idx", 245L, "uniq", 1.0002442201269182));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Test
    public void testSubqueryWithHyperUniquesPostAggregator() {
        GroupByQuery subquery = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList()).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"), new HyperUniquesAggregatorFactory("quality_uniques_inner", "quality_uniques"))).setPostAggregatorSpecs(Arrays.asList(new FieldAccessPostAggregator("quality_uniques_inner_post", "quality_uniques_inner"))).setGranularity(QueryRunnerTestHelper.dayGran).build();
        GroupByQuery query = GroupByQuery.builder().setDataSource((Query)subquery).setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList()).setAggregatorSpecs(Arrays.asList(new LongSumAggregatorFactory("rows", "rows"), new LongSumAggregatorFactory("idx", "idx"), new HyperUniquesAggregatorFactory("quality_uniques_outer", "quality_uniques_inner_post"))).setPostAggregatorSpecs(Arrays.asList(new HyperUniqueFinalizingPostAggregator("quality_uniques_outer_post", "quality_uniques_outer"))).setGranularity(QueryRunnerTestHelper.allGran).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "rows", 26L, "idx", 12446L, "quality_uniques_outer", 9.019833517963864, "quality_uniques_outer_post", 9.019833517963864));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Test
    public void testSubqueryWithFirstLast() {
        GroupByQuery subquery = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.fullOnInterval).setDimensions((List)ImmutableList.of((Object)new DefaultDimensionSpec("market", "market"))).setAggregatorSpecs((List)ImmutableList.of((Object)QueryRunnerTestHelper.rowsCount, (Object)new LongFirstAggregatorFactory("innerfirst", "index"), (Object)new LongLastAggregatorFactory("innerlast", "index"))).setGranularity(QueryRunnerTestHelper.dayGran).setContext((Map)ImmutableMap.of((Object)"finalize", (Object)true)).build();
        GroupByQuery query = GroupByQuery.builder().setDataSource((Query)subquery).setQuerySegmentSpec(QueryRunnerTestHelper.fullOnInterval).setDimensions((List)Lists.newArrayList()).setAggregatorSpecs((List)ImmutableList.of((Object)new LongFirstAggregatorFactory("first", "innerfirst"), (Object)new LongLastAggregatorFactory("last", "innerlast"))).setGranularity(QueryRunnerTestHelper.monthGran).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-01-01", "first", 100L, "last", 943L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-02-01", "first", 132L, "last", 1101L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-03-01", "first", 153L, "last", 1063L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "first", 135L, "last", 780L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Test
    public void testGroupByWithTimeColumn() {
        GroupByQuery query = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, QueryRunnerTestHelper.jsCountIfTimeGreaterThan, QueryRunnerTestHelper.__timeLongSum)).setGranularity(QueryRunnerTestHelper.allGran).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "rows", 26L, "ntimestamps", 13.0, "sumtime", 33843139200000L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Test
    public void testGroupByTimeExtraction() {
        GroupByQuery query = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.fullOnInterval).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("market", "market"), new ExtractionDimensionSpec("__time", "dayOfWeek", (ExtractionFn)new TimeFormatExtractionFn("EEEE", null, null, null, false))})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, QueryRunnerTestHelper.indexDoubleSum)).setPostAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).setGranularity(QueryRunnerTestHelper.allGran).setDimFilter((DimFilter)new OrDimFilter(Arrays.asList(new SelectorDimFilter("market", "spot", null), new SelectorDimFilter("market", "upfront", null)))).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("1970-01-01", "dayOfWeek", "Friday", "market", "spot", "index", 13219.574157714844, "rows", 117L, "addRowsIndexConstant", 13337.574157714844), GroupByQueryRunnerTestHelper.createExpectedRow("1970-01-01", "dayOfWeek", "Monday", "market", "spot", "index", 13557.738830566406, "rows", 117L, "addRowsIndexConstant", 13675.738830566406), GroupByQueryRunnerTestHelper.createExpectedRow("1970-01-01", "dayOfWeek", "Saturday", "market", "spot", "index", 13493.751281738281, "rows", 117L, "addRowsIndexConstant", 13611.751281738281), GroupByQueryRunnerTestHelper.createExpectedRow("1970-01-01", "dayOfWeek", "Sunday", "market", "spot", "index", 13585.541015625, "rows", 117L, "addRowsIndexConstant", 13703.541015625), GroupByQueryRunnerTestHelper.createExpectedRow("1970-01-01", "dayOfWeek", "Thursday", "market", "spot", "index", 14279.127197265625, "rows", 126L, "addRowsIndexConstant", 14406.127197265625), GroupByQueryRunnerTestHelper.createExpectedRow("1970-01-01", "dayOfWeek", "Tuesday", "market", "spot", "index", 13199.471435546875, "rows", 117L, "addRowsIndexConstant", 13317.471435546875), GroupByQueryRunnerTestHelper.createExpectedRow("1970-01-01", "dayOfWeek", "Wednesday", "market", "spot", "index", 14271.368591308594, "rows", 126L, "addRowsIndexConstant", 14398.368591308594), GroupByQueryRunnerTestHelper.createExpectedRow("1970-01-01", "dayOfWeek", "Friday", "market", "upfront", "index", 27297.8623046875, "rows", 26L, "addRowsIndexConstant", 27324.8623046875), GroupByQueryRunnerTestHelper.createExpectedRow("1970-01-01", "dayOfWeek", "Monday", "market", "upfront", "index", 27619.58447265625, "rows", 26L, "addRowsIndexConstant", 27646.58447265625), GroupByQueryRunnerTestHelper.createExpectedRow("1970-01-01", "dayOfWeek", "Saturday", "market", "upfront", "index", 27820.83154296875, "rows", 26L, "addRowsIndexConstant", 27847.83154296875), GroupByQueryRunnerTestHelper.createExpectedRow("1970-01-01", "dayOfWeek", "Sunday", "market", "upfront", "index", 24791.223876953125, "rows", 26L, "addRowsIndexConstant", 24818.223876953125), GroupByQueryRunnerTestHelper.createExpectedRow("1970-01-01", "dayOfWeek", "Thursday", "market", "upfront", "index", 28562.748901367188, "rows", 28L, "addRowsIndexConstant", 28591.748901367188), GroupByQueryRunnerTestHelper.createExpectedRow("1970-01-01", "dayOfWeek", "Tuesday", "market", "upfront", "index", 26968.280639648438, "rows", 26L, "addRowsIndexConstant", 26995.280639648438), GroupByQueryRunnerTestHelper.createExpectedRow("1970-01-01", "dayOfWeek", "Wednesday", "market", "upfront", "index", 28985.5751953125, "rows", 28L, "addRowsIndexConstant", 29014.5751953125));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Test
    public void testGroupByTimeExtractionWithNulls() {
        DimExtractionFn nullWednesdays = new DimExtractionFn(){

            public String apply(String dimValue) {
                if ("Wednesday".equals(dimValue)) {
                    return null;
                }
                return dimValue;
            }

            public byte[] getCacheKey() {
                throw new UnsupportedOperationException();
            }

            public boolean preservesOrdering() {
                return false;
            }

            public ExtractionFn.ExtractionType getExtractionType() {
                return ExtractionFn.ExtractionType.MANY_TO_ONE;
            }
        };
        GroupByQuery query = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.fullOnInterval).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("market", "market"), new ExtractionDimensionSpec("__time", "dayOfWeek", (ExtractionFn)new CascadeExtractionFn(new ExtractionFn[]{new TimeFormatExtractionFn("EEEE", null, null, null, false), nullWednesdays}))})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, QueryRunnerTestHelper.indexDoubleSum)).setPostAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).setGranularity(QueryRunnerTestHelper.allGran).setDimFilter((DimFilter)new OrDimFilter(Arrays.asList(new SelectorDimFilter("market", "spot", null), new SelectorDimFilter("market", "upfront", null)))).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("1970-01-01", "dayOfWeek", null, "market", "spot", "index", 14271.368591308594, "rows", 126L, "addRowsIndexConstant", 14398.368591308594), GroupByQueryRunnerTestHelper.createExpectedRow("1970-01-01", "dayOfWeek", "Friday", "market", "spot", "index", 13219.574157714844, "rows", 117L, "addRowsIndexConstant", 13337.574157714844), GroupByQueryRunnerTestHelper.createExpectedRow("1970-01-01", "dayOfWeek", "Monday", "market", "spot", "index", 13557.738830566406, "rows", 117L, "addRowsIndexConstant", 13675.738830566406), GroupByQueryRunnerTestHelper.createExpectedRow("1970-01-01", "dayOfWeek", "Saturday", "market", "spot", "index", 13493.751281738281, "rows", 117L, "addRowsIndexConstant", 13611.751281738281), GroupByQueryRunnerTestHelper.createExpectedRow("1970-01-01", "dayOfWeek", "Sunday", "market", "spot", "index", 13585.541015625, "rows", 117L, "addRowsIndexConstant", 13703.541015625), GroupByQueryRunnerTestHelper.createExpectedRow("1970-01-01", "dayOfWeek", "Thursday", "market", "spot", "index", 14279.127197265625, "rows", 126L, "addRowsIndexConstant", 14406.127197265625), GroupByQueryRunnerTestHelper.createExpectedRow("1970-01-01", "dayOfWeek", "Tuesday", "market", "spot", "index", 13199.471435546875, "rows", 117L, "addRowsIndexConstant", 13317.471435546875), GroupByQueryRunnerTestHelper.createExpectedRow("1970-01-01", "dayOfWeek", null, "market", "upfront", "index", 28985.5751953125, "rows", 28L, "addRowsIndexConstant", 29014.5751953125), GroupByQueryRunnerTestHelper.createExpectedRow("1970-01-01", "dayOfWeek", "Friday", "market", "upfront", "index", 27297.8623046875, "rows", 26L, "addRowsIndexConstant", 27324.8623046875), GroupByQueryRunnerTestHelper.createExpectedRow("1970-01-01", "dayOfWeek", "Monday", "market", "upfront", "index", 27619.58447265625, "rows", 26L, "addRowsIndexConstant", 27646.58447265625), GroupByQueryRunnerTestHelper.createExpectedRow("1970-01-01", "dayOfWeek", "Saturday", "market", "upfront", "index", 27820.83154296875, "rows", 26L, "addRowsIndexConstant", 27847.83154296875), GroupByQueryRunnerTestHelper.createExpectedRow("1970-01-01", "dayOfWeek", "Sunday", "market", "upfront", "index", 24791.223876953125, "rows", 26L, "addRowsIndexConstant", 24818.223876953125), GroupByQueryRunnerTestHelper.createExpectedRow("1970-01-01", "dayOfWeek", "Thursday", "market", "upfront", "index", 28562.748901367188, "rows", 28L, "addRowsIndexConstant", 28591.748901367188), GroupByQueryRunnerTestHelper.createExpectedRow("1970-01-01", "dayOfWeek", "Tuesday", "market", "upfront", "index", 26968.280639648438, "rows", 26L, "addRowsIndexConstant", 26995.280639648438));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Test
    public void testBySegmentResults() {
        int segmentCount = 32;
        Result singleSegmentResult = new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new BySegmentResultValueClass(Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "mezzanine", "rows", 6L, "idx", 4420L)), "testSegment", Intervals.of((String)"2011-04-02T00:00:00.000Z/2011-04-04T00:00:00.000Z")));
        ArrayList bySegmentResults = Lists.newArrayList();
        for (int i = 0; i < segmentCount; ++i) {
            bySegmentResults.add(singleSegmentResult);
        }
        GroupByQuery.Builder builder = GroupByQuery.builder().setDataSource("testing").setInterval("2011-04-02/2011-04-04").setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).setGranularity((Granularity)new PeriodGranularity(new Period((Object)"P1M"), null, null)).setDimFilter((DimFilter)new SelectorDimFilter("quality", "mezzanine", null)).setContext((Map)ImmutableMap.of((Object)"bySegment", (Object)true));
        GroupByQuery fullQuery = builder.build();
        QueryToolChest toolChest = this.factory.getToolchest();
        ArrayList singleSegmentRunners = Lists.newArrayList();
        for (int i = 0; i < segmentCount; ++i) {
            singleSegmentRunners.add(toolChest.preMergeQueryDecoration(this.runner));
        }
        ExecutorService exec = Executors.newCachedThreadPool();
        QueryRunner theRunner = toolChest.postMergeQueryDecoration((QueryRunner)new FinalizeResultsQueryRunner(toolChest.mergeResults(this.factory.mergeRunners(Executors.newCachedThreadPool(), (Iterable)singleSegmentRunners)), toolChest));
        TestHelper.assertExpectedObjects(bySegmentResults, theRunner.run(QueryPlus.wrap((Query)fullQuery), (Map)Maps.newHashMap()), "");
        exec.shutdownNow();
    }

    @Test
    public void testBySegmentResultsUnOptimizedDimextraction() {
        int segmentCount = 32;
        Result singleSegmentResult = new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new BySegmentResultValueClass(Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "mezzanine0", "rows", 6L, "idx", 4420L)), "testSegment", Intervals.of((String)"2011-04-02T00:00:00.000Z/2011-04-04T00:00:00.000Z")));
        ArrayList bySegmentResults = Lists.newArrayList();
        for (int i = 0; i < segmentCount; ++i) {
            bySegmentResults.add(singleSegmentResult);
        }
        GroupByQuery.Builder builder = GroupByQuery.builder().setDataSource("testing").setInterval("2011-04-02/2011-04-04").setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new ExtractionDimensionSpec("quality", "alias", (ExtractionFn)new LookupExtractionFn((LookupExtractor)new MapLookupExtractor((Map)ImmutableMap.of((Object)"mezzanine", (Object)"mezzanine0"), false), false, null, Boolean.valueOf(false), Boolean.valueOf(false)))})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).setGranularity((Granularity)new PeriodGranularity(new Period((Object)"P1M"), null, null)).setDimFilter((DimFilter)new SelectorDimFilter("quality", "mezzanine", null)).setContext((Map)ImmutableMap.of((Object)"bySegment", (Object)true));
        GroupByQuery fullQuery = builder.build();
        QueryToolChest toolChest = this.factory.getToolchest();
        ArrayList singleSegmentRunners = Lists.newArrayList();
        for (int i = 0; i < segmentCount; ++i) {
            singleSegmentRunners.add(toolChest.preMergeQueryDecoration(this.runner));
        }
        ExecutorService exec = Executors.newCachedThreadPool();
        QueryRunner theRunner = toolChest.postMergeQueryDecoration((QueryRunner)new FinalizeResultsQueryRunner(toolChest.mergeResults(this.factory.mergeRunners(Executors.newCachedThreadPool(), (Iterable)singleSegmentRunners)), toolChest));
        TestHelper.assertExpectedObjects(bySegmentResults, theRunner.run(QueryPlus.wrap((Query)fullQuery), (Map)Maps.newHashMap()), "");
        exec.shutdownNow();
    }

    @Test
    public void testBySegmentResultsOptimizedDimextraction() {
        int segmentCount = 32;
        Result singleSegmentResult = new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new BySegmentResultValueClass(Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "mezzanine0", "rows", 6L, "idx", 4420L)), "testSegment", Intervals.of((String)"2011-04-02T00:00:00.000Z/2011-04-04T00:00:00.000Z")));
        ArrayList bySegmentResults = Lists.newArrayList();
        for (int i = 0; i < segmentCount; ++i) {
            bySegmentResults.add(singleSegmentResult);
        }
        GroupByQuery.Builder builder = GroupByQuery.builder().setDataSource("testing").setInterval("2011-04-02/2011-04-04").setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new ExtractionDimensionSpec("quality", "alias", (ExtractionFn)new LookupExtractionFn((LookupExtractor)new MapLookupExtractor((Map)ImmutableMap.of((Object)"mezzanine", (Object)"mezzanine0"), false), false, null, Boolean.valueOf(true), Boolean.valueOf(false)))})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).setGranularity((Granularity)new PeriodGranularity(new Period((Object)"P1M"), null, null)).setDimFilter((DimFilter)new SelectorDimFilter("quality", "mezzanine", null)).setContext((Map)ImmutableMap.of((Object)"bySegment", (Object)true));
        GroupByQuery fullQuery = builder.build();
        QueryToolChest toolChest = this.factory.getToolchest();
        ArrayList singleSegmentRunners = Lists.newArrayList();
        for (int i = 0; i < segmentCount; ++i) {
            singleSegmentRunners.add(toolChest.preMergeQueryDecoration(this.runner));
        }
        ExecutorService exec = Executors.newCachedThreadPool();
        QueryRunner theRunner = toolChest.postMergeQueryDecoration((QueryRunner)new FinalizeResultsQueryRunner(toolChest.mergeResults(this.factory.mergeRunners(Executors.newCachedThreadPool(), (Iterable)singleSegmentRunners)), toolChest));
        TestHelper.assertExpectedObjects(bySegmentResults, theRunner.run(QueryPlus.wrap((Query)fullQuery), (Map)Maps.newHashMap()), "");
        exec.shutdownNow();
    }

    @Test
    public void testGroupByWithExtractionDimFilter() {
        HashMap<String, String> extractionMap = new HashMap<String, String>();
        extractionMap.put("automotive", "automotiveAndBusinessAndNewsAndMezzanine");
        extractionMap.put("business", "automotiveAndBusinessAndNewsAndMezzanine");
        extractionMap.put("mezzanine", "automotiveAndBusinessAndNewsAndMezzanine");
        extractionMap.put("news", "automotiveAndBusinessAndNewsAndMezzanine");
        MapLookupExtractor mapLookupExtractor = new MapLookupExtractor(extractionMap, false);
        LookupExtractionFn lookupExtractionFn = new LookupExtractionFn((LookupExtractor)mapLookupExtractor, false, null, Boolean.valueOf(true), Boolean.valueOf(false));
        ArrayList dimFilters = Lists.newArrayList((Object[])new DimFilter[]{new ExtractionDimFilter("quality", "automotiveAndBusinessAndNewsAndMezzanine", (ExtractionFn)lookupExtractionFn, null), new SelectorDimFilter("quality", "entertainment", null), new SelectorDimFilter("quality", "health", null), new SelectorDimFilter("quality", "premium", null), new SelectorDimFilter("quality", "technology", null), new SelectorDimFilter("quality", "travel", null)});
        GroupByQuery query = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).setGranularity(QueryRunnerTestHelper.dayGran).setDimFilter((DimFilter)new OrDimFilter((List)dimFilters)).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "automotive", "rows", 1L, "idx", 135L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "business", "rows", 1L, "idx", 118L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "entertainment", "rows", 1L, "idx", 158L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "health", "rows", 1L, "idx", 120L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "mezzanine", "rows", 3L, "idx", 2870L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "news", "rows", 1L, "idx", 121L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "premium", "rows", 3L, "idx", 2900L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "technology", "rows", 1L, "idx", 78L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "travel", "rows", 1L, "idx", 119L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "automotive", "rows", 1L, "idx", 147L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "business", "rows", 1L, "idx", 112L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "entertainment", "rows", 1L, "idx", 166L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "health", "rows", 1L, "idx", 113L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "mezzanine", "rows", 3L, "idx", 2447L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "news", "rows", 1L, "idx", 114L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "premium", "rows", 3L, "idx", 2505L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "technology", "rows", 1L, "idx", 97L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "travel", "rows", 1L, "idx", 126L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Test
    public void testGroupByWithExtractionDimFilterCaseMappingValueIsNullOrEmpty() {
        HashMap<String, String> extractionMap = new HashMap<String, String>();
        extractionMap.put("automotive", "automotive0");
        extractionMap.put("business", "business0");
        extractionMap.put("entertainment", "entertainment0");
        extractionMap.put("health", "health0");
        extractionMap.put("mezzanine", null);
        extractionMap.put("news", "");
        extractionMap.put("premium", "premium0");
        extractionMap.put("technology", "technology0");
        extractionMap.put("travel", "travel0");
        MapLookupExtractor mapLookupExtractor = new MapLookupExtractor(extractionMap, false);
        LookupExtractionFn lookupExtractionFn = new LookupExtractionFn((LookupExtractor)mapLookupExtractor, false, null, Boolean.valueOf(true), Boolean.valueOf(false));
        GroupByQuery query = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).setGranularity(QueryRunnerTestHelper.dayGran).setDimFilter((DimFilter)new ExtractionDimFilter("quality", "", (ExtractionFn)lookupExtractionFn, null)).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "mezzanine", "rows", 3L, "idx", 2870L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "news", "rows", 1L, "idx", 121L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "mezzanine", "rows", 3L, "idx", 2447L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "news", "rows", 1L, "idx", 114L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Test
    public void testGroupByWithExtractionDimFilterWhenSearchValueNotInTheMap() {
        HashMap extractionMap = new HashMap();
        MapLookupExtractor mapLookupExtractor = new MapLookupExtractor(extractionMap, false);
        LookupExtractionFn lookupExtractionFn = new LookupExtractionFn((LookupExtractor)mapLookupExtractor, false, null, Boolean.valueOf(true), Boolean.valueOf(false));
        GroupByQuery query = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).setGranularity(QueryRunnerTestHelper.dayGran).setDimFilter((DimFilter)new ExtractionDimFilter("quality", "NOT_THERE", (ExtractionFn)lookupExtractionFn, null)).build();
        List<Row> expectedResults = Arrays.asList(new Row[0]);
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Test
    public void testGroupByWithExtractionDimFilterKeyisNull() {
        HashMap<String, String> extractionMap = new HashMap<String, String>();
        extractionMap.put("", "NULLorEMPTY");
        MapLookupExtractor mapLookupExtractor = new MapLookupExtractor(extractionMap, false);
        LookupExtractionFn lookupExtractionFn = new LookupExtractionFn((LookupExtractor)mapLookupExtractor, false, null, Boolean.valueOf(true), Boolean.valueOf(false));
        GroupByQuery query = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("null_column", "alias")})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).setGranularity(QueryRunnerTestHelper.dayGran).setDimFilter((DimFilter)new ExtractionDimFilter("null_column", "NULLorEMPTY", (ExtractionFn)lookupExtractionFn, null)).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", null, "rows", 13L, "idx", 6619L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", null, "rows", 13L, "idx", 5827L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Test
    public void testGroupByWithAggregatorFilterAndExtractionFunction() {
        HashMap<String, String> extractionMap = new HashMap<String, String>();
        extractionMap.put("automotive", "automotive0");
        extractionMap.put("business", "business0");
        extractionMap.put("entertainment", "entertainment0");
        extractionMap.put("health", "health0");
        extractionMap.put("mezzanine", "mezzanineANDnews");
        extractionMap.put("news", "mezzanineANDnews");
        extractionMap.put("premium", "premium0");
        extractionMap.put("technology", "technology0");
        extractionMap.put("travel", "travel0");
        MapLookupExtractor mapLookupExtractor = new MapLookupExtractor(extractionMap, false);
        LookupExtractionFn lookupExtractionFn = new LookupExtractionFn((LookupExtractor)mapLookupExtractor, false, "missing", Boolean.valueOf(true), Boolean.valueOf(false));
        ExtractionDimFilter filter = new ExtractionDimFilter("quality", "mezzanineANDnews", (ExtractionFn)lookupExtractionFn, null);
        GroupByQuery query = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")})).setAggregatorSpecs(Arrays.asList(new FilteredAggregatorFactory((AggregatorFactory)QueryRunnerTestHelper.rowsCount, (DimFilter)filter), new FilteredAggregatorFactory((AggregatorFactory)new LongSumAggregatorFactory("idx", "index"), (DimFilter)filter))).setGranularity(QueryRunnerTestHelper.dayGran).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "automotive", "rows", 0L, "idx", 0L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "business", "rows", 0L, "idx", 0L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "entertainment", "rows", 0L, "idx", 0L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "health", "rows", 0L, "idx", 0L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "mezzanine", "rows", 3L, "idx", 2870L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "news", "rows", 1L, "idx", 121L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "premium", "rows", 0L, "idx", 0L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "technology", "rows", 0L, "idx", 0L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "travel", "rows", 0L, "idx", 0L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "automotive", "rows", 0L, "idx", 0L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "business", "rows", 0L, "idx", 0L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "entertainment", "rows", 0L, "idx", 0L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "health", "rows", 0L, "idx", 0L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "mezzanine", "rows", 3L, "idx", 2447L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "news", "rows", 1L, "idx", 114L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "premium", "rows", 0L, "idx", 0L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "technology", "rows", 0L, "idx", 0L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "travel", "rows", 0L, "idx", 0L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Test
    public void testGroupByWithExtractionDimFilterOptimazitionManyToOne() {
        HashMap<String, String> extractionMap = new HashMap<String, String>();
        extractionMap.put("mezzanine", "newsANDmezzanine");
        extractionMap.put("news", "newsANDmezzanine");
        MapLookupExtractor mapLookupExtractor = new MapLookupExtractor(extractionMap, false);
        LookupExtractionFn lookupExtractionFn = new LookupExtractionFn((LookupExtractor)mapLookupExtractor, false, null, Boolean.valueOf(true), Boolean.valueOf(true));
        GroupByQuery query = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).setGranularity(QueryRunnerTestHelper.dayGran).setDimFilter((DimFilter)new ExtractionDimFilter("quality", "newsANDmezzanine", (ExtractionFn)lookupExtractionFn, null)).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "mezzanine", "rows", 3L, "idx", 2870L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "news", "rows", 1L, "idx", 121L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "mezzanine", "rows", 3L, "idx", 2447L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "news", "rows", 1L, "idx", 114L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Test
    public void testGroupByWithExtractionDimFilterNullDims() {
        HashMap<String, String> extractionMap = new HashMap<String, String>();
        extractionMap.put("", "EMPTY");
        MapLookupExtractor mapLookupExtractor = new MapLookupExtractor(extractionMap, false);
        LookupExtractionFn lookupExtractionFn = new LookupExtractionFn((LookupExtractor)mapLookupExtractor, false, null, Boolean.valueOf(true), Boolean.valueOf(true));
        GroupByQuery query = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("null_column", "alias")})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).setGranularity(QueryRunnerTestHelper.dayGran).setDimFilter((DimFilter)new ExtractionDimFilter("null_column", "EMPTY", (ExtractionFn)lookupExtractionFn, null)).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", null, "rows", 13L, "idx", 6619L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", null, "rows", 13L, "idx", 5827L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Test
    public void testBySegmentResultsWithAllFiltersWithExtractionFns() {
        int segmentCount = 32;
        Result singleSegmentResult = new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new BySegmentResultValueClass(Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "mezzanine", "rows", 6L, "idx", 4420L)), "testSegment", Intervals.of((String)"2011-04-02T00:00:00.000Z/2011-04-04T00:00:00.000Z")));
        ArrayList bySegmentResults = Lists.newArrayList();
        for (int i = 0; i < segmentCount; ++i) {
            bySegmentResults.add(singleSegmentResult);
        }
        String extractionJsFn = "function(str) { return 'super-' + str; }";
        String jsFn = "function(x) { return(x === 'super-mezzanine') }";
        JavaScriptExtractionFn extractionFn = new JavaScriptExtractionFn(extractionJsFn, false, JavaScriptConfig.getEnabledInstance());
        ArrayList<Object> superFilterList = new ArrayList<Object>();
        superFilterList.add(new SelectorDimFilter("quality", "super-mezzanine", (ExtractionFn)extractionFn));
        superFilterList.add(new InDimFilter("quality", Arrays.asList("not-super-mezzanine", "FOOBAR", "super-mezzanine"), (ExtractionFn)extractionFn));
        superFilterList.add(new BoundDimFilter("quality", "super-mezzanine", "super-mezzanine", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true), (ExtractionFn)extractionFn, StringComparators.ALPHANUMERIC));
        superFilterList.add(new RegexDimFilter("quality", "super-mezzanine", (ExtractionFn)extractionFn));
        superFilterList.add(new SearchQueryDimFilter("quality", (SearchQuerySpec)new ContainsSearchQuerySpec("super-mezzanine", true), (ExtractionFn)extractionFn));
        superFilterList.add(new JavaScriptDimFilter("quality", jsFn, (ExtractionFn)extractionFn, JavaScriptConfig.getEnabledInstance()));
        AndDimFilter superFilter = new AndDimFilter(superFilterList);
        GroupByQuery.Builder builder = GroupByQuery.builder().setDataSource("testing").setInterval("2011-04-02/2011-04-04").setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).setGranularity((Granularity)new PeriodGranularity(new Period((Object)"P1M"), null, null)).setDimFilter((DimFilter)superFilter).setContext((Map)ImmutableMap.of((Object)"bySegment", (Object)true));
        GroupByQuery fullQuery = builder.build();
        QueryToolChest toolChest = this.factory.getToolchest();
        ArrayList singleSegmentRunners = Lists.newArrayList();
        for (int i = 0; i < segmentCount; ++i) {
            singleSegmentRunners.add(toolChest.preMergeQueryDecoration(this.runner));
        }
        ExecutorService exec = Executors.newCachedThreadPool();
        QueryRunner theRunner = toolChest.postMergeQueryDecoration((QueryRunner)new FinalizeResultsQueryRunner(toolChest.mergeResults(this.factory.mergeRunners(Executors.newCachedThreadPool(), (Iterable)singleSegmentRunners)), toolChest));
        TestHelper.assertExpectedObjects(bySegmentResults, theRunner.run(QueryPlus.wrap((Query)fullQuery), (Map)Maps.newHashMap()), "");
        exec.shutdownNow();
    }

    @Test
    public void testGroupByWithAllFiltersOnNullDimsWithExtractionFns() {
        HashMap<String, String> extractionMap = new HashMap<String, String>();
        extractionMap.put("", "EMPTY");
        extractionMap.put(null, "EMPTY");
        MapLookupExtractor mapLookupExtractor = new MapLookupExtractor(extractionMap, false);
        LookupExtractionFn extractionFn = new LookupExtractionFn((LookupExtractor)mapLookupExtractor, false, null, Boolean.valueOf(true), Boolean.valueOf(true));
        String jsFn = "function(x) { return(x === 'EMPTY') }";
        ArrayList<Object> superFilterList = new ArrayList<Object>();
        superFilterList.add(new SelectorDimFilter("null_column", "EMPTY", (ExtractionFn)extractionFn));
        superFilterList.add(new InDimFilter("null_column", Arrays.asList("NOT-EMPTY", "FOOBAR", "EMPTY"), (ExtractionFn)extractionFn));
        superFilterList.add(new BoundDimFilter("null_column", "EMPTY", "EMPTY", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true), (ExtractionFn)extractionFn, StringComparators.ALPHANUMERIC));
        superFilterList.add(new RegexDimFilter("null_column", "EMPTY", (ExtractionFn)extractionFn));
        superFilterList.add(new SearchQueryDimFilter("null_column", (SearchQuerySpec)new ContainsSearchQuerySpec("EMPTY", true), (ExtractionFn)extractionFn));
        superFilterList.add(new JavaScriptDimFilter("null_column", jsFn, (ExtractionFn)extractionFn, JavaScriptConfig.getEnabledInstance()));
        AndDimFilter superFilter = new AndDimFilter(superFilterList);
        GroupByQuery query = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("null_column", "alias")})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).setGranularity(QueryRunnerTestHelper.dayGran).setDimFilter((DimFilter)superFilter).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", null, "rows", 13L, "idx", 6619L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", null, "rows", 13L, "idx", 5827L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Test
    public void testGroupByCardinalityAggWithExtractionFn() {
        String helloJsFn = "function(str) { return 'hello' }";
        JavaScriptExtractionFn helloFn = new JavaScriptExtractionFn(helloJsFn, false, JavaScriptConfig.getEnabledInstance());
        GroupByQuery query = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("market", "alias")})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new CardinalityAggregatorFactory("numVals", (List)ImmutableList.of((Object)new ExtractionDimensionSpec("quality", "quality", (ExtractionFn)helloFn)), false))).setGranularity(QueryRunnerTestHelper.dayGran).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "spot", "rows", 9L, "numVals", 1.0002442201269182), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "total_market", "rows", 2L, "numVals", 1.0002442201269182), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "upfront", "rows", 2L, "numVals", 1.0002442201269182), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "spot", "rows", 9L, "numVals", 1.0002442201269182), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "total_market", "rows", 2L, "numVals", 1.0002442201269182), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "upfront", "rows", 2L, "numVals", 1.0002442201269182));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Test
    public void testGroupByCardinalityAggOnFloat() {
        GroupByQuery query = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("market", "alias")})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new CardinalityAggregatorFactory("numVals", (List)ImmutableList.of((Object)new DefaultDimensionSpec("index", "index")), false))).setGranularity(QueryRunnerTestHelper.dayGran).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "spot", "rows", 9L, "numVals", 8.015665809687173), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "total_market", "rows", 2L, "numVals", 2.000977198748901), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "upfront", "rows", 2L, "numVals", 2.000977198748901), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "spot", "rows", 9L, "numVals", 9.019833517963864), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "total_market", "rows", 2L, "numVals", 2.000977198748901), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "upfront", "rows", 2L, "numVals", 2.000977198748901));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Test
    public void testGroupByLongColumn() {
        if (this.config.getDefaultStrategy().equals("v1")) {
            this.expectedException.expect(UnsupportedOperationException.class);
            this.expectedException.expectMessage("GroupBy v1 only supports dimensions with an outputType of STRING.");
        }
        GroupByQuery query = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("qualityLong", "ql_alias", ValueType.LONG)})).setDimFilter((DimFilter)new SelectorDimFilter("quality", "entertainment", null)).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).addOrderByColumn(new OrderByColumnSpec("ql_alias", OrderByColumnSpec.Direction.ASCENDING, StringComparators.NUMERIC)).setGranularity(QueryRunnerTestHelper.dayGran).build();
        Assert.assertEquals((Object)Functions.identity(), (Object)query.getLimitSpec().build(query.getDimensions(), query.getAggregatorSpecs(), query.getPostAggregatorSpecs(), query.getGranularity(), query.getContextSortByDimsFirst()));
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "ql_alias", 1200L, "rows", 1L, "idx", 158L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "ql_alias", 1200L, "rows", 1L, "idx", 166L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Test
    public void testGroupByLongColumnDescending() {
        if (this.config.getDefaultStrategy().equals("v1")) {
            this.expectedException.expect(UnsupportedOperationException.class);
            this.expectedException.expectMessage("GroupBy v1 only supports dimensions with an outputType of STRING.");
        }
        GroupByQuery query = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("qualityLong", "ql_alias", ValueType.LONG)})).setDimFilter((DimFilter)new InDimFilter("quality", Arrays.asList("entertainment", "technology"), null)).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).addOrderByColumn(new OrderByColumnSpec("ql_alias", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)).setGranularity(QueryRunnerTestHelper.allGran).build();
        Assert.assertNotEquals((Object)Functions.identity(), (Object)query.getLimitSpec().build(query.getDimensions(), query.getAggregatorSpecs(), query.getPostAggregatorSpecs(), query.getGranularity(), query.getContextSortByDimsFirst()));
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "ql_alias", 1700L, "rows", 2L, "idx", 175L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "ql_alias", 1200L, "rows", 2L, "idx", 324L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Test
    public void testGroupByLongColumnWithExFn() {
        if (this.config.getDefaultStrategy().equals("v1")) {
            this.expectedException.expect(UnsupportedOperationException.class);
            this.expectedException.expectMessage("GroupBy v1 does not support dimension selectors with unknown cardinality.");
        }
        String jsFn = "function(str) { return 'super-' + str; }";
        JavaScriptExtractionFn jsExtractionFn = new JavaScriptExtractionFn(jsFn, false, JavaScriptConfig.getEnabledInstance());
        GroupByQuery query = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new ExtractionDimensionSpec("qualityLong", "ql_alias", (ExtractionFn)jsExtractionFn)})).setDimFilter((DimFilter)new SelectorDimFilter("quality", "entertainment", null)).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).setGranularity(QueryRunnerTestHelper.dayGran).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "ql_alias", "super-1200", "rows", 1L, "idx", 158L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "ql_alias", "super-1200", "rows", 1L, "idx", 166L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Test
    public void testGroupByLongTimeColumn() {
        if (this.config.getDefaultStrategy().equals("v1")) {
            this.expectedException.expect(UnsupportedOperationException.class);
            this.expectedException.expectMessage("GroupBy v1 only supports dimensions with an outputType of STRING.");
        }
        GroupByQuery query = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("__time", "time_alias", ValueType.LONG)})).setDimFilter((DimFilter)new SelectorDimFilter("quality", "entertainment", null)).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).setGranularity(QueryRunnerTestHelper.dayGran).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "time_alias", 1301616000000L, "rows", 1L, "idx", 158L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "time_alias", 1301702400000L, "rows", 1L, "idx", 166L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Test
    public void testGroupByLongTimeColumnWithExFn() {
        String jsFn = "function(str) { return 'super-' + str; }";
        JavaScriptExtractionFn jsExtractionFn = new JavaScriptExtractionFn(jsFn, false, JavaScriptConfig.getEnabledInstance());
        GroupByQuery query = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new ExtractionDimensionSpec("__time", "time_alias", (ExtractionFn)jsExtractionFn)})).setDimFilter((DimFilter)new SelectorDimFilter("quality", "entertainment", null)).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).setGranularity(QueryRunnerTestHelper.dayGran).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "time_alias", "super-1301616000000", "rows", 1L, "idx", 158L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "time_alias", "super-1301702400000", "rows", 1L, "idx", 166L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Test
    public void testGroupByFloatColumn() {
        if (this.config.getDefaultStrategy().equals("v1")) {
            this.expectedException.expect(UnsupportedOperationException.class);
            this.expectedException.expectMessage("GroupBy v1 only supports dimensions with an outputType of STRING.");
        }
        GroupByQuery query = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("index", "index_alias", ValueType.FLOAT)})).setDimFilter((DimFilter)new SelectorDimFilter("quality", "entertainment", null)).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).addOrderByColumn(new OrderByColumnSpec("index_alias", OrderByColumnSpec.Direction.ASCENDING, StringComparators.NUMERIC)).setGranularity(QueryRunnerTestHelper.dayGran).build();
        Assert.assertEquals((Object)Functions.identity(), (Object)query.getLimitSpec().build(query.getDimensions(), query.getAggregatorSpecs(), query.getPostAggregatorSpecs(), query.getGranularity(), query.getContextSortByDimsFirst()));
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "index_alias", Float.valueOf(158.74722f), "rows", 1L, "idx", 158L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "index_alias", Float.valueOf(166.01605f), "rows", 1L, "idx", 166L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Test
    public void testGroupByFloatColumnDescending() {
        if (this.config.getDefaultStrategy().equals("v1")) {
            this.expectedException.expect(UnsupportedOperationException.class);
            this.expectedException.expectMessage("GroupBy v1 only supports dimensions with an outputType of STRING.");
        }
        GroupByQuery query = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("qualityFloat", "qf_alias", ValueType.FLOAT)})).setDimFilter((DimFilter)new InDimFilter("quality", Arrays.asList("entertainment", "technology"), null)).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).addOrderByColumn(new OrderByColumnSpec("qf_alias", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)).setGranularity(QueryRunnerTestHelper.allGran).build();
        Assert.assertNotEquals((Object)Functions.identity(), (Object)query.getLimitSpec().build(query.getDimensions(), query.getAggregatorSpecs(), query.getPostAggregatorSpecs(), query.getGranularity(), query.getContextSortByDimsFirst()));
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "qf_alias", Float.valueOf(17000.0f), "rows", 2L, "idx", 175L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "qf_alias", Float.valueOf(12000.0f), "rows", 2L, "idx", 324L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Test
    public void testGroupByDoubleColumnDescending() {
        if (this.config.getDefaultStrategy().equals("v1")) {
            this.expectedException.expect(UnsupportedOperationException.class);
            this.expectedException.expectMessage("GroupBy v1 only supports dimensions with an outputType of STRING.");
        }
        GroupByQuery query = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("qualityDouble", "alias", ValueType.DOUBLE)})).setDimFilter((DimFilter)new InDimFilter("quality", Arrays.asList("entertainment", "technology"), null)).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).addOrderByColumn(new OrderByColumnSpec("alias", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)).setGranularity(QueryRunnerTestHelper.allGran).build();
        Assert.assertNotEquals((Object)Functions.identity(), (Object)query.getLimitSpec().build(query.getDimensions(), query.getAggregatorSpecs(), query.getPostAggregatorSpecs(), query.getGranularity(), query.getContextSortByDimsFirst()));
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", 17000.0, "rows", 2L, "idx", 175L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", 12000.0, "rows", 2L, "idx", 324L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Test
    public void testGroupByFloatColumnWithExFn() {
        if (this.config.getDefaultStrategy().equals("v1")) {
            this.expectedException.expect(UnsupportedOperationException.class);
            this.expectedException.expectMessage("GroupBy v1 does not support dimension selectors with unknown cardinality.");
        }
        String jsFn = "function(str) { return 'super-' + str; }";
        JavaScriptExtractionFn jsExtractionFn = new JavaScriptExtractionFn(jsFn, false, JavaScriptConfig.getEnabledInstance());
        GroupByQuery query = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new ExtractionDimensionSpec("index", "index_alias", (ExtractionFn)jsExtractionFn)})).setDimFilter((DimFilter)new SelectorDimFilter("quality", "entertainment", null)).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).setGranularity(QueryRunnerTestHelper.dayGran).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "index_alias", "super-158.747224", "rows", 1L, "idx", 158L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "index_alias", "super-166.016049", "rows", 1L, "idx", 166L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Test
    public void testGroupByWithHavingSpecOnLongAndFloat() {
        if (this.config.getDefaultStrategy().equals("v1")) {
            this.expectedException.expect(UnsupportedOperationException.class);
            this.expectedException.expectMessage("GroupBy v1 only supports dimensions with an outputType of STRING.");
        }
        GroupByQuery query = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("market", "alias"), new DefaultDimensionSpec("qualityLong", "ql_alias", ValueType.LONG), new DefaultDimensionSpec("__time", "time_alias", ValueType.LONG), new DefaultDimensionSpec("index", "index_alias", ValueType.FLOAT)})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount)).setHavingSpec((HavingSpec)new DimFilterHavingSpec((DimFilter)new AndDimFilter((List)Lists.newArrayList((Object[])new DimFilter[]{new SelectorDimFilter("ql_alias", "1400", null), new SelectorDimFilter("time_alias", "1301616000000", null), new BoundDimFilter("index_alias", "1310.0", "1320.0", Boolean.valueOf(true), Boolean.valueOf(true), null, null, StringComparators.NUMERIC)})), null)).setGranularity(QueryRunnerTestHelper.allGran).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "total_market", "time_alias", 1301616000000L, "index_alias", 1314.8397, "ql_alias", 1400L, "rows", 1L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Test
    public void testGroupByLongAndFloatOutputAsString() {
        if (this.config.getDefaultStrategy().equals("v1")) {
            this.expectedException.expect(UnsupportedOperationException.class);
            this.expectedException.expectMessage("GroupBy v1 does not support dimension selectors with unknown cardinality.");
        }
        GroupByQuery query = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("qualityLong", "ql_alias"), new DefaultDimensionSpec("qualityFloat", "qf_alias")})).setDimFilter((DimFilter)new SelectorDimFilter("quality", "entertainment", null)).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).setGranularity(QueryRunnerTestHelper.dayGran).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "ql_alias", "1200", "qf_alias", "12000.0", "rows", 1L, "idx", 158L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "ql_alias", "1200", "qf_alias", "12000.0", "rows", 1L, "idx", 166L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Test
    public void testGroupByNumericStringsAsNumeric() {
        if (this.config.getDefaultStrategy().equals("v1")) {
            this.expectedException.expect(UnsupportedOperationException.class);
            this.expectedException.expectMessage("GroupBy v1 does not support dimension selectors with unknown cardinality.");
        }
        GroupByQuery subquery = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("qualityLong", "ql_alias"), new DefaultDimensionSpec("qualityFloat", "qf_alias"), new DefaultDimensionSpec("__time", "time_alias")})).setDimFilter((DimFilter)new SelectorDimFilter("quality", "entertainment", null)).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).setGranularity(QueryRunnerTestHelper.dayGran).build();
        GroupByQuery outerQuery = GroupByQuery.builder().setDataSource((Query)subquery).setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("time_alias", "time_alias2", ValueType.LONG), new DefaultDimensionSpec("ql_alias", "ql_alias_long", ValueType.LONG), new DefaultDimensionSpec("qf_alias", "qf_alias_float", ValueType.FLOAT), new DefaultDimensionSpec("ql_alias", "ql_alias_float", ValueType.FLOAT)})).setAggregatorSpecs(Arrays.asList(new CountAggregatorFactory("count"))).setGranularity(QueryRunnerTestHelper.allGran).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "time_alias2", 1301616000000L, "ql_alias_long", 1200L, "qf_alias_float", 12000.0, "ql_alias_float", 1200.0, "count", 1L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "time_alias2", 1301702400000L, "ql_alias_long", 1200L, "qf_alias_float", 12000.0, "ql_alias_float", 1200.0, "count", 1L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, outerQuery);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Test
    public void testGroupByNumericStringsAsNumericWithDecoration() {
        if (this.config.getDefaultStrategy().equals("v1")) {
            this.expectedException.expect(UnsupportedOperationException.class);
            this.expectedException.expectMessage("GroupBy v1 only supports dimensions with an outputType of STRING.");
        }
        RegexFilteredDimensionSpec regexSpec = new RegexFilteredDimensionSpec((DimensionSpec)new DefaultDimensionSpec("qualityNumericString", "ql", ValueType.LONG), "170000");
        ListFilteredDimensionSpec listFilteredSpec = new ListFilteredDimensionSpec((DimensionSpec)new DefaultDimensionSpec("qualityNumericString", "qf", ValueType.FLOAT), (Set)Sets.newHashSet((Object[])new String[]{"170000"}), Boolean.valueOf(true));
        GroupByQuery query = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{regexSpec, listFilteredSpec})).setDimFilter((DimFilter)new InDimFilter("quality", Arrays.asList("entertainment", "technology"), null)).setAggregatorSpecs(Arrays.asList(new CountAggregatorFactory("count"))).setGranularity(QueryRunnerTestHelper.allGran).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "ql", 0L, "qf", 0.0, "count", 2L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "ql", 170000L, "qf", 170000.0, "count", 2L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Test
    public void testGroupByDecorationOnNumerics() {
        if (this.config.getDefaultStrategy().equals("v1")) {
            this.expectedException.expect(UnsupportedOperationException.class);
            this.expectedException.expectMessage("GroupBy v1 only supports dimensions with an outputType of STRING.");
        }
        RegexFilteredDimensionSpec regexSpec = new RegexFilteredDimensionSpec((DimensionSpec)new DefaultDimensionSpec("qualityLong", "ql", ValueType.LONG), "1700");
        ListFilteredDimensionSpec listFilteredSpec = new ListFilteredDimensionSpec((DimensionSpec)new DefaultDimensionSpec("qualityFloat", "qf", ValueType.FLOAT), (Set)Sets.newHashSet((Object[])new String[]{"17000.0"}), Boolean.valueOf(true));
        GroupByQuery query = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{regexSpec, listFilteredSpec})).setDimFilter((DimFilter)new InDimFilter("quality", Arrays.asList("entertainment", "technology"), null)).setAggregatorSpecs(Arrays.asList(new CountAggregatorFactory("count"))).setGranularity(QueryRunnerTestHelper.allGran).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "ql", 0L, "qf", 0.0, "count", 2L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "ql", 1700L, "qf", 17000.0, "count", 2L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Test
    public void testGroupByNestedWithInnerQueryNumerics() {
        if (this.config.getDefaultStrategy().equals("v1")) {
            this.expectedException.expect(UnsupportedOperationException.class);
            this.expectedException.expectMessage("GroupBy v1 only supports dimensions with an outputType of STRING.");
        }
        GroupByQuery subquery = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias"), new DefaultDimensionSpec("qualityLong", "ql_alias", ValueType.LONG), new DefaultDimensionSpec("qualityFloat", "qf_alias", ValueType.FLOAT)})).setDimFilter((DimFilter)new InDimFilter("quality", (Collection)Lists.newArrayList((Object[])new String[]{"entertainment"}), null)).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).setGranularity(QueryRunnerTestHelper.dayGran).build();
        GroupByQuery outerQuery = GroupByQuery.builder().setDataSource((Query)subquery).setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("ql_alias", "quallong", ValueType.LONG), new DefaultDimensionSpec("qf_alias", "qualfloat", ValueType.FLOAT)})).setDimFilter((DimFilter)new AndDimFilter((List)Lists.newArrayList((Object[])new DimFilter[]{new SelectorDimFilter("ql_alias", "1200", null), new BoundDimFilter("qf_alias", "11095.0", "12005.0", Boolean.valueOf(true), Boolean.valueOf(true), null, null, StringComparators.NUMERIC)}))).setAggregatorSpecs(Arrays.asList(new LongSumAggregatorFactory("ql_alias_sum", "ql_alias"), new DoubleSumAggregatorFactory("qf_alias_sum", "qf_alias"))).setGranularity(QueryRunnerTestHelper.allGran).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "quallong", 1200L, "qualfloat", 12000.0, "ql_alias_sum", 2400L, "qf_alias_sum", 24000.0));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, outerQuery);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Test
    public void testGroupByNestedWithInnerQueryNumericsWithLongTime() {
        if (this.config.getDefaultStrategy().equals("v1")) {
            this.expectedException.expect(UnsupportedOperationException.class);
            this.expectedException.expectMessage("GroupBy v1 only supports dimensions with an outputType of STRING.");
        }
        GroupByQuery subQuery = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("market", "alias"), new DefaultDimensionSpec("__time", "time_alias", ValueType.LONG), new DefaultDimensionSpec("index", "index_alias", ValueType.FLOAT)})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount)).setGranularity(QueryRunnerTestHelper.allGran).build();
        GroupByQuery outerQuery = GroupByQuery.builder().setDataSource((Query)subQuery).setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("alias", "market"), new DefaultDimensionSpec("time_alias", "time_alias2", ValueType.LONG)})).setAggregatorSpecs(Arrays.asList(new LongMaxAggregatorFactory("time_alias_max", "time_alias"), new DoubleMaxAggregatorFactory("index_alias_max", "index_alias"))).setGranularity(QueryRunnerTestHelper.allGran).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "market", "spot", "time_alias2", 1301616000000L, "time_alias_max", 1301616000000L, "index_alias_max", 158.74722290039062), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "market", "spot", "time_alias2", 1301702400000L, "time_alias_max", 1301702400000L, "index_alias_max", 166.01605224609375), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "market", "total_market", "time_alias2", 1301616000000L, "time_alias_max", 1301616000000L, "index_alias_max", 1522.043701171875), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "market", "total_market", "time_alias2", 1301702400000L, "time_alias_max", 1301702400000L, "index_alias_max", 1321.375), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "market", "upfront", "time_alias2", 1301616000000L, "time_alias_max", 1301616000000L, "index_alias_max", 1447.3411865234375), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "market", "upfront", "time_alias2", 1301702400000L, "time_alias_max", 1301702400000L, "index_alias_max", 1144.3424072265625));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, outerQuery);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Test
    public void testGroupByStringOutputAsLong() {
        if (this.config.getDefaultStrategy().equals("v1")) {
            this.expectedException.expect(UnsupportedOperationException.class);
            this.expectedException.expectMessage("GroupBy v1 only supports dimensions with an outputType of STRING.");
        }
        StrlenExtractionFn strlenFn = StrlenExtractionFn.instance();
        GroupByQuery query = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new ExtractionDimensionSpec("quality", "alias", ValueType.LONG, (ExtractionFn)strlenFn)})).setDimFilter((DimFilter)new SelectorDimFilter("quality", "entertainment", null)).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).setGranularity(QueryRunnerTestHelper.dayGran).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", 13L, "rows", 1L, "idx", 158L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", 13L, "rows", 1L, "idx", 166L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Test
    public void testGroupByWithAggsOnNumericDimensions() {
        GroupByQuery query = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")})).setDimFilter((DimFilter)new SelectorDimFilter("quality", "technology", null)).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("qlLong", "qualityLong"), new DoubleSumAggregatorFactory("qlFloat", "qualityLong"), new JavaScriptAggregatorFactory("qlJs", (List)ImmutableList.of((Object)"qualityLong"), "function(a,b) { return a + b; }", "function() { return 0; }", "function(a,b) { return a + b }", JavaScriptConfig.getEnabledInstance()), new DoubleSumAggregatorFactory("qfFloat", "qualityFloat"), new LongSumAggregatorFactory("qfLong", "qualityFloat"), new JavaScriptAggregatorFactory("qfJs", (List)ImmutableList.of((Object)"qualityFloat"), "function(a,b) { return a + b; }", "function() { return 0; }", "function(a,b) { return a + b }", JavaScriptConfig.getEnabledInstance()))).setGranularity(QueryRunnerTestHelper.dayGran).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "technology", "rows", 1L, "qlLong", 1700L, "qlFloat", 1700.0, "qlJs", 1700.0, "qfFloat", 17000.0, "qfLong", 17000L, "qfJs", 17000.0), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "technology", "rows", 1L, "qlLong", 1700L, "qlFloat", 1700.0, "qlJs", 1700.0, "qfFloat", 17000.0, "qfLong", 17000L, "qfJs", 17000.0));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Test
    public void testGroupByNestedOuterExtractionFnOnFloatInner() {
        if (this.config.getDefaultStrategy().equals("v1")) {
            this.expectedException.expect(UnsupportedOperationException.class);
            this.expectedException.expectMessage("GroupBy v1 only supports dimensions with an outputType of STRING.");
        }
        String jsFn = "function(obj) { return obj; }";
        JavaScriptExtractionFn jsExtractionFn = new JavaScriptExtractionFn(jsFn, false, JavaScriptConfig.getEnabledInstance());
        GroupByQuery subquery = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias"), new ExtractionDimensionSpec("qualityFloat", "qf_inner", ValueType.FLOAT, (ExtractionFn)jsExtractionFn)})).setDimFilter((DimFilter)new SelectorDimFilter("quality", "technology", null)).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount)).setGranularity(QueryRunnerTestHelper.dayGran).build();
        GroupByQuery outerQuery = GroupByQuery.builder().setDataSource((Query)subquery).setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("alias", "alias"), new ExtractionDimensionSpec("qf_inner", "qf_outer", ValueType.FLOAT, (ExtractionFn)jsExtractionFn)})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount)).setGranularity(QueryRunnerTestHelper.allGran).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "technology", "qf_outer", Float.valueOf(17000.0f), "rows", 2L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, outerQuery);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Test
    public void testGroupByNestedDoubleTimeExtractionFnWithLongOutputTypes() {
        if (this.config.getDefaultStrategy().equals("v1")) {
            this.expectedException.expect(UnsupportedOperationException.class);
            this.expectedException.expectMessage("GroupBy v1 only supports dimensions with an outputType of STRING.");
        }
        GroupByQuery subquery = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias"), new ExtractionDimensionSpec("__time", "time_day", ValueType.LONG, (ExtractionFn)new TimeFormatExtractionFn(null, null, null, Granularities.DAY, true))})).setDimFilter((DimFilter)new SelectorDimFilter("quality", "technology", null)).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount)).setGranularity(QueryRunnerTestHelper.dayGran).build();
        GroupByQuery outerQuery = GroupByQuery.builder().setDataSource((Query)subquery).setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("alias", "alias"), new ExtractionDimensionSpec("time_day", "time_week", ValueType.LONG, (ExtractionFn)new TimeFormatExtractionFn(null, null, null, Granularities.WEEK, true))})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount)).setGranularity(QueryRunnerTestHelper.allGran).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "technology", "time_week", 1301270400000L, "rows", 2L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, outerQuery);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Test
    public void testGroupByLimitPushDown() {
        if (!this.config.getDefaultStrategy().equals("v2")) {
            return;
        }
        GroupByQuery query = new GroupByQuery.Builder().setDataSource("testing").setGranularity(QueryRunnerTestHelper.allGran).setDimensions(Arrays.asList(new DefaultDimensionSpec("market", "marketalias"))).setInterval(QueryRunnerTestHelper.fullOnInterval).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)Lists.newArrayList((Object[])new OrderByColumnSpec[]{new OrderByColumnSpec("marketalias", OrderByColumnSpec.Direction.DESCENDING)}), Integer.valueOf(2))).setAggregatorSpecs((List)Lists.newArrayList((Object[])new AggregatorFactory[]{QueryRunnerTestHelper.rowsCount})).setContext((Map)ImmutableMap.of((Object)"forceLimitPushDown", (Object)true)).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("1970-01-01T00:00:00.000Z", "marketalias", "upfront", "rows", 186L), GroupByQueryRunnerTestHelper.createExpectedRow("1970-01-01T00:00:00.000Z", "marketalias", "total_market", "rows", 186L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "order-limit");
    }

    @Test
    public void testMergeResultsWithLimitPushDown() {
        if (!this.config.getDefaultStrategy().equals("v2")) {
            return;
        }
        GroupByQuery.Builder builder = GroupByQuery.builder().setDataSource("testing").setInterval("2011-04-02/2011-04-04").setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)Lists.newArrayList((Object[])new OrderByColumnSpec[]{new OrderByColumnSpec("alias", OrderByColumnSpec.Direction.DESCENDING)}), Integer.valueOf(5))).setContext((Map)ImmutableMap.of((Object)"forceLimitPushDown", (Object)true)).setGranularity(Granularities.ALL);
        GroupByQuery allGranQuery = builder.build();
        QueryRunner mergedRunner = this.factory.getToolchest().mergeResults((QueryRunner)new QueryRunner<Row>(){

            public Sequence<Row> run(QueryPlus<Row> queryPlus, Map<String, Object> responseContext) {
                QueryPlus queryPlus1 = queryPlus.withQuerySegmentSpec((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)Lists.newArrayList((Object[])new Interval[]{Intervals.of((String)"2011-04-02/2011-04-03")})));
                QueryPlus queryPlus2 = queryPlus.withQuerySegmentSpec((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)Lists.newArrayList((Object[])new Interval[]{Intervals.of((String)"2011-04-03/2011-04-04")})));
                return GroupByQueryRunnerTest.this.factory.getToolchest().mergeResults((queryPlus3, responseContext1) -> new MergeSequence(queryPlus3.getQuery().getResultOrdering(), Sequences.simple(Arrays.asList(GroupByQueryRunnerTest.this.runner.run(queryPlus1, responseContext1), GroupByQueryRunnerTest.this.runner.run(queryPlus2, responseContext1))))).run(queryPlus, responseContext);
            }
        });
        HashMap context = Maps.newHashMap();
        List<Row> allGranExpectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "travel", "rows", 2L, "idx", 243L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "technology", "rows", 2L, "idx", 177L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "premium", "rows", 6L, "idx", 4416L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "news", "rows", 2L, "idx", 221L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "mezzanine", "rows", 6L, "idx", 4420L));
        TestHelper.assertExpectedObjects(allGranExpectedResults, mergedRunner.run(QueryPlus.wrap((Query)allGranQuery), (Map)context), "merged");
    }

    @Test
    public void testMergeResultsWithLimitPushDownSortByAgg() {
        if (!this.config.getDefaultStrategy().equals("v2")) {
            return;
        }
        GroupByQuery.Builder builder = GroupByQuery.builder().setDataSource("testing").setInterval("2011-04-02/2011-04-04").setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)Lists.newArrayList((Object[])new OrderByColumnSpec[]{new OrderByColumnSpec("idx", OrderByColumnSpec.Direction.DESCENDING)}), Integer.valueOf(5))).setContext((Map)ImmutableMap.of((Object)"forceLimitPushDown", (Object)true)).setGranularity(Granularities.ALL);
        GroupByQuery allGranQuery = builder.build();
        QueryRunner mergedRunner = this.factory.getToolchest().mergeResults((QueryRunner)new QueryRunner<Row>(){

            public Sequence<Row> run(QueryPlus<Row> queryPlus, Map<String, Object> responseContext) {
                QueryPlus queryPlus1 = queryPlus.withQuerySegmentSpec((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)Lists.newArrayList((Object[])new Interval[]{Intervals.of((String)"2011-04-02/2011-04-03")})));
                QueryPlus queryPlus2 = queryPlus.withQuerySegmentSpec((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)Lists.newArrayList((Object[])new Interval[]{Intervals.of((String)"2011-04-03/2011-04-04")})));
                return GroupByQueryRunnerTest.this.factory.getToolchest().mergeResults((queryPlus3, responseContext1) -> new MergeSequence(queryPlus3.getQuery().getResultOrdering(), Sequences.simple(Arrays.asList(GroupByQueryRunnerTest.this.runner.run(queryPlus1, responseContext1), GroupByQueryRunnerTest.this.runner.run(queryPlus2, responseContext1))))).run(queryPlus, responseContext);
            }
        });
        HashMap context = Maps.newHashMap();
        List<Row> allGranExpectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "mezzanine", "rows", 6L, "idx", 4420L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "premium", "rows", 6L, "idx", 4416L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "entertainment", "rows", 2L, "idx", 319L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "automotive", "rows", 2L, "idx", 269L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "travel", "rows", 2L, "idx", 243L));
        List results = Sequences.toList((Sequence)mergedRunner.run(QueryPlus.wrap((Query)allGranQuery), (Map)context), new ArrayList());
        TestHelper.assertExpectedObjects(allGranExpectedResults, results, "merged");
    }

    @Test
    public void testMergeResultsWithLimitPushDownSortByDimDim() {
        if (!this.config.getDefaultStrategy().equals("v2")) {
            return;
        }
        GroupByQuery.Builder builder = GroupByQuery.builder().setDataSource("testing").setInterval("2011-04-02/2011-04-04").setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias"), new DefaultDimensionSpec("market", "market")})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)Lists.newArrayList((Object[])new OrderByColumnSpec[]{new OrderByColumnSpec("alias", OrderByColumnSpec.Direction.DESCENDING), new OrderByColumnSpec("market", OrderByColumnSpec.Direction.DESCENDING)}), Integer.valueOf(5))).setContext((Map)ImmutableMap.of((Object)"forceLimitPushDown", (Object)true)).setGranularity(Granularities.ALL);
        GroupByQuery allGranQuery = builder.build();
        QueryRunner mergedRunner = this.factory.getToolchest().mergeResults((QueryRunner)new QueryRunner<Row>(){

            public Sequence<Row> run(QueryPlus<Row> queryPlus, Map<String, Object> responseContext) {
                QueryPlus queryPlus1 = queryPlus.withQuerySegmentSpec((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)Lists.newArrayList((Object[])new Interval[]{Intervals.of((String)"2011-04-02/2011-04-03")})));
                QueryPlus queryPlus2 = queryPlus.withQuerySegmentSpec((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)Lists.newArrayList((Object[])new Interval[]{Intervals.of((String)"2011-04-03/2011-04-04")})));
                return GroupByQueryRunnerTest.this.factory.getToolchest().mergeResults((queryPlus3, responseContext1) -> new MergeSequence(queryPlus3.getQuery().getResultOrdering(), Sequences.simple(Arrays.asList(GroupByQueryRunnerTest.this.runner.run(queryPlus1, responseContext1), GroupByQueryRunnerTest.this.runner.run(queryPlus2, responseContext1))))).run(queryPlus, responseContext);
            }
        });
        HashMap context = Maps.newHashMap();
        List<Row> allGranExpectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "travel", "market", "spot", "rows", 2L, "idx", 243L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "technology", "market", "spot", "rows", 2L, "idx", 177L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "premium", "market", "upfront", "rows", 2L, "idx", 1817L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "premium", "market", "total_market", "rows", 2L, "idx", 2342L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "premium", "market", "spot", "rows", 2L, "idx", 257L));
        List results = Sequences.toList((Sequence)mergedRunner.run(QueryPlus.wrap((Query)allGranQuery), (Map)context), (List)Lists.newArrayList());
        TestHelper.assertExpectedObjects(allGranExpectedResults, results, "merged");
    }

    @Test
    public void testMergeResultsWithLimitPushDownSortByDimAggDim() {
        if (!this.config.getDefaultStrategy().equals("v2")) {
            return;
        }
        GroupByQuery.Builder builder = GroupByQuery.builder().setDataSource("testing").setInterval("2011-04-02/2011-04-04").setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias"), new DefaultDimensionSpec("market", "market")})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)Lists.newArrayList((Object[])new OrderByColumnSpec[]{new OrderByColumnSpec("alias", OrderByColumnSpec.Direction.DESCENDING), new OrderByColumnSpec("idx", OrderByColumnSpec.Direction.DESCENDING), new OrderByColumnSpec("market", OrderByColumnSpec.Direction.DESCENDING)}), Integer.valueOf(5))).setContext((Map)ImmutableMap.of((Object)"forceLimitPushDown", (Object)true)).setGranularity(Granularities.ALL);
        GroupByQuery allGranQuery = builder.build();
        QueryRunner mergedRunner = this.factory.getToolchest().mergeResults((QueryRunner)new QueryRunner<Row>(){

            public Sequence<Row> run(QueryPlus<Row> queryPlus, Map<String, Object> responseContext) {
                QueryPlus queryPlus1 = queryPlus.withQuerySegmentSpec((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)Lists.newArrayList((Object[])new Interval[]{Intervals.of((String)"2011-04-02/2011-04-03")})));
                QueryPlus queryPlus2 = queryPlus.withQuerySegmentSpec((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)Lists.newArrayList((Object[])new Interval[]{Intervals.of((String)"2011-04-03/2011-04-04")})));
                return GroupByQueryRunnerTest.this.factory.getToolchest().mergeResults((queryPlus3, responseContext1) -> new MergeSequence(queryPlus3.getQuery().getResultOrdering(), Sequences.simple(Arrays.asList(GroupByQueryRunnerTest.this.runner.run(queryPlus1, responseContext1), GroupByQueryRunnerTest.this.runner.run(queryPlus2, responseContext1))))).run(queryPlus, responseContext);
            }
        });
        HashMap context = Maps.newHashMap();
        List<Row> allGranExpectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "travel", "market", "spot", "rows", 2L, "idx", 243L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "technology", "market", "spot", "rows", 2L, "idx", 177L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "premium", "market", "total_market", "rows", 2L, "idx", 2342L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "premium", "market", "upfront", "rows", 2L, "idx", 1817L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "premium", "market", "spot", "rows", 2L, "idx", 257L));
        List results = Sequences.toList((Sequence)mergedRunner.run(QueryPlus.wrap((Query)allGranQuery), (Map)context), (List)Lists.newArrayList());
        TestHelper.assertExpectedObjects(allGranExpectedResults, results, "merged");
    }

    @Test
    public void testGroupByLimitPushDownPostAggNotSupported() {
        this.expectedException.expect(UnsupportedOperationException.class);
        this.expectedException.expectMessage("Limit push down when sorting by a post aggregator is not supported.");
        GroupByQuery query = new GroupByQuery.Builder().setDataSource("testing").setGranularity(QueryRunnerTestHelper.allGran).setDimensions(Arrays.asList(new DefaultDimensionSpec("market", "marketalias"))).setInterval(QueryRunnerTestHelper.fullOnInterval).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)Lists.newArrayList((Object[])new OrderByColumnSpec[]{new OrderByColumnSpec("constant", OrderByColumnSpec.Direction.DESCENDING)}), Integer.valueOf(2))).setAggregatorSpecs((List)Lists.newArrayList((Object[])new AggregatorFactory[]{QueryRunnerTestHelper.rowsCount})).setPostAggregatorSpecs((List)Lists.newArrayList((Object[])new PostAggregator[]{new ConstantPostAggregator("constant", (Number)1)})).setContext((Map)ImmutableMap.of((Object)"forceLimitPushDown", (Object)true)).build();
        GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
    }

    @Test
    public void testEmptySubqueryWithLimitPushDown() {
        GroupByQuery subquery = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.emptyInterval).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)Lists.newArrayList((Object[])new OrderByColumnSpec[]{new OrderByColumnSpec("alias", OrderByColumnSpec.Direction.DESCENDING)}), Integer.valueOf(5))).setGranularity(QueryRunnerTestHelper.dayGran).build();
        GroupByQuery query = GroupByQuery.builder().setDataSource((Query)subquery).setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setAggregatorSpecs(Arrays.asList(new DoubleMaxAggregatorFactory("idx", "idx"))).setLimitSpec((LimitSpec)new DefaultLimitSpec(null, Integer.valueOf(5))).setGranularity(QueryRunnerTestHelper.dayGran).build();
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        Assert.assertFalse((boolean)results.iterator().hasNext());
    }

    @Test
    public void testSubqueryWithMultipleIntervalsInOuterQueryWithLimitPushDown() {
        GroupByQuery subquery = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")})).setDimFilter((DimFilter)new JavaScriptDimFilter("quality", "function(dim){ return true; }", null, JavaScriptConfig.getEnabledInstance())).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)Lists.newArrayList((Object[])new OrderByColumnSpec[]{new OrderByColumnSpec("alias", OrderByColumnSpec.Direction.DESCENDING)}), Integer.valueOf(12))).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"), new LongSumAggregatorFactory("indexMaxPlusTen", "indexMaxPlusTen"))).setGranularity(QueryRunnerTestHelper.dayGran).build();
        GroupByQuery query = GroupByQuery.builder().setDataSource((Query)subquery).setQuerySegmentSpec((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.of((String)"2011-04-01T00:00:00.000Z/2011-04-01T23:58:00.000Z"), (Object)Intervals.of((String)"2011-04-02T00:00:00.000Z/2011-04-03T00:00:00.000Z")))).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("alias", "alias")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)Lists.newArrayList((Object[])new OrderByColumnSpec[]{new OrderByColumnSpec("alias", OrderByColumnSpec.Direction.DESCENDING)}), Integer.valueOf(15))).setAggregatorSpecs(Arrays.asList(new LongSumAggregatorFactory("rows", "rows"), new LongSumAggregatorFactory("idx", "idx"))).setGranularity(QueryRunnerTestHelper.dayGran).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "travel", "rows", 1L, "idx", 119L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "technology", "rows", 1L, "idx", 78L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "premium", "rows", 3L, "idx", 2900L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "news", "rows", 1L, "idx", 121L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "mezzanine", "rows", 3L, "idx", 2870L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "health", "rows", 1L, "idx", 120L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "entertainment", "rows", 1L, "idx", 158L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "business", "rows", 1L, "idx", 118L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "automotive", "rows", 1L, "idx", 135L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "travel", "rows", 1L, "idx", 126L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "technology", "rows", 1L, "idx", 97L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "premium", "rows", 3L, "idx", 2505L));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, this.runner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }

    @Test
    public void testRejectForceLimitPushDownWithHaving() {
        this.expectedException.expect(IAE.class);
        this.expectedException.expectMessage("Cannot force limit push down when a having spec is present.");
        GroupByQuery.builder().setDataSource("testing").setGranularity(QueryRunnerTestHelper.allGran).setDimensions(Arrays.asList(new DefaultDimensionSpec("market", "marketalias"))).setInterval(QueryRunnerTestHelper.fullOnInterval).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)Lists.newArrayList((Object[])new OrderByColumnSpec[]{new OrderByColumnSpec("marketalias", OrderByColumnSpec.Direction.DESCENDING)}), Integer.valueOf(2))).setAggregatorSpecs((List)Lists.newArrayList((Object[])new AggregatorFactory[]{QueryRunnerTestHelper.rowsCount})).setContext((Map)ImmutableMap.of((Object)"forceLimitPushDown", (Object)true)).setHavingSpec((HavingSpec)new GreaterThanHavingSpec("rows", (Number)10)).build();
    }

    @Test
    public void testTypeConversionWithMergingChainedExecutionRunner() {
        if (this.config.getDefaultStrategy().equals("v1")) {
            this.expectedException.expect(UnsupportedOperationException.class);
            this.expectedException.expectMessage("GroupBy v1 only supports dimensions with an outputType of STRING.");
        }
        GroupByQuery query = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias"), new ExtractionDimensionSpec("quality", "qualityLen", ValueType.LONG, (ExtractionFn)StrlenExtractionFn.instance())})).setDimFilter((DimFilter)new SelectorDimFilter("quality", "technology", null)).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).setGranularity(QueryRunnerTestHelper.dayGran).build();
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-01", "alias", "technology", "qualityLen", 10L, "rows", 2L, "idx", 156L), GroupByQueryRunnerTestHelper.createExpectedRow("2011-04-02", "alias", "technology", "qualityLen", 10L, "rows", 2L, "idx", 194L));
        ChainedExecutionQueryRunner ceqr = new ChainedExecutionQueryRunner((ExecutorService)MoreExecutors.sameThreadExecutor(), (query1, future) -> {}, (Iterable)ImmutableList.of(this.runner, this.runner));
        QueryRunner mergingRunner = this.factory.mergeRunners((ExecutorService)MoreExecutors.sameThreadExecutor(), (Iterable)ImmutableList.of((Object)ceqr));
        Iterable results = GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, mergingRunner, query);
        TestHelper.assertExpectedObjects(expectedResults, results, "");
    }
}

