/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.groupby;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.druid.data.input.MapBasedRow;
import io.druid.data.input.Row;
import io.druid.java.util.common.DateTimes;
import io.druid.java.util.common.guava.Sequence;
import io.druid.java.util.common.guava.Sequences;
import io.druid.query.FinalizeResultsQueryRunner;
import io.druid.query.Query;
import io.druid.query.QueryPlus;
import io.druid.query.QueryRunner;
import io.druid.query.QueryRunnerFactory;
import io.druid.query.QueryToolChest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.chrono.ISOChronology;

public class GroupByQueryRunnerTestHelper {
    public static <T> Iterable<T> runQuery(QueryRunnerFactory factory, QueryRunner runner, Query<T> query) {
        QueryToolChest toolChest = factory.getToolchest();
        FinalizeResultsQueryRunner theRunner = new FinalizeResultsQueryRunner(toolChest.mergeResults(toolChest.preMergeQueryDecoration(runner)), toolChest);
        Sequence queryResult = theRunner.run(QueryPlus.wrap(query), (Map)Maps.newHashMap());
        return Sequences.toList((Sequence)queryResult, (List)Lists.newArrayList());
    }

    public static Row createExpectedRow(String timestamp, Object ... vals) {
        return GroupByQueryRunnerTestHelper.createExpectedRow(DateTimes.of((String)timestamp), vals);
    }

    public static Row createExpectedRow(DateTime timestamp, Object ... vals) {
        Preconditions.checkArgument((vals.length % 2 == 0 ? 1 : 0) != 0);
        HashMap theVals = Maps.newHashMap();
        for (int i = 0; i < vals.length; i += 2) {
            theVals.put(vals[i].toString(), vals[i + 1]);
        }
        return new MapBasedRow(timestamp, (Map)theVals);
    }

    public static List<Row> createExpectedRows(String[] columnNames, Object[] ... values) {
        int timeIndex = Arrays.asList(columnNames).indexOf("__time");
        Preconditions.checkArgument((timeIndex >= 0 ? 1 : 0) != 0);
        ArrayList expected = Lists.newArrayList();
        for (Object[] value : values) {
            Preconditions.checkArgument((value.length == columnNames.length ? 1 : 0) != 0);
            HashMap theVals = Maps.newHashMapWithExpectedSize((int)value.length);
            for (int i = 0; i < columnNames.length; ++i) {
                if (i == timeIndex) continue;
                theVals.put(columnNames[i], value[i]);
            }
            expected.add(new MapBasedRow(new DateTime(value[timeIndex], (Chronology)ISOChronology.getInstanceUTC()), (Map)theVals));
        }
        return expected;
    }
}

