/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.groupby.having;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.druid.data.input.MapBasedInputRow;
import io.druid.data.input.Row;
import io.druid.jackson.DefaultObjectMapper;
import io.druid.query.groupby.having.AndHavingSpec;
import io.druid.query.groupby.having.BaseHavingSpec;
import io.druid.query.groupby.having.EqualToHavingSpec;
import io.druid.query.groupby.having.GreaterThanHavingSpec;
import io.druid.query.groupby.having.HavingSpec;
import io.druid.query.groupby.having.LessThanHavingSpec;
import io.druid.query.groupby.having.NotHavingSpec;
import io.druid.query.groupby.having.OrHavingSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;

public class HavingSpecTest {
    private static final Row ROW = new MapBasedInputRow(0L, new ArrayList(), (Map)ImmutableMap.of((Object)"metric", (Object)Float.valueOf(10.0f)));

    @Test
    public void testHavingClauseSerde() throws Exception {
        List<HavingSpec> havings = Arrays.asList(new GreaterThanHavingSpec("agg", (Number)1.3), new OrHavingSpec(Arrays.asList(new LessThanHavingSpec("lessAgg", (Number)1L), new NotHavingSpec((HavingSpec)new EqualToHavingSpec("equalAgg", (Number)2.0)))));
        AndHavingSpec andHavingSpec = new AndHavingSpec(havings);
        ImmutableMap notMap = ImmutableMap.of((Object)"type", (Object)"not", (Object)"havingSpec", (Object)ImmutableMap.of((Object)"type", (Object)"equalTo", (Object)"aggregation", (Object)"equalAgg", (Object)"value", (Object)2.0));
        ImmutableMap lessMap = ImmutableMap.of((Object)"type", (Object)"lessThan", (Object)"aggregation", (Object)"lessAgg", (Object)"value", (Object)1);
        ImmutableMap greaterMap = ImmutableMap.of((Object)"type", (Object)"greaterThan", (Object)"aggregation", (Object)"agg", (Object)"value", (Object)1.3);
        ImmutableMap orMap = ImmutableMap.of((Object)"type", (Object)"or", (Object)"havingSpecs", (Object)ImmutableList.of((Object)lessMap, (Object)notMap));
        ImmutableMap payloadMap = ImmutableMap.of((Object)"type", (Object)"and", (Object)"havingSpecs", (Object)ImmutableList.of((Object)greaterMap, (Object)orMap));
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        Assert.assertEquals((Object)andHavingSpec, (Object)mapper.convertValue((Object)payloadMap, AndHavingSpec.class));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testTypeTypo() {
        ImmutableMap greaterMap = ImmutableMap.of((Object)"type", (Object)"nonExistingType", (Object)"aggregation", (Object)"agg", (Object)"value", (Object)1.3);
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        HavingSpec spec = (HavingSpec)mapper.convertValue((Object)greaterMap, HavingSpec.class);
    }

    @Test
    public void testGreaterThanHavingSpec() {
        GreaterThanHavingSpec spec = new GreaterThanHavingSpec("metric", (Number)0x7FFFFFFFFFFFFFF5L);
        Assert.assertFalse((boolean)spec.eval(this.getTestRow(0x7FFFFFFFFFFFFFF5L)));
        Assert.assertFalse((boolean)spec.eval(this.getTestRow(0x7FFFFFFFFFFFFFF0L)));
        Assert.assertTrue((boolean)spec.eval(this.getTestRow(0x7FFFFFFFFFFFFFFAL)));
        Assert.assertTrue((boolean)spec.eval(this.getTestRow(String.valueOf(0x7FFFFFFFFFFFFFFAL))));
        Assert.assertFalse((boolean)spec.eval(this.getTestRow(Float.valueOf(100.05f))));
        spec = new GreaterThanHavingSpec("metric", (Number)Float.valueOf(100.56f));
        Assert.assertFalse((boolean)spec.eval(this.getTestRow(Float.valueOf(100.56f))));
        Assert.assertFalse((boolean)spec.eval(this.getTestRow(Float.valueOf(90.53f))));
        Assert.assertFalse((boolean)spec.eval(this.getTestRow("90.53f")));
        Assert.assertTrue((boolean)spec.eval(this.getTestRow(Float.valueOf(101.34f))));
        Assert.assertTrue((boolean)spec.eval(this.getTestRow(Long.MAX_VALUE)));
    }

    @Test
    public void testLessThanHavingSpec() {
        LessThanHavingSpec spec = new LessThanHavingSpec("metric", (Number)0x7FFFFFFFFFFFFFF5L);
        Assert.assertFalse((boolean)spec.eval(this.getTestRow(0x7FFFFFFFFFFFFFF5L)));
        Assert.assertTrue((boolean)spec.eval(this.getTestRow(0x7FFFFFFFFFFFFFF0L)));
        Assert.assertTrue((boolean)spec.eval(this.getTestRow(String.valueOf(0x7FFFFFFFFFFFFFF0L))));
        Assert.assertFalse((boolean)spec.eval(this.getTestRow(0x7FFFFFFFFFFFFFFAL)));
        Assert.assertTrue((boolean)spec.eval(this.getTestRow(Float.valueOf(100.05f))));
        spec = new LessThanHavingSpec("metric", (Number)Float.valueOf(100.56f));
        Assert.assertFalse((boolean)spec.eval(this.getTestRow(Float.valueOf(100.56f))));
        Assert.assertTrue((boolean)spec.eval(this.getTestRow(Float.valueOf(90.53f))));
        Assert.assertFalse((boolean)spec.eval(this.getTestRow(Float.valueOf(101.34f))));
        Assert.assertFalse((boolean)spec.eval(this.getTestRow("101.34f")));
        Assert.assertFalse((boolean)spec.eval(this.getTestRow(Long.MAX_VALUE)));
    }

    private Row getTestRow(Object metricValue) {
        return new MapBasedInputRow(0L, new ArrayList(), (Map)ImmutableMap.of((Object)"metric", (Object)metricValue));
    }

    @Test
    public void testEqualHavingSpec() {
        EqualToHavingSpec spec = new EqualToHavingSpec("metric", (Number)0x7FFFFFFFFFFFFFF5L);
        Assert.assertTrue((boolean)spec.eval(this.getTestRow(0x7FFFFFFFFFFFFFF5L)));
        Assert.assertFalse((boolean)spec.eval(this.getTestRow(0x7FFFFFFFFFFFFFFAL)));
        Assert.assertFalse((boolean)spec.eval(this.getTestRow(Float.valueOf(100.05f))));
        spec = new EqualToHavingSpec("metric", (Number)Float.valueOf(100.56f));
        Assert.assertFalse((boolean)spec.eval(this.getTestRow(100L)));
        Assert.assertFalse((boolean)spec.eval(this.getTestRow(100.0)));
        Assert.assertFalse((boolean)spec.eval(this.getTestRow(100.0)));
        Assert.assertFalse((boolean)spec.eval(this.getTestRow(100.56)));
        Assert.assertFalse((boolean)spec.eval(this.getTestRow(90.53)));
        Assert.assertTrue((boolean)spec.eval(this.getTestRow(Float.valueOf(100.56f))));
        Assert.assertFalse((boolean)spec.eval(this.getTestRow(Float.valueOf(90.53f))));
        Assert.assertFalse((boolean)spec.eval(this.getTestRow(Long.MAX_VALUE)));
        spec = new EqualToHavingSpec("metric", (Number)100.56);
        Assert.assertFalse((boolean)spec.eval(this.getTestRow(100L)));
        Assert.assertFalse((boolean)spec.eval(this.getTestRow(100.0)));
        Assert.assertFalse((boolean)spec.eval(this.getTestRow(100.0)));
        Assert.assertTrue((boolean)spec.eval(this.getTestRow(100.56)));
        Assert.assertFalse((boolean)spec.eval(this.getTestRow(90.53)));
        Assert.assertFalse((boolean)spec.eval(this.getTestRow(Float.valueOf(100.56f))));
        Assert.assertFalse((boolean)spec.eval(this.getTestRow(Float.valueOf(90.53f))));
        Assert.assertFalse((boolean)spec.eval(this.getTestRow(Long.MAX_VALUE)));
        spec = new EqualToHavingSpec("metric", (Number)Float.valueOf(100.0f));
        Assert.assertTrue((boolean)spec.eval(this.getTestRow(100L)));
        Assert.assertTrue((boolean)spec.eval(this.getTestRow(100.0)));
        Assert.assertTrue((boolean)spec.eval(this.getTestRow(100.0)));
        Assert.assertFalse((boolean)spec.eval(this.getTestRow(100.56)));
        Assert.assertFalse((boolean)spec.eval(this.getTestRow(90.53)));
        Assert.assertFalse((boolean)spec.eval(this.getTestRow(Float.valueOf(100.56f))));
        Assert.assertFalse((boolean)spec.eval(this.getTestRow(Float.valueOf(90.53f))));
        Assert.assertFalse((boolean)spec.eval(this.getTestRow(Long.MAX_VALUE)));
        spec = new EqualToHavingSpec("metric", (Number)100.0);
        Assert.assertTrue((boolean)spec.eval(this.getTestRow(100L)));
        Assert.assertTrue((boolean)spec.eval(this.getTestRow(100.0)));
        Assert.assertTrue((boolean)spec.eval(this.getTestRow(100.0)));
        Assert.assertFalse((boolean)spec.eval(this.getTestRow(100.56)));
        Assert.assertFalse((boolean)spec.eval(this.getTestRow(90.53)));
        Assert.assertFalse((boolean)spec.eval(this.getTestRow(Float.valueOf(100.56f))));
        Assert.assertFalse((boolean)spec.eval(this.getTestRow(Float.valueOf(90.53f))));
        Assert.assertFalse((boolean)spec.eval(this.getTestRow(Long.MAX_VALUE)));
        spec = new EqualToHavingSpec("metric", (Number)100);
        Assert.assertTrue((boolean)spec.eval(this.getTestRow(100L)));
        Assert.assertTrue((boolean)spec.eval(this.getTestRow(100.0)));
        Assert.assertTrue((boolean)spec.eval(this.getTestRow(100.0)));
        Assert.assertFalse((boolean)spec.eval(this.getTestRow(100.56)));
        Assert.assertFalse((boolean)spec.eval(this.getTestRow(90.53)));
        Assert.assertFalse((boolean)spec.eval(this.getTestRow(Float.valueOf(100.56f))));
        Assert.assertFalse((boolean)spec.eval(this.getTestRow(Float.valueOf(90.53f))));
        Assert.assertFalse((boolean)spec.eval(this.getTestRow(Long.MAX_VALUE)));
        spec = new EqualToHavingSpec("metric", (Number)100L);
        Assert.assertTrue((boolean)spec.eval(this.getTestRow(100L)));
        Assert.assertTrue((boolean)spec.eval(this.getTestRow(100.0)));
        Assert.assertTrue((boolean)spec.eval(this.getTestRow(100.0)));
        Assert.assertFalse((boolean)spec.eval(this.getTestRow(100.56)));
        Assert.assertFalse((boolean)spec.eval(this.getTestRow(90.53)));
        Assert.assertFalse((boolean)spec.eval(this.getTestRow(Float.valueOf(100.56f))));
        Assert.assertFalse((boolean)spec.eval(this.getTestRow(Float.valueOf(90.53f))));
        Assert.assertFalse((boolean)spec.eval(this.getTestRow(Long.MAX_VALUE)));
    }

    @Test
    public void testAndHavingSpecShouldSupportShortcutEvaluation() {
        AtomicInteger counter = new AtomicInteger(0);
        AndHavingSpec spec = new AndHavingSpec((List)ImmutableList.of((Object)((Object)new CountingHavingSpec(counter, true)), (Object)((Object)new CountingHavingSpec(counter, false)), (Object)((Object)new CountingHavingSpec(counter, true)), (Object)((Object)new CountingHavingSpec(counter, false))));
        spec.eval(ROW);
        Assert.assertEquals((long)2L, (long)counter.get());
    }

    @Test
    public void testAndHavingSpec() {
        AtomicInteger counter = new AtomicInteger(0);
        AndHavingSpec spec = new AndHavingSpec((List)ImmutableList.of((Object)((Object)new CountingHavingSpec(counter, true)), (Object)((Object)new CountingHavingSpec(counter, true)), (Object)((Object)new CountingHavingSpec(counter, true)), (Object)((Object)new CountingHavingSpec(counter, true))));
        spec.eval(ROW);
        Assert.assertEquals((long)4L, (long)counter.get());
        counter.set(0);
        spec = new AndHavingSpec((List)ImmutableList.of((Object)((Object)new CountingHavingSpec(counter, false)), (Object)((Object)new CountingHavingSpec(counter, true)), (Object)((Object)new CountingHavingSpec(counter, true)), (Object)((Object)new CountingHavingSpec(counter, true))));
        spec.eval(ROW);
        Assert.assertEquals((long)1L, (long)counter.get());
    }

    @Test
    public void testOrHavingSpecSupportsShortcutEvaluation() {
        AtomicInteger counter = new AtomicInteger(0);
        OrHavingSpec spec = new OrHavingSpec((List)ImmutableList.of((Object)((Object)new CountingHavingSpec(counter, true)), (Object)((Object)new CountingHavingSpec(counter, true)), (Object)((Object)new CountingHavingSpec(counter, true)), (Object)((Object)new CountingHavingSpec(counter, false))));
        spec.eval(ROW);
        Assert.assertEquals((long)1L, (long)counter.get());
    }

    @Test
    public void testOrHavingSpec() {
        AtomicInteger counter = new AtomicInteger(0);
        OrHavingSpec spec = new OrHavingSpec((List)ImmutableList.of((Object)((Object)new CountingHavingSpec(counter, false)), (Object)((Object)new CountingHavingSpec(counter, false)), (Object)((Object)new CountingHavingSpec(counter, false)), (Object)((Object)new CountingHavingSpec(counter, false))));
        spec.eval(ROW);
        Assert.assertEquals((long)4L, (long)counter.get());
        counter.set(0);
        spec = new OrHavingSpec((List)ImmutableList.of((Object)((Object)new CountingHavingSpec(counter, false)), (Object)((Object)new CountingHavingSpec(counter, false)), (Object)((Object)new CountingHavingSpec(counter, false)), (Object)((Object)new CountingHavingSpec(counter, true))));
        spec.eval(ROW);
        Assert.assertEquals((long)4L, (long)counter.get());
    }

    @Test
    public void testNotHavingSepc() {
        NotHavingSpec spec = new NotHavingSpec(HavingSpec.NEVER);
        Assert.assertTrue((boolean)spec.eval(ROW));
        spec = new NotHavingSpec(HavingSpec.ALWAYS);
        Assert.assertFalse((boolean)spec.eval(ROW));
    }

    private static class CountingHavingSpec
    extends BaseHavingSpec {
        private final AtomicInteger counter;
        private final boolean value;

        private CountingHavingSpec(AtomicInteger counter, boolean value) {
            this.counter = counter;
            this.value = value;
        }

        public boolean eval(Row row) {
            this.counter.incrementAndGet();
            return this.value;
        }
    }
}

