/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.lookup;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import io.druid.jackson.DefaultObjectMapper;
import io.druid.query.extraction.MapLookupExtractor;
import io.druid.query.lookup.LookupExtractor;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class LookupExtractorTest {
    static final Map<String, String> EXPECTED_MAP = ImmutableMap.of((Object)"key1", (Object)"value1", (Object)"key2", (Object)"value2", (Object)"key-1", (Object)"value1", (Object)"", (Object)"emptyString");
    static final Map<String, List<String>> EXPECTED_REVERSE_MAP = ImmutableMap.of((Object)"value1", Arrays.asList("key1", "key-1"), (Object)"value2", Arrays.asList("key2"), (Object)"emptyString", Arrays.asList(""));
    LookupExtractor lookupExtractor = new MapLookupExtractor(EXPECTED_MAP, false);

    @Test
    public void testSerDes() throws IOException {
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        Assert.assertEquals((Object)this.lookupExtractor, (Object)mapper.reader(LookupExtractor.class).readValue(mapper.writeValueAsBytes((Object)this.lookupExtractor)));
    }

    @Test
    public void testApplyAll() {
        Assert.assertEquals(EXPECTED_MAP, (Object)this.lookupExtractor.applyAll(EXPECTED_MAP.keySet()));
    }

    @Test
    public void testApplyAllWithNull() {
        Assert.assertEquals(Collections.emptyMap(), (Object)this.lookupExtractor.applyAll(null));
    }

    @Test
    public void testApplyAllWithEmptySet() {
        Assert.assertEquals(Collections.emptyMap(), (Object)this.lookupExtractor.applyAll(Collections.emptySet()));
    }

    @Test
    public void testApplyAllWithNotExisting() {
        HashMap<String, Object> expected = new HashMap<String, Object>();
        expected.put("not there", null);
        Assert.assertEquals(expected, (Object)this.lookupExtractor.applyAll((Iterable)Lists.newArrayList((Object[])new String[]{"not there"})));
    }

    @Test
    public void testUnapplyAllWithNull() {
        Assert.assertEquals(Collections.emptyMap(), (Object)this.lookupExtractor.unapplyAll(null));
    }

    @Test
    public void testunapplyAllWithEmptySet() {
        Assert.assertEquals(Collections.emptyMap(), (Object)this.lookupExtractor.unapplyAll(Collections.emptySet()));
    }

    @Test
    public void testUnapplyAll() {
        Assert.assertEquals(EXPECTED_REVERSE_MAP, (Object)this.lookupExtractor.unapplyAll(EXPECTED_MAP.values()));
    }
}

