/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.search;

import com.google.common.base.Suppliers;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.CharSource;
import io.druid.java.util.common.DateTimes;
import io.druid.java.util.common.StringUtils;
import io.druid.java.util.common.guava.Sequence;
import io.druid.java.util.common.guava.Sequences;
import io.druid.query.Druids;
import io.druid.query.Query;
import io.druid.query.QueryPlus;
import io.druid.query.QueryRunner;
import io.druid.query.QueryRunnerTestHelper;
import io.druid.query.Result;
import io.druid.query.search.SearchHit;
import io.druid.query.search.SearchQuery;
import io.druid.query.search.SearchQueryConfig;
import io.druid.query.search.SearchQueryQueryToolChest;
import io.druid.query.search.SearchQueryRunnerFactory;
import io.druid.query.search.SearchStrategySelector;
import io.druid.segment.IncrementalIndexSegment;
import io.druid.segment.QueryableIndex;
import io.druid.segment.QueryableIndexSegment;
import io.druid.segment.Segment;
import io.druid.segment.TestIndex;
import io.druid.segment.incremental.IncrementalIndex;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SearchQueryRunnerWithCaseTest {
    private final QueryRunner runner;

    @Parameterized.Parameters
    public static Iterable<Object[]> constructorFeeder() throws IOException {
        SearchQueryConfig[] configs = new SearchQueryConfig[3];
        configs[0] = new SearchQueryConfig();
        configs[0].setSearchStrategy("useIndexes");
        configs[1] = new SearchQueryConfig();
        configs[1].setSearchStrategy("cursorOnly");
        configs[2] = new SearchQueryConfig();
        configs[2].setSearchStrategy("auto");
        CharSource input = CharSource.wrap((CharSequence)"2011-01-12T00:00:00.000Z\tspot\tAutoMotive\t1000\t10000.0\t10000.0\t100000\tPREFERRED\ta\u0001preferred\t100.000000\n2011-01-12T00:00:00.000Z\tSPot\tbusiness\t1100\t11000.0\t11000.0\t110000\tpreferred\tb\u0001Preferred\t100.000000\n2011-01-12T00:00:00.000Z\tspot\tentertainment\t1200\t12000.0\t12000.0\t120000\tPREFERRed\te\u0001preferred\t100.000000\n2011-01-13T00:00:00.000Z\tspot\tautomotive\t1000\t10000.0\t10000.0\t100000\tpreferred\ta\u0001preferred\t94.874713");
        IncrementalIndex index1 = TestIndex.makeRealtimeIndex(input);
        IncrementalIndex index2 = TestIndex.makeRealtimeIndex(input);
        QueryableIndex index3 = TestIndex.persistRealtimeAndLoadMMapped(index1);
        QueryableIndex index4 = TestIndex.persistRealtimeAndLoadMMapped(index2);
        ArrayList runners = Lists.newArrayList();
        for (SearchQueryConfig config : configs) {
            runners.addAll(Arrays.asList(QueryRunnerTestHelper.makeQueryRunner(SearchQueryRunnerWithCaseTest.makeRunnerFactory(config), "index1", (Segment)new IncrementalIndexSegment(index1, "index1"), "index1"), QueryRunnerTestHelper.makeQueryRunner(SearchQueryRunnerWithCaseTest.makeRunnerFactory(config), "index2", (Segment)new IncrementalIndexSegment(index2, "index2"), "index2"), QueryRunnerTestHelper.makeQueryRunner(SearchQueryRunnerWithCaseTest.makeRunnerFactory(config), "index3", (Segment)new QueryableIndexSegment("index3", index3), "index3"), QueryRunnerTestHelper.makeQueryRunner(SearchQueryRunnerWithCaseTest.makeRunnerFactory(config), "index4", (Segment)new QueryableIndexSegment("index4", index4), "index4")));
        }
        return QueryRunnerTestHelper.transformToConstructionFeeder(runners);
    }

    static SearchQueryRunnerFactory makeRunnerFactory(SearchQueryConfig config) {
        return new SearchQueryRunnerFactory(new SearchStrategySelector(Suppliers.ofInstance((Object)config)), new SearchQueryQueryToolChest(config, QueryRunnerTestHelper.NoopIntervalChunkingQueryRunnerDecorator()), QueryRunnerTestHelper.NOOP_QUERYWATCHER);
    }

    public SearchQueryRunnerWithCaseTest(QueryRunner runner) {
        this.runner = runner;
    }

    private Druids.SearchQueryBuilder testBuilder() {
        return Druids.newSearchQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).intervals(QueryRunnerTestHelper.fullOnInterval);
    }

    @Test
    public void testSearch() {
        Druids.SearchQueryBuilder builder = this.testBuilder();
        TreeMap expectedResults = Maps.newTreeMap((Comparator)String.CASE_INSENSITIVE_ORDER);
        SearchQuery searchQuery = builder.query("SPOT").build();
        expectedResults.put("market", Sets.newHashSet((Object[])new String[]{"spot", "SPot"}));
        this.checkSearchQuery(searchQuery, expectedResults);
        searchQuery = builder.query("spot", true).build();
        expectedResults.put("market", Sets.newHashSet((Object[])new String[]{"spot"}));
        this.checkSearchQuery(searchQuery, expectedResults);
        searchQuery = builder.query("SPot", true).build();
        expectedResults.put("market", Sets.newHashSet((Object[])new String[]{"SPot"}));
        this.checkSearchQuery(searchQuery, expectedResults);
    }

    @Test
    public void testSearchSameValueInMultiDims() {
        Druids.SearchQueryBuilder builder = this.testBuilder().dimensions(Arrays.asList("placement", "placementish"));
        TreeMap expectedResults = Maps.newTreeMap((Comparator)String.CASE_INSENSITIVE_ORDER);
        SearchQuery searchQuery = builder.query("PREFERRED").build();
        expectedResults.put("placement", Sets.newHashSet((Object[])new String[]{"PREFERRED", "preferred", "PREFERRed"}));
        expectedResults.put("placementish", Sets.newHashSet((Object[])new String[]{"preferred", "Preferred"}));
        this.checkSearchQuery(searchQuery, expectedResults);
        searchQuery = builder.query("preferred", true).build();
        expectedResults.put("placement", Sets.newHashSet((Object[])new String[]{"preferred"}));
        expectedResults.put("placementish", Sets.newHashSet((Object[])new String[]{"preferred"}));
        this.checkSearchQuery(searchQuery, expectedResults);
    }

    @Test
    public void testSearchIntervals() {
        Druids.SearchQueryBuilder builder = this.testBuilder().dimensions(Arrays.asList("quality")).intervals("2011-01-12T00:00:00.000Z/2011-01-13T00:00:00.000Z");
        TreeMap expectedResults = Maps.newTreeMap((Comparator)String.CASE_INSENSITIVE_ORDER);
        SearchQuery searchQuery = builder.query("otive").build();
        expectedResults.put("quality", Sets.newHashSet((Object[])new String[]{"AutoMotive"}));
        this.checkSearchQuery(searchQuery, expectedResults);
    }

    @Test
    public void testSearchNoOverrappingIntervals() {
        Druids.SearchQueryBuilder builder = this.testBuilder().dimensions(Arrays.asList("quality")).intervals("2011-01-10T00:00:00.000Z/2011-01-11T00:00:00.000Z");
        TreeMap expectedResults = Maps.newTreeMap((Comparator)String.CASE_INSENSITIVE_ORDER);
        SearchQuery searchQuery = builder.query("business").build();
        expectedResults.put("quality", Sets.newHashSet());
        this.checkSearchQuery(searchQuery, expectedResults);
    }

    @Test
    public void testFragmentSearch() {
        Druids.SearchQueryBuilder builder = this.testBuilder();
        TreeMap expectedResults = Maps.newTreeMap((Comparator)String.CASE_INSENSITIVE_ORDER);
        SearchQuery searchQuery = builder.fragments(Arrays.asList("auto", "ve")).build();
        expectedResults.put("quality", Sets.newHashSet((Object[])new String[]{"automotive", "AutoMotive"}));
        this.checkSearchQuery(searchQuery, expectedResults);
        searchQuery = builder.fragments(Arrays.asList("auto", "ve"), true).build();
        expectedResults.put("quality", Sets.newHashSet((Object[])new String[]{"automotive"}));
        this.checkSearchQuery(searchQuery, expectedResults);
    }

    private void checkSearchQuery(SearchQuery searchQuery, Map<String, Set<String>> expectedResults) {
        HashMap context = new HashMap();
        List results = Sequences.toList((Sequence)this.runner.run(QueryPlus.wrap((Query)searchQuery), context), (List)Lists.newArrayList());
        for (Result result : results) {
            Assert.assertEquals((Object)DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)result.getTimestamp());
            Assert.assertNotNull((Object)result.getValue());
            Iterable resultValues = (Iterable)result.getValue();
            for (SearchHit resultValue : resultValues) {
                String dimension = resultValue.getDimension();
                String theValue = resultValue.getValue();
                Assert.assertTrue((String)StringUtils.format((String)"Result had unknown dimension[%s]", (Object[])new Object[]{dimension}), (boolean)expectedResults.containsKey(dimension));
                Set<String> expectedSet = expectedResults.get(dimension);
                Assert.assertTrue((String)StringUtils.format((String)"Couldn't remove dim[%s], value[%s]", (Object[])new Object[]{dimension, theValue}), (boolean)expectedSet.remove(theValue));
            }
        }
        for (Map.Entry entry : expectedResults.entrySet()) {
            Assert.assertTrue((String)StringUtils.format((String)"Dimension[%s] should have had everything removed, still has[%s]", (Object[])new Object[]{entry.getKey(), entry.getValue()}), (boolean)((Set)entry.getValue()).isEmpty());
        }
        expectedResults.clear();
    }
}

