/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.select;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.ObjectArrays;
import com.google.common.collect.Sets;
import io.druid.jackson.DefaultObjectMapper;
import io.druid.java.util.common.DateTimes;
import io.druid.java.util.common.ISE;
import io.druid.java.util.common.Intervals;
import io.druid.java.util.common.guava.Sequence;
import io.druid.java.util.common.guava.Sequences;
import io.druid.js.JavaScriptConfig;
import io.druid.query.DataSource;
import io.druid.query.Druids;
import io.druid.query.Query;
import io.druid.query.QueryPlus;
import io.druid.query.QueryRunner;
import io.druid.query.QueryRunnerTestHelper;
import io.druid.query.Result;
import io.druid.query.TableDataSource;
import io.druid.query.dimension.DefaultDimensionSpec;
import io.druid.query.dimension.DimensionSpec;
import io.druid.query.dimension.ExtractionDimensionSpec;
import io.druid.query.expression.TestExprMacroTable;
import io.druid.query.extraction.ExtractionFn;
import io.druid.query.extraction.JavaScriptExtractionFn;
import io.druid.query.extraction.MapLookupExtractor;
import io.druid.query.filter.AndDimFilter;
import io.druid.query.filter.BoundDimFilter;
import io.druid.query.filter.DimFilter;
import io.druid.query.filter.SelectorDimFilter;
import io.druid.query.lookup.LookupExtractionFn;
import io.druid.query.lookup.LookupExtractor;
import io.druid.query.ordering.StringComparators;
import io.druid.query.select.EventHolder;
import io.druid.query.select.PagingOffset;
import io.druid.query.select.PagingSpec;
import io.druid.query.select.SelectQuery;
import io.druid.query.select.SelectQueryConfig;
import io.druid.query.select.SelectQueryEngine;
import io.druid.query.select.SelectQueryQueryToolChest;
import io.druid.query.select.SelectQueryRunnerFactory;
import io.druid.query.select.SelectResultValue;
import io.druid.query.spec.LegacySegmentSpec;
import io.druid.query.spec.QuerySegmentSpec;
import io.druid.segment.VirtualColumn;
import io.druid.segment.column.ValueType;
import io.druid.segment.virtual.ExpressionVirtualColumn;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.chrono.ISOChronology;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SelectQueryRunnerTest {
    public static final String[] V_0112 = new String[]{"2011-01-12T00:00:00.000Z\tspot\tautomotive\t1000\t10000.0\t100000\tpreferred\ta\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\tbusiness\t1100\t11000.0\t110000\tpreferred\tb\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\tentertainment\t1200\t12000.0\t120000\tpreferred\te\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\thealth\t1300\t13000.0\t130000\tpreferred\th\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\tmezzanine\t1400\t14000.0\t140000\tpreferred\tm\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\tnews\t1500\t15000.0\t150000\tpreferred\tn\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\tpremium\t1600\t16000.0\t160000\tpreferred\tp\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\ttechnology\t1700\t17000.0\t170000\tpreferred\tt\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\ttravel\t1800\t18000.0\t180000\tpreferred\tt\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\ttotal_market\tmezzanine\t1400\t14000.0\t140000\tpreferred\tm\u0001preferred\t1000.000000", "2011-01-12T00:00:00.000Z\ttotal_market\tpremium\t1600\t16000.0\t160000\tpreferred\tp\u0001preferred\t1000.000000", "2011-01-12T00:00:00.000Z\tupfront\tmezzanine\t1400\t14000.0\t140000\tpreferred\tm\u0001preferred\t800.000000\tvalue", "2011-01-12T00:00:00.000Z\tupfront\tpremium\t1600\t16000.0\t160000\tpreferred\tp\u0001preferred\t800.000000\tvalue"};
    public static final String[] V_0113 = new String[]{"2011-01-13T00:00:00.000Z\tspot\tautomotive\t1000\t10000.0\t100000\tpreferred\ta\u0001preferred\t94.874713", "2011-01-13T00:00:00.000Z\tspot\tbusiness\t1100\t11000.0\t110000\tpreferred\tb\u0001preferred\t103.629399", "2011-01-13T00:00:00.000Z\tspot\tentertainment\t1200\t12000.0\t120000\tpreferred\te\u0001preferred\t110.087299", "2011-01-13T00:00:00.000Z\tspot\thealth\t1300\t13000.0\t130000\tpreferred\th\u0001preferred\t114.947403", "2011-01-13T00:00:00.000Z\tspot\tmezzanine\t1400\t14000.0\t140000\tpreferred\tm\u0001preferred\t104.465767", "2011-01-13T00:00:00.000Z\tspot\tnews\t1500\t15000.0\t150000\tpreferred\tn\u0001preferred\t102.851683", "2011-01-13T00:00:00.000Z\tspot\tpremium\t1600\t16000.0\t160000\tpreferred\tp\u0001preferred\t108.863011", "2011-01-13T00:00:00.000Z\tspot\ttechnology\t1700\t17000.0\t170000\tpreferred\tt\u0001preferred\t111.356672", "2011-01-13T00:00:00.000Z\tspot\ttravel\t1800\t18000.0\t180000\tpreferred\tt\u0001preferred\t106.236928", "2011-01-13T00:00:00.000Z\ttotal_market\tmezzanine\t1400\t14000.0\t140000\tpreferred\tm\u0001preferred\t1040.945505", "2011-01-13T00:00:00.000Z\ttotal_market\tpremium\t1600\t16000.0\t160000\tpreferred\tp\u0001preferred\t1689.012875", "2011-01-13T00:00:00.000Z\tupfront\tmezzanine\t1400\t14000.0\t140000\tpreferred\tm\u0001preferred\t826.060182\tvalue", "2011-01-13T00:00:00.000Z\tupfront\tpremium\t1600\t16000.0\t160000\tpreferred\tp\u0001preferred\t1564.617729\tvalue"};
    public static final QuerySegmentSpec I_0112_0114 = new LegacySegmentSpec((Object)Intervals.of((String)"2011-01-12/2011-01-14"));
    public static final String[] V_0112_0114 = (String[])ObjectArrays.concat((Object[])V_0112, (Object[])V_0113, String.class);
    private static final boolean DEFAULT_FROM_NEXT = true;
    private static final SelectQueryConfig config = new SelectQueryConfig(Boolean.valueOf(true));
    private static final Supplier<SelectQueryConfig> configSupplier = Suppliers.ofInstance((Object)config);
    private static final SelectQueryQueryToolChest toolChest = new SelectQueryQueryToolChest((ObjectMapper)new DefaultObjectMapper(), QueryRunnerTestHelper.NoopIntervalChunkingQueryRunnerDecorator(), configSupplier);
    private final QueryRunner runner;
    private final boolean descending;

    @Parameterized.Parameters(name="{0}:descending={1}")
    public static Iterable<Object[]> constructorFeeder() throws IOException {
        return QueryRunnerTestHelper.cartesian(QueryRunnerTestHelper.makeQueryRunners(new SelectQueryRunnerFactory(toolChest, new SelectQueryEngine(), QueryRunnerTestHelper.NOOP_QUERYWATCHER)), Arrays.asList(false, true));
    }

    public SelectQueryRunnerTest(QueryRunner runner, boolean descending) {
        config.setEnableFromNextDefault(true);
        this.runner = runner;
        this.descending = descending;
    }

    private Druids.SelectQueryBuilder newTestQuery() {
        return Druids.newSelectQueryBuilder().dataSource((DataSource)new TableDataSource("testing")).dimensionSpecs(DefaultDimensionSpec.toSpec(Arrays.asList(new String[0]))).metrics(Arrays.asList(new String[0])).intervals(QueryRunnerTestHelper.fullOnInterval).granularity(QueryRunnerTestHelper.allGran).pagingSpec(PagingSpec.newSpec((int)3)).descending(this.descending);
    }

    @Test
    public void testFullOnSelect() {
        SelectQuery query = this.newTestQuery().intervals(I_0112_0114).build();
        HashMap context = new HashMap();
        List results = Sequences.toList((Sequence)this.runner.run(QueryPlus.wrap((Query)query), context), (List)Lists.newArrayList());
        PagingOffset offset = query.getPagingOffset("testSegment");
        List<Result<SelectResultValue>> expectedResults = this.toExpected(this.toFullEvents(new String[][]{V_0112_0114}), Lists.newArrayList((Object[])new String[]{"market", "quality", "qualityLong", "qualityFloat", "qualityDouble", "qualityNumericString", "placement", "placementish", "partial_null_column", "null_column"}), Lists.newArrayList((Object[])new String[]{"index", "quality_uniques", "indexMin", "indexMaxPlusTen", "indexFloat", "indexMaxFloat", "indexMinFloat"}), offset.startOffset(), offset.threshold());
        SelectQueryRunnerTest.verify(expectedResults, SelectQueryRunnerTest.populateNullColumnAtLastForQueryableIndexCase(results, "null_column"));
    }

    @Test
    public void testSequentialPaging() {
        Map pagingIdentifiers;
        SelectResultValue result;
        List results;
        int[] asc = new int[]{2, 5, 8, 11, 14, 17, 20, 23, 25};
        int[] dsc = new int[]{-3, -6, -9, -12, -15, -18, -21, -24, -26};
        int[] expected = this.descending ? dsc : asc;
        SelectQuery query = this.newTestQuery().intervals(I_0112_0114).build();
        for (int offset : expected) {
            results = Sequences.toList((Sequence)this.runner.run(QueryPlus.wrap((Query)query), (Map)ImmutableMap.of()), (List)Lists.newArrayList());
            Assert.assertEquals((long)1L, (long)results.size());
            result = (SelectResultValue)((Result)results.get(0)).getValue();
            pagingIdentifiers = result.getPagingIdentifiers();
            Assert.assertEquals((long)offset, (long)((Integer)pagingIdentifiers.get("testSegment")).intValue());
            Map next = PagingSpec.next((Map)pagingIdentifiers, (boolean)this.descending);
            query = query.withPagingSpec(new PagingSpec(next, 3, Boolean.valueOf(false)));
        }
        query = this.newTestQuery().intervals(I_0112_0114).build();
        for (int offset : expected) {
            results = Sequences.toList((Sequence)this.runner.run(QueryPlus.wrap((Query)query), (Map)ImmutableMap.of()), (List)Lists.newArrayList());
            Assert.assertEquals((long)1L, (long)results.size());
            result = (SelectResultValue)((Result)results.get(0)).getValue();
            pagingIdentifiers = result.getPagingIdentifiers();
            Assert.assertEquals((long)offset, (long)((Integer)pagingIdentifiers.get("testSegment")).intValue());
            query = query.withPagingSpec(new PagingSpec(pagingIdentifiers, 3, Boolean.valueOf(true)));
        }
    }

    @Test
    public void testFullOnSelectWithDimensionSpec() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("automotive", "automotive0");
        map.put("business", "business0");
        map.put("entertainment", "entertainment0");
        map.put("health", "health0");
        map.put("mezzanine", "mezzanine0");
        map.put("news", "news0");
        map.put("premium", "premium0");
        map.put("technology", "technology0");
        map.put("travel", "travel0");
        SelectQuery query = this.newTestQuery().dimensionSpecs(Arrays.asList(new DefaultDimensionSpec("market", "mar"), new ExtractionDimensionSpec("quality", "qual", (ExtractionFn)new LookupExtractionFn((LookupExtractor)new MapLookupExtractor(map, true), false, null, Boolean.valueOf(true), Boolean.valueOf(false))), new DefaultDimensionSpec("placement", "place"))).build();
        HashMap context = new HashMap();
        List results = Sequences.toList((Sequence)this.runner.run(QueryPlus.wrap((Query)query), context), (List)Lists.newArrayList());
        List<Result> expectedResultsAsc = Arrays.asList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new SelectResultValue((Map)ImmutableMap.of((Object)"testSegment", (Object)2), (Set)Sets.newHashSet((Object[])new String[]{"mar", "qual", "place"}), (Set)Sets.newHashSet((Object[])new String[]{"index", "quality_uniques", "indexMin", "indexMaxPlusTen", "indexMinFloat", "indexFloat", "indexMaxFloat"}), Arrays.asList(new EventHolder("testSegment", 0, (Map)new ImmutableMap.Builder().put((Object)"timestamp", (Object)DateTimes.of((String)"2011-01-12T00:00:00.000Z")).put((Object)"mar", (Object)"spot").put((Object)"qual", (Object)"automotive0").put((Object)"place", (Object)"preferred").put((Object)"index", (Object)Float.valueOf(100.0f)).build()), new EventHolder("testSegment", 1, (Map)new ImmutableMap.Builder().put((Object)"timestamp", (Object)DateTimes.of((String)"2011-01-12T00:00:00.000Z")).put((Object)"mar", (Object)"spot").put((Object)"qual", (Object)"business0").put((Object)"place", (Object)"preferred").put((Object)"index", (Object)Float.valueOf(100.0f)).build()), new EventHolder("testSegment", 2, (Map)new ImmutableMap.Builder().put((Object)"timestamp", (Object)DateTimes.of((String)"2011-01-12T00:00:00.000Z")).put((Object)"mar", (Object)"spot").put((Object)"qual", (Object)"entertainment0").put((Object)"place", (Object)"preferred").put((Object)"index", (Object)Float.valueOf(100.0f)).build())))));
        List<Result<SelectResultValue>> expectedResultsDsc = Arrays.asList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new SelectResultValue((Map)ImmutableMap.of((Object)"testSegment", (Object)-3), (Set)Sets.newHashSet((Object[])new String[]{"mar", "qual", "place"}), (Set)Sets.newHashSet((Object[])new String[]{"index", "quality_uniques", "indexMin", "indexMaxPlusTen", "indexMinFloat", "indexFloat", "indexMaxFloat"}), Arrays.asList(new EventHolder("testSegment", -1, (Map)new ImmutableMap.Builder().put((Object)"timestamp", (Object)DateTimes.of((String)"2011-04-15T00:00:00.000Z")).put((Object)"mar", (Object)"upfront").put((Object)"qual", (Object)"premium0").put((Object)"place", (Object)"preferred").put((Object)"index", (Object)Float.valueOf(780.272f)).build()), new EventHolder("testSegment", -2, (Map)new ImmutableMap.Builder().put((Object)"timestamp", (Object)DateTimes.of((String)"2011-04-15T00:00:00.000Z")).put((Object)"mar", (Object)"upfront").put((Object)"qual", (Object)"mezzanine0").put((Object)"place", (Object)"preferred").put((Object)"index", (Object)Float.valueOf(962.7312f)).build()), new EventHolder("testSegment", -3, (Map)new ImmutableMap.Builder().put((Object)"timestamp", (Object)DateTimes.of((String)"2011-04-15T00:00:00.000Z")).put((Object)"mar", (Object)"total_market").put((Object)"qual", (Object)"premium0").put((Object)"place", (Object)"preferred").put((Object)"index", (Object)Float.valueOf(1029.057f)).build())))));
        SelectQueryRunnerTest.verify(this.descending ? expectedResultsDsc : expectedResultsAsc, results);
    }

    @Test
    public void testSelectWithDimsAndMets() {
        SelectQuery query = this.newTestQuery().intervals(I_0112_0114).dimensionSpecs(DefaultDimensionSpec.toSpec((String[])new String[]{"market"})).metrics(Arrays.asList("index")).build();
        HashMap context = new HashMap();
        List results = Sequences.toList((Sequence)this.runner.run(QueryPlus.wrap((Query)query), context), (List)Lists.newArrayList());
        PagingOffset offset = query.getPagingOffset("testSegment");
        List<Result<SelectResultValue>> expectedResults = this.toExpected(this.toEvents(new String[]{"timestamp:TIME", "market:STRING", null, null, null, null, null, null, "index:FLOAT"}, new String[][]{V_0112_0114}), Lists.newArrayList((Object[])new String[]{"market"}), Lists.newArrayList((Object[])new String[]{"index"}), offset.startOffset(), offset.threshold());
        SelectQueryRunnerTest.verify(expectedResults, results);
    }

    @Test
    public void testSelectPagination() {
        SelectQuery query = this.newTestQuery().intervals(I_0112_0114).dimensionSpecs(DefaultDimensionSpec.toSpec((String[])new String[]{"quality"})).metrics(Arrays.asList("index")).pagingSpec(new PagingSpec(this.toPagingIdentifier(3, this.descending), 3)).build();
        List results = Sequences.toList((Sequence)this.runner.run(QueryPlus.wrap((Query)query), (Map)Maps.newHashMap()), (List)Lists.newArrayList());
        PagingOffset offset = query.getPagingOffset("testSegment");
        List<Result<SelectResultValue>> expectedResults = this.toExpected(this.toEvents(new String[]{"timestamp:TIME", "foo:NULL", "foo2:NULL"}, new String[][]{V_0112_0114}), Lists.newArrayList((Object[])new String[]{"quality"}), Lists.newArrayList((Object[])new String[]{"index"}), offset.startOffset(), offset.threshold());
        SelectQueryRunnerTest.verify(expectedResults, results);
    }

    @Test
    public void testFullOnSelectWithFilter() {
        for (int[] param : new int[][]{{3, 3}, {0, 1}, {5, 5}, {2, 7}, {3, 0}}) {
            SelectQuery query = this.newTestQuery().intervals(I_0112_0114).filters((DimFilter)new SelectorDimFilter("market", "spot", null)).granularity(QueryRunnerTestHelper.dayGran).dimensionSpecs(DefaultDimensionSpec.toSpec((String[])new String[]{"quality"})).metrics((List)Lists.newArrayList((Object[])new String[]{"index"})).pagingSpec(new PagingSpec(this.toPagingIdentifier(param[0], this.descending), param[1])).build();
            HashMap context = new HashMap();
            List results = Sequences.toList((Sequence)this.runner.run(QueryPlus.wrap((Query)query), context), (List)Lists.newArrayList());
            List<List<Map<String, Object>>> events = this.toEvents(new String[]{"timestamp:TIME", null, "quality:STRING", null, null, "index:FLOAT"}, {"2011-01-12T00:00:00.000Z\tspot\tautomotive\tpreferred\ta\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\tbusiness\tpreferred\tb\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\tentertainment\tpreferred\te\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\thealth\tpreferred\th\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\tmezzanine\tpreferred\tm\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\tnews\tpreferred\tn\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\tpremium\tpreferred\tp\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\ttechnology\tpreferred\tt\u0001preferred\t100.000000", "2011-01-12T00:00:00.000Z\tspot\ttravel\tpreferred\tt\u0001preferred\t100.000000"}, {"2011-01-13T00:00:00.000Z\tspot\tautomotive\tpreferred\ta\u0001preferred\t94.874713", "2011-01-13T00:00:00.000Z\tspot\tbusiness\tpreferred\tb\u0001preferred\t103.629399", "2011-01-13T00:00:00.000Z\tspot\tentertainment\tpreferred\te\u0001preferred\t110.087299", "2011-01-13T00:00:00.000Z\tspot\thealth\tpreferred\th\u0001preferred\t114.947403", "2011-01-13T00:00:00.000Z\tspot\tmezzanine\tpreferred\tm\u0001preferred\t104.465767", "2011-01-13T00:00:00.000Z\tspot\tnews\tpreferred\tn\u0001preferred\t102.851683", "2011-01-13T00:00:00.000Z\tspot\tpremium\tpreferred\tp\u0001preferred\t108.863011", "2011-01-13T00:00:00.000Z\tspot\ttechnology\tpreferred\tt\u0001preferred\t111.356672", "2011-01-13T00:00:00.000Z\tspot\ttravel\tpreferred\tt\u0001preferred\t106.236928"});
            PagingOffset offset = query.getPagingOffset("testSegment");
            List<Result<SelectResultValue>> expectedResults = this.toExpected(events, Lists.newArrayList((Object[])new String[]{"quality"}), Lists.newArrayList((Object[])new String[]{"index"}), offset.startOffset(), offset.threshold());
            SelectQueryRunnerTest.verify(expectedResults, results);
        }
    }

    @Test
    public void testFullOnSelectWithFilterOnVirtualColumn() {
        SelectQuery query = this.newTestQuery().intervals("2011-01-13/2011-01-14").filters((DimFilter)new AndDimFilter(Arrays.asList(new SelectorDimFilter("market", "spot", null), new BoundDimFilter("expr", "11.1", null, Boolean.valueOf(false), Boolean.valueOf(false), null, null, StringComparators.NUMERIC)))).granularity(QueryRunnerTestHelper.allGran).dimensionSpecs(DefaultDimensionSpec.toSpec((String[])new String[]{"quality"})).metrics((List)Lists.newArrayList((Object[])new String[]{"index"})).pagingSpec(new PagingSpec(null, 10, Boolean.valueOf(true))).virtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("expr", "index / 10.0", ValueType.FLOAT, TestExprMacroTable.INSTANCE)}).build();
        HashMap context = new HashMap();
        List results = Sequences.toList((Sequence)this.runner.run(QueryPlus.wrap((Query)query), context), (List)Lists.newArrayList());
        List<List<Map<String, Object>>> events = this.toEvents(new String[]{"timestamp:TIME", null, "quality:STRING", null, null, "index:FLOAT"}, new String[][]{{"2011-01-13T00:00:00.000Z\tspot\thealth\tpreferred\th\u0001preferred\t114.947403", "2011-01-13T00:00:00.000Z\tspot\ttechnology\tpreferred\tt\u0001preferred\t111.356672"}});
        PagingOffset offset = query.getPagingOffset("testSegment");
        List<Result<SelectResultValue>> expectedResults = this.toExpected(events, Lists.newArrayList((Object[])new String[]{"quality"}), Lists.newArrayList((Object[])new String[]{"index"}), offset.startOffset(), offset.threshold());
        SelectQueryRunnerTest.verify(expectedResults, results);
    }

    @Test
    public void testSelectWithFilterLookupExtractionFn() {
        HashMap<String, String> extractionMap = new HashMap<String, String>();
        extractionMap.put("total_market", "replaced");
        MapLookupExtractor mapLookupExtractor = new MapLookupExtractor(extractionMap, false);
        LookupExtractionFn lookupExtractionFn = new LookupExtractionFn((LookupExtractor)mapLookupExtractor, false, null, Boolean.valueOf(true), Boolean.valueOf(true));
        SelectQuery query = this.newTestQuery().intervals(I_0112_0114).filters((DimFilter)new SelectorDimFilter("market", "replaced", (ExtractionFn)lookupExtractionFn)).granularity(QueryRunnerTestHelper.dayGran).dimensionSpecs(DefaultDimensionSpec.toSpec((String[])new String[]{"quality"})).metrics((List)Lists.newArrayList((Object[])new String[]{"index"})).build();
        List results = Sequences.toList((Sequence)this.runner.run(QueryPlus.wrap((Query)query), (Map)Maps.newHashMap()), (List)Lists.newArrayList());
        List resultsOptimize = Sequences.toList((Sequence)toolChest.postMergeQueryDecoration(toolChest.mergeResults(toolChest.preMergeQueryDecoration(this.runner))).run(QueryPlus.wrap((Query)query), (Map)Maps.newHashMap()), (List)Lists.newArrayList());
        List<List<Map<String, Object>>> events = this.toEvents(new String[]{"timestamp:TIME", null, "quality:STRING", null, null, "index:FLOAT"}, {"2011-01-12T00:00:00.000Z\ttotal_market\tmezzanine\tpreferred\tm\u0001preferred\t1000.000000", "2011-01-12T00:00:00.000Z\ttotal_market\tpremium\tpreferred\tp\u0001preferred\t1000.000000"}, {"2011-01-13T00:00:00.000Z\ttotal_market\tmezzanine\tpreferred\tm\u0001preferred\t1040.945505", "2011-01-13T00:00:00.000Z\ttotal_market\tpremium\tpreferred\tp\u0001preferred\t1689.012875"});
        PagingOffset offset = query.getPagingOffset("testSegment");
        List<Result<SelectResultValue>> expectedResults = this.toExpected(events, Lists.newArrayList((Object[])new String[]{"quality"}), Lists.newArrayList((Object[])new String[]{"index"}), offset.startOffset(), offset.threshold());
        SelectQueryRunnerTest.verify(expectedResults, results);
        SelectQueryRunnerTest.verify(expectedResults, resultsOptimize);
    }

    @Test
    public void testFullSelectNoResults() {
        SelectQuery query = this.newTestQuery().intervals(I_0112_0114).filters((DimFilter)new AndDimFilter(Arrays.asList(new SelectorDimFilter("market", "spot", null), new SelectorDimFilter("market", "foo", null)))).build();
        List results = Sequences.toList((Sequence)this.runner.run(QueryPlus.wrap((Query)query), (Map)Maps.newHashMap()), (List)Lists.newArrayList());
        List<Result<SelectResultValue>> expectedResults = Arrays.asList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new SelectResultValue((Map)ImmutableMap.of(), (Set)Sets.newHashSet((Object[])new String[]{"market", "quality", "qualityLong", "qualityFloat", "qualityDouble", "qualityNumericString", "placement", "placementish", "partial_null_column", "null_column"}), (Set)Sets.newHashSet((Object[])new String[]{"index", "quality_uniques", "indexMin", "indexMaxPlusTen", "indexMinFloat", "indexFloat", "indexMaxFloat"}), (List)Lists.newArrayList())));
        SelectQueryRunnerTest.verify(expectedResults, SelectQueryRunnerTest.populateNullColumnAtLastForQueryableIndexCase(results, "null_column"));
    }

    @Test
    public void testFullSelectNoDimensionAndMetric() {
        SelectQuery query = this.newTestQuery().intervals(I_0112_0114).dimensionSpecs(DefaultDimensionSpec.toSpec((String[])new String[]{"foo"})).metrics((List)Lists.newArrayList((Object[])new String[]{"foo2"})).build();
        List results = Sequences.toList((Sequence)this.runner.run(QueryPlus.wrap((Query)query), (Map)Maps.newHashMap()), (List)Lists.newArrayList());
        List<List<Map<String, Object>>> events = this.toEvents(new String[]{"timestamp:TIME", "foo:NULL", "foo2:NULL"}, new String[][]{V_0112_0114});
        PagingOffset offset = query.getPagingOffset("testSegment");
        List<Result<SelectResultValue>> expectedResults = this.toExpected(events, Lists.newArrayList((Object[])new String[]{"foo"}), Lists.newArrayList((Object[])new String[]{"foo2"}), offset.startOffset(), offset.threshold());
        SelectQueryRunnerTest.verify(expectedResults, results);
    }

    @Test
    public void testFullOnSelectWithLongAndFloat() {
        List<DimensionSpec> dimSpecs = Arrays.asList(new DefaultDimensionSpec("index", "floatIndex", ValueType.FLOAT), new DefaultDimensionSpec("__time", "longTime", ValueType.LONG));
        SelectQuery query = this.newTestQuery().dimensionSpecs(dimSpecs).metrics(Arrays.asList("__time", "index")).intervals(I_0112_0114).build();
        HashMap context = new HashMap();
        List results = Sequences.toList((Sequence)this.runner.run(QueryPlus.wrap((Query)query), context), (List)Lists.newArrayList());
        List<Result> expectedResultsAsc = Arrays.asList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new SelectResultValue((Map)ImmutableMap.of((Object)"testSegment", (Object)2), (Set)Sets.newHashSet((Object[])new String[]{"null_column", "floatIndex", "longTime"}), (Set)Sets.newHashSet((Object[])new String[]{"__time", "index"}), Arrays.asList(new EventHolder("testSegment", 0, (Map)new ImmutableMap.Builder().put((Object)"timestamp", (Object)DateTimes.of((String)"2011-01-12T00:00:00.000Z")).put((Object)"longTime", (Object)1294790400000L).put((Object)"floatIndex", (Object)Float.valueOf(100.0f)).put((Object)"index", (Object)Float.valueOf(100.0f)).put((Object)"__time", (Object)1294790400000L).build()), new EventHolder("testSegment", 1, (Map)new ImmutableMap.Builder().put((Object)"timestamp", (Object)DateTimes.of((String)"2011-01-12T00:00:00.000Z")).put((Object)"longTime", (Object)1294790400000L).put((Object)"floatIndex", (Object)Float.valueOf(100.0f)).put((Object)"index", (Object)Float.valueOf(100.0f)).put((Object)"__time", (Object)1294790400000L).build()), new EventHolder("testSegment", 2, (Map)new ImmutableMap.Builder().put((Object)"timestamp", (Object)DateTimes.of((String)"2011-01-12T00:00:00.000Z")).put((Object)"longTime", (Object)1294790400000L).put((Object)"floatIndex", (Object)Float.valueOf(100.0f)).put((Object)"index", (Object)Float.valueOf(100.0f)).put((Object)"__time", (Object)1294790400000L).build())))));
        List<Result<SelectResultValue>> expectedResultsDsc = Arrays.asList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new SelectResultValue((Map)ImmutableMap.of((Object)"testSegment", (Object)-3), (Set)Sets.newHashSet((Object[])new String[]{"null_column", "floatIndex", "longTime"}), (Set)Sets.newHashSet((Object[])new String[]{"__time", "index"}), Arrays.asList(new EventHolder("testSegment", -1, (Map)new ImmutableMap.Builder().put((Object)"timestamp", (Object)DateTimes.of((String)"2011-01-13T00:00:00.000Z")).put((Object)"longTime", (Object)1294876800000L).put((Object)"floatIndex", (Object)Float.valueOf(1564.6177f)).put((Object)"index", (Object)Float.valueOf(1564.6177f)).put((Object)"__time", (Object)1294876800000L).build()), new EventHolder("testSegment", -2, (Map)new ImmutableMap.Builder().put((Object)"timestamp", (Object)DateTimes.of((String)"2011-01-13T00:00:00.000Z")).put((Object)"longTime", (Object)1294876800000L).put((Object)"floatIndex", (Object)Float.valueOf(826.0602f)).put((Object)"index", (Object)Float.valueOf(826.0602f)).put((Object)"__time", (Object)1294876800000L).build()), new EventHolder("testSegment", -3, (Map)new ImmutableMap.Builder().put((Object)"timestamp", (Object)DateTimes.of((String)"2011-01-13T00:00:00.000Z")).put((Object)"longTime", (Object)1294876800000L).put((Object)"floatIndex", (Object)Float.valueOf(1689.0128f)).put((Object)"index", (Object)Float.valueOf(1689.0128f)).put((Object)"__time", (Object)1294876800000L).build())))));
        SelectQueryRunnerTest.verify(this.descending ? expectedResultsDsc : expectedResultsAsc, SelectQueryRunnerTest.populateNullColumnAtLastForQueryableIndexCase(results, "null_column"));
    }

    @Test
    public void testFullOnSelectWithLongAndFloatWithExFn() {
        String jsFn = "function(str) { return 'super-' + str; }";
        JavaScriptExtractionFn jsExtractionFn = new JavaScriptExtractionFn(jsFn, false, JavaScriptConfig.getEnabledInstance());
        List<DimensionSpec> dimSpecs = Arrays.asList(new ExtractionDimensionSpec("index", "floatIndex", (ExtractionFn)jsExtractionFn), new ExtractionDimensionSpec("__time", "longTime", (ExtractionFn)jsExtractionFn));
        SelectQuery query = this.newTestQuery().dimensionSpecs(dimSpecs).metrics(Arrays.asList("__time", "index")).intervals(I_0112_0114).build();
        HashMap context = new HashMap();
        List results = Sequences.toList((Sequence)this.runner.run(QueryPlus.wrap((Query)query), context), (List)Lists.newArrayList());
        List<Result> expectedResultsAsc = Arrays.asList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new SelectResultValue((Map)ImmutableMap.of((Object)"testSegment", (Object)2), (Set)Sets.newHashSet((Object[])new String[]{"null_column", "floatIndex", "longTime"}), (Set)Sets.newHashSet((Object[])new String[]{"__time", "index"}), Arrays.asList(new EventHolder("testSegment", 0, (Map)new ImmutableMap.Builder().put((Object)"timestamp", (Object)DateTimes.of((String)"2011-01-12T00:00:00.000Z")).put((Object)"longTime", (Object)"super-1294790400000").put((Object)"floatIndex", (Object)"super-100").put((Object)"index", (Object)Float.valueOf(100.0f)).put((Object)"__time", (Object)1294790400000L).build()), new EventHolder("testSegment", 1, (Map)new ImmutableMap.Builder().put((Object)"timestamp", (Object)DateTimes.of((String)"2011-01-12T00:00:00.000Z")).put((Object)"longTime", (Object)"super-1294790400000").put((Object)"floatIndex", (Object)"super-100").put((Object)"index", (Object)Float.valueOf(100.0f)).put((Object)"__time", (Object)1294790400000L).build()), new EventHolder("testSegment", 2, (Map)new ImmutableMap.Builder().put((Object)"timestamp", (Object)DateTimes.of((String)"2011-01-12T00:00:00.000Z")).put((Object)"longTime", (Object)"super-1294790400000").put((Object)"floatIndex", (Object)"super-100").put((Object)"index", (Object)Float.valueOf(100.0f)).put((Object)"__time", (Object)1294790400000L).build())))));
        List<Result<SelectResultValue>> expectedResultsDsc = Arrays.asList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new SelectResultValue((Map)ImmutableMap.of((Object)"testSegment", (Object)-3), (Set)Sets.newHashSet((Object[])new String[]{"null_column", "floatIndex", "longTime"}), (Set)Sets.newHashSet((Object[])new String[]{"__time", "index"}), Arrays.asList(new EventHolder("testSegment", -1, (Map)new ImmutableMap.Builder().put((Object)"timestamp", (Object)DateTimes.of((String)"2011-01-13T00:00:00.000Z")).put((Object)"longTime", (Object)"super-1294876800000").put((Object)"floatIndex", (Object)"super-1564.617729").put((Object)"index", (Object)Float.valueOf(1564.6177f)).put((Object)"__time", (Object)1294876800000L).build()), new EventHolder("testSegment", -2, (Map)new ImmutableMap.Builder().put((Object)"timestamp", (Object)DateTimes.of((String)"2011-01-13T00:00:00.000Z")).put((Object)"longTime", (Object)"super-1294876800000").put((Object)"floatIndex", (Object)"super-826.060182").put((Object)"index", (Object)Float.valueOf(826.0602f)).put((Object)"__time", (Object)1294876800000L).build()), new EventHolder("testSegment", -3, (Map)new ImmutableMap.Builder().put((Object)"timestamp", (Object)DateTimes.of((String)"2011-01-13T00:00:00.000Z")).put((Object)"longTime", (Object)"super-1294876800000").put((Object)"floatIndex", (Object)"super-1689.012875").put((Object)"index", (Object)Float.valueOf(1689.0128f)).put((Object)"__time", (Object)1294876800000L).build())))));
        SelectQueryRunnerTest.verify(this.descending ? expectedResultsDsc : expectedResultsAsc, SelectQueryRunnerTest.populateNullColumnAtLastForQueryableIndexCase(results, "null_column"));
    }

    private Map<String, Integer> toPagingIdentifier(int startDelta, boolean descending) {
        return ImmutableMap.of((Object)"testSegment", (Object)PagingOffset.toOffset((int)startDelta, (boolean)descending));
    }

    private List<List<Map<String, Object>>> toFullEvents(String[] ... valueSet) {
        return this.toEvents(new String[]{"timestamp:TIME", "market:STRING", "quality:STRING", "qualityLong:LONG", "qualityFloat:FLOAT", "qualityNumericString:STRING", "placement:STRING", "placementish:STRINGS", "index:FLOAT", "partial_null_column:STRING"}, valueSet);
    }

    private List<List<Map<String, Object>>> toEvents(final String[] dimSpecs, String[] ... valueSet) {
        ArrayList events = Lists.newArrayList();
        for (String[] values : valueSet) {
            events.add(Lists.newArrayList((Iterable)Iterables.transform(Arrays.asList(values), (Function)new Function<String, Map<String, Object>>(){

                public Map<String, Object> apply(String input) {
                    HashMap event = Maps.newHashMap();
                    String[] values = input.split("\\t");
                    for (int i = 0; i < dimSpecs.length; ++i) {
                        if (dimSpecs[i] == null || i >= dimSpecs.length || i >= values.length) continue;
                        String[] specs = dimSpecs[i].split(":");
                        event.put(specs[0], specs.length == 1 || specs[1].equals("STRING") ? values[i] : (specs[1].equals("TIME") ? DateTimes.of((String)values[i]) : (specs[1].equals("FLOAT") ? Float.valueOf(values[i]) : (specs[1].equals("DOUBLE") ? Double.valueOf(values[i]) : (specs[1].equals("LONG") ? Long.valueOf(values[i]) : (specs[1].equals("NULL") ? null : (specs[1].equals("STRINGS") ? Arrays.asList(values[i].split("\u0001")) : values[i])))))));
                    }
                    return event;
                }
            })));
        }
        return events;
    }

    private List<Result<SelectResultValue>> toExpected(List<List<Map<String, Object>>> targets, List<String> dimensions, List<String> metrics, int offset, int threshold) {
        if (offset < 0) {
            targets = Lists.reverse(targets);
        }
        ArrayList expected = Lists.newArrayListWithExpectedSize((int)targets.size());
        for (List group : targets) {
            ArrayList holders = Lists.newArrayListWithExpectedSize((int)threshold);
            int newOffset = offset;
            if (offset < 0) {
                int start = group.size() + offset;
                int end = Math.max(-1, start - threshold);
                for (int i = start; i > end; --i) {
                    holders.add(new EventHolder("testSegment", newOffset--, (Map)group.get(i)));
                }
            } else {
                int end = Math.min(group.size(), offset + threshold);
                for (int i = offset; i < end; ++i) {
                    holders.add(new EventHolder("testSegment", newOffset++, (Map)group.get(i)));
                }
            }
            int lastOffset = holders.isEmpty() ? offset : ((EventHolder)holders.get(holders.size() - 1)).getOffset();
            expected.add(new Result(new DateTime(((Map)group.get(0)).get("timestamp"), (Chronology)ISOChronology.getInstanceUTC()), (Object)new SelectResultValue((Map)ImmutableMap.of((Object)"testSegment", (Object)lastOffset), (Set)Sets.newHashSet(dimensions), (Set)Sets.newHashSet(metrics), (List)holders)));
        }
        return expected;
    }

    private static void verify(Iterable<Result<SelectResultValue>> expectedResults, Iterable<Result<SelectResultValue>> actualResults) {
        Iterator<Result<SelectResultValue>> expectedIter = expectedResults.iterator();
        Iterator<Result<SelectResultValue>> actualIter = actualResults.iterator();
        while (expectedIter.hasNext()) {
            Result<SelectResultValue> expected = expectedIter.next();
            Result<SelectResultValue> actual = actualIter.next();
            Assert.assertEquals((Object)expected.getTimestamp(), (Object)actual.getTimestamp());
            for (Map.Entry entry : ((SelectResultValue)expected.getValue()).getPagingIdentifiers().entrySet()) {
                Assert.assertEquals(entry.getValue(), ((SelectResultValue)actual.getValue()).getPagingIdentifiers().get(entry.getKey()));
            }
            Assert.assertEquals((Object)((SelectResultValue)expected.getValue()).getDimensions(), (Object)((SelectResultValue)actual.getValue()).getDimensions());
            Assert.assertEquals((Object)((SelectResultValue)expected.getValue()).getMetrics(), (Object)((SelectResultValue)actual.getValue()).getMetrics());
            Iterator expectedEvts = ((SelectResultValue)expected.getValue()).getEvents().iterator();
            Iterator actualEvts = ((SelectResultValue)actual.getValue()).getEvents().iterator();
            while (expectedEvts.hasNext()) {
                EventHolder exHolder = (EventHolder)expectedEvts.next();
                EventHolder acHolder = (EventHolder)actualEvts.next();
                Assert.assertEquals((Object)exHolder.getTimestamp(), (Object)acHolder.getTimestamp());
                Assert.assertEquals((long)exHolder.getOffset(), (long)acHolder.getOffset());
                for (Map.Entry ex : exHolder.getEvent().entrySet()) {
                    Object actVal = acHolder.getEvent().get(ex.getKey());
                    if (acHolder.getEvent().get(ex.getKey()) instanceof Double) {
                        actVal = Float.valueOf(((Double)actVal).floatValue());
                    }
                    Assert.assertEquals((String)("invalid value for " + (String)ex.getKey()), ex.getValue(), actVal);
                }
            }
            if (!actualEvts.hasNext()) continue;
            throw new ISE("This event iterator should be exhausted!", new Object[0]);
        }
        if (actualIter.hasNext()) {
            throw new ISE("This iterator should be exhausted!", new Object[0]);
        }
    }

    private static Iterable<Result<SelectResultValue>> populateNullColumnAtLastForQueryableIndexCase(Iterable<Result<SelectResultValue>> results, String columnName) {
        Result<SelectResultValue> value;
        Set dimensions;
        Iterator<Result<SelectResultValue>> iterator = results.iterator();
        while (iterator.hasNext() && !(dimensions = ((SelectResultValue)(value = iterator.next()).getValue()).getDimensions()).contains(columnName)) {
            dimensions.add(columnName);
        }
        return results;
    }
}

