/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.timeseries;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import io.druid.data.input.InputRow;
import io.druid.data.input.MapBasedInputRow;
import io.druid.java.util.common.DateTimes;
import io.druid.java.util.common.Intervals;
import io.druid.java.util.common.granularity.Granularities;
import io.druid.java.util.common.guava.Sequence;
import io.druid.java.util.common.guava.Sequences;
import io.druid.query.Druids;
import io.druid.query.FinalizeResultsQueryRunner;
import io.druid.query.Query;
import io.druid.query.QueryPlus;
import io.druid.query.QueryRunner;
import io.druid.query.QueryRunnerFactory;
import io.druid.query.QueryRunnerTestHelper;
import io.druid.query.Result;
import io.druid.query.aggregation.CountAggregatorFactory;
import io.druid.query.timeseries.TimeseriesQuery;
import io.druid.query.timeseries.TimeseriesQueryEngine;
import io.druid.query.timeseries.TimeseriesQueryQueryToolChest;
import io.druid.query.timeseries.TimeseriesQueryRunnerFactory;
import io.druid.query.timeseries.TimeseriesResultValue;
import io.druid.segment.IncrementalIndexSegment;
import io.druid.segment.Segment;
import io.druid.segment.incremental.IncrementalIndex;
import io.druid.segment.incremental.IncrementalIndexSchema;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TimeseriesQueryRunnerBonusTest {
    private final boolean descending;

    @Parameterized.Parameters(name="descending={0}")
    public static Iterable<Object[]> constructorFeeder() throws IOException {
        return QueryRunnerTestHelper.transformToConstructionFeeder(Arrays.asList(false, true));
    }

    public TimeseriesQueryRunnerBonusTest(boolean descending) {
        this.descending = descending;
    }

    @Test
    public void testOneRowAtATime() throws Exception {
        IncrementalIndex oneRowIndex = new IncrementalIndex.Builder().setIndexSchema(new IncrementalIndexSchema.Builder().withMinTimestamp(DateTimes.of((String)"2012-01-01T00:00:00Z").getMillis()).build()).setMaxRowCount(1000).buildOnheap();
        oneRowIndex.add((InputRow)new MapBasedInputRow(DateTimes.of((String)"2012-01-01T00:00:00Z").getMillis(), (List)ImmutableList.of((Object)"dim1"), (Map)ImmutableMap.of((Object)"dim1", (Object)"x")));
        List<Result<TimeseriesResultValue>> results = this.runTimeseriesCount(oneRowIndex);
        Assert.assertEquals((String)"index size", (long)1L, (long)oneRowIndex.size());
        Assert.assertEquals((String)"result size", (long)1L, (long)results.size());
        Assert.assertEquals((String)"result timestamp", (Object)DateTimes.of((String)"2012-01-01T00:00:00Z"), (Object)results.get(0).getTimestamp());
        Assert.assertEquals((String)"result count metric", (long)1L, (long)((TimeseriesResultValue)results.get(0).getValue()).getLongMetric("rows"));
        oneRowIndex.add((InputRow)new MapBasedInputRow(DateTimes.of((String)"2012-01-01T00:00:00Z").getMillis(), (List)ImmutableList.of((Object)"dim1"), (Map)ImmutableMap.of((Object)"dim1", (Object)"y")));
        results = this.runTimeseriesCount(oneRowIndex);
        Assert.assertEquals((String)"index size", (long)2L, (long)oneRowIndex.size());
        Assert.assertEquals((String)"result size", (long)1L, (long)results.size());
        Assert.assertEquals((String)"result timestamp", (Object)DateTimes.of((String)"2012-01-01T00:00:00Z"), (Object)results.get(0).getTimestamp());
        Assert.assertEquals((String)"result count metric", (long)2L, (long)((TimeseriesResultValue)results.get(0).getValue()).getLongMetric("rows"));
    }

    private List<Result<TimeseriesResultValue>> runTimeseriesCount(IncrementalIndex index) {
        TimeseriesQueryRunnerFactory factory = new TimeseriesQueryRunnerFactory(new TimeseriesQueryQueryToolChest(QueryRunnerTestHelper.NoopIntervalChunkingQueryRunnerDecorator()), new TimeseriesQueryEngine(), QueryRunnerTestHelper.NOOP_QUERYWATCHER);
        QueryRunner runner = TimeseriesQueryRunnerBonusTest.makeQueryRunner(factory, (Segment)new IncrementalIndexSegment(index, null));
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("xxx").granularity(Granularities.ALL).intervals((List)ImmutableList.of((Object)Intervals.of((String)"2012-01-01T00:00:00Z/P1D"))).aggregators((List)ImmutableList.of((Object)new CountAggregatorFactory("rows"))).descending(this.descending).build();
        HashMap context = new HashMap();
        return Sequences.toList((Sequence)runner.run(QueryPlus.wrap((Query)query), context), (List)Lists.newArrayList());
    }

    private static <T> QueryRunner<T> makeQueryRunner(QueryRunnerFactory<T, Query<T>> factory, Segment adapter) {
        return new FinalizeResultsQueryRunner(factory.createRunner(adapter), factory.getToolchest());
    }
}

