/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.topn;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import io.druid.query.Query;
import io.druid.query.QueryRunnerTestHelper;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.DoubleMaxAggregatorFactory;
import io.druid.query.aggregation.DoubleMinAggregatorFactory;
import io.druid.query.aggregation.SimpleDoubleAggregatorFactory;
import io.druid.query.dimension.DimensionSpec;
import io.druid.query.dimension.ExtractionDimensionSpec;
import io.druid.query.dimension.LegacyDimensionSpec;
import io.druid.query.extraction.ExtractionFn;
import io.druid.query.extraction.MapLookupExtractor;
import io.druid.query.lookup.LookupExtractionFn;
import io.druid.query.lookup.LookupExtractor;
import io.druid.query.ordering.StringComparators;
import io.druid.query.topn.DimensionTopNMetricSpec;
import io.druid.query.topn.NumericTopNMetricSpec;
import io.druid.query.topn.TopNMetricSpec;
import io.druid.query.topn.TopNQuery;
import io.druid.query.topn.TopNQueryBuilder;
import io.druid.segment.TestHelper;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class TopNQueryTest {
    private static final ObjectMapper jsonMapper = TestHelper.makeJsonMapper();

    @Test
    public void testQuerySerialization() throws IOException {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).dimension("market").metric("index").threshold(4).intervals(QueryRunnerTestHelper.fullOnInterval).aggregators((List)Lists.newArrayList((Iterable)Iterables.concat(QueryRunnerTestHelper.commonDoubleAggregators, (Iterable)Lists.newArrayList((Object[])new SimpleDoubleAggregatorFactory[]{new DoubleMaxAggregatorFactory("maxIndex", "index"), new DoubleMinAggregatorFactory("minIndex", "index")})))).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        String json = jsonMapper.writeValueAsString((Object)query);
        Query serdeQuery = (Query)jsonMapper.readValue(json, Query.class);
        Assert.assertEquals((Object)query, (Object)serdeQuery);
    }

    @Test
    public void testQuerySerdeWithLookupExtractionFn() throws IOException {
        TopNQuery expectedQuery = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).dimension((DimensionSpec)new ExtractionDimensionSpec("market", "market", (ExtractionFn)new LookupExtractionFn((LookupExtractor)new MapLookupExtractor((Map)ImmutableMap.of((Object)"foo", (Object)"bar"), false), true, null, Boolean.valueOf(false), Boolean.valueOf(false)))).metric((TopNMetricSpec)new NumericTopNMetricSpec("index")).threshold(2).intervals(QueryRunnerTestHelper.fullOnInterval.getIntervals()).aggregators((List)Lists.newArrayList((Iterable)Iterables.concat(QueryRunnerTestHelper.commonDoubleAggregators, (Iterable)Lists.newArrayList((Object[])new SimpleDoubleAggregatorFactory[]{new DoubleMaxAggregatorFactory("maxIndex", "index"), new DoubleMinAggregatorFactory("minIndex", "index")})))).build();
        String str = jsonMapper.writeValueAsString((Object)expectedQuery);
        Assert.assertEquals((Object)expectedQuery, (Object)jsonMapper.readValue(str, TopNQuery.class));
    }

    @Test
    public void testQuerySerdeWithAlphaNumericTopNMetricSpec() throws IOException {
        TopNQuery expectedQuery = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).dimension((DimensionSpec)new LegacyDimensionSpec((Object)"market")).metric((TopNMetricSpec)new DimensionTopNMetricSpec(null, StringComparators.ALPHANUMERIC)).threshold(2).intervals(QueryRunnerTestHelper.fullOnInterval.getIntervals()).aggregators((List)Lists.newArrayList((Object[])new AggregatorFactory[]{QueryRunnerTestHelper.rowsCount})).build();
        String jsonQuery = "{\n  \"queryType\": \"topN\",\n  \"dataSource\": \"testing\",\n  \"dimension\": \"market\",\n  \"threshold\": 2,\n  \"metric\": {\n    \"type\": \"dimension\",\n    \"ordering\": \"alphanumeric\"\n   },\n  \"granularity\": \"all\",\n  \"aggregations\": [\n    {\n      \"type\": \"count\",\n      \"name\": \"rows\"\n    }\n  ],\n  \"intervals\": [\n    \"1970-01-01T00:00:00.000Z/2020-01-01T00:00:00.000Z\"\n  ]\n}";
        TopNQuery actualQuery = (TopNQuery)jsonMapper.readValue(jsonMapper.writeValueAsString(jsonMapper.readValue(jsonQuery, TopNQuery.class)), TopNQuery.class);
        Assert.assertEquals((Object)expectedQuery, (Object)actualQuery);
    }
}

