/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment;

import com.google.common.util.concurrent.Runnables;
import io.druid.segment.CloserRule;
import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class CloserRuleTest {
    @Rule
    public final ExpectedException expectedException = ExpectedException.none();

    @Test
    public void testCloses() throws Throwable {
        CloserRule closer = new CloserRule(false);
        final AtomicBoolean closed = new AtomicBoolean(false);
        closer.closeLater(new Closeable(){

            @Override
            public void close() throws IOException {
                closed.set(true);
            }
        });
        this.run(closer, Runnables.doNothing());
        Assert.assertTrue((boolean)closed.get());
    }

    @Test
    public void testPreservesException() throws Throwable {
        CloserRule closer = new CloserRule(false);
        final AtomicBoolean closed = new AtomicBoolean(false);
        closer.closeLater(new Closeable(){

            @Override
            public void close() throws IOException {
                closed.set(true);
            }
        });
        String msg = "You can't divide by zero, you can only take the limit of such!";
        Exception ex = null;
        try {
            this.run(closer, new Runnable(){

                @Override
                public void run() {
                    throw new ArithmeticException("You can't divide by zero, you can only take the limit of such!");
                }
            });
        }
        catch (Exception e) {
            ex = e;
        }
        Assert.assertTrue((boolean)closed.get());
        Assert.assertNotNull((Object)ex);
        Assert.assertTrue((boolean)(ex instanceof ArithmeticException));
        Assert.assertEquals((Object)"You can't divide by zero, you can only take the limit of such!", (Object)ex.getMessage());
    }

    @Test
    public void testSuppressed() throws Throwable {
        CloserRule closer = new CloserRule(true);
        final AtomicBoolean closed = new AtomicBoolean(false);
        String ioExceptionMsg = "You can't triple stamp a double stamp!";
        final IOException suppressed = new IOException("You can't triple stamp a double stamp!");
        closer.closeLater(new Closeable(){

            @Override
            public void close() throws IOException {
                throw suppressed;
            }
        });
        closer.closeLater(new Closeable(){

            @Override
            public void close() throws IOException {
                closed.set(true);
            }
        });
        String msg = "You can't divide by zero, you can only take the limit of such!";
        final ArithmeticException arithmeticException = new ArithmeticException("You can't divide by zero, you can only take the limit of such!");
        Throwable ex = null;
        try {
            this.run(closer, new Runnable(){

                @Override
                public void run() {
                    throw arithmeticException;
                }
            });
        }
        catch (Throwable e) {
            ex = e;
        }
        Assert.assertEquals((Object)arithmeticException, (Object)ex);
        Assert.assertNotNull((Object)ex);
        Assert.assertNotNull((Object)ex.getSuppressed());
        Assert.assertEquals((Object)suppressed, (Object)ex.getSuppressed()[0]);
    }

    @Test
    public void testThrowsCloseException() {
        CloserRule closer = new CloserRule(true);
        String ioExceptionMsg = "You can't triple stamp a double stamp!";
        final IOException ioException = new IOException("You can't triple stamp a double stamp!");
        closer.closeLater(new Closeable(){

            @Override
            public void close() throws IOException {
                throw ioException;
            }
        });
        Throwable ex = null;
        try {
            this.run(closer, Runnables.doNothing());
        }
        catch (Throwable throwable) {
            ex = throwable;
        }
        Assert.assertEquals((Object)ioException, (Object)ex);
    }

    @Test
    public void testJustLogs() throws Throwable {
        CloserRule closer = new CloserRule(false);
        String ioExceptionMsg = "You can't triple stamp a double stamp!";
        closer.closeLater(new Closeable(){

            @Override
            public void close() throws IOException {
                throw new IOException("You can't triple stamp a double stamp!");
            }
        });
        this.run(closer, Runnables.doNothing());
    }

    @Test
    public void testJustLogsAnything() throws Throwable {
        CloserRule closer = new CloserRule(false);
        String ioExceptionMsg = "You can't triple stamp a double stamp!";
        closer.closeLater(new Closeable(){

            @Override
            public void close() throws IOException {
                throw new IOException("You can't triple stamp a double stamp!");
            }
        });
        closer.closeLater(new Closeable(){

            @Override
            public void close() throws IOException {
                throw new IOException("You can't triple stamp a double stamp!");
            }
        });
        closer.closeLater(new Closeable(){

            @Override
            public void close() throws IOException {
                throw new IOException("You can't triple stamp a double stamp!");
            }
        });
        this.run(closer, Runnables.doNothing());
    }

    @Test
    public void testClosesEverything() {
        final AtomicLong counter = new AtomicLong(0L);
        CloserRule closer = new CloserRule(true);
        String ioExceptionMsg = "You can't triple stamp a double stamp!";
        List<IOException> ioExceptions = Arrays.asList(new IOException("You can't triple stamp a double stamp!"), null, new IOException("You can't triple stamp a double stamp!"), null, new IOException("You can't triple stamp a double stamp!"), null);
        for (final IOException throwable : ioExceptions) {
            closer.closeLater(new Closeable(){

                @Override
                public void close() throws IOException {
                    counter.incrementAndGet();
                    if (throwable != null) {
                        throw throwable;
                    }
                }
            });
        }
        Throwable ex = null;
        try {
            this.run(closer, Runnables.doNothing());
        }
        catch (Throwable throwable) {
            ex = throwable;
        }
        Assert.assertNotNull((Object)ex);
        Assert.assertEquals((long)ioExceptions.size(), (long)counter.get());
        Assert.assertEquals((long)2L, (long)ex.getSuppressed().length);
    }

    private void run(CloserRule closer, final Runnable runnable) throws Throwable {
        closer.apply(new Statement(){

            public void evaluate() throws Throwable {
                runnable.run();
            }
        }, Description.createTestDescription((String)CloserRuleTest.class.getCanonicalName(), (String)"baseRunner", (Serializable)UUID.randomUUID())).evaluate();
    }
}

