/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import io.druid.collections.bitmap.BitmapFactory;
import io.druid.collections.bitmap.ConciseBitmapFactory;
import io.druid.java.util.common.Intervals;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.segment.IndexSpec;
import io.druid.segment.IndexableAdapter;
import io.druid.segment.QueryableIndex;
import io.druid.segment.TestHelper;
import io.druid.segment.incremental.IncrementalIndex;
import io.druid.segment.incremental.IncrementalIndexAdapter;
import io.druid.segment.writeout.OffHeapMemorySegmentWriteOutMediumFactory;
import io.druid.segment.writeout.SegmentWriteOutMediumFactory;
import io.druid.segment.writeout.TmpFileSegmentWriteOutMediumFactory;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class EmptyIndexTest {
    private final SegmentWriteOutMediumFactory segmentWriteOutMediumFactory;

    @Parameterized.Parameters
    public static Collection<?> constructorFeeder() throws IOException {
        return ImmutableList.of((Object)new Object[]{TmpFileSegmentWriteOutMediumFactory.instance()}, (Object)new Object[]{OffHeapMemorySegmentWriteOutMediumFactory.instance()});
    }

    public EmptyIndexTest(SegmentWriteOutMediumFactory segmentWriteOutMediumFactory) {
        this.segmentWriteOutMediumFactory = segmentWriteOutMediumFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEmptyIndex() throws Exception {
        File tmpDir = File.createTempFile("emptyIndex", "");
        if (!tmpDir.delete()) {
            throw new IllegalStateException("tmp delete failed");
        }
        if (!tmpDir.mkdir()) {
            throw new IllegalStateException("tmp mkdir failed");
        }
        try {
            IncrementalIndex emptyIndex = new IncrementalIndex.Builder().setSimpleTestingIndexSchema(new AggregatorFactory[0]).setMaxRowCount(1000).buildOnheap();
            IncrementalIndexAdapter emptyIndexAdapter = new IncrementalIndexAdapter(Intervals.of((String)"2012-08-01/P3D"), emptyIndex, (BitmapFactory)new ConciseBitmapFactory());
            TestHelper.getTestIndexMergerV9(this.segmentWriteOutMediumFactory).merge((List)Lists.newArrayList((Object[])new IndexableAdapter[]{emptyIndexAdapter}), true, new AggregatorFactory[0], tmpDir, new IndexSpec());
            QueryableIndex emptyQueryableIndex = TestHelper.getTestIndexIO(this.segmentWriteOutMediumFactory).loadIndex(tmpDir);
            Assert.assertEquals((String)"getDimensionNames", (long)0L, (long)Iterables.size((Iterable)emptyQueryableIndex.getAvailableDimensions()));
            Assert.assertEquals((String)"getMetricNames", (long)0L, (long)Iterables.size((Iterable)emptyQueryableIndex.getColumnNames()));
            Assert.assertEquals((String)"getDataInterval", (Object)Intervals.of((String)"2012-08-01/P3D"), (Object)emptyQueryableIndex.getDataInterval());
            Assert.assertEquals((String)"getReadOnlyTimestamps", (long)0L, (long)emptyQueryableIndex.getColumn("__time").getLength());
        }
        finally {
            FileUtils.deleteDirectory((File)tmpDir);
        }
    }
}

