/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.data;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import io.druid.java.util.common.guava.CloseQuietly;
import io.druid.java.util.common.io.Closer;
import io.druid.java.util.common.io.smoosh.FileSmoosher;
import io.druid.java.util.common.io.smoosh.Smoosh;
import io.druid.java.util.common.io.smoosh.SmooshedFileMapper;
import io.druid.java.util.common.io.smoosh.SmooshedWriter;
import io.druid.segment.data.ColumnarInts;
import io.druid.segment.data.CompressedVSizeColumnarIntsSerializer;
import io.druid.segment.data.CompressedVSizeColumnarIntsSupplier;
import io.druid.segment.data.CompressionStrategy;
import io.druid.segment.data.GenericIndexedWriter;
import io.druid.segment.writeout.OffHeapMemorySegmentWriteOutMedium;
import io.druid.segment.writeout.SegmentWriteOutMedium;
import io.druid.segment.writeout.WriteOutBytes;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class CompressedVSizeColumnarIntsSerializerTest {
    private static final int[] MAX_VALUES = new int[]{255, 65535, 0xFFFFFF, 0xFFFFFFF};
    private final SegmentWriteOutMedium segmentWriteOutMedium = new OffHeapMemorySegmentWriteOutMedium();
    private final CompressionStrategy compressionStrategy;
    private final ByteOrder byteOrder;
    private final Random rand = new Random(0L);
    private int[] vals;

    public CompressedVSizeColumnarIntsSerializerTest(CompressionStrategy compressionStrategy, ByteOrder byteOrder) {
        this.compressionStrategy = compressionStrategy;
        this.byteOrder = byteOrder;
    }

    @Parameterized.Parameters(name="{index}: compression={0}, byteOrder={1}")
    public static Iterable<Object[]> compressionStrategiesAndByteOrders() {
        Set combinations = Sets.cartesianProduct((Set[])new Set[]{Sets.newHashSet((Object[])CompressionStrategy.noNoneValues()), Sets.newHashSet((Object[])new ByteOrder[]{ByteOrder.BIG_ENDIAN, ByteOrder.LITTLE_ENDIAN})});
        return Iterables.transform((Iterable)combinations, (Function)new Function<List, Object[]>(){

            public Object[] apply(List input) {
                return new Object[]{input.get(0), input.get(1)};
            }
        });
    }

    @Before
    public void setUp() throws Exception {
        this.vals = null;
    }

    @After
    public void tearDown() throws Exception {
        this.segmentWriteOutMedium.close();
    }

    private void generateVals(int totalSize, int maxValue) throws IOException {
        this.vals = new int[totalSize];
        for (int i = 0; i < this.vals.length; ++i) {
            this.vals[i] = this.rand.nextInt(maxValue);
        }
    }

    private void checkSerializedSizeAndData(int chunkSize) throws Exception {
        FileSmoosher smoosher = new FileSmoosher(FileUtils.getTempDirectory());
        CompressedVSizeColumnarIntsSerializer writer = new CompressedVSizeColumnarIntsSerializer(this.segmentWriteOutMedium, "test", this.vals.length > 0 ? Ints.max((int[])this.vals) : 0, chunkSize, this.byteOrder, this.compressionStrategy);
        CompressedVSizeColumnarIntsSupplier supplierFromList = CompressedVSizeColumnarIntsSupplier.fromList((IntList)IntArrayList.wrap((int[])this.vals), (int)(this.vals.length > 0 ? Ints.max((int[])this.vals) : 0), (int)chunkSize, (ByteOrder)this.byteOrder, (CompressionStrategy)this.compressionStrategy, (Closer)this.segmentWriteOutMedium.getCloser());
        writer.open();
        for (int val : this.vals) {
            writer.add((Object)val);
        }
        long writtenLength = writer.getSerializedSize();
        WriteOutBytes writeOutBytes = this.segmentWriteOutMedium.makeWriteOutBytes();
        writer.writeTo((WritableByteChannel)writeOutBytes, smoosher);
        smoosher.close();
        Assert.assertEquals((long)writtenLength, (long)supplierFromList.getSerializedSize());
        CompressedVSizeColumnarIntsSupplier supplierFromByteBuffer = CompressedVSizeColumnarIntsSupplier.fromByteBuffer((ByteBuffer)ByteBuffer.wrap(IOUtils.toByteArray((InputStream)writeOutBytes.asInputStream())), (ByteOrder)this.byteOrder);
        ColumnarInts columnarInts = supplierFromByteBuffer.get();
        for (int i = 0; i < this.vals.length; ++i) {
            Assert.assertEquals((long)this.vals[i], (long)columnarInts.get(i));
        }
        CloseQuietly.close((Closeable)columnarInts);
    }

    @Test
    public void testSmallData() throws Exception {
        for (int maxValue : MAX_VALUES) {
            int maxChunkSize = CompressedVSizeColumnarIntsSupplier.maxIntsInBufferForValue((int)maxValue);
            this.generateVals(this.rand.nextInt(maxChunkSize), maxValue);
            this.checkSerializedSizeAndData(maxChunkSize);
        }
    }

    @Test
    public void testLargeData() throws Exception {
        for (int maxValue : MAX_VALUES) {
            int maxChunkSize = CompressedVSizeColumnarIntsSupplier.maxIntsInBufferForValue((int)maxValue);
            this.generateVals((this.rand.nextInt(5) + 5) * maxChunkSize + this.rand.nextInt(maxChunkSize), maxValue);
            this.checkSerializedSizeAndData(maxChunkSize);
        }
    }

    @Test
    public void testEmpty() throws Exception {
        this.vals = new int[0];
        this.checkSerializedSizeAndData(2);
    }

    private void checkV2SerializedSizeAndData(int chunkSize) throws Exception {
        File tmpDirectory = FileUtils.getTempDirectory();
        FileSmoosher smoosher = new FileSmoosher(tmpDirectory);
        GenericIndexedWriter genericIndexed = GenericIndexedWriter.ofCompressedByteBuffers((SegmentWriteOutMedium)this.segmentWriteOutMedium, (String)"test", (CompressionStrategy)this.compressionStrategy, (int)80000);
        CompressedVSizeColumnarIntsSerializer writer = new CompressedVSizeColumnarIntsSerializer(this.segmentWriteOutMedium, this.vals.length > 0 ? Ints.max((int[])this.vals) : 0, chunkSize, this.byteOrder, this.compressionStrategy, genericIndexed);
        writer.open();
        for (int val : this.vals) {
            writer.add((Object)val);
        }
        SmooshedWriter channel = smoosher.addWithSmooshedWriter("test", writer.getSerializedSize());
        writer.writeTo((WritableByteChannel)channel, smoosher);
        channel.close();
        smoosher.close();
        SmooshedFileMapper mapper = Smoosh.map((File)tmpDirectory);
        CompressedVSizeColumnarIntsSupplier supplierFromByteBuffer = CompressedVSizeColumnarIntsSupplier.fromByteBuffer((ByteBuffer)mapper.mapFile("test"), (ByteOrder)this.byteOrder);
        ColumnarInts columnarInts = supplierFromByteBuffer.get();
        for (int i = 0; i < this.vals.length; ++i) {
            Assert.assertEquals((long)this.vals[i], (long)columnarInts.get(i));
        }
        CloseQuietly.close((Closeable)columnarInts);
        mapper.close();
    }

    @Test
    public void testMultiValueFileLargeData() throws Exception {
        for (int maxValue : MAX_VALUES) {
            int maxChunkSize = CompressedVSizeColumnarIntsSupplier.maxIntsInBufferForValue((int)maxValue);
            this.generateVals((this.rand.nextInt(5) + 5) * maxChunkSize + this.rand.nextInt(maxChunkSize), maxValue);
            this.checkV2SerializedSizeAndData(maxChunkSize);
        }
    }
}

