/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.data;

import io.druid.segment.data.GenericIndexed;
import io.druid.segment.data.GenericIndexedWriter;
import io.druid.segment.writeout.OnHeapMemorySegmentWriteOutMedium;
import io.druid.segment.writeout.SegmentWriteOutMedium;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.concurrent.ThreadLocalRandom;
import org.junit.Assert;
import org.junit.Test;

public class GenericIndexedStringWriterTest {
    @Test
    public void testRandomAccess() throws IOException {
        int i;
        OnHeapMemorySegmentWriteOutMedium segmentWriteOutMedium = new OnHeapMemorySegmentWriteOutMedium();
        GenericIndexedWriter writer = new GenericIndexedWriter((SegmentWriteOutMedium)segmentWriteOutMedium, "test", GenericIndexed.STRING_STRATEGY);
        writer.open();
        writer.write(null);
        ArrayList<String> strings = new ArrayList<String>();
        strings.add(null);
        ThreadLocalRandom r = ThreadLocalRandom.current();
        for (i = 0; i < 100000; ++i) {
            byte[] bs = new byte[r.nextInt(1, 10)];
            r.nextBytes(bs);
            String s = new String(bs, StandardCharsets.US_ASCII);
            strings.add(s);
            writer.write((Object)s);
        }
        for (i = 0; i < strings.size(); ++i) {
            Assert.assertEquals(strings.get(i), (Object)writer.get(i));
        }
    }
}

