/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.filter;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.druid.data.input.InputRow;
import io.druid.data.input.impl.DimensionsSpec;
import io.druid.data.input.impl.InputRowParser;
import io.druid.data.input.impl.MapInputRowParser;
import io.druid.data.input.impl.ParseSpec;
import io.druid.data.input.impl.TimeAndDimsParseSpec;
import io.druid.data.input.impl.TimestampSpec;
import io.druid.java.util.common.DateTimes;
import io.druid.java.util.common.Pair;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.CountAggregatorFactory;
import io.druid.query.aggregation.DoubleMaxAggregatorFactory;
import io.druid.query.aggregation.hyperloglog.HyperUniquesAggregatorFactory;
import io.druid.query.filter.DimFilter;
import io.druid.query.filter.InDimFilter;
import io.druid.query.filter.SelectorDimFilter;
import io.druid.segment.IndexBuilder;
import io.druid.segment.StorageAdapter;
import io.druid.segment.filter.BaseFilterTest;
import io.druid.segment.incremental.IncrementalIndexSchema;
import java.io.Closeable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.junit.AfterClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class InvalidFilteringTest
extends BaseFilterTest {
    private static final String TIMESTAMP_COLUMN = "ts";
    private static final InputRowParser<Map<String, Object>> PARSER = new MapInputRowParser((ParseSpec)new TimeAndDimsParseSpec(new TimestampSpec("ts", "millis", DateTimes.of((String)"2000")), new DimensionsSpec(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"dim0", (Object)"dim1", (Object)"dim2", (Object)"dim3")), null, null)));
    private static final InputRow row0 = (InputRow)PARSER.parseBatch((Object)ImmutableMap.of((Object)"ts", (Object)1L, (Object)"dim0", (Object)"1", (Object)"dim1", (Object)"", (Object)"dim2", (Object)ImmutableList.of((Object)"a", (Object)"b"))).get(0);
    private static final InputRow row1 = (InputRow)PARSER.parseBatch((Object)ImmutableMap.of((Object)"ts", (Object)2L, (Object)"dim0", (Object)"2", (Object)"dim1", (Object)"10", (Object)"dim2", (Object)ImmutableList.of())).get(0);
    private static final InputRow row2 = (InputRow)PARSER.parseBatch((Object)ImmutableMap.of((Object)"ts", (Object)3L, (Object)"dim0", (Object)"3", (Object)"dim1", (Object)"2", (Object)"dim2", (Object)ImmutableList.of((Object)""))).get(0);
    private static final InputRow row3 = (InputRow)PARSER.parseBatch((Object)ImmutableMap.of((Object)"ts", (Object)4L, (Object)"dim0", (Object)"4", (Object)"dim1", (Object)"1", (Object)"dim2", (Object)ImmutableList.of((Object)"a"))).get(0);
    private static final InputRow row4 = (InputRow)PARSER.parseBatch((Object)ImmutableMap.of((Object)"ts", (Object)5L, (Object)"dim0", (Object)"5", (Object)"dim1", (Object)"def", (Object)"dim2", (Object)ImmutableList.of((Object)"c"))).get(0);
    private static final InputRow row5 = (InputRow)PARSER.parseBatch((Object)ImmutableMap.of((Object)"ts", (Object)6L, (Object)"dim0", (Object)"6", (Object)"dim1", (Object)"abc")).get(0);
    private static final List<InputRow> ROWS = ImmutableList.of((Object)row0, (Object)row1, (Object)row2, (Object)row3, (Object)row4, (Object)row5);

    public InvalidFilteringTest(String testName, IndexBuilder indexBuilder, Function<IndexBuilder, Pair<StorageAdapter, Closeable>> finisher, boolean cnf, boolean optimize) {
        super(testName, ROWS, InvalidFilteringTest.overrideIndexBuilderSchema(indexBuilder), finisher, cnf, optimize);
    }

    private static IndexBuilder overrideIndexBuilderSchema(IndexBuilder indexBuilder) {
        IncrementalIndexSchema schema = new IncrementalIndexSchema.Builder().withMetrics(new AggregatorFactory[]{new CountAggregatorFactory("count"), new HyperUniquesAggregatorFactory("hyperion", "dim1"), new DoubleMaxAggregatorFactory("dmax", "dim0")}).build();
        return indexBuilder.schema(schema);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        BaseFilterTest.tearDown(InvalidFilteringTest.class.getName());
    }

    @Test
    public void testFilterTheUnfilterable() {
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("hyperion", "a string", null), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("hyperion", null, null), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6"));
        this.assertFilterMatches((DimFilter)new InDimFilter("hyperion", Arrays.asList("hello", "world"), null), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new InDimFilter("hyperion", Arrays.asList("hello", "world", null), null), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6"));
    }
}

