/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.filter;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.druid.data.input.InputRow;
import io.druid.data.input.impl.DimensionsSpec;
import io.druid.data.input.impl.InputRowParser;
import io.druid.data.input.impl.MapInputRowParser;
import io.druid.data.input.impl.ParseSpec;
import io.druid.data.input.impl.TimeAndDimsParseSpec;
import io.druid.data.input.impl.TimestampSpec;
import io.druid.java.util.common.DateTimes;
import io.druid.java.util.common.Pair;
import io.druid.js.JavaScriptConfig;
import io.druid.query.extraction.ExtractionFn;
import io.druid.query.extraction.JavaScriptExtractionFn;
import io.druid.query.filter.DimFilter;
import io.druid.query.filter.RegexDimFilter;
import io.druid.segment.IndexBuilder;
import io.druid.segment.StorageAdapter;
import io.druid.segment.filter.BaseFilterTest;
import java.io.Closeable;
import java.util.List;
import java.util.Map;
import org.junit.AfterClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class RegexFilterTest
extends BaseFilterTest {
    private static final String TIMESTAMP_COLUMN = "timestamp";
    private static final InputRowParser<Map<String, Object>> PARSER = new MapInputRowParser((ParseSpec)new TimeAndDimsParseSpec(new TimestampSpec("timestamp", "iso", DateTimes.of((String)"2000")), new DimensionsSpec(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"dim0", (Object)"dim1", (Object)"dim2", (Object)"dim3")), null, null)));
    private static final List<InputRow> ROWS = ImmutableList.of(PARSER.parseBatch((Object)ImmutableMap.of((Object)"dim0", (Object)"0", (Object)"dim1", (Object)"", (Object)"dim2", (Object)ImmutableList.of((Object)"a", (Object)"b"))).get(0), PARSER.parseBatch((Object)ImmutableMap.of((Object)"dim0", (Object)"1", (Object)"dim1", (Object)"10", (Object)"dim2", (Object)ImmutableList.of())).get(0), PARSER.parseBatch((Object)ImmutableMap.of((Object)"dim0", (Object)"2", (Object)"dim1", (Object)"2", (Object)"dim2", (Object)ImmutableList.of((Object)""))).get(0), PARSER.parseBatch((Object)ImmutableMap.of((Object)"dim0", (Object)"3", (Object)"dim1", (Object)"1", (Object)"dim2", (Object)ImmutableList.of((Object)"a"))).get(0), PARSER.parseBatch((Object)ImmutableMap.of((Object)"dim0", (Object)"4", (Object)"dim1", (Object)"abdef", (Object)"dim2", (Object)ImmutableList.of((Object)"c"))).get(0), PARSER.parseBatch((Object)ImmutableMap.of((Object)"dim0", (Object)"5", (Object)"dim1", (Object)"abc")).get(0));

    public RegexFilterTest(String testName, IndexBuilder indexBuilder, Function<IndexBuilder, Pair<StorageAdapter, Closeable>> finisher, boolean cnf, boolean optimize) {
        super(testName, ROWS, indexBuilder, finisher, cnf, optimize);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        BaseFilterTest.tearDown(RegexFilterTest.class.getName());
    }

    @Test
    public void testSingleValueStringColumnWithoutNulls() {
        this.assertFilterMatches((DimFilter)new RegexDimFilter("dim0", ".*", null), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
        this.assertFilterMatches((DimFilter)new RegexDimFilter("dim0", "0", null), (List<String>)ImmutableList.of((Object)"0"));
        this.assertFilterMatches((DimFilter)new RegexDimFilter("dim0", "5", null), (List<String>)ImmutableList.of((Object)"5"));
    }

    @Test
    public void testSingleValueStringColumnWithNulls() {
        this.assertFilterMatches((DimFilter)new RegexDimFilter("dim1", ".*", null), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
        this.assertFilterMatches((DimFilter)new RegexDimFilter("dim1", "10", null), (List<String>)ImmutableList.of((Object)"1"));
        this.assertFilterMatches((DimFilter)new RegexDimFilter("dim1", "2", null), (List<String>)ImmutableList.of((Object)"2"));
        this.assertFilterMatches((DimFilter)new RegexDimFilter("dim1", "1", null), (List<String>)ImmutableList.of((Object)"1", (Object)"3"));
        this.assertFilterMatches((DimFilter)new RegexDimFilter("dim1", ".*def", null), (List<String>)ImmutableList.of((Object)"4"));
        this.assertFilterMatches((DimFilter)new RegexDimFilter("dim1", "abc", null), (List<String>)ImmutableList.of((Object)"5"));
        this.assertFilterMatches((DimFilter)new RegexDimFilter("dim1", "ab.*", null), (List<String>)ImmutableList.of((Object)"4", (Object)"5"));
    }

    @Test
    public void testMultiValueStringColumn() {
        this.assertFilterMatches((DimFilter)new RegexDimFilter("dim2", ".*", null), (List<String>)ImmutableList.of((Object)"0", (Object)"3", (Object)"4"));
        this.assertFilterMatches((DimFilter)new RegexDimFilter("dim2", "a", null), (List<String>)ImmutableList.of((Object)"0", (Object)"3"));
        this.assertFilterMatches((DimFilter)new RegexDimFilter("dim2", "b", null), (List<String>)ImmutableList.of((Object)"0"));
        this.assertFilterMatches((DimFilter)new RegexDimFilter("dim2", "c", null), (List<String>)ImmutableList.of((Object)"4"));
        this.assertFilterMatches((DimFilter)new RegexDimFilter("dim2", "d", null), (List<String>)ImmutableList.of());
    }

    @Test
    public void testMissingColumnSpecifiedInDimensionList() {
        this.assertFilterMatches((DimFilter)new RegexDimFilter("dim3", "", null), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new RegexDimFilter("dim3", "a", null), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new RegexDimFilter("dim3", "b", null), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new RegexDimFilter("dim3", "c", null), (List<String>)ImmutableList.of());
    }

    @Test
    public void testMissingColumnNotSpecifiedInDimensionList() {
        this.assertFilterMatches((DimFilter)new RegexDimFilter("dim4", "", null), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new RegexDimFilter("dim4", "a", null), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new RegexDimFilter("dim4", "b", null), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new RegexDimFilter("dim4", "c", null), (List<String>)ImmutableList.of());
    }

    @Test
    public void testRegexWithExtractionFn() {
        String nullJsFn = "function(str) { if (str === null) { return 'NOT_NULL_ANYMORE'; } else { return str;} }";
        JavaScriptExtractionFn changeNullFn = new JavaScriptExtractionFn(nullJsFn, false, JavaScriptConfig.getEnabledInstance());
        this.assertFilterMatches((DimFilter)new RegexDimFilter("dim1", ".*ANYMORE", (ExtractionFn)changeNullFn), (List<String>)ImmutableList.of((Object)"0"));
        this.assertFilterMatches((DimFilter)new RegexDimFilter("dim1", "ab.*", (ExtractionFn)changeNullFn), (List<String>)ImmutableList.of((Object)"4", (Object)"5"));
        this.assertFilterMatches((DimFilter)new RegexDimFilter("dim2", ".*ANYMORE", (ExtractionFn)changeNullFn), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"5"));
        this.assertFilterMatches((DimFilter)new RegexDimFilter("dim2", "a.*", (ExtractionFn)changeNullFn), (List<String>)ImmutableList.of((Object)"0", (Object)"3"));
        this.assertFilterMatches((DimFilter)new RegexDimFilter("dim3", ".*ANYMORE", (ExtractionFn)changeNullFn), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
        this.assertFilterMatches((DimFilter)new RegexDimFilter("dim3", "a.*", (ExtractionFn)changeNullFn), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new RegexDimFilter("dim4", ".*ANYMORE", (ExtractionFn)changeNullFn), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
        this.assertFilterMatches((DimFilter)new RegexDimFilter("dim4", "a.*", (ExtractionFn)changeNullFn), (List<String>)ImmutableList.of());
    }
}

