/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.incremental;

import io.druid.segment.IndexSpec;
import io.druid.segment.Rowboat;
import io.druid.segment.data.BitmapSerdeFactory;
import io.druid.segment.data.BitmapValues;
import io.druid.segment.data.CompressionFactory;
import io.druid.segment.data.CompressionStrategy;
import io.druid.segment.data.ConciseBitmapSerdeFactory;
import io.druid.segment.data.IncrementalIndexTest;
import io.druid.segment.incremental.IncrementalIndex;
import io.druid.segment.incremental.IncrementalIndexAdapter;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;

public class IncrementalIndexAdapterTest {
    private static final IndexSpec INDEX_SPEC = new IndexSpec((BitmapSerdeFactory)new ConciseBitmapSerdeFactory(), CompressionStrategy.LZ4, CompressionStrategy.LZ4, CompressionFactory.LongEncodingStrategy.LONGS);

    @Test
    public void testGetBitmapIndex() throws Exception {
        long timestamp = System.currentTimeMillis();
        IncrementalIndex incrementalIndex = IncrementalIndexTest.createIndex(null);
        IncrementalIndexTest.populateIndex(timestamp, incrementalIndex);
        IncrementalIndexAdapter adapter = new IncrementalIndexAdapter(incrementalIndex.getInterval(), incrementalIndex, INDEX_SPEC.getBitmapSerdeFactory().getBitmapFactory());
        String dimension = "dim1";
        for (int i = 0; i < adapter.getDimValueLookup(dimension).size(); ++i) {
            BitmapValues bitmapValues = adapter.getBitmapValues(dimension, i);
            Assert.assertEquals((long)1L, (long)bitmapValues.size());
        }
    }

    @Test
    public void testGetRowsIterable() throws Exception {
        long timestamp = System.currentTimeMillis();
        IncrementalIndex toPersist1 = IncrementalIndexTest.createIndex(null);
        IncrementalIndexTest.populateIndex(timestamp, toPersist1);
        IncrementalIndexAdapter incrementalAdapter = new IncrementalIndexAdapter(toPersist1.getInterval(), toPersist1, INDEX_SPEC.getBitmapSerdeFactory().getBitmapFactory());
        Iterable boats = incrementalAdapter.getRows();
        ArrayList<Rowboat> boatList = new ArrayList<Rowboat>();
        for (Rowboat boat : boats) {
            boatList.add(boat);
        }
        Assert.assertEquals((long)2L, (long)boatList.size());
        Assert.assertEquals((long)0L, (long)((Rowboat)boatList.get(0)).getRowNum());
        Assert.assertEquals((long)1L, (long)((Rowboat)boatList.get(1)).getRowNum());
        boatList = new ArrayList();
        for (Rowboat boat : boats) {
            boatList.add(boat);
        }
        boatList = new ArrayList();
        for (Rowboat boat : boats) {
            boatList.add(boat);
        }
        boatList = new ArrayList();
        for (Rowboat boat : boats) {
            boatList.add(boat);
        }
        boatList = new ArrayList();
        for (Rowboat boat : boats) {
            boatList.add(boat);
        }
        Assert.assertEquals((long)2L, (long)boatList.size());
        Assert.assertEquals((long)0L, (long)((Rowboat)boatList.get(0)).getRowNum());
        Assert.assertEquals((long)1L, (long)((Rowboat)boatList.get(1)).getRowNum());
    }
}

