/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.incremental;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import io.druid.data.input.InputRow;
import io.druid.data.input.MapBasedInputRow;
import io.druid.java.util.common.granularity.Granularities;
import io.druid.query.aggregation.Aggregator;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.LongMaxAggregator;
import io.druid.query.aggregation.LongMaxAggregatorFactory;
import io.druid.segment.incremental.IncrementalIndex;
import io.druid.segment.incremental.IncrementalIndexSchema;
import io.druid.segment.incremental.OnheapIncrementalIndex;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class OnheapIncrementalIndexTest {
    private static final int MAX_ROWS = 100000;

    @Test
    public void testMultithreadAddFacts() throws Exception {
        final IncrementalIndex index = new IncrementalIndex.Builder().setIndexSchema(new IncrementalIndexSchema.Builder().withQueryGranularity(Granularities.MINUTE).withMetrics(new AggregatorFactory[]{new LongMaxAggregatorFactory("max", "max")}).build()).setMaxRowCount(100000).buildOnheap();
        final Random random = new Random();
        int addThreadCount = 2;
        Thread[] addThreads = new Thread[2];
        for (int i = 0; i < 2; ++i) {
            addThreads[i] = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        for (int j = 0; j < 50000; ++j) {
                            index.add((InputRow)new MapBasedInputRow(0L, (List)Lists.newArrayList((Object[])new String[]{"billy"}), (Map)ImmutableMap.of((Object)"billy", (Object)random.nextLong(), (Object)"max", (Object)1)));
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
            addThreads[i].start();
        }
        final AtomicInteger checkFailedCount = new AtomicInteger(0);
        Thread checkThread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (!Thread.interrupted()) {
                    for (IncrementalIndex.TimeAndDims row : index.getFacts().keySet()) {
                        if (index.getMetricLongValue(row.getRowIndex(), 0) == 1L) continue;
                        checkFailedCount.addAndGet(1);
                    }
                }
            }
        });
        checkThread.start();
        for (int i = 0; i < 2; ++i) {
            addThreads[i].join();
        }
        checkThread.interrupt();
        Assert.assertEquals((long)0L, (long)checkFailedCount.get());
    }

    @Test
    public void testOnHeapIncrementalIndexClose() throws Exception {
        Aggregator mockedAggregator = (Aggregator)EasyMock.createMock(LongMaxAggregator.class);
        mockedAggregator.close();
        EasyMock.expectLastCall().times(1);
        OnheapIncrementalIndex index = (OnheapIncrementalIndex)new IncrementalIndex.Builder().setIndexSchema(new IncrementalIndexSchema.Builder().withQueryGranularity(Granularities.MINUTE).withMetrics(new AggregatorFactory[]{new LongMaxAggregatorFactory("max", "max")}).build()).setMaxRowCount(100000).buildOnheap();
        index.add((InputRow)new MapBasedInputRow(0L, (List)Lists.newArrayList((Object[])new String[]{"billy"}), (Map)ImmutableMap.of((Object)"billy", (Object)1, (Object)"max", (Object)1)));
        index.concurrentGet((int)0)[0] = mockedAggregator;
        EasyMock.replay((Object[])new Object[]{mockedAggregator});
        index.close();
        EasyMock.verify((Object[])new Object[]{mockedAggregator});
    }
}

