/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.virtual;

import com.google.common.base.Supplier;
import io.druid.common.guava.SettableSupplier;
import io.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import io.druid.segment.ColumnValueSelector;
import io.druid.segment.DimensionSelector;
import io.druid.segment.TestObjectColumnSelector;
import io.druid.segment.virtual.BaseSingleValueDimensionSelector;
import io.druid.segment.virtual.ExpressionSelectors;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class ExpressionColumnValueSelectorTest {
    @Test
    public void testSupplierFromDimensionSelector() {
        SettableSupplier settableSupplier = new SettableSupplier();
        Supplier supplier = ExpressionSelectors.supplierFromDimensionSelector((DimensionSelector)ExpressionColumnValueSelectorTest.dimensionSelectorFromSupplier((Supplier<String>)settableSupplier));
        Assert.assertNotNull((Object)supplier);
        Assert.assertEquals(null, (Object)supplier.get());
        settableSupplier.set(null);
        Assert.assertEquals(null, (Object)supplier.get());
        settableSupplier.set((Object)"1234");
        Assert.assertEquals((Object)"1234", (Object)supplier.get());
    }

    @Test
    public void testSupplierFromObjectSelectorObject() {
        SettableSupplier settableSupplier = new SettableSupplier();
        Supplier supplier = ExpressionSelectors.supplierFromObjectSelector(ExpressionColumnValueSelectorTest.objectSelectorFromSupplier(settableSupplier, Object.class));
        Assert.assertNotNull((Object)supplier);
        Assert.assertEquals(null, (Object)supplier.get());
        settableSupplier.set((Object)Float.valueOf(1.1f));
        Assert.assertEquals((Object)Float.valueOf(1.1f), (Object)supplier.get());
        settableSupplier.set((Object)1L);
        Assert.assertEquals((Object)1L, (Object)supplier.get());
        settableSupplier.set((Object)"1234");
        Assert.assertEquals((Object)"1234", (Object)supplier.get());
        settableSupplier.set((Object)"1.234");
        Assert.assertEquals((Object)"1.234", (Object)supplier.get());
    }

    @Test
    public void testSupplierFromObjectSelectorNumber() {
        SettableSupplier settableSupplier = new SettableSupplier();
        Supplier supplier = ExpressionSelectors.supplierFromObjectSelector(ExpressionColumnValueSelectorTest.objectSelectorFromSupplier(settableSupplier, Number.class));
        Assert.assertNotNull((Object)supplier);
        Assert.assertEquals(null, (Object)supplier.get());
        settableSupplier.set((Object)Float.valueOf(1.1f));
        Assert.assertEquals((Object)Float.valueOf(1.1f), (Object)supplier.get());
        settableSupplier.set((Object)1L);
        Assert.assertEquals((Object)1L, (Object)supplier.get());
    }

    @Test
    public void testSupplierFromObjectSelectorString() {
        SettableSupplier settableSupplier = new SettableSupplier();
        Supplier supplier = ExpressionSelectors.supplierFromObjectSelector(ExpressionColumnValueSelectorTest.objectSelectorFromSupplier(settableSupplier, String.class));
        Assert.assertNotNull((Object)supplier);
        Assert.assertEquals(null, (Object)supplier.get());
        settableSupplier.set((Object)"1.1");
        Assert.assertEquals((Object)"1.1", (Object)supplier.get());
        settableSupplier.set((Object)"1");
        Assert.assertEquals((Object)"1", (Object)supplier.get());
    }

    @Test
    public void testSupplierFromObjectSelectorList() {
        SettableSupplier settableSupplier = new SettableSupplier();
        Supplier supplier = ExpressionSelectors.supplierFromObjectSelector(ExpressionColumnValueSelectorTest.objectSelectorFromSupplier(settableSupplier, List.class));
        Assert.assertNull((Object)supplier);
    }

    private static DimensionSelector dimensionSelectorFromSupplier(final Supplier<String> supplier) {
        return new BaseSingleValueDimensionSelector(){

            protected String getValue() {
                return (String)supplier.get();
            }

            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("supplier", (Object)supplier);
            }
        };
    }

    private static <T> ColumnValueSelector<T> objectSelectorFromSupplier(final Supplier<T> supplier, final Class<T> clazz) {
        return new TestObjectColumnSelector<T>(){

            public Class<T> classOfObject() {
                return clazz;
            }

            public T getObject() {
                return supplier.get();
            }
        };
    }
}

