/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.virtual;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Longs;
import io.druid.query.dimension.DefaultDimensionSpec;
import io.druid.query.dimension.DimensionSpec;
import io.druid.query.dimension.ExtractionDimensionSpec;
import io.druid.query.expression.TestExprMacroTable;
import io.druid.query.extraction.BucketExtractionFn;
import io.druid.query.extraction.ExtractionFn;
import io.druid.query.filter.ValueMatcher;
import io.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import io.druid.segment.BaseLongColumnValueSelector;
import io.druid.segment.ColumnSelectorFactory;
import io.druid.segment.ColumnValueSelector;
import io.druid.segment.DimensionSelector;
import io.druid.segment.DimensionSelectorUtils;
import io.druid.segment.IdLookup;
import io.druid.segment.TestHelper;
import io.druid.segment.TestLongColumnSelector;
import io.druid.segment.VirtualColumn;
import io.druid.segment.VirtualColumns;
import io.druid.segment.column.ColumnCapabilities;
import io.druid.segment.column.ColumnCapabilitiesImpl;
import io.druid.segment.column.ValueType;
import io.druid.segment.data.IndexedInts;
import io.druid.segment.data.ZeroIndexedInts;
import io.druid.segment.virtual.ExpressionVirtualColumn;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class VirtualColumnsTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void testExists() {
        VirtualColumns virtualColumns = this.makeVirtualColumns();
        Assert.assertTrue((boolean)virtualColumns.exists("expr"));
        Assert.assertTrue((boolean)virtualColumns.exists("foo"));
        Assert.assertTrue((boolean)virtualColumns.exists("foo.5"));
        Assert.assertFalse((boolean)virtualColumns.exists("bar"));
    }

    @Test
    public void testNonExistentSelector() {
        VirtualColumns virtualColumns = this.makeVirtualColumns();
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("No such virtual column[bar]");
        virtualColumns.makeColumnValueSelector("bar", null);
    }

    @Test
    public void testMakeSelectors() {
        VirtualColumns virtualColumns = this.makeVirtualColumns();
        ColumnValueSelector objectSelector = virtualColumns.makeColumnValueSelector("expr", null);
        DimensionSelector dimensionSelector = virtualColumns.makeDimensionSelector((DimensionSpec)new DefaultDimensionSpec("expr", "x"), null);
        DimensionSelector extractionDimensionSelector = virtualColumns.makeDimensionSelector((DimensionSpec)new ExtractionDimensionSpec("expr", "x", (ExtractionFn)new BucketExtractionFn(Double.valueOf(1.0), Double.valueOf(0.5))), null);
        ColumnValueSelector floatSelector = virtualColumns.makeColumnValueSelector("expr", null);
        ColumnValueSelector longSelector = virtualColumns.makeColumnValueSelector("expr", null);
        Assert.assertEquals((Object)1L, (Object)objectSelector.getObject());
        Assert.assertEquals((Object)"1", (Object)dimensionSelector.lookupName(dimensionSelector.getRow().get(0)));
        Assert.assertEquals((Object)"0.5", (Object)extractionDimensionSelector.lookupName(extractionDimensionSelector.getRow().get(0)));
        Assert.assertEquals((float)1.0f, (float)floatSelector.getFloat(), (float)0.0f);
        Assert.assertEquals((long)1L, (long)longSelector.getLong());
    }

    @Test
    public void testMakeSelectorsWithDotSupport() {
        VirtualColumns virtualColumns = this.makeVirtualColumns();
        ColumnValueSelector objectSelector = virtualColumns.makeColumnValueSelector("foo.5", null);
        DimensionSelector dimensionSelector = virtualColumns.makeDimensionSelector((DimensionSpec)new DefaultDimensionSpec("foo.5", "x"), null);
        ColumnValueSelector floatSelector = virtualColumns.makeColumnValueSelector("foo.5", null);
        ColumnValueSelector longSelector = virtualColumns.makeColumnValueSelector("foo.5", null);
        Assert.assertEquals((Object)5L, (Object)objectSelector.getObject());
        Assert.assertEquals((Object)"5", (Object)dimensionSelector.lookupName(dimensionSelector.getRow().get(0)));
        Assert.assertEquals((float)5.0f, (float)floatSelector.getFloat(), (float)0.0f);
        Assert.assertEquals((long)5L, (long)longSelector.getLong());
    }

    @Test
    public void testMakeSelectorsWithDotSupportBaseNameOnly() {
        VirtualColumns virtualColumns = this.makeVirtualColumns();
        ColumnValueSelector objectSelector = virtualColumns.makeColumnValueSelector("foo", null);
        DimensionSelector dimensionSelector = virtualColumns.makeDimensionSelector((DimensionSpec)new DefaultDimensionSpec("foo", "x"), null);
        ColumnValueSelector floatSelector = virtualColumns.makeColumnValueSelector("foo", null);
        ColumnValueSelector longSelector = virtualColumns.makeColumnValueSelector("foo", null);
        Assert.assertEquals((Object)-1L, (Object)objectSelector.getObject());
        Assert.assertEquals((Object)"-1", (Object)dimensionSelector.lookupName(dimensionSelector.getRow().get(0)));
        Assert.assertEquals((float)-1.0f, (float)floatSelector.getFloat(), (float)0.0f);
        Assert.assertEquals((long)-1L, (long)longSelector.getLong());
    }

    @Test
    public void testTimeNotAllowed() {
        ExpressionVirtualColumn expr = new ExpressionVirtualColumn("__time", "x + y", ValueType.FLOAT, TestExprMacroTable.INSTANCE);
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("virtualColumn name[__time] not allowed");
        VirtualColumns.create((List)ImmutableList.of((Object)expr));
    }

    @Test
    public void testDuplicateNameDetection() {
        ExpressionVirtualColumn expr = new ExpressionVirtualColumn("expr", "x + y", ValueType.FLOAT, TestExprMacroTable.INSTANCE);
        ExpressionVirtualColumn expr2 = new ExpressionVirtualColumn("expr", "x * 2", ValueType.FLOAT, TestExprMacroTable.INSTANCE);
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Duplicate virtualColumn name[expr]");
        VirtualColumns.create((List)ImmutableList.of((Object)expr, (Object)expr2));
    }

    @Test
    public void testCycleDetection() {
        ExpressionVirtualColumn expr = new ExpressionVirtualColumn("expr", "x + expr2", ValueType.FLOAT, TestExprMacroTable.INSTANCE);
        ExpressionVirtualColumn expr2 = new ExpressionVirtualColumn("expr2", "expr * 2", ValueType.FLOAT, TestExprMacroTable.INSTANCE);
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Self-referential column[expr]");
        VirtualColumns.create((List)ImmutableList.of((Object)expr, (Object)expr2));
    }

    @Test
    public void testGetCacheKey() throws Exception {
        VirtualColumns virtualColumns = VirtualColumns.create((List)ImmutableList.of((Object)new ExpressionVirtualColumn("expr", "x + y", ValueType.FLOAT, TestExprMacroTable.INSTANCE)));
        VirtualColumns virtualColumns2 = VirtualColumns.create((List)ImmutableList.of((Object)new ExpressionVirtualColumn("expr", "x + y", ValueType.FLOAT, TestExprMacroTable.INSTANCE)));
        Assert.assertArrayEquals((byte[])virtualColumns.getCacheKey(), (byte[])virtualColumns2.getCacheKey());
        Assert.assertFalse((boolean)Arrays.equals(virtualColumns.getCacheKey(), VirtualColumns.EMPTY.getCacheKey()));
    }

    @Test
    public void testEqualsAndHashCode() throws Exception {
        VirtualColumns virtualColumns = VirtualColumns.create((List)ImmutableList.of((Object)new ExpressionVirtualColumn("expr", "x + y", ValueType.FLOAT, TestExprMacroTable.INSTANCE)));
        VirtualColumns virtualColumns2 = VirtualColumns.create((List)ImmutableList.of((Object)new ExpressionVirtualColumn("expr", "x + y", ValueType.FLOAT, TestExprMacroTable.INSTANCE)));
        Assert.assertEquals((Object)virtualColumns, (Object)virtualColumns);
        Assert.assertEquals((Object)virtualColumns, (Object)virtualColumns2);
        Assert.assertNotEquals((Object)VirtualColumns.EMPTY, (Object)virtualColumns);
        Assert.assertNotEquals((Object)VirtualColumns.EMPTY, null);
        Assert.assertEquals((long)virtualColumns.hashCode(), (long)virtualColumns.hashCode());
        Assert.assertEquals((long)virtualColumns.hashCode(), (long)virtualColumns2.hashCode());
        Assert.assertNotEquals((long)VirtualColumns.EMPTY.hashCode(), (long)virtualColumns.hashCode());
    }

    @Test
    public void testSerde() throws Exception {
        ObjectMapper mapper = TestHelper.makeJsonMapper();
        ImmutableList theColumns = ImmutableList.of((Object)new ExpressionVirtualColumn("expr", "x + y", ValueType.FLOAT, TestExprMacroTable.INSTANCE), (Object)new ExpressionVirtualColumn("expr2", "x + z", ValueType.FLOAT, TestExprMacroTable.INSTANCE));
        VirtualColumns virtualColumns = VirtualColumns.create((List)theColumns);
        Assert.assertEquals((Object)virtualColumns, (Object)mapper.readValue(mapper.writeValueAsString((Object)virtualColumns), VirtualColumns.class));
        Assert.assertEquals((Object)theColumns, (Object)mapper.readValue(mapper.writeValueAsString((Object)virtualColumns), mapper.getTypeFactory().constructParametricType(List.class, new Class[]{VirtualColumn.class})));
    }

    private VirtualColumns makeVirtualColumns() {
        ExpressionVirtualColumn expr = new ExpressionVirtualColumn("expr", "1", ValueType.FLOAT, TestExprMacroTable.INSTANCE);
        DottyVirtualColumn dotty = new DottyVirtualColumn("foo");
        return VirtualColumns.create((List)ImmutableList.of((Object)expr, (Object)dotty));
    }

    static class DottyVirtualColumn
    implements VirtualColumn {
        private final String name;

        public DottyVirtualColumn(String name) {
            this.name = name;
        }

        public String getOutputName() {
            return this.name;
        }

        public DimensionSelector makeDimensionSelector(DimensionSpec dimensionSpec, ColumnSelectorFactory factory) {
            ColumnValueSelector<?> selector = this.makeColumnValueSelector(dimensionSpec.getDimension(), factory);
            ExtractionFn extractionFn = dimensionSpec.getExtractionFn();
            DimensionSelector dimensionSelector = new DimensionSelector((BaseLongColumnValueSelector)selector, extractionFn){
                final /* synthetic */ BaseLongColumnValueSelector val$selector;
                final /* synthetic */ ExtractionFn val$extractionFn;
                {
                    this.val$selector = baseLongColumnValueSelector;
                    this.val$extractionFn = extractionFn;
                }

                public IndexedInts getRow() {
                    return ZeroIndexedInts.instance();
                }

                public int getValueCardinality() {
                    return -1;
                }

                public String lookupName(int id) {
                    String stringValue = String.valueOf(this.val$selector.getLong());
                    return this.val$extractionFn == null ? stringValue : this.val$extractionFn.apply(stringValue);
                }

                public ValueMatcher makeValueMatcher(String value) {
                    return DimensionSelectorUtils.makeValueMatcherGeneric((DimensionSelector)this, (String)value);
                }

                public ValueMatcher makeValueMatcher(Predicate<String> predicate) {
                    return DimensionSelectorUtils.makeValueMatcherGeneric((DimensionSelector)this, predicate);
                }

                public boolean nameLookupPossibleInAdvance() {
                    return false;
                }

                @Nullable
                public IdLookup idLookup() {
                    return new IdLookup(){

                        public int lookupId(String name) {
                            return 0;
                        }
                    };
                }

                public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                }

                @Nullable
                public Object getObject() {
                    return this.lookupName(0);
                }

                public Class classOfObject() {
                    return String.class;
                }
            };
            return dimensionSpec.decorate(dimensionSelector);
        }

        public ColumnValueSelector<?> makeColumnValueSelector(String columnName, ColumnSelectorFactory factory) {
            String subColumn = (String)VirtualColumns.splitColumnName((String)columnName).rhs;
            Long boxed = subColumn == null ? null : Longs.tryParse((String)subColumn);
            final long theLong = boxed == null ? -1L : boxed;
            return new TestLongColumnSelector(){

                public long getLong() {
                    return theLong;
                }
            };
        }

        public ColumnCapabilities capabilities(String columnName) {
            return new ColumnCapabilitiesImpl().setType(ValueType.LONG);
        }

        public List<String> requiredColumns() {
            return ImmutableList.of();
        }

        public boolean usesDotNotation() {
            return true;
        }

        public byte[] getCacheKey() {
            throw new UnsupportedOperationException();
        }
    }
}

