/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.writeout;

import com.google.common.io.Files;
import com.google.common.primitives.Ints;
import io.druid.java.util.common.StringUtils;
import io.druid.segment.writeout.OffHeapMemorySegmentWriteOutMedium;
import io.druid.segment.writeout.OnHeapMemorySegmentWriteOutMedium;
import io.druid.segment.writeout.SegmentWriteOutMedium;
import io.druid.segment.writeout.TmpFileSegmentWriteOutMedium;
import io.druid.segment.writeout.WriteOutBytes;
import java.io.IOException;
import java.io.InputStream;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class WriteOutBytesTest {
    private final SegmentWriteOutMedium segmentWriteOutMedium;

    @Parameterized.Parameters
    public static Collection<Object[]> constructorFeeder() throws IOException {
        return Arrays.asList({new TmpFileSegmentWriteOutMedium(Files.createTempDir())}, {new OffHeapMemorySegmentWriteOutMedium()}, {new OnHeapMemorySegmentWriteOutMedium()});
    }

    public WriteOutBytesTest(SegmentWriteOutMedium segmentWriteOutMedium) {
        this.segmentWriteOutMedium = segmentWriteOutMedium;
    }

    @Test
    public void testWriteOutBytes() throws IOException {
        WriteOutBytes writeOutBytes = this.segmentWriteOutMedium.makeWriteOutBytes();
        writeOutBytes.write(49);
        this.verifyContents(writeOutBytes, "1");
        writeOutBytes.writeInt(Ints.fromBytes((byte)50, (byte)51, (byte)52, (byte)53));
        this.verifyContents(writeOutBytes, "12345");
        writeOutBytes.write(new byte[]{97});
        this.verifyContents(writeOutBytes, "12345a");
        writeOutBytes.write(new byte[]{97, 98, 99}, 1, 1);
        this.verifyContents(writeOutBytes, "12345ab");
        ByteBuffer bb = ByteBuffer.wrap(new byte[]{97, 98, 99});
        bb.position(2);
        writeOutBytes.write(bb);
        Assert.assertEquals((long)3L, (long)bb.position());
        this.verifyContents(writeOutBytes, "12345abc");
    }

    private void verifyContents(WriteOutBytes writeOutBytes, String expected) throws IOException {
        Assert.assertEquals((Object)expected, (Object)IOUtils.toString((InputStream)writeOutBytes.asInputStream(), (Charset)StandardCharsets.US_ASCII));
        ByteBuffer bb = ByteBuffer.allocate((int)writeOutBytes.size());
        writeOutBytes.readFully(0L, bb);
        bb.flip();
        Assert.assertEquals((Object)expected, (Object)StringUtils.fromUtf8((ByteBuffer)bb));
    }

    @Test
    public void testCrossBufferRandomAccess() throws IOException {
        WriteOutBytes writeOutBytes = this.segmentWriteOutMedium.makeWriteOutBytes();
        for (int i = 0; i < 65536; ++i) {
            writeOutBytes.write(48);
        }
        writeOutBytes.write(49);
        writeOutBytes.write(50);
        writeOutBytes.write(51);
        ByteBuffer bb = ByteBuffer.allocate(4);
        writeOutBytes.readFully(65535L, bb);
        bb.flip();
        Assert.assertEquals((Object)"0123", (Object)StringUtils.fromUtf8((ByteBuffer)bb));
    }

    @Test(expected=BufferUnderflowException.class)
    public void testReadFullyUnderflow() throws IOException {
        WriteOutBytes writeOutBytes = this.segmentWriteOutMedium.makeWriteOutBytes();
        writeOutBytes.write(49);
        writeOutBytes.readFully(0L, ByteBuffer.allocate(2));
    }

    @Test
    public void testReadFullyEmptyAtTheEnd() throws IOException {
        WriteOutBytes writeOutBytes = this.segmentWriteOutMedium.makeWriteOutBytes();
        writeOutBytes.write(49);
        writeOutBytes.readFully(1L, ByteBuffer.allocate(0));
    }
}

