/*
 * Decompiled with CFR 0.152.
 */
package io.dylemma.spac.json;

import fs2.RaiseThrowable;
import fs2.Stream;
import fs2.Stream$;
import fs2.data.json.Token;
import fs2.data.json.package$;
import fs2.data.text.CharLikeChunks;
import fs2.data.text.CharLikeChunks$;
import io.dylemma.spac.CallerPos;
import io.dylemma.spac.ContextLocation$;
import io.dylemma.spac.Transformer;
import io.dylemma.spac.Transformer$;
import io.dylemma.spac.interop.fs2.package;
import io.dylemma.spac.json.JsonEvent;
import io.dylemma.spac.json.JsonValueEvent;
import io.dylemma.spac.json.impl.JsonStackFixer$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;

public final class Fs2DataSource$ {
    public static Fs2DataSource$ MODULE$;
    private final JsonEvent.ObjectStart objectStart;
    private final JsonEvent.ObjectEnd objectEnd;
    private final JsonEvent.ArrayStart arrayStart;
    private final JsonEvent.ArrayEnd arrayEnd;
    private final JsonEvent.JBool jsonTrue;
    private final JsonEvent.JBool jsonFalse;
    private final JsonEvent.JNull jsonNull;

    static {
        new Fs2DataSource$();
    }

    public <F, A> Stream<F, JsonEvent> fromRawJsonStream(Stream<F, A> rawJsonStream, CharLikeChunks<F, A> A, RaiseThrowable<F> F, CallerPos callerPos) {
        return rawJsonStream.through(package$.MODULE$.tokens(F, A)).through(this.convert(callerPos));
    }

    public <F> Stream<F, JsonEvent> fromString(String rawJson, RaiseThrowable<F> F, CallerPos callerPos) {
        return this.fromRawJsonStream(Stream$.MODULE$.emit((Object)rawJson), CharLikeChunks$.MODULE$.stringStreamCharLike(), F, callerPos);
    }

    public <F> Function1<Stream<F, Token>, Stream<F, JsonEvent>> convert(CallerPos callerPos) {
        return package.TransformerFs2Ops$.MODULE$.toPipe$extension(io.dylemma.spac.interop.fs2.package$.MODULE$.TransformerFs2Ops(Transformer$.MODULE$.map((Function1 & Serializable & scala.Serializable)token -> MODULE$.tokenToJsonEvent((Token)token)).through((Transformer)JsonStackFixer$.MODULE$)), callerPos);
    }

    private JsonEvent tokenToJsonEvent(Token token) {
        Token token2 = token;
        if (Token.StartObject$.MODULE$.equals(token2)) {
            return this.objectStart();
        }
        if (Token.EndObject$.MODULE$.equals(token2)) {
            return this.objectEnd();
        }
        if (Token.StartArray$.MODULE$.equals(token2)) {
            return this.arrayStart();
        }
        if (Token.EndArray$.MODULE$.equals(token2)) {
            return this.arrayEnd();
        }
        if (token2 instanceof Token.Key) {
            Token.Key key = (Token.Key)token2;
            String name = key.value();
            return JsonEvent.FieldStart$.MODULE$.apply(name, ContextLocation$.MODULE$.empty());
        }
        if (token2 instanceof Token.StringValue) {
            Token.StringValue stringValue = (Token.StringValue)token2;
            String s = stringValue.value();
            return JsonEvent.JString$.MODULE$.apply(s, ContextLocation$.MODULE$.empty());
        }
        if (token2 instanceof Token.NumberValue) {
            Token.NumberValue numberValue = (Token.NumberValue)token2;
            String raw = numberValue.value();
            return this.jsonNumber(raw);
        }
        if (Token.TrueValue$.MODULE$.equals(token2)) {
            return this.jsonTrue();
        }
        if (Token.FalseValue$.MODULE$.equals(token2)) {
            return this.jsonFalse();
        }
        if (Token.NullValue$.MODULE$.equals(token2)) {
            return this.jsonNull();
        }
        throw new MatchError((Object)token2);
    }

    private JsonEvent.ObjectStart objectStart() {
        return this.objectStart;
    }

    private JsonEvent.ObjectEnd objectEnd() {
        return this.objectEnd;
    }

    private JsonEvent.ArrayStart arrayStart() {
        return this.arrayStart;
    }

    private JsonEvent.ArrayEnd arrayEnd() {
        return this.arrayEnd;
    }

    private JsonEvent.JBool jsonTrue() {
        return this.jsonTrue;
    }

    private JsonEvent.JBool jsonFalse() {
        return this.jsonFalse;
    }

    private JsonEvent.JNull jsonNull() {
        return this.jsonNull;
    }

    private JsonValueEvent jsonNumber(String raw) {
        Some some;
        try {
            some = new Some((Object)BoxesRunTime.boxToLong((long)new StringOps(Predef$.MODULE$.augmentString(raw)).toLong()));
        }
        catch (NumberFormatException numberFormatException) {
            some = None$.MODULE$;
        }
        Some asLong = some;
        return (JsonValueEvent)asLong.map((Function1 & Serializable & scala.Serializable)x$1 -> JsonEvent.JLong$.MODULE$.apply(BoxesRunTime.unboxToLong((Object)x$1), ContextLocation$.MODULE$.empty())).getOrElse((Function0 & Serializable & scala.Serializable)() -> JsonEvent.JDouble$.MODULE$.apply(new StringOps(Predef$.MODULE$.augmentString(raw)).toDouble(), ContextLocation$.MODULE$.empty()));
    }

    private Fs2DataSource$() {
        MODULE$ = this;
        this.objectStart = JsonEvent.ObjectStart$.MODULE$.apply(ContextLocation$.MODULE$.empty());
        this.objectEnd = JsonEvent.ObjectEnd$.MODULE$.apply(ContextLocation$.MODULE$.empty());
        this.arrayStart = JsonEvent.ArrayStart$.MODULE$.apply(ContextLocation$.MODULE$.empty());
        this.arrayEnd = JsonEvent.ArrayEnd$.MODULE$.apply(ContextLocation$.MODULE$.empty());
        this.jsonTrue = JsonEvent.JBool$.MODULE$.apply(true, ContextLocation$.MODULE$.empty());
        this.jsonFalse = JsonEvent.JBool$.MODULE$.apply(false, ContextLocation$.MODULE$.empty());
        this.jsonNull = JsonEvent.JNull$.MODULE$.apply(ContextLocation$.MODULE$.empty());
    }
}

