package io.dyte.callstats.media

import io.dyte.media.Transport
import io.dyte.media.hive.HiveTransport
import io.dyte.webrtc.RtcStatsReport

class TransportFacade(
  private val isHive: Boolean,
  private val mediasoupTransport: Transport? = null,
  private val hiveTransport: HiveTransport? = null,
) {
  suspend fun getStats(): List<RtcStatsReport> {
    return if (isHive) {
      val stats = hiveTransport!!.getStats()

      if (stats != null) listOf(stats) else emptyList()
    } else {
      mediasoupTransport!!.getStats()
    }
  }

  fun getId(): String {
    return if (isHive) hiveTransport!!.getId()!! else mediasoupTransport!!.id
  }
}
