package io.dyte.callstats.datasinks

import io.dyte.callstats.api.CollectorApiService
import io.dyte.callstats.events.EventChunk
import io.dyte.callstats.models.AuthPayload
import io.dyte.callstats.models.Environment
import io.dyte.callstats.models.SQSPacketStructure
import io.dyte.callstats.utils.Logger

class HTTPDataSink(private val logger: Logger, environment: Environment) : DataSink {
  private val api = CollectorApiService(environment)
  private lateinit var authInfo: AuthPayload

  override fun authenticate(data: AuthPayload) {
    authInfo = data
  }

  override suspend fun sendChunk(chunk: EventChunk) {
    logger.logDebug("Received chunk: $chunk")
    val packet = SQSPacketStructure(payload = chunk, peerId = this.authInfo.peerId)
    api.sendCallStats(packet)
    logger.logDebug("Sent chunk!: $chunk")
  }
}
