package io.dyte.callstats

import io.dyte.callstats.events.TransportStatistics
import kotlinx.serialization.Serializable

data class ParsedRTCStats(
  var transport: WebRtcTransportStats? = null,
  var candidatePair: IceCandidatePairStats? = null,
  val outboundVideoRtp: MutableMap<String, OutboundVideoStreamStats> = mutableMapOf(),
  val inboundVideoRtp: MutableMap<String, InboundVideoStreamStats> = mutableMapOf(),
  val outboundAudioRtp: MutableMap<String, OutboundAudioStreamStats> = mutableMapOf(),
  val inboundAudioRtp: MutableMap<String, InboundAudioStreamStats> = mutableMapOf(),
  val remoteInboundRtp: MutableMap<String, RemoteInboundStreamStats> = mutableMapOf(),
  val producerStreamMap: MutableMap<String, ParsedProducerStats> = mutableMapOf(),
  val consumerStreamMap: MutableMap<String, ParsedConsumerStats> = mutableMapOf(),
  var staleProducerStreamMap: Boolean = false,
  var staleConsumerStreamMap: Boolean = false
)

data class OverallConsumerStatsValue(
  var totalVideoPacketReceived: Double?,
  var totalAudioPacketReceived: Double?
)

data class ParsedProducerStats(
  val outboundVideoRtpId: MutableList<String> = mutableListOf(),
  val outboundAudioRtpId: MutableList<String> = mutableListOf()
)

data class ParsedConsumerStats(
  val inboundVideoRtpId: MutableList<String> = mutableListOf(),
  val inboundAudioRtpId: MutableList<String> = mutableListOf()
)

@Serializable
data class RemoteInboundStreamStats(
  val jitter: Double?,
  val fractionLost: Double?,
  val roundTripTime: Double?,
  val roundTripTimeMeasurements: Double?,
  val totalRoundTripTime: Double?,
  val packetsLost: Double?,
  val localId: String?
)

@Serializable
data class InboundVideoStreamStats(
  val framesDecoded: Double?,
  val keyFramesDecoded: Double?,
  val framesReceived: Double?,
  val decoderImplementation: String?,

  // Video Stream Stats
  val frameHeight: Double?,
  val frameWidth: Double?,
  val droppedFrames: Double?,
  val frameRateMean: Double?,
  val framesDropped: Double?,
  val framesPerSecond: Double?,
  val firCount: Double?,

  // Inbound Stream Stats
  val bytesReceived: Double?,
  val packetsReceived: Double?,
  val packetsLost: Double?,
  val jitter: Double?,
  val nackCount: Double?
)

@Serializable
data class OutboundVideoStreamStats(
  val hugeFramesSent: Double?,
  val pliCount: Double?,
  val qpSum: Double?,
  val framesEncoded: Double?,
  val framesSent: Double?,
  val keyFramesEncoded: Double?,
  val encoderImplementation: String?,
  val qualityLimitationReason: String?,
  val qualityLimitationResolutionChanges: Double?,
  val totalEncodeTime: Double?,
  val totalPacketSendDelay: Double?,

  // Video Stream Stats
  val frameHeight: Double?,
  val frameWidth: Double?,
  val droppedFrames: Double?,
  val frameRateMean: Double?,
  val framesDropped: Double?,
  val framesPerSecond: Double?,
  val firCount: Double?,

  // Outbound Stream Stats
  val bytesSent: Double?,
  val packetsSent: Double?,
  val retransmittedBytesSent: Double?,
  val retransmittedPacketsSent: Double?,
  var remoteData: RemoteInboundStreamStats?,
  val nackCount: Double?
)

@Serializable
data class InboundAudioStreamStats(
  val audioLevel: Double?,
  val concealedSamples: Double?,
  val concealmentEvents: Double?,
  val jitterBufferDelay: Double?,
  val jitterBufferEmittedCount: Double?,
  val totalAudioEnergy: Double?,
  val totalSamplesDuration: Double?,
  val totalSamplesReceived: Double?,

  // Inbound Stream Stats
  val bytesReceived: Double?,
  val packetsReceived: Double?,
  val packetsLost: Double?,
  val jitter: Double?,
  val nackCount: Double?
)

@Serializable
data class OutboundAudioStreamStats(
  // Outbound Stream Stats
  val bytesSent: Double?,
  val packetsSent: Double?,
  val retransmittedBytesSent: Double?,
  val retransmittedPacketsSent: Double?,
  var remoteData: RemoteInboundStreamStats?,
  val nackCount: Double?
)

typealias RTCDtlsTransportState = String

typealias RTCIceRole = String

typealias RTCIceCredentialType = String

@Serializable
data class WebRtcTransportStats(
  var bytesReceived: Double?,
  var bytesSent: Double?,
  var roundTripTime: Double?,
  var totalRoundTripTime: Double?,
  var availableOutgoingBitrate: Double?,
  var dtlsCipher: String?,
  var dtlsState: RTCDtlsTransportState?,
  var iceRole: RTCIceRole?,
  var packetsReceived: Double?,
  var packetsSent: Double?,
)

data class IceCandidatePairStats(
  val bytesReceived: Double?,
  val bytesSent: Double?,
  val currentRoundTripTime: Double?,
  val totalRoundTripTime: Double?,
  val availableOutgoingBitrate: Double?,
)

@Serializable
data class ProducerStatistics(
  val producerId: String = "",
  val videoStats: List<OutboundVideoStreamStats> = emptyList(),
  val audioStats: List<OutboundAudioStreamStats> = emptyList()
)

@Serializable
data class ConsumerStatistics(
  val consumerId: String? = "",
  val peerId: String? = "",
  val producerId: String? = "",
  val videoStats: List<InboundVideoStreamStats> = emptyList(),
  val audioStats: List<InboundAudioStreamStats> = emptyList()
)

data class ConsumerPeerIdValue(val producerId: String? = "", val peerId: String? = "")

@Serializable data class Coords(val latitude: Double?, val longitude: Double?)

@Serializable data class GeoLocation(val coords: Coords?)

@Serializable
data class IPDetails(
  val ip: String? = null,
  val city: String? = null,
  val region: String? = null,
  val country: String? = null,
  val location: GeoLocation? = null,
  val org: String? = null,
  val portal: String? = null,
  val timezone: String? = null
)

@Serializable
data class IceConnectivity(
  val host: Boolean?,
  val relay: Boolean?,
  val reflexive: Boolean?,
)

data class ThroughputInformation(
  val throughput: Long,
  val fractionLoss: Long,
  val RTT: Long,
  val jitter: Long,
  val backendRTT: Long
)

@Serializable
data class NetworkQualityInformation(
  val connectivity: IceConnectivity?,

  // Throughput Information
  val throughput: Long?,
  val fractionLoss: Long?,
  val RTT: Long?,
  val jitter: Long?,
  val backendRTT: Long?
)

@Serializable
data class NetworkInformation(
  val ipDetails: IPDetails?,
  val location: GeoLocation?,
  val turnConnectivity: Boolean?,
  val effectiveNetworkType: String?,

  // NetworkQualityInformation
  val connectivity: IceConnectivity?,

  // ThroughputInformation
  val throughput: Long?,
  val fractionLoss: Long?,
  val RTT: Long?,
  val jitter: Long?,
  val backendRTT: Long?
)

data class IceServerInfo(
  val urls: String,
  val username: String,
  val credential: String?,
  val credentialType: RTCIceCredentialType?
)

data class ProcessedStatsReport(
  val transportReport: TransportStatistics,
  var producerReport: List<ProducerStatistics>?,
  var consumerReport: List<ConsumerStatistics>?,
)
