package io.dyte.core.media

import io.dyte.core.controllers.SelfController
import io.dyte.webrtc.MediaStream
import io.dyte.webrtc.MediaStreamConstraintsBuilder
import kotlinx.coroutines.flow.MutableSharedFlow

internal interface DyteUserMedia {
  suspend fun getUserMedia(
    streamConstraints: MediaStreamConstraintsBuilder.() -> Unit = {}
  ): MediaStream

  fun getDisplayMedia(
    gotScreenShareStreamCallback: (MediaStream) -> Unit,
    selfController: SelfController,
  )

  fun cleanupDisplay()

  companion object : DyteUserMedia by userMedia {
    var ssVideoTrackAvailable: Boolean = false

    val observer = MutableSharedFlow<String>()
  }
}

internal expect val userMedia: DyteUserMedia
