package io.dyte.core.cameramanager

import io.dyte.core.models.DyteVideoDevice
import io.dyte.core.models.VideoDeviceType.EXTERNAL
import io.dyte.core.models.VideoDeviceType.FRONT
import io.dyte.core.models.VideoDeviceType.REAR
import platform.AVFoundation.AVCaptureDevice
import platform.AVFoundation.AVCaptureDevicePositionBack
import platform.AVFoundation.AVCaptureDevicePositionFront
import platform.AVFoundation.AVCaptureDevicePositionUnspecified
import platform.AVFoundation.AVMediaTypeVideo
import platform.AVFoundation.position

internal class DyteCameraManager {

  fun getCameraDevices(): List<DyteVideoDevice> {
    val devices =
      AVCaptureDevice.devicesWithMediaType(AVMediaTypeVideo).filterIsInstance<AVCaptureDevice>()
    val dyteVideoDevices = arrayListOf<DyteVideoDevice>()
    devices.forEach { device ->
      if (device.position == AVCaptureDevicePositionFront) {
        dyteVideoDevices.add(DyteVideoDevice(device.modelID(), FRONT))
      }

      if (device.position == AVCaptureDevicePositionBack) {
        dyteVideoDevices.add(DyteVideoDevice(device.modelID(), REAR))
      }

      if (device.position == AVCaptureDevicePositionUnspecified) {
        dyteVideoDevices.add(DyteVideoDevice(device.modelID(), EXTERNAL))
      }
    }
    return dyteVideoDevices
  }
}
