package io.dyte.core.controllers

import io.dyte.core.observability.DyteLogger
import io.dyte.core.platform.IDytePlatformUtilsProvider
import platform.Network.nw_path_get_status
import platform.Network.nw_path_monitor_cancel
import platform.Network.nw_path_monitor_create
import platform.Network.nw_path_monitor_set_queue
import platform.Network.nw_path_monitor_set_update_handler
import platform.Network.nw_path_monitor_start
import platform.Network.nw_path_monitor_t
import platform.Network.nw_path_monitor_update_handler_t
import platform.Network.nw_path_status_unsatisfied
import platform.Network.nw_path_t
import platform.darwin.dispatch_get_main_queue

internal actual class PlatformConnectionChangeListener {
  private val callback: () -> Unit
  private var nwPathMonitor: nw_path_monitor_t = null

  private val networkMonitor =
    object : nw_path_monitor_update_handler_t {
      override fun invoke(network: nw_path_t) {
        checkReachability(network)
      }
    }

  actual constructor(provider: IDytePlatformUtilsProvider, disconnectCallback: () -> Unit) {
    this.callback = disconnectCallback
    nwPathMonitor = nw_path_monitor_create()
    nw_path_monitor_set_queue(nwPathMonitor, dispatch_get_main_queue())
    nw_path_monitor_set_update_handler(nwPathMonitor, networkMonitor)
    nw_path_monitor_start(nwPathMonitor)
  }

  fun dispose() {
    nw_path_monitor_cancel(nwPathMonitor)
  }

  private fun checkReachability(network: nw_path_t) {
    when (nw_path_get_status(network)) {
      nw_path_status_unsatisfied -> {
        DyteLogger.info("PlatformConnectionChangeListener::disconnection::")
        callback()
      }
      else -> {}
    }
  }
}
