package io.dyte.core.platform

import io.dyte.core.controllers.IControllerContainer

internal class DyteIOSPlatformProvider : IDytePlatformUtilsProvider {
  private val platformUtils = DyteIOSPlatform()
  private lateinit var mediaUtils: DyteIOSMedia
  private lateinit var controllerContainer: IControllerContainer
  private lateinit var videoUtils: DyteIOSVideoUtils
  private lateinit var platformPermissionUtils: DyteIOSPlatformPermissions

  override fun init(controllerContainer: IControllerContainer) {
    this.controllerContainer = controllerContainer
    mediaUtils = DyteIOSMedia(this)
    videoUtils = DyteIOSVideoUtils(this)
    platformPermissionUtils = DyteIOSPlatformPermissions()
  }

  override fun getPlatformUtils(): IDytePlatformUtils {
    return platformUtils
  }

  override fun getMediaUtils(): IDyteMediaUtils {
    return mediaUtils
  }

  override fun getControllerContainer(): IControllerContainer {
    return controllerContainer
  }

  override fun createWebView(): IDyteWebView {
    return DyteIOSWebView()
  }

  override fun getVideoUtils(): IDyteVideoUtils {
    return videoUtils
  }

  override fun getPermissionUtils(): IDytePlatformPermissionUtils {
    return platformPermissionUtils
  }
}
