import kotlinx.cinterop.BetaInteropApi
import kotlinx.cinterop.ExperimentalForeignApi
import kotlinx.cinterop.addressOf
import kotlinx.cinterop.allocArrayOf
import kotlinx.cinterop.memScoped
import kotlinx.cinterop.usePinned
import platform.Foundation.NSData
import platform.Foundation.create
import platform.posix.memcpy

@OptIn(ExperimentalForeignApi::class, BetaInteropApi::class)
public fun ByteArray.toData(): NSData = memScoped {
  NSData.create(bytes = allocArrayOf(this@toData), length = this@toData.size.toULong())
}

@OptIn(ExperimentalForeignApi::class)
public fun NSData.toByteArray(): ByteArray =
  ByteArray(this@toByteArray.length.toInt()).apply {
    usePinned { memcpy(it.addressOf(0), this@toByteArray.bytes, this@toByteArray.length) }
  }
