package io.dyte.core.utils

import platform.Foundation.NSUUID

internal actual class PeerIdGenerator {
  actual fun generate(): String {
    /*
     * NSUUID generates UUID strings in uppercase by default, but SocketService requires peerIds to
     * be in lowercase. So we convert the UUID to lowercase before returning it.
     * */
    return NSUUID().UUIDString().lowercase()
  }
}
