package io.dyte.core

import io.ktor.util.decodeBase64String
import kotlinx.serialization.json.Json
import kotlinx.serialization.json.jsonObject

internal object Utils {
  fun getInitialsFromName(name: String): String {
    val trimmedName = name.trim()

    if (trimmedName.isBlank()) {
      return "NN"
    }

    if (trimmedName.length < 2) {
      return trimmedName.first().toString().uppercase()
    }

    val subNames = trimmedName.split(" ")
    return if (subNames.size >= 2) {
      "${subNames.first().first()}${subNames.last().first()}".uppercase()
    } else {
      subNames.first().substring(0, 2).uppercase()
    }
  }

  fun decodeAuthToken(authToken: String): String? {
    var meetingId: String? = null
    try {
      val split = authToken.split("\\.".toRegex()).toTypedArray()
      val json = split[1].decodeBase64String()
      val jsonElement = Json.parseToJsonElement(json)
      val map = jsonElement.jsonObject.toMap()

      if (map.containsKey("meetingId")) {
        meetingId = map["meetingId"].toString()
        meetingId = meetingId.replace(oldValue = '"'.toString(), newValue = "")
      } else {
        return null
      }
    } catch (e: Exception) {
      print("Error: ${e.message}")
    }
    return meetingId
  }
}
