package io.dyte.core.chat.models

import io.dyte.core.feat.DyteChatMessage

data class ChatChannel(
  val id: String,
  val displayName: String,
  val displayPictureUrl: String?,
  val visibility: ChannelVisibility,
  val isDirectMessage: Boolean?,
  val latestMessage: DyteChatMessage?,
  val unreadMessageCount: Long,
  val memberIds: List<String>,
) {
  enum class ChannelVisibility {
    PUBLIC,
    PRIVATE
  }
}
