package io.dyte.core.media

import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.DelicateCoroutinesApi
import kotlinx.coroutines.ExperimentalCoroutinesApi
import kotlinx.coroutines.launch
import kotlinx.coroutines.newSingleThreadContext
import kotlinx.coroutines.runBlocking
import kotlinx.coroutines.sync.Mutex
import kotlinx.coroutines.sync.withLock

expect interface DyteVideoMiddleware

@OptIn(ExperimentalCoroutinesApi::class, DelicateCoroutinesApi::class)
internal object DyteVideoMiddlewares {
  private val serialScope = CoroutineScope(newSingleThreadContext("DyteVideoMiddlewares"))
  private val videoMiddlewareMutex = Mutex()

  private val middlewares = arrayListOf<DyteVideoMiddleware>()

  fun addVideoMiddleware(middleware: DyteVideoMiddleware) {
    serialScope.launch { videoMiddlewareMutex.withLock { middlewares.add(middleware) } }
  }

  fun removeVideoMiddleware(middleware: DyteVideoMiddleware) {
    serialScope.launch { videoMiddlewareMutex.withLock { middlewares.remove(middleware) } }
  }

  fun getVideoMiddlewares(): List<DyteVideoMiddleware> {
    return runBlocking { videoMiddlewareMutex.withLock { middlewares } }
  }
}
