package io.dyte.core.observability

import io.dyte.core.controllers.IControllerContainer

internal class DyteTracer(private val controllerContainer: IControllerContainer) : IDyteTracer {
  override val traces: List<DyteTrace>
    get() = _traces

  private val _traces = arrayListOf<DyteTrace>()

  private val currentTime: Long
    get() = controllerContainer.platformUtilsProvider.getPlatformUtils().getCurrentTime()

  override fun startTrace(id: String) {
    if (_traces.find { it.id == id } == null) {
      _traces.add(DyteTrace(id, currentTime))
    }
  }

  override fun endTrace(id: String) {
    val trace = _traces.find { it.id == id }
    if (trace != null) {
      trace.endedAt = currentTime
      // TODO : process the trace here
    }
  }
}

// TODO : add a tags here.
data class DyteTrace(
  val id: String,
  val startedAt: Long,
  var endedAt: Long = -1,
  var isProcessed: Boolean = false,
)

internal interface IDyteTracer {
  val traces: List<DyteTrace>

  fun startTrace(id: String)

  fun endTrace(id: String)
}
