package io.dyte.core.utils

import kotlin.reflect.KProperty1
import kotlinx.atomicfu.locks.reentrantLock
import kotlinx.atomicfu.locks.withLock

internal class WriteHeavyMutableList<T> {
  val lock = reentrantLock()
  val internalList = mutableListOf<T>()

  val size: Int
    get() = lock.withLock { internalList.size }

  fun contains(element: T): Boolean = lock.withLock { internalList.contains(element) }

  fun containsAll(elements: Collection<T>): Boolean =
    lock.withLock { internalList.containsAll(elements) }

  fun get(index: Int): T = lock.withLock { internalList[index] }

  fun indexOf(element: T): Int = lock.withLock { internalList.indexOf(element) }

  fun isEmpty(): Boolean = lock.withLock { internalList.isEmpty() }

  fun iterator(): MutableIterator<T> = lock.withLock { internalList.toMutableList().iterator() }

  fun lastIndexOf(element: T): Int = lock.withLock { internalList.lastIndexOf(element) }

  fun add(element: T): Boolean = lock.withLock { internalList.add(element) }

  fun add(index: Int, element: T) = lock.withLock { internalList.add(index, element) }

  fun addAll(index: Int, elements: Collection<T>): Boolean =
    lock.withLock { internalList.addAll(index, elements) }

  fun addAll(elements: Collection<T>): Boolean = lock.withLock { internalList.addAll(elements) }

  fun clear() = lock.withLock { internalList.clear() }

  fun listIterator(): MutableListIterator<T> =
    lock.withLock { internalList.toMutableList().listIterator() }

  fun listIterator(index: Int): MutableListIterator<T> =
    lock.withLock { internalList.toMutableList().listIterator(index) }

  fun remove(element: T): Boolean = lock.withLock { internalList.remove(element) }

  fun removeAll(elements: Collection<T>): Boolean =
    lock.withLock { internalList.removeAll(elements) }

  fun removeAt(index: Int): T = lock.withLock { internalList.removeAt(index) }

  fun retainAll(elements: Collection<T>): Boolean =
    lock.withLock { internalList.retainAll(elements) }

  fun set(index: Int, element: T): T = lock.withLock { internalList.set(index, element) }

  fun subList(fromIndex: Int, toIndex: Int): MutableList<T> =
    lock.withLock { internalList.subList(fromIndex, toIndex).toMutableList() }

  fun toSafeList(): List<T> = lock.withLock { internalList.toList() }

  fun find(function: (T) -> Boolean): T? = lock.withLock { internalList.find(function) }

  fun filter(function: (T) -> Boolean) = lock.withLock { internalList.filter(function) }

  fun any(function: (T) -> Boolean) = lock.withLock { internalList.any(function) }

  fun <R> map(function: (T) -> R) = lock.withLock { internalList.map(function) }

  fun none(function: (T) -> Boolean) = lock.withLock { internalList.none(function) }
}

internal expect class ReadHeavyMutableList<T>() {
  val size: Int

  fun contains(element: T): Boolean

  fun get(index: Int): T

  fun indexOf(element: T): Int

  fun isEmpty(): Boolean

  fun lastIndexOf(element: T): Int

  fun add(element: T): Boolean

  fun add(index: Int, element: T)

  fun addAll(index: Int, elements: Collection<T>): Boolean

  fun addAll(elements: Collection<T>): Boolean

  fun clear()

  fun remove(element: T): Boolean

  fun removeAll(elements: Collection<T>): Boolean

  fun removeAll(function: (T) -> Boolean): Boolean

  fun removeAt(index: Int): T

  fun set(index: Int, element: T): T

  fun find(function: (T) -> Boolean): T?

  fun distinctBy(property: KProperty1<T, String>): List<T>

  fun subList(fromIndex: Int, toIndex: Int): MutableList<T>

  fun toSafeList(): List<T>
}
