package io.dyte.core.media

import kotlinx.cinterop.ExperimentalForeignApi
import platform.CoreFoundation.CFNotificationCenterGetDarwinNotifyCenter
import platform.CoreFoundation.CFNotificationCenterPostNotification
import platform.CoreMedia.CMSampleBufferRef
import platform.Foundation.NSBundle
import platform.Foundation.NSFileManager
import platform.Foundation.URLByAppendingPathComponent
import platform.ReplayKit.RPSampleBufferType
import platform.darwin.DISPATCH_SOURCE_TYPE_TIMER
import platform.darwin.DISPATCH_TIME_NOW
import platform.darwin.NSEC_PER_MSEC
import platform.darwin.dispatch_queue_create
import platform.darwin.dispatch_resume
import platform.darwin.dispatch_source_cancel
import platform.darwin.dispatch_source_create
import platform.darwin.dispatch_source_set_event_handler
import platform.darwin.dispatch_source_set_timer

@OptIn(ExperimentalForeignApi::class)
open class DyteBroadcastHandler() {
  var clientConnection: ClientSocketConnection? = null
  val notif = CFNotificationCenterGetDarwinNotifyCenter()
  var uploader: SampleUploader? = null

  init {
    val appGroupIdentifierDefault =
      NSBundle.mainBundle.infoDictionary?.get(kRTCAppGroupIdentifier) as? String ?: ""
    val sharedContainer =
      NSFileManager.defaultManager.containerURLForSecurityApplicationGroupIdentifier(
        appGroupIdentifierDefault
      )
    val spath = sharedContainer?.URLByAppendingPathComponent(kRTCScreensharingSocketFD)?.path ?: ""
    clientConnection = ClientSocketConnection(spath)
    clientConnection?.let {
      setupConnection()
      uploader = SampleUploader(it)
    }
  }

  fun broadcastStartedWithSetupInfo(setupInfo: Map<Any?, *>?) {
    CFNotificationCenterPostNotification(notif, "broadcastStarted".toCString(), null, null, true)
    openConnection()
  }

  fun broadcastPaused() {}

  fun broadcastResumed() {}

  fun broadcastFinished() {
    CFNotificationCenterPostNotification(notif, "broadcastStopped".toCString(), null, null, true)
    clientConnection?.close()
  }

  private fun setupConnection() {
    clientConnection?.didClose?.let {
      // TODO: What is finishBroadcastWithError
      println("SS: Client Connection Closed /E")
    }
  }

  private fun openConnection() {
    val queue = dispatch_queue_create("broadcast.connectTimer", null)
    val timer = dispatch_source_create(DISPATCH_SOURCE_TYPE_TIMER, 0UL, 0UL, queue)
    dispatch_source_set_timer(
      timer,
      DISPATCH_TIME_NOW,
      ((100).toULong() * NSEC_PER_MSEC),
      ((500).toULong() * NSEC_PER_MSEC),
    )

    dispatch_source_set_event_handler(timer) {
      clientConnection?.open()?.let {
        if (!it) {
          return@dispatch_source_set_event_handler
        }
      }
      dispatch_source_cancel(timer)
    }

    dispatch_resume(timer)
  }

  fun processSampleBuffer(sampleBuffer: CMSampleBufferRef?, withType: RPSampleBufferType) {
    sampleBuffer?.let {
      // RPSampleBufferType.video
      if (withType.toInt() == 1) {
        uploader?.send(sampleBuffer)
      }
    }
  }
}
