package io.dyte.core.media

import DyteWebRTC.DyteRTCVideoCapturer
import io.dyte.webrtc.VideoCaptureController
import platform.Foundation.NSBundle
import platform.Foundation.NSFileManager
import platform.Foundation.URLByAppendingPathComponent

const val kRTCScreensharingSocketFD = "rtc_SSFD"
const val kRTCAppGroupIdentifier = "RTCAppGroupIdentifier"

class ScreenCaptureController(private val capturer: ScreenCapturer) :
  VideoCaptureController, CapturerEventsDelegate {

  // Private property with custom getter
  private val appGroupIdentifier: String?
    get() {
      val infoDictionary = NSBundle.mainBundle.infoDictionary
      return infoDictionary?.get(kRTCAppGroupIdentifier) as? String
    }

  // Initialization
  init {
    // Initialization code if needed
  }

  // Deinitializer
  fun dealloc() {
    capturer.stopCapture()
  }

  // Other methods
  override fun startCapture() {
    val appGroupIdentifier = appGroupIdentifier ?: return
    capturer.eventsDelegate = this
    val socketFilePath = filePathForApplicationGroupIdentifier(appGroupIdentifier)
    val connection = SocketConnection.initWithFilePath(socketFilePath)
    connection?.let { capturer.startCaptureWithConnection(it) }
  }

  override fun stopCapture() {
    capturer.stopCapture()
  }

  // CapturerEventsDelegate method
  override fun capturerDidEnd(capturer: DyteRTCVideoCapturer) {
    // TODO: Figure this
  }

  // Private method
  private fun filePathForApplicationGroupIdentifier(identifier: String): String {
    val sharedContainer =
      NSFileManager.defaultManager.containerURLForSecurityApplicationGroupIdentifier(identifier)
    val socketFilePath =
      sharedContainer?.URLByAppendingPathComponent(kRTCScreensharingSocketFD)?.path

    return socketFilePath ?: ""
  }
}
