package io.dyte.core.utils

import kotlin.reflect.KProperty1
import kotlinx.atomicfu.locks.reentrantLock
import kotlinx.atomicfu.locks.withLock

internal actual class ReadHeavyMutableList<T> {
  val lock = reentrantLock()
  var internalList = mutableListOf<T>()

  actual val size: Int
    get() = internalList.size

  actual fun contains(element: T): Boolean = internalList.contains(element)

  actual fun get(index: Int): T = internalList[index]

  actual fun indexOf(element: T): Int = internalList.indexOf(element)

  actual fun isEmpty(): Boolean = internalList.isEmpty()

  actual fun lastIndexOf(element: T): Int = internalList.lastIndexOf(element)

  actual fun add(element: T): Boolean =
    lock.withLock {
      val newList = internalList.toMutableList()
      val ret = newList.add(element)
      internalList = newList
      return ret
    }

  actual fun add(index: Int, element: T) =
    lock.withLock {
      val newList = internalList.toMutableList()
      newList.add(index, element)
      internalList = newList
    }

  actual fun addAll(index: Int, elements: Collection<T>): Boolean =
    lock.withLock {
      val newList = internalList.toMutableList()
      val ret = newList.addAll(index, elements)
      internalList = newList
      return ret
    }

  actual fun addAll(elements: Collection<T>): Boolean =
    lock.withLock {
      val newList = internalList.toMutableList()
      val ret = newList.addAll(elements)
      internalList = newList
      return ret
    }

  actual fun clear() =
    lock.withLock {
      val newList = internalList.toMutableList()
      newList.clear()
      internalList = newList
    }

  actual fun remove(element: T): Boolean =
    lock.withLock {
      val newList = internalList.toMutableList()
      val ret = newList.remove(element)
      internalList = newList
      return ret
    }

  actual fun removeAll(elements: Collection<T>): Boolean =
    lock.withLock {
      val newList = internalList.toMutableList()
      val ret = newList.removeAll(elements)
      internalList = newList
      return ret
    }

  actual fun removeAll(function: (T) -> Boolean): Boolean =
    lock.withLock {
      val newList = internalList.toMutableList()
      val ret = newList.removeAll(function)
      internalList = newList
      return ret
    }

  actual fun removeAt(index: Int): T =
    lock.withLock {
      val newList = internalList.toMutableList()
      val ret = newList.removeAt(index)
      internalList = newList
      return ret
    }

  actual fun set(index: Int, element: T): T =
    lock.withLock {
      val newList = internalList.toMutableList()
      val ret = newList.set(index, element)
      internalList = newList
      return ret
    }

  actual fun find(function: (T) -> Boolean): T? = internalList.find(function)

  actual fun distinctBy(property: KProperty1<T, String>) = internalList.distinctBy(property)

  actual fun subList(fromIndex: Int, toIndex: Int): MutableList<T> =
    internalList.subList(fromIndex, toIndex).toMutableList()

  actual fun toSafeList(): List<T> = internalList
}
