package dyte.io.uikit.atoms

import android.content.Context
import android.util.AttributeSet
import android.view.View
import androidx.core.content.ContextCompat
import dyte.io.uikit.DyteUIKitBuilder
import dyte.io.uikit.R
import dyte.io.uikit.view.DyteControlBarButton
import dyte.io.uikit.wiptoken.DyteUITokens
import io.dyte.core.DyteMobileClient
import io.dyte.core.listeners.DyteSelfEventsListener
import kotlinx.coroutines.launch

class DyteCameraToggleButton : DyteControlBarButton {
  private var meeting: DyteMobileClient? = null

  override val defaultIconResId: Int
    get() = R.drawable.ic_camera_on_24

  override val defaultLabelResId: Int
    get() = R.string.dytecameratogglebutton_on_state_label

  private val selfVideoEventsListener = object : DyteSelfEventsListener {
    override fun onVideoUpdate(videoEnabled: Boolean) {
      super.onVideoUpdate(videoEnabled)
      updateState()
    }
  }

  private val onClickListener = CameraToggleOnClickListener()

  constructor(context: Context) : super(context)
  constructor(context: Context, attrs: AttributeSet?) : super(context, attrs)
  constructor(context: Context, attrs: AttributeSet?, defStyleAttr: Int) : super(
    context,
    attrs,
    defStyleAttr
  )

  fun activate(meeting: DyteMobileClient) {
    this.meeting = meeting
    this.meeting?.addSelfEventsListener(selfVideoEventsListener)
    setOnClickListener(onClickListener)
    updateState()
  }

  override fun setOnClickListener(listener: OnClickListener?) {
    if ((listener is CameraToggleOnClickListener) || listener == null) {
      super.setOnClickListener(listener)
    }
  }

  override fun onDetachedFromWindow() {
    super.setOnClickListener(null)
    this.meeting?.removeSelfEventsListener(selfVideoEventsListener)
    super.onDetachedFromWindow()
  }

  private fun updateState() {
    meeting?.let {
      if (it.localUser.videoEnabled) {
        setIconDrawable(ContextCompat.getDrawable(context, R.drawable.ic_camera_on_24))
        setLabelResource(R.string.dytecameratogglebutton_on_state_label)
      } else {
        setIconDrawable(ContextCompat.getDrawable(context, R.drawable.ic_camera_off_24))
        setLabelResource(R.string.dytecameratogglebutton_off_state_label)
      }
    }
  }

  private fun setLabelResource(stringResId: Int) {
    labelTextView.setText(stringResId)
  }

  private inner class CameraToggleOnClickListener : View.OnClickListener {
    override fun onClick(view: View?) {
      meeting?.let {
          if (it.localUser.videoEnabled) {
            it.localUser.disableVideo()
          } else {
            it.localUser.enableVideo()
          }
      }
    }
  }
}