package dyte.io.uikit.atoms

import android.content.Context
import android.content.res.ColorStateList
import android.util.AttributeSet
import dyte.io.uikit.designtokens.TokenRepo
import dyte.io.uikit.tokens
import dyte.io.uikit.wiptoken.DyteUITokens

class DyteCheckBoxAtom : androidx.appcompat.widget.AppCompatCheckBox {
  constructor(context: Context) : super(context) {
    init()
  }

  constructor(context: Context, attrs: AttributeSet?) : super(context, attrs) {
    init()
  }

  constructor(context: Context, attrs: AttributeSet?, defStyleAttr: Int) : super(
    context,
    attrs,
    defStyleAttr
  ) {
    init()
  }

  fun init() {
    refresh(tokens)
  }

  fun refresh(uiTokens: DyteUITokens) {
    buttonTintList = ColorStateList.valueOf(uiTokens.colors.brand.shade500)
    setTextColor(uiTokens.colors.text.onBackground.shade1000)
    val fontSize = TokenRepo.getFontSizeRepo().getFontSize()
    textSize = fontSize
    transformationMethod = null
  }
}