package dyte.io.uikit.atoms

import android.content.Context
import android.content.res.ColorStateList
import android.graphics.drawable.GradientDrawable
import android.util.AttributeSet
import android.widget.ImageView.ScaleType.CENTER_INSIDE
import androidx.appcompat.widget.AppCompatImageView
import dyte.io.uikit.tokens
import dyte.io.uikit.utils.displayDensity
import dyte.io.uikit.wiptoken.BorderRadiusToken.BorderRadiusSize
import dyte.io.uikit.wiptoken.DyteUITokens

class DyteImageButton : AppCompatImageView {
  constructor(context: Context) : super(context) {
    init()
  }

  constructor(context: Context, attrs: AttributeSet?) : super(context, attrs) {
    init()
  }

  constructor(context: Context, attrs: AttributeSet?, defStyleAttr: Int) : super(
    context,
    attrs,
    defStyleAttr
  ) {
    init()
  }

  fun init() {
    refresh(tokens)
  }

  fun refresh(uiTokens: DyteUITokens) {
    scaleType = CENTER_INSIDE

    val shape = GradientDrawable()
    // Set color
    shape.setColor(uiTokens.colors.background.shade900)
    // Set corner radius
    shape.cornerRadius = uiTokens.borderRadius.getRadius(BorderRadiusSize.ONE, displayDensity)
    background = shape

    imageTintList = ColorStateList.valueOf(uiTokens.colors.text.onBackground.shade1000)
  }
}